/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bql.projection;

import com.tridium.bql.Projection;
import com.tridium.bql.expression.BPath;
import com.tridium.bql.expression.ExprEngine;
import com.tridium.bql.projection.BProjectionTable;
import com.tridium.bql.projection.ColumnProjectionColumn;
import com.tridium.bql.projection.ExprProjectionColumn;
import com.tridium.bql.projection.PathProjectionColumn;
import com.tridium.bql.projection.ProjectionColumn;
import com.tridium.bql.projection.UnresolvedProjectionColumn;
import com.tridium.bql.query.BqlVisitor;
import javax.baja.bql.BIRelational;
import javax.baja.collection.BITable;
import javax.baja.collection.Column;
import javax.baja.collection.ColumnList;
import javax.baja.collection.TableCursor;
import javax.baja.query.BExpression;
import javax.baja.query.BProjectionColumn;
import javax.baja.sys.BIObject;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.Context;
import javax.baja.sys.Type;

public class SomeProjection
implements Projection {
    private BProjectionColumn[] projCols;
    private ExprEngine engine;

    public SomeProjection(BProjectionColumn[] columns, ExprEngine engine) {
        this.projCols = columns;
        this.engine = engine;
    }

    @Override
    public BITable<? extends BIObject> getTable(BITable<? extends BIObject> innerTable, Context cx) {
        int colCount = this.projCols.length;
        ProjectionColumn[] columns = new ProjectionColumn[colCount];
        ColumnList innerCols = innerTable.getColumns();
        if (innerTable instanceof BIRelational) {
            boolean anyUnresolved = false;
            for (int i = 0; i < colCount; ++i) {
                Column col;
                BPath path;
                if (this.projCols[i].getColumnExpression() instanceof BPath && (path = (BPath)this.projCols[i].getColumnExpression()).getParts().length == 1 && (col = innerCols.get(path.getField())) != null) {
                    columns[i] = new ColumnProjectionColumn(col, this.getAlias(i));
                }
                anyUnresolved = true;
            }
            if (anyUnresolved) {
                this.toProjectionColumn(innerTable, cx, columns);
            }
        } else {
            this.toProjectionColumn(innerTable, cx, columns);
        }
        return new BProjectionTable<BIObject>(columns, innerTable);
    }

    private void toProjectionColumn(BITable<? extends BIObject> innerTable, Context cx, ProjectionColumn[] columns) {
        int colCount = this.projCols.length;
        WhatType[] types = new WhatType[colCount];
        for (int i = 0; i < colCount; ++i) {
            if (columns[i] != null) continue;
            types[i] = new WhatType();
        }
        try (TableCursor cursor = innerTable.cursor();){
            while (cursor.next()) {
                BObject o = (BObject)cursor.get();
                for (int i = 0; i < colCount; ++i) {
                    if (columns[i] != null) continue;
                    BObject result = this.engine.evaluate(this.projCols[i].getColumnExpression(), o, cx);
                    Type resultType = result == null ? null : result.getType();
                    types[i].updateType(resultType);
                }
            }
        }
        for (int i = 0; i < colCount; ++i) {
            if (types[i] == null) continue;
            Type colType = types[i].getType();
            if (colType != null) {
                BExpression expr = this.projCols[i].getColumnExpression();
                if (expr instanceof BPath) {
                    columns[i] = new PathProjectionColumn((BPath)expr, colType, this.getAlias(i), cx);
                    continue;
                }
                columns[i] = new ExprProjectionColumn(this.toColName(i), expr, colType, this.getAlias(i), this.engine, cx);
                continue;
            }
            columns[i] = new UnresolvedProjectionColumn(this.toColName(i), this.getAlias(i));
        }
    }

    private String toColName(int projCol) {
        BqlVisitor v = new BqlVisitor();
        v.visit(this.projCols[projCol].getColumnExpression());
        return v.getQueryString();
    }

    private String getAlias(int projCol) {
        return this.projCols[projCol].hasAlias() ? this.projCols[projCol].getAlias() : null;
    }

    private static class WhatType {
        private Type type;

        private WhatType() {
        }

        public void updateType(Type newType) {
            if (newType == null) {
                this.type = BString.TYPE;
            } else if (this.type == null) {
                this.type = newType;
            } else {
                Type base;
                if (this.type == newType || newType.is(this.type)) {
                    return;
                }
                for (base = this.type.getSuperType(); base != null && !newType.is(base); base = base.getSuperType()) {
                }
                this.type = base == null ? BObject.TYPE : base;
            }
        }

        public Type getType() {
            return this.type;
        }
    }
}

