/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bql.filter;

import com.tridium.bql.filter.BRangeFilter;
import javax.baja.bql.BIBqlFilter;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.query.BExpression;
import javax.baja.query.BIQueryFilter;
import javax.baja.query.util.Predicates;
import javax.baja.sys.BFloat;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType(agent={@AgentOn(types={"baja:Float"})})
@NiagaraProperties(value={@NiagaraProperty(name="minValue", type="float", defaultValue="0f"), @NiagaraProperty(name="maxValue", type="float", defaultValue="0f")})
public class BFloatFilter
extends BRangeFilter
implements BIBqlFilter,
BIQueryFilter {
    @Generated
    public static final Property minValue = BFloatFilter.newProperty((int)0, (float)0.0f, null);
    @Generated
    public static final Property maxValue = BFloatFilter.newProperty((int)0, (float)0.0f, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BFloatFilter.class);

    @Generated
    public float getMinValue() {
        return this.getFloat(minValue);
    }

    @Generated
    public void setMinValue(float v) {
        this.setFloat(minValue, v, null);
    }

    @Generated
    public float getMaxValue() {
        return this.getFloat(maxValue);
    }

    @Generated
    public void setMaxValue(float v) {
        this.setFloat(maxValue, v, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    @Override
    public void init(BObject o) {
    }

    @Override
    public String getPredicate(String columnName) {
        float min = this.getMinValue();
        float max = this.getMaxValue();
        if (!this.getMinEnabled() && !this.getMaxEnabled()) {
            return null;
        }
        StringBuilder s = new StringBuilder(64);
        if (this.getMinEnabled()) {
            s.append(columnName);
            s.append(" >= ");
            try {
                s.append(BFloat.make((float)min).encodeToString());
            }
            catch (Exception e) {
                e.printStackTrace();
                s.append("error");
            }
        }
        if (this.getMaxEnabled()) {
            if (s.length() != 0) {
                s.append(" and ");
            }
            s.append(columnName);
            s.append(" <= ");
            try {
                s.append(BFloat.make((float)max).encodeToString());
            }
            catch (Exception e) {
                e.printStackTrace();
                s.append("error");
            }
        }
        return s.toString();
    }

    public BExpression getExpression(BExpression columnExpression) {
        BFloat min = BFloat.make((float)this.getMinValue());
        BFloat max = BFloat.make((float)this.getMaxValue());
        if (!this.getMinEnabled() && !this.getMaxEnabled()) {
            return null;
        }
        if (this.getMinEnabled() && !this.getMaxEnabled()) {
            return Predicates.ge((BExpression)columnExpression, (BSimple)min);
        }
        if (this.getMaxEnabled() && !this.getMinEnabled()) {
            return Predicates.le((BExpression)columnExpression, (BSimple)min);
        }
        return Predicates.and((BExpression)Predicates.ge((BExpression)columnExpression, (BSimple)min), (BExpression)Predicates.le((BExpression)((BExpression)columnExpression.newCopy()), (BSimple)max));
    }

    @Override
    public boolean accept(BObject o) {
        float value = ((BFloat)o).getFloat();
        float min = this.getMinValue();
        float max = this.getMaxValue();
        boolean retVal = true;
        if (this.getMinEnabled() && value < min) {
            retVal = false;
        }
        if (this.getMaxEnabled() && value > max) {
            retVal = false;
        }
        return retVal;
    }
}

