/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bql.expression;

import com.tridium.bql.util.BqlUtil;
import com.tridium.query.expression.BField;
import com.tridium.script.ScriptField;
import com.tridium.script.ScriptUtil;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.TextUtil;
import javax.baja.security.BIProtected;
import javax.baja.security.BPermissions;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.user.BUser;

@NiagaraType
public class BPath
extends BField {
    @Generated
    public static final Type TYPE = Sys.loadType(BPath.class);
    private QueryPath path;

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BPath() {
    }

    public BPath(String path) {
        super(path);
    }

    public BPath(String[] parts) {
        super(parts);
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (property == fieldPath) {
            this.path = new QueryPath(this.getField());
        }
    }

    public QueryPath getPath() {
        return this.path;
    }

    public PathTarget resolve(Object root, Context cx) {
        return this.path.resolve(root, cx);
    }

    public BObject evaluate(BObject root, Context cx) {
        return BqlUtil.toBObject(this.evaluate((Object)root, cx));
    }

    public Object evaluate(Object root, Context cx) {
        PathTarget target = this.resolve(root, cx);
        if (target == null) {
            return null;
        }
        return target.target;
    }

    public BFacets evaluateFacets(Object root, Context cx) {
        PathTarget target = this.resolve(root, cx);
        if (target == null) {
            return null;
        }
        return target.facets;
    }

    public String toString(Context cx) {
        if (this.path != null) {
            return this.path.toString();
        }
        return "";
    }

    public static class PathTarget {
        public final Object target;
        public final int flags;
        public final BFacets facets;

        public PathTarget(Object target, int flags, BFacets facets) {
            this.target = target;
            this.flags = flags;
            this.facets = facets;
        }
    }

    public static class PathElement {
        public final String fieldName;
        private ScriptField field;
        private Class<?> lastClass;

        public static PathElement make(PathElement parent, String fieldName) {
            return new PathElement(fieldName);
        }

        protected PathElement(String fieldName) {
            this.fieldName = fieldName;
        }

        public String getDisplayName(Object base, Context cx) {
            if (this.lastClass == null) {
                this.lastClass = base.getClass();
                this.field = ScriptUtil.getField(base, this.fieldName);
            } else if (!base.getClass().equals(this.lastClass)) {
                this.lastClass = base.getClass();
                this.field = ScriptUtil.getField(base, this.fieldName);
            }
            if (this.field != null) {
                return this.field.scriptDisplayName(base, cx);
            }
            return TextUtil.toFriendly((String)this.fieldName);
        }

        public Object get(Object base, Context context) {
            if (this.field == null || !this.field.isReusable()) {
                this.lastClass = base.getClass();
                this.field = ScriptUtil.getField(base, this.fieldName);
            } else if (!base.getClass().equals(this.lastClass)) {
                this.lastClass = base.getClass();
                this.field = ScriptUtil.getField(base, this.fieldName);
            }
            if (this.field == null) {
                return null;
            }
            try {
                return this.field.scriptGet(base, context);
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }

        public int getFlags(Object target) {
            if (this.field == null) {
                return 0;
            }
            return this.field.scriptFlags(target);
        }

        public BFacets getFacets(Object target) {
            if (this.field == null || !this.field.isReusable()) {
                this.lastClass = target.getClass();
                this.field = ScriptUtil.getField(target, this.fieldName);
            } else if (!target.getClass().equals(this.lastClass)) {
                this.lastClass = target.getClass();
                this.field = ScriptUtil.getField(target, this.fieldName);
            }
            if (this.field == null) {
                return BFacets.NULL;
            }
            return this.field.scriptFacets(target);
        }

        public String toString() {
            return this.fieldName;
        }
    }

    public static class QueryPath {
        private PathElement[] path;

        public QueryPath(String single) {
            this.parse(single);
        }

        public QueryPath(String[] pathElements) {
            this.parse(pathElements);
        }

        public String getName() {
            return this.path[this.path.length - 1].toString();
        }

        public String getDisplayName(Object base, Context context) {
            String displayName = null;
            if (base != null) {
                for (PathElement pathElement : this.path) {
                    Object target = pathElement.get(base, context);
                    if (target == null) {
                        return null;
                    }
                    displayName = pathElement.getDisplayName(target, context);
                    base = target;
                }
            }
            if (displayName == null) {
                return TextUtil.toFriendly((String)this.getName());
            }
            return displayName;
        }

        public int getDepth() {
            return this.path.length;
        }

        private void parse(String pathString) {
            ArrayList<String> temp = new ArrayList<String>(4);
            StringTokenizer st = new StringTokenizer(pathString, ".");
            while (st.hasMoreTokens()) {
                temp.add(st.nextToken());
            }
            this.parse(temp.toArray(new String[0]));
        }

        private void parse(String[] names) {
            PathElement previous = null;
            int pathLen = names.length;
            int depth = 0;
            this.path = new PathElement[pathLen];
            for (String token : names) {
                PathElement newElement = PathElement.make(previous, token);
                this.path[depth++] = newElement;
                previous = depth == 0 ? null : this.path[depth - 1];
            }
            if (depth != this.path.length) {
                PathElement[] temp = new PathElement[depth];
                System.arraycopy(this.path, 0, temp, 0, depth);
                this.path = temp;
            }
        }

        public String toString() {
            StringBuilder sbuf = new StringBuilder(64);
            int pathLen = this.path.length;
            for (int i = 0; i < pathLen; ++i) {
                sbuf.append(this.path[i]);
                if (i == pathLen - 1) continue;
                sbuf.append('.');
            }
            return sbuf.toString();
        }

        public PathTarget resolve(Object base, Context cx) {
            boolean op;
            BIProtected secure = null;
            int flags = 0;
            BFacets facets = BFacets.NULL;
            if (base instanceof BIProtected) {
                secure = (BIProtected)base;
            }
            Object target = null;
            for (PathElement pathElement : this.path) {
                if (BqlUtil.excludeFromResults(target)) {
                    return null;
                }
                target = pathElement.get(base, cx);
                if (target == null) {
                    return null;
                }
                flags = pathElement.getFlags(base);
                facets = pathElement.getFacets(base);
                base = target;
                if (!(base instanceof BIProtected)) continue;
                secure = (BIProtected)base;
            }
            PathTarget resolved = new PathTarget(target, flags, facets);
            if (cx == null || secure == null) {
                return resolved;
            }
            BPermissions p = this.permissionsFor(secure, cx);
            boolean bl = op = (flags & 0x100) != 0;
            if (op) {
                if (p.has(1)) {
                    return resolved;
                }
                return null;
            }
            if (p.has(16)) {
                return resolved;
            }
            return null;
        }

        public Object get(Object base, Context context) {
            boolean op;
            BIProtected secure = null;
            int flags = 0;
            if (base instanceof BIProtected) {
                secure = (BIProtected)base;
            }
            Object result = null;
            for (PathElement pathElement : this.path) {
                result = pathElement.get(base, context);
                if (result == null) {
                    return null;
                }
                flags = pathElement.getFlags(base);
                base = result;
                if (!(base instanceof BIProtected)) continue;
                secure = (BIProtected)base;
            }
            if (context == null || secure == null) {
                return result;
            }
            BPermissions p = this.permissionsFor(secure, context);
            boolean bl = op = (flags & 0x100) != 0;
            if (op) {
                if (p.has(1)) {
                    return result;
                }
                return null;
            }
            if (p.has(16)) {
                return result;
            }
            return null;
        }

        public BFacets getFacets(Object base, Context context) {
            boolean op;
            BIProtected secure = null;
            int flags = 0;
            BFacets facets = null;
            if (base instanceof BIProtected) {
                secure = (BIProtected)base;
            }
            for (PathElement pathElement : this.path) {
                Object result = pathElement.get(base, context);
                if (result == null) {
                    return BFacets.NULL;
                }
                flags = pathElement.getFlags(base);
                facets = pathElement.getFacets(base);
                base = result;
                if (!(base instanceof BIProtected)) continue;
                secure = (BIProtected)base;
            }
            if (context == null || secure == null) {
                return facets;
            }
            BPermissions p = this.permissionsFor(secure, context);
            boolean bl = op = (flags & 0x100) != 0;
            if (op) {
                if (p.has(1)) {
                    return facets;
                }
                return BFacets.NULL;
            }
            if (p.has(16)) {
                return facets;
            }
            return BFacets.NULL;
        }

        private BPermissions permissionsFor(BIProtected secure, Context context) {
            if (secure == null || context == null) {
                return BPermissions.all;
            }
            BUser user = context.getUser();
            if (user == null) {
                return BPermissions.all;
            }
            return user.getPermissionsFor(secure);
        }
    }
}

