/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bql.compiler;

import com.tridium.bql.compiler.Constants;
import com.tridium.bql.compiler.RuntimeCompilerException;
import com.tridium.bql.compiler.Token;
import com.tridium.bql.compiler.UnrecognizedSymbolException;

public class BqlTokenizer
implements Constants {
    private static final short WHITESPACE_CHAR = 1;
    private static final short WORD_START_CHAR = 2;
    private static final short WORD_CHAR = 4;
    private static final short ALPHA_CHAR = 8;
    private static final short NUMBER_CHAR = 16;
    private static final short OPERATOR_CHAR = 32;
    private static final short DELIMITER_CHAR = 64;
    private static short[] charTypes = new short[255];
    private char[] buf;
    private int bufLen;
    private int index;
    private int current = -1;
    private int currentType = -1;
    private Token peek;
    private Token poke;
    private Token eof;
    private boolean showWhite = false;

    public BqlTokenizer(String queryText) {
        this.reset(queryText);
    }

    public void setShowWhite(boolean show) {
        if (show == this.showWhite) {
            return;
        }
        this.showWhite = show;
        if (!this.showWhite) {
            if (this.poke != null && this.poke.type == 0) {
                this.poke = null;
            }
            if (this.peek != null && this.peek.type == 0) {
                this.peek = null;
            }
        }
    }

    public void reset(String queryText) {
        this.buf = queryText.toCharArray();
        this.bufLen = this.buf.length;
        this.index = -1;
        this.advance();
    }

    public void reset() {
        this.index = -1;
        this.currentType = -1;
        this.current = -1;
        this.eof = null;
        this.poke = null;
        this.peek = null;
        this.advance();
    }

    public Token peek() {
        if (this.poke != null) {
            return this.poke;
        }
        if (this.peek == null) {
            this.peek = this.next();
        }
        return this.peek;
    }

    public void push(Token t) {
        if (this.poke != null) {
            throw new IllegalStateException("Only one token can be pushed back onto the tokenizer.");
        }
        if (!this.showWhite && t.type == 0) {
            return;
        }
        this.poke = t;
    }

    public Token next() {
        if (this.poke != null) {
            Token p = this.poke;
            this.poke = null;
            return p;
        }
        if (this.peek != null) {
            Token p = this.peek;
            this.peek = null;
            return p;
        }
        if (this.eof != null) {
            return this.eof;
        }
        int start = this.index;
        if (this.skipWhiteSpace() && this.showWhite) {
            return new Token(0, start, " ");
        }
        if (this.eof()) {
            this.eof = new Token(2, start, null);
            return this.eof;
        }
        if (BqlTokenizer.is(this.currentType, 2)) {
            return this.parseWord();
        }
        if (BqlTokenizer.is(this.currentType, 16)) {
            return this.parseNumber();
        }
        if (BqlTokenizer.is(this.currentType, 32)) {
            return this.parseOperator();
        }
        if (this.current == 34) {
            return this.parseDelimitedWord(1, 34);
        }
        if (this.current == 39) {
            return this.parseDelimitedWord(5, 39);
        }
        return this.parseChar();
    }

    private Token parseChar() {
        int start = this.index;
        Token charToken = null;
        if (this.current == 40) {
            charToken = new Token(7, start, "(");
        } else if (this.current == 41) {
            charToken = new Token(8, start, ")");
        } else if (this.current == 123) {
            charToken = new Token(9, start, "{");
        } else if (this.current == 125) {
            charToken = new Token(10, start, "}");
        } else if (this.current == 91) {
            charToken = new Token(35, start, "[");
        } else if (this.current == 93) {
            charToken = new Token(36, start, "]");
        } else if (this.current == 44) {
            charToken = new Token(11, start, ",");
        } else if (this.current == 46) {
            charToken = new Token(12, start, ".");
        } else if (this.current == 59) {
            charToken = new Token(28, start, ";");
        } else if (this.current == 58) {
            this.advance();
            if (this.current == 58) {
                charToken = new Token(22, start, "::");
            } else {
                this.backup();
                charToken = new Token(21, start, ":");
            }
        } else {
            throw new UnrecognizedSymbolException(this.index, String.valueOf((char)this.current));
        }
        this.advance();
        return charToken;
    }

    private Token parseWord() {
        int start = this.index;
        boolean isType = false;
        boolean afterColon = false;
        while (this.current != -1 && BqlTokenizer.is(this.currentType, 4)) {
            if (this.current == 58) {
                if (afterColon) {
                    throw new RuntimeCompilerException(start, "invalid.typespec", new String(this.buf, start, this.index - start));
                }
                isType = true;
                afterColon = true;
            }
            this.advance();
        }
        if (isType && this.buf[this.index - 1] == ':') {
            isType = false;
            this.backup();
        }
        String lex = new String(this.buf, start, this.index - start);
        Token t = null;
        t = isType ? new Token(23, start, lex) : this.parseKeyword(lex, start);
        if (t == null) {
            if (this.showWhite) {
                t = Token.identifier(start, lex);
            } else {
                this.skipWhiteSpace();
                if (this.current == 39) {
                    return new Token(23, start, lex);
                }
                t = Token.identifier(start, lex);
            }
        }
        return t;
    }

    private Token parseKeyword(String lex, int startIndex) {
        if (lex.length() == 0) {
            return null;
        }
        lex = lex.toLowerCase();
        char first = lex.charAt(0);
        switch (first) {
            case 'a': {
                if (lex.equals("all")) {
                    return new Token(20, startIndex, lex);
                }
                if (lex.equals("and")) {
                    return Token.operator(13, startIndex, lex);
                }
                if (lex.equals("as")) {
                    return new Token(14, startIndex, lex);
                }
                if (!lex.equals("asc")) break;
                return new Token(39, startIndex, lex);
            }
            case 'b': {
                if (lex.startsWith("bqltime")) {
                    if (lex.length() == 7) {
                        return new Token(33, startIndex, lex);
                    }
                    if (lex.equals("bqltimerange")) {
                        return new Token(34, startIndex, lex);
                    }
                }
                if (!lex.equals("by")) break;
                return new Token(38, startIndex, lex);
            }
            case 'c': {
                if (lex.equals("current_date")) {
                    return new Token(29, startIndex, lex);
                }
                if (lex.equals("currentdate")) {
                    return new Token(29, startIndex, lex);
                }
                if (lex.equals("current_time")) {
                    return new Token(30, startIndex, lex);
                }
                if (lex.equals("currenttime")) {
                    return new Token(30, startIndex, lex);
                }
                if (lex.equals("current_timestamp")) {
                    return new Token(31, startIndex, lex);
                }
                if (!lex.equals("currenttimestamp")) break;
                return new Token(31, startIndex, lex);
            }
            case 'd': {
                if (lex.equals("depth")) {
                    return new Token(17, startIndex, lex);
                }
                if (lex.equals("distinct")) {
                    return new Token(19, startIndex, lex);
                }
                if (!lex.equals("desc")) break;
                return new Token(40, startIndex, lex);
            }
            case 'f': {
                if (lex.equals("false")) {
                    return Token.bool(startIndex, lex, false);
                }
                if (!lex.equals("from")) break;
                return new Token(16, startIndex, lex);
            }
            case 'h': {
                if (!lex.equals("having")) break;
                return new Token(41, startIndex, lex);
            }
            case 'i': {
                if (!lex.equals("in")) break;
                return Token.operator(15, startIndex, lex);
            }
            case 'l': {
                if (!lex.equals("like")) break;
                return Token.operator(11, startIndex, lex);
            }
            case 'n': {
                if (lex.equals("not")) {
                    return Token.operator(12, startIndex, lex);
                }
                if (!lex.equals("null")) break;
                return new Token(26, startIndex, lex);
            }
            case 'o': {
                if (lex.equals("or")) {
                    return Token.operator(14, startIndex, lex);
                }
                if (!lex.equals("order")) break;
                return new Token(37, startIndex, lex);
            }
            case 's': {
                if (lex.equals("select")) {
                    return new Token(13, startIndex, lex);
                }
                if (!lex.equals("stop")) break;
                return new Token(18, startIndex, lex);
            }
            case 't': {
                if (lex.equals("top")) {
                    return new Token(42, startIndex, lex);
                }
                if (!lex.equals("true")) break;
                return Token.bool(startIndex, lex, true);
            }
            case 'w': {
                if (!lex.equals("where")) break;
                return new Token(15, startIndex, lex);
            }
        }
        return null;
    }

    private Token parseDelimitedWord(int tokenType, int delim) {
        this.advance();
        int start = this.index;
        while (this.current != -1 && this.current != delim) {
            this.advance();
        }
        if (this.current != delim) {
            throw new RuntimeCompilerException(start, "invalid.string.unterminated", "" + (char)delim);
        }
        int end = this.index;
        this.advance();
        return new Token(tokenType, start, new String(this.buf, start, end - start));
    }

    private Token parseNumber() {
        int start = this.index;
        String err = null;
        while (this.current != -1 && BqlTokenizer.is(this.currentType, 16)) {
            this.advance();
        }
        String lex = new String(this.buf, start, this.index - start);
        if (err != null) {
            this.error(start, err, lex);
        }
        return Token.number(start, lex);
    }

    private Token parseOperator() {
        int start = this.index;
        int char1 = this.current;
        int char2 = this.nextChar();
        this.advance();
        int len = 2;
        if (char2 != 61) {
            if (char2 != -1) {
                this.backup();
            }
            len = 1;
        }
        while (true) {
            if (len == 1) {
                switch (char1) {
                    case 43: {
                        return Token.operator(0, start, "+");
                    }
                    case 45: {
                        return Token.operator(1, start, "-");
                    }
                    case 42: {
                        return Token.operator(2, start, "*");
                    }
                    case 47: {
                        return Token.operator(3, start, "/");
                    }
                    case 37: {
                        return Token.operator(4, start, "%");
                    }
                    case 61: {
                        return Token.operator(5, start, "=");
                    }
                    case 62: {
                        return Token.operator(7, start, ">");
                    }
                    case 60: {
                        return Token.operator(9, start, "<");
                    }
                    case 33: {
                        return Token.operator(12, start, "not");
                    }
                }
                this.error(start, "operator.format", new String(this.buf, start, len));
                continue;
            }
            switch (char1) {
                case 33: {
                    return Token.operator(6, start, "!=");
                }
                case 62: {
                    return Token.operator(8, start, ">=");
                }
                case 60: {
                    return Token.operator(10, start, "<=");
                }
            }
            this.backup();
            len = 1;
        }
    }

    private void advance() {
        ++this.index;
        if (this.index >= this.bufLen) {
            this.index = this.bufLen;
            this.currentType = -1;
            this.current = -1;
        } else {
            this.current = this.buf[this.index];
            this.currentType = this.current < 255 ? charTypes[this.current] : 8;
        }
    }

    private void backup() {
        this.backup(1);
    }

    private void backup(int count) {
        this.index -= count;
        if (this.index <= -1) {
            this.index = -1;
            this.currentType = -1;
            this.current = -1;
        }
        this.current = this.buf[this.index];
        this.currentType = this.current < 255 ? charTypes[this.current] : 8;
    }

    private int nextChar() {
        this.advance();
        return this.current;
    }

    private int nextType() {
        this.advance();
        return this.currentType;
    }

    private boolean eof() {
        return this.index == this.bufLen;
    }

    private boolean skipWhiteSpace() {
        boolean white = false;
        while (BqlTokenizer.isWhiteSpace(this.current)) {
            white = true;
            this.advance();
        }
        return white;
    }

    private static boolean isWhiteSpace(int ch) {
        int charType = ch != -1 && ch < 255 ? charTypes[ch] : 8;
        return (charType & 1) != 0;
    }

    private static final boolean is(int type, int mask) {
        return (type & mask) != 0;
    }

    private static final boolean isNot(int type, int mask) {
        return (type & mask) == 0;
    }

    private static final boolean isAndNot(int type, int mask, int notMask) {
        return (type & mask) != 0 && (type & notMask) == 0;
    }

    private void error(int index, String key) {
        throw new RuntimeCompilerException(index, key);
    }

    private void error(int index, String key, String arg) {
        throw new RuntimeCompilerException(index, key, arg);
    }

    public static void main(String[] args) {
        try {
            BqlTokenizer tokens = new BqlTokenizer(args[0]);
            tokens.setShowWhite(true);
            while (true) {
                Token t = tokens.next();
                if (t.type != 2) {
                    System.out.println(t);
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        charTypes[32] = (short)(charTypes[32] | 0x41);
        charTypes[10] = (short)(charTypes[10] | 0x41);
        charTypes[13] = (short)(charTypes[13] | 0x41);
        charTypes[9] = (short)(charTypes[9] | 0x41);
        charTypes[44] = (short)(charTypes[44] | 0x40);
        charTypes[40] = (short)(charTypes[40] | 0x40);
        charTypes[41] = (short)(charTypes[41] | 0x40);
        charTypes[95] = (short)(charTypes[95] | 6);
        charTypes[36] = (short)(charTypes[36] | 6);
        charTypes[45] = (short)(charTypes[45] | 4);
        charTypes[58] = (short)(charTypes[58] | 4);
        charTypes[43] = (short)(charTypes[43] | 0x20);
        charTypes[45] = (short)(charTypes[45] | 0x20);
        charTypes[42] = (short)(charTypes[42] | 0x20);
        charTypes[47] = (short)(charTypes[47] | 0x20);
        charTypes[61] = (short)(charTypes[61] | 0x20);
        charTypes[60] = (short)(charTypes[60] | 0x20);
        charTypes[62] = (short)(charTypes[62] | 0x20);
        charTypes[37] = (short)(charTypes[37] | 0x20);
        charTypes[33] = (short)(charTypes[33] | 0x20);
        int i = 65;
        while (i <= 90) {
            int n = i++;
            charTypes[n] = (short)(charTypes[n] | 0xE);
        }
        i = 97;
        while (i <= 122) {
            int n = i++;
            charTypes[n] = (short)(charTypes[n] | 0xE);
        }
        i = 48;
        while (i <= 57) {
            int n = i++;
            charTypes[n] = (short)(charTypes[n] | 0x14);
        }
    }
}

