/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bql;

import com.tridium.bql.BDateTimeSource;
import com.tridium.bql.expression.ExprEngine;
import com.tridium.bql.projection.SomeProjection;
import com.tridium.bql.query.BqlVisitor;
import com.tridium.collection.BEmptyTable;
import com.tridium.collection.BListTable;
import java.util.ArrayList;
import javax.baja.bql.BqlQuery;
import javax.baja.collection.BITable;
import javax.baja.naming.OrdTarget;
import javax.baja.naming.UnresolvedException;
import javax.baja.query.BExpression;
import javax.baja.query.BNull;
import javax.baja.query.BProjectionColumn;
import javax.baja.query.util.Columns;
import javax.baja.sys.BIObject;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;

public abstract class ExpressionQuery
extends BqlQuery {
    public static SingleExpr make(BExpression single) {
        return new SingleExpr(single);
    }

    public static class SingleExpr
    extends ExpressionQuery {
        private BExpression expr;

        public SingleExpr(BExpression expr) {
            this.expr = expr;
        }

        @Override
        public OrdTarget resolve(OrdTarget base) {
            ExprEngine engine = new ExprEngine(new BDateTimeSource());
            BObject result = engine.evaluate(this.expr, base.get(), (Context)base);
            if (result.equals((Object)BNull.NULL)) {
                throw new UnresolvedException();
            }
            return new OrdTarget(base, result);
        }

        @Override
        public String toString() {
            BqlVisitor v = new BqlVisitor();
            v.visit(this.expr);
            return v.getQueryString();
        }
    }

    public static class ExprSet
    extends ExpressionQuery {
        private final BProjectionColumn[] exprCols;
        private BITable<? extends BIObject> proj;

        public ExprSet(BExpression[] exprs) {
            this.exprCols = new BProjectionColumn[exprs.length];
            for (int i = 0; i < exprs.length; ++i) {
                this.exprCols[i] = Columns.make((BExpression)exprs[i]);
            }
            this.setBody(this.toQueryString());
        }

        public ExprSet(BProjectionColumn[] exprCols) {
            this.exprCols = exprCols;
            this.setBody(this.toQueryString());
        }

        @Override
        public OrdTarget resolve(OrdTarget base) {
            if (this.exprCols.length == 0) {
                return new OrdTarget(base, (BObject)new BEmptyTable());
            }
            if (this.proj == null) {
                ArrayList<BObject> arr = new ArrayList<BObject>(1);
                arr.add(base.get());
                SomeProjection some = new SomeProjection(this.exprCols, new ExprEngine(null));
                this.proj = some.getTable((BITable<? extends BIObject>)new BListTable(arr, (Context)base), (Context)base);
            }
            return new OrdTarget(base, (BObject)this.proj);
        }

        private String toQueryString() {
            StringBuilder sb = new StringBuilder().append('{');
            BqlVisitor v = new BqlVisitor();
            for (int i = 0; i < this.exprCols.length; ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                v.visit(this.exprCols[i]);
                sb.append(v.getQueryString());
            }
            return sb.append('}').toString();
        }
    }
}

