/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.fcEasyOnboard.utils;

import com.tridium.cloud.client.BCloudConnector;
import com.tridium.fcModelSync.service.BModelSyncService;
import com.tridium.fcTagDict.dictionary.BFcTagDictionary;
import com.tridium.nc.BNiagaraCloudNetwork;
import com.tridium.nc.alarms.BCloudAlarmRecipient;
import com.tridium.nc.devices.sentience.BCloudSentienceDevice;
import com.tridium.nc.events.BCloudEventRecipient;
import com.tridium.nc.security.BCloudAuthenticationScheme;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.baja.collection.BITable;
import javax.baja.collection.TableCursor;
import javax.baja.naming.BOrd;
import javax.baja.sys.BComponent;
import javax.baja.user.BUser;
import javax.baja.user.BUserService;

public final class OnboardUtils {
    private static final Logger logger = Logger.getLogger("fcEasyOnboard");

    private OnboardUtils() {
    }

    public static BCloudConnector getCloudConnector() {
        BOrd ord = BOrd.make((String)"station:|slot:/|bql:select * from cloudConnector:CloudConnector");
        BITable result = (BITable)ord.get();
        try (TableCursor c = result.cursor();){
            if (c.next()) {
                BCloudConnector connector;
                BCloudConnector bCloudConnector = connector = (BCloudConnector)c.get();
                return bCloudConnector;
            }
            BCloudConnector bCloudConnector = null;
            return bCloudConnector;
        }
    }

    public static LinkedList<BNiagaraCloudNetwork> getCloudNetworks() {
        LinkedList<BNiagaraCloudNetwork> list = new LinkedList<BNiagaraCloudNetwork>();
        BOrd ord = BOrd.make((String)"station:|slot:/|bql:select * from nCloudDriver:NiagaraCloudNetwork");
        BITable result = (BITable)ord.get();
        try (TableCursor c = result.cursor();){
            while (c.next()) {
                BNiagaraCloudNetwork network = (BNiagaraCloudNetwork)c.get();
                list.add(network);
            }
        }
        return list;
    }

    public static LinkedList<BCloudSentienceDevice> getCloudSentienceDevices() {
        LinkedList<BCloudSentienceDevice> list = new LinkedList<BCloudSentienceDevice>();
        BOrd ord = BOrd.make((String)"station:|slot:/|bql:select * from nCloudDriver:CloudSentienceDevice");
        BITable result = (BITable)ord.get();
        try (TableCursor c = result.cursor();){
            while (c.next()) {
                BCloudSentienceDevice device = (BCloudSentienceDevice)c.get();
                list.add(device);
            }
        }
        return list;
    }

    public static String toOrd(BComponent component) {
        return component != null ? "station:|" + component.getSlotPath() : null;
    }

    public static LinkedList<BCloudAlarmRecipient> getCloudAlarmRecipients() {
        LinkedList<BCloudAlarmRecipient> list = new LinkedList<BCloudAlarmRecipient>();
        BOrd ord = BOrd.make((String)"station:|slot:/|bql:select * from nCloudDriver:CloudAlarmRecipient");
        BITable result = (BITable)ord.get();
        try (TableCursor c = result.cursor();){
            while (c.next()) {
                BCloudAlarmRecipient rec = (BCloudAlarmRecipient)c.get();
                list.add(rec);
            }
        }
        return list;
    }

    public static LinkedList<BCloudEventRecipient> getCloudEventRecipients() {
        LinkedList<BCloudEventRecipient> list = new LinkedList<BCloudEventRecipient>();
        BOrd ord = BOrd.make((String)"station:|slot:/|bql:select * from nCloudDriver:CloudEventRecipient");
        BITable result = (BITable)ord.get();
        try (TableCursor c = result.cursor();){
            while (c.next()) {
                BCloudEventRecipient rec = (BCloudEventRecipient)c.get();
                list.add(rec);
            }
        }
        return list;
    }

    public static LinkedList<BFcTagDictionary> getForgeTagDictionaries() {
        LinkedList<BFcTagDictionary> list = new LinkedList<BFcTagDictionary>();
        BOrd ord = BOrd.make((String)"station:|slot:/|bql:select * from fcTagDict:FcTagDictionary");
        BITable result = (BITable)ord.get();
        try (TableCursor c = result.cursor();){
            while (c.next()) {
                BFcTagDictionary tagDictionary = (BFcTagDictionary)c.get();
                list.add(tagDictionary);
            }
        }
        return list;
    }

    public static LinkedList<BModelSyncService> getModelSyncServices() {
        LinkedList<BModelSyncService> list = new LinkedList<BModelSyncService>();
        BOrd ord = BOrd.make((String)"station:|slot:/|bql:select * from fcModelSync:ModelSyncService");
        BITable result = (BITable)ord.get();
        try (TableCursor c = result.cursor();){
            while (c.next()) {
                BModelSyncService modelSyncService = (BModelSyncService)c.get();
                list.add(modelSyncService);
            }
        }
        return list;
    }

    public static LinkedList<BCloudAuthenticationScheme> getCloudAuthenticationSchemes() {
        LinkedList<BCloudAuthenticationScheme> list = new LinkedList<BCloudAuthenticationScheme>();
        BOrd ord = BOrd.make((String)"station:|slot:/|bql:select * from nCloudDriver:CloudAuthenticationScheme");
        BITable result = (BITable)ord.get();
        try (TableCursor c = result.cursor();){
            while (c.next()) {
                BCloudAuthenticationScheme authScheme = (BCloudAuthenticationScheme)c.get();
                list.add(authScheme);
            }
        }
        return list;
    }

    public static List<BUser> getCloudUsers() {
        BUserService userService = BUserService.getService();
        BUser[] users = (BUser[])userService.getChildren(BUser.class);
        List<BUser> cloudUsers = Arrays.stream(users).filter(OnboardUtils::isCloudAuthenticationSchemeAssigned).collect(Collectors.toList());
        return cloudUsers;
    }

    private static boolean isCloudAuthenticationSchemeAssigned(BUser user) {
        boolean isCloudAuthenticationScheme = false;
        try {
            isCloudAuthenticationScheme = user.getAuthenticationScheme() instanceof BCloudAuthenticationScheme;
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Unable check user authentication scheme", e);
        }
        return isCloudAuthenticationScheme;
    }

    public static BNiagaraCloudNetwork getCloudNetwork() {
        LinkedList<BNiagaraCloudNetwork> list = OnboardUtils.getCloudNetworks();
        return list.isEmpty() ? null : list.getFirst();
    }

    public static BCloudSentienceDevice getCloudSentienceDevice() {
        LinkedList<BCloudSentienceDevice> list = OnboardUtils.getCloudSentienceDevices();
        return list.isEmpty() ? null : list.getFirst();
    }

    public static BCloudAuthenticationScheme getCloudAuthenticationScheme() {
        LinkedList<BCloudAuthenticationScheme> list = OnboardUtils.getCloudAuthenticationSchemes();
        return list.isEmpty() ? null : list.getFirst();
    }

    public static BCloudAlarmRecipient getCloudAlarmRecipient() {
        LinkedList<BCloudAlarmRecipient> list = OnboardUtils.getCloudAlarmRecipients();
        return list.isEmpty() ? null : list.getFirst();
    }

    public static BCloudEventRecipient getCloudEventRecipient() {
        LinkedList<BCloudEventRecipient> list = OnboardUtils.getCloudEventRecipients();
        return list.isEmpty() ? null : list.getFirst();
    }

    public static BFcTagDictionary getForgeTagDictionary() {
        LinkedList<BFcTagDictionary> list = OnboardUtils.getForgeTagDictionaries();
        return list.isEmpty() ? null : list.getFirst();
    }

    public static BModelSyncService getModelSyncService() {
        LinkedList<BModelSyncService> list = OnboardUtils.getModelSyncServices();
        return list.isEmpty() ? null : list.getFirst();
    }
}

