/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.fcEasyOnboard;

import com.tridium.fcEasyOnboard.ActivityStatus;
import com.tridium.fcEasyOnboard.utils.OnboardUtils;
import com.tridium.fcModelSync.enums.BUnitSystem;
import com.tridium.fcModelSync.extractor.BContextDiscoveryModelExtractor;
import com.tridium.fcModelSync.service.BModelSyncService;
import com.tridium.fcTagDict.condition.BIsPointProxyTypeCondition;
import com.tridium.fcTagDict.dictionary.BFcTagDictionary;
import com.tridium.fcTagDict.tag.BDriverSuppliedTag;
import com.tridium.fcTagDict.tag.BPropertySuppliedTag;
import com.tridium.sys.Nre;
import com.tridium.sys.transfer.TransferResult;
import com.tridium.tagdictionary.condition.BIsTypeCondition;
import com.tridium.tagdictionary.condition.BOr;
import com.tridium.util.CompUtil;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.baja.collection.SlotCursorIterator;
import javax.baja.naming.BOrd;
import javax.baja.nre.platform.RuntimeProfile;
import javax.baja.space.Mark;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.ServiceNotFoundException;
import javax.baja.sys.Slot;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.tagdictionary.BRelationInfo;
import javax.baja.tagdictionary.BRelationInfoList;
import javax.baja.tagdictionary.BTagDictionaryService;
import javax.baja.tagdictionary.BTagGroupInfo;
import javax.baja.tagdictionary.BTagGroupInfoList;
import javax.baja.tagdictionary.BTagInfo;
import javax.baja.tagdictionary.BTagInfoList;
import javax.baja.tagdictionary.BTagRule;
import javax.baja.tagdictionary.BTagRuleCondition;
import javax.baja.tagdictionary.BTagRuleList;
import javax.baja.util.BTypeSpec;

public class CloudAlertsHelper {
    private static final Logger logger = Logger.getLogger("fcEasyOnboard");

    public static void setupForgeTagDictionary(BFcTagDictionary bogDict) {
        BFcTagDictionary palettDict = CloudAlertsHelper.createForgeTagDictionaryInstance();
        BTagInfoList tagdefs = palettDict.getTagDefinitions();
        Iterator tagIt = SlotCursorIterator.iterator((SlotCursor)tagdefs.getProperties(), BTagInfo.class);
        while (tagIt.hasNext()) {
            BTagInfo tag = (BTagInfo)tagIt.next();
            CompUtil.setOrAdd((BComponent)bogDict.getTagDefinitions(), (String)tag.getName(), (BValue)((BValue)tag.newCopy().as(BTagInfo.class)), (int)tagdefs.getFlags((Slot)tag.getPropertyInParent()), (BFacets)tagdefs.getSlotFacets((Slot)tag.getPropertyInParent()), null);
        }
        BTagGroupInfoList taggps = palettDict.getTagGroupDefinitions();
        Iterator tagGpIt = SlotCursorIterator.iterator((SlotCursor)taggps.getProperties(), BTagGroupInfo.class);
        while (tagGpIt.hasNext()) {
            BTagGroupInfo grp = (BTagGroupInfo)tagGpIt.next();
            CompUtil.setOrAdd((BComponent)bogDict.getTagGroupDefinitions(), (String)grp.getName(), (BValue)((BValue)grp.newCopy().as(BTagGroupInfo.class)), (int)tagdefs.getFlags((Slot)grp.getPropertyInParent()), (BFacets)tagdefs.getSlotFacets((Slot)grp.getPropertyInParent()), null);
        }
        BRelationInfoList rels = palettDict.getRelationDefinitions();
        Iterator relIt = SlotCursorIterator.iterator((SlotCursor)rels.getProperties(), BRelationInfo.class);
        while (relIt.hasNext()) {
            BRelationInfo rel = (BRelationInfo)relIt.next();
            CompUtil.setOrAdd((BComponent)bogDict.getRelationDefinitions(), (String)rel.getName(), (BValue)((BValue)rel.newCopy().as(BRelationInfo.class)), (int)tagdefs.getFlags((Slot)rel.getPropertyInParent()), (BFacets)tagdefs.getSlotFacets((Slot)rel.getPropertyInParent()), null);
        }
        BTagRuleList rulz = palettDict.getTagRules();
        Iterator rulzIt = SlotCursorIterator.iterator((SlotCursor)rulz.getProperties(), BTagRule.class);
        while (rulzIt.hasNext()) {
            BTagRule rule = (BTagRule)rulzIt.next();
            CompUtil.setOrAdd((BComponent)bogDict.getTagRules(), (String)rule.getName(), (BValue)((BValue)rule.newCopy().as(BTagRule.class)), (int)tagdefs.getFlags((Slot)rule.getPropertyInParent()), (BFacets)tagdefs.getSlotFacets((Slot)rule.getPropertyInParent()), null);
        }
        CloudAlertsHelper.ensureEbiTagRules(bogDict);
    }

    public ActivityStatus addForgeTagDictionary() throws Exception {
        BFcTagDictionary tagDictionary = OnboardUtils.getForgeTagDictionary();
        if (tagDictionary != null) {
            CloudAlertsHelper.ensureEbiTagRules(tagDictionary);
            return ActivityStatus.makeSkip("ForgeTagDictionary already exists - " + OnboardUtils.toOrd((BComponent)tagDictionary));
        }
        String dictionaryName = "fcTagDict";
        BFcTagDictionary fcTagDictionary = CloudAlertsHelper.createForgeTagDictionaryInstance();
        BTagDictionaryService tagDictionaryService = null;
        try {
            tagDictionaryService = (BTagDictionaryService)Sys.getService((Type)BTagDictionaryService.TYPE);
        }
        catch (ServiceNotFoundException notFound) {
            return ActivityStatus.makeSkip("Cannot add FC TagDict, no Tag Dictionary Service");
        }
        Mark mark = new Mark((BObject)fcTagDictionary, "fcTagDict");
        TransferResult result = mark.copyTo((BObject)tagDictionaryService, null);
        BFcTagDictionary bfcTagDictionary = (BFcTagDictionary)tagDictionaryService.get("fcTagDict");
        CloudAlertsHelper.ensureEbiTagRules(bfcTagDictionary);
        return ActivityStatus.makeSuccess("Adds fcTagDict - " + OnboardUtils.toOrd((BComponent)bfcTagDictionary));
    }

    public ActivityStatus addModelSyncService() {
        BModelSyncService service = OnboardUtils.getModelSyncService();
        if (service != null) {
            return ActivityStatus.makeSkip("ModelService already added - " + OnboardUtils.toOrd((BComponent)service));
        }
        BModelSyncService modelSyncService = new BModelSyncService();
        modelSyncService.setUnit(BUnitSystem.DEFAULT);
        modelSyncService.setSiteName(Sys.getStation().getStationName());
        modelSyncService.setContextDiscoveryRequired(true);
        BContextDiscoveryModelExtractor extractor = modelSyncService.getModelExtractor();
        extractor.setScope(BOrd.make((String)"station:|slot:/"));
        extractor.setFlags((Slot)BContextDiscoveryModelExtractor.isExportCloudOnlyPoints, 0);
        extractor.setIsIncludeTags(true);
        extractor.setIsExportCloudOnlyPoints(true);
        extractor.setRootEntityTag("hon:Gateway");
        extractor.setEntityIdTag("hon:Id");
        extractor.setEntityTypeTag("hon:honType");
        extractor.setEntityRelations("honhvac:containsProperty;honcore:containsElement");
        extractor.setProxyPointReferenceTag("hon:pointPath");
        extractor.add("label", (BValue)BString.make((String)"n:displayName"));
        extractor.add("comment", (BValue)BString.make((String)"hon:PointDescription"));
        Sys.getStation().getServices().add("ModelSyncService", (BValue)modelSyncService);
        return ActivityStatus.makeSuccess("Adds new modelSyncService - " + OnboardUtils.toOrd((BComponent)modelSyncService));
    }

    public static BFcTagDictionary createForgeTagDictionaryInstance() {
        try {
            String tagDictionaryPalette = "module://fcTagDict/module.palette|slot:/ForgeTagDictionaryPalettes/GenericNetworkDevicePointsDictionary/FcTagDictionary";
            BFcTagDictionary bFcTagDictionary = (BFcTagDictionary)BOrd.make((String)tagDictionaryPalette).resolve().get();
            return bFcTagDictionary;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Unable to create dictionary from ForgeTagDictionary jar's module.palette.", e);
            return null;
        }
    }

    public ActivityStatus removeForgeTagDictionary() {
        LinkedList<BFcTagDictionary> list = OnboardUtils.getForgeTagDictionaries();
        String ordList = list.stream().map(OnboardUtils::toOrd).collect(Collectors.joining("\n"));
        for (BFcTagDictionary comp : list) {
            BComponent parent = (BComponent)comp.getParent();
            parent.remove(comp.getName());
        }
        return ActivityStatus.makeSuccess("Removed ForgeTagDictionaries - " + ordList);
    }

    public ActivityStatus removeModelSyncService() {
        LinkedList<BModelSyncService> list = OnboardUtils.getModelSyncServices();
        String ordList = list.stream().map(OnboardUtils::toOrd).collect(Collectors.joining("\n"));
        for (BModelSyncService comp : list) {
            BComponent parent = (BComponent)comp.getParent();
            parent.remove(comp.getName());
        }
        return ActivityStatus.makeSuccess("Removed Model Sync Service - " + ordList);
    }

    protected static void ensureEbiTagRules(BFcTagDictionary bfcTagDictionary) {
        if (CloudAlertsHelper.isEbiModulePresent()) {
            CloudAlertsHelper.addEbiTagRules(bfcTagDictionary);
        }
    }

    private static boolean isEbiModulePresent() {
        try {
            return Nre.getModuleManager().loadModule("ebiConnector", RuntimeProfile.rt) != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static void addEbiTagRules(BFcTagDictionary bfcTagDictionary) {
        if (bfcTagDictionary.getTagRules().get("ebiPropertyNameRule") == null) {
            bfcTagDictionary.getTagRules().add("ebiPropertyNameRule", (BValue)CloudAlertsHelper.makeTagRule("ebiConnector:EbiConnectorProxyExt", "parameterName", "PropertyName"));
        }
        if (bfcTagDictionary.getTagRules().get("ebiLocationRule") == null) {
            bfcTagDictionary.getTagRules().add("ebiLocationRule", (BValue)CloudAlertsHelper.makeTagRule("ebiConnector:EbiConnectorProxyExt", "locationFullName", "Location"));
        }
        if (bfcTagDictionary.getTagRules().get("ebiCloudIdRule") == null) {
            bfcTagDictionary.getTagRules().add("ebiCloudIdRule", (BValue)CloudAlertsHelper.makePtOrHistPropSuppliedTagRule("ebiConnector:EbiConnectorProxyExt", "ebiConnector:EbiConnectorStandardHistoryImport", "CloudId", ".", "tagName", "parameterName"));
        }
    }

    public static BTagRule makeTagRule(String typeSpec, String driverSlotName, String tagName) {
        BIsPointProxyTypeCondition condition = new BIsPointProxyTypeCondition();
        condition.setProxyExtType(BTypeSpec.make((String)typeSpec));
        BDriverSuppliedTag tag = new BDriverSuppliedTag();
        tag.setSlotName(driverSlotName);
        BTagRule rule = new BTagRule();
        rule.setCondition((BTagRuleCondition)condition);
        rule.getTagList().add(tagName, (BValue)tag);
        return rule;
    }

    public static BTagRule makeProxyExtPropSuppliedTagRule(String typeSpec, String tagName, String separator, String ... driverSlotNames) {
        BIsPointProxyTypeCondition condition = new BIsPointProxyTypeCondition();
        condition.setProxyExtType(BTypeSpec.make((String)typeSpec));
        BPropertySuppliedTag tag = new BPropertySuppliedTag();
        tag.setSeparator(separator);
        tag.setPropertyNamesFromArray(driverSlotNames);
        BTagRule rule = new BTagRule();
        rule.setCondition((BTagRuleCondition)condition);
        rule.getTagList().add(tagName, (BValue)tag);
        return rule;
    }

    public static BTagRule makePtOrHistPropSuppliedTagRule(String tsPoint, String tsHist, String tagName, String separator, String ... driverSlotNames) {
        BIsPointProxyTypeCondition ptCondition = new BIsPointProxyTypeCondition();
        ptCondition.setProxyExtType(BTypeSpec.make((String)tsPoint));
        BIsTypeCondition histCondition = new BIsTypeCondition();
        histCondition.setObjectType(BTypeSpec.make((String)tsHist));
        BOr or = new BOr();
        or.add("pointCondition", (BValue)ptCondition);
        or.add("historyCondition", (BValue)histCondition);
        BPropertySuppliedTag tag = new BPropertySuppliedTag();
        tag.setSeparator(separator);
        tag.setPropertyNamesFromArray(driverSlotNames);
        BTagRule rule = new BTagRule();
        rule.setCondition((BTagRuleCondition)or);
        rule.getTagList().add(tagName, (BValue)tag);
        return rule;
    }
}

