/*
 * Decompiled with CFR 0.152.
 */
package org.testng.reporters.jq;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import org.testng.IReporter;
import org.testng.ISuite;
import org.testng.internal.Utils;
import org.testng.reporters.Files;
import org.testng.reporters.XMLStringBuffer;
import org.testng.reporters.jq.BannerPanel;
import org.testng.reporters.jq.ChronologicalPanel;
import org.testng.reporters.jq.GroupPanel;
import org.testng.reporters.jq.INavigatorPanel;
import org.testng.reporters.jq.IgnoredMethodsPanel;
import org.testng.reporters.jq.Model;
import org.testng.reporters.jq.NavigatorPanel;
import org.testng.reporters.jq.ReporterPanel;
import org.testng.reporters.jq.SuitePanel;
import org.testng.reporters.jq.TestNgXmlPanel;
import org.testng.reporters.jq.TestPanel;
import org.testng.reporters.jq.TimesPanel;
import org.testng.xml.XmlSuite;

public class Main
implements IReporter {
    private static final String TESTNG_RESOURCE_PREFIX = "/org/testng/";
    private static final String[] RESOURCES = new String[]{"jquery-1.7.1.min.js", "testng-reports.css", "testng-reports.js", "passed.png", "failed.png", "skipped.png", "navigator-bullet.png", "bullet_point.png", "collapseall.gif"};
    public static final String REPORT_HEADER_FILE = "header";
    private Model m_model;
    private String m_outputDirectory;

    @Override
    public void generateReport(List<XmlSuite> xmlSuites, List<ISuite> suites, String outputDirectory) {
        this.m_model = new Model(suites);
        this.m_outputDirectory = outputDirectory;
        XMLStringBuffer xsb = new XMLStringBuffer("    ");
        new BannerPanel(this.m_model).generate(xsb);
        List<INavigatorPanel> panels = Arrays.asList(new TestNgXmlPanel(this.m_model), new TestPanel(this.m_model), new GroupPanel(this.m_model), new TimesPanel(this.m_model), new ReporterPanel(this.m_model), new IgnoredMethodsPanel(this.m_model), new ChronologicalPanel(this.m_model));
        new NavigatorPanel(this.m_model, panels).generate(xsb);
        xsb.push("div", "class", "wrapper");
        xsb.push("div", "class", "main-panel-root");
        new SuitePanel(this.m_model).generate(xsb);
        for (INavigatorPanel panel : panels) {
            panel.generate(xsb);
        }
        xsb.pop("div");
        xsb.pop("div");
        xsb.addString("  </body>\n");
        xsb.addString("</html>\n");
        try (InputStream header = this.getClass().getResourceAsStream("/org/testng/header");){
            if (header == null) {
                throw new RuntimeException("Couldn't find resource header");
            }
            for (String fileName : RESOURCES) {
                try (InputStream is = this.getClass().getResourceAsStream(TESTNG_RESOURCE_PREFIX + fileName);){
                    if (is == null) {
                        throw new AssertionError((Object)("Couldn't find resource: " + fileName));
                    }
                    Files.copyFile(is, new File(this.m_outputDirectory, fileName));
                }
            }
            String all = Files.readFile(header);
            Utils.writeUtf8File(this.m_outputDirectory, "index.html", xsb, all);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

