/*
 * Decompiled with CFR 0.152.
 */
package org.testng.reporters;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import java.util.Queue;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.regex.Pattern;
import org.testng.ITestContext;
import org.testng.ITestNGMethod;
import org.testng.ITestResult;
import org.testng.collections.Maps;
import org.testng.collections.Sets;
import org.testng.internal.IResultListener2;
import org.testng.internal.Utils;
import org.testng.reporters.XMLStringBuffer;

public class JUnitXMLReporter
implements IResultListener2 {
    private static final Pattern ENTITY = Pattern.compile("&[a-zA-Z]+;.*");
    private static final Pattern LESS = Pattern.compile("<");
    private static final Pattern GREATER = Pattern.compile(">");
    private static final Pattern SINGLE_QUOTE = Pattern.compile("'");
    private static final Pattern QUOTE = Pattern.compile("\"");
    private static final Map<String, Pattern> ATTR_ESCAPES = Maps.newHashMap();
    private int m_numFailed = 0;
    private Queue<ITestResult> m_allTests = new ConcurrentLinkedDeque<ITestResult>();
    private Queue<ITestResult> m_configIssues = new ConcurrentLinkedDeque<ITestResult>();
    private Map<String, String> m_fileNameMap = Maps.newHashMap();
    private int m_fileNameIncrementer = 0;

    @Override
    public void onTestStart(ITestResult result) {
    }

    @Override
    public void beforeConfiguration(ITestResult tr) {
    }

    @Override
    public void onTestSuccess(ITestResult tr) {
        this.m_allTests.add(tr);
    }

    @Override
    public void onTestFailedButWithinSuccessPercentage(ITestResult tr) {
        this.m_allTests.add(tr);
    }

    @Override
    public void onTestFailure(ITestResult tr) {
        this.m_allTests.add(tr);
        ++this.m_numFailed;
    }

    @Override
    public void onTestSkipped(ITestResult tr) {
        this.m_allTests.add(tr);
    }

    @Override
    public void onStart(ITestContext context) {
    }

    @Override
    public void onFinish(ITestContext context) {
        this.generateReport(context);
        this.resetAll();
    }

    @Override
    public void onConfigurationFailure(ITestResult itr) {
        this.m_configIssues.add(itr);
    }

    @Override
    public void onConfigurationSkip(ITestResult itr) {
        this.m_configIssues.add(itr);
    }

    @Override
    public void onConfigurationSuccess(ITestResult itr) {
    }

    protected void generateReport(ITestContext context) {
        XMLStringBuffer document = new XMLStringBuffer();
        document.addComment("Generated by " + this.getClass().getName());
        Properties attrs = new Properties();
        attrs.setProperty("errors", "0");
        attrs.setProperty("failures", Integer.toString(this.m_numFailed));
        attrs.setProperty("ignored", Integer.toString(context.getExcludedMethods().size()));
        try {
            attrs.setProperty("hostname", InetAddress.getLocalHost().getHostName());
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        Set<String> packages = this.getPackages(context);
        if (packages.size() > 0) {
            attrs.setProperty("name", context.getCurrentXmlTest().getName());
        }
        attrs.setProperty("tests", Integer.toString(this.m_allTests.size()));
        attrs.setProperty("time", Double.toString((double)(context.getEndDate().getTime() - context.getStartDate().getTime()) / 1000.0));
        attrs.setProperty("timestamp", JUnitXMLReporter.timeAsGmt());
        document.push("testsuite", attrs);
        this.createElementFromTestResults(document, this.m_configIssues);
        this.createElementFromTestResults(document, this.m_allTests);
        this.createElementFromIgnoredTests(document, context);
        document.pop();
        Utils.writeUtf8File(context.getOutputDirectory(), this.generateFileName(context) + ".xml", document.toXML());
    }

    static String timeAsGmt() {
        SimpleDateFormat sdf = new SimpleDateFormat();
        sdf.setTimeZone(TimeZone.getTimeZone("GMT"));
        sdf.applyPattern("dd MMM yyyy HH:mm:ss z");
        return sdf.format(Calendar.getInstance().getTime());
    }

    private synchronized void createElementFromTestResults(XMLStringBuffer document, Collection<ITestResult> results) {
        for (ITestResult tr : results) {
            this.createElement(document, tr);
        }
    }

    private synchronized void createElementFromIgnoredTests(XMLStringBuffer doc, ITestContext context) {
        Collection<ITestNGMethod> methods = context.getExcludedMethods();
        for (ITestNGMethod method : methods) {
            Properties properties = this.getPropertiesFor(method, 0L);
            doc.push("testcase", properties);
            doc.addEmptyElement("ignored");
            doc.pop();
        }
    }

    private Properties getPropertiesFor(ITestNGMethod method, long elapsedTimeMillis) {
        Properties attrs = new Properties();
        String name = Utils.detailedMethodName(method, false);
        attrs.setProperty("name", name);
        attrs.setProperty("classname", method.getRealClass().getName());
        attrs.setProperty("time", Double.toString((double)elapsedTimeMillis / 1000.0));
        return attrs;
    }

    private Set<String> getPackages(ITestContext context) {
        Set<String> result = Sets.newHashSet();
        for (ITestNGMethod m : context.getAllTestMethods()) {
            Package pkg = m.getConstructorOrMethod().getDeclaringClass().getPackage();
            if (pkg == null) continue;
            result.add(pkg.getName());
        }
        return result;
    }

    private void createElement(XMLStringBuffer doc, ITestResult tr) {
        long elapsedTimeMillis = tr.getEndMillis() - tr.getStartMillis();
        Properties attrs = this.getPropertiesFor(tr.getMethod(), elapsedTimeMillis);
        if (tr.getMethod().isTest()) {
            attrs.setProperty("name", tr.getName());
        }
        if (2 == tr.getStatus() || 3 == tr.getStatus()) {
            doc.push("testcase", attrs);
            if (2 == tr.getStatus()) {
                this.createFailureElement(doc, tr);
            } else if (3 == tr.getStatus()) {
                this.createSkipElement(doc);
            }
            doc.pop();
        } else {
            doc.addEmptyElement("testcase", attrs);
        }
    }

    private void createFailureElement(XMLStringBuffer doc, ITestResult tr) {
        Properties attrs = new Properties();
        Throwable t = tr.getThrowable();
        if (t != null) {
            attrs.setProperty("type", t.getClass().getName());
            String message = t.getMessage();
            if (message != null && message.length() > 0) {
                attrs.setProperty("message", this.encodeAttr(message));
            }
            doc.push("failure", attrs);
            doc.addCDATA(Utils.shortStackTrace(t, false));
            doc.pop();
        } else {
            doc.addEmptyElement("failure");
        }
    }

    private void createSkipElement(XMLStringBuffer doc) {
        doc.addEmptyElement("skipped");
    }

    private String encodeAttr(String attr) {
        String result = this.replaceAmpersand(attr, ENTITY);
        for (Map.Entry<String, Pattern> e : ATTR_ESCAPES.entrySet()) {
            result = e.getValue().matcher(result).replaceAll(e.getKey());
        }
        return result;
    }

    private String replaceAmpersand(String str, Pattern pattern) {
        int start = 0;
        int idx = str.indexOf(38, start);
        if (idx == -1) {
            return str;
        }
        StringBuilder result = new StringBuilder();
        while (idx != -1) {
            result.append(str.substring(start, idx));
            if (pattern.matcher(str.substring(idx)).matches()) {
                result.append("&");
            } else {
                result.append("&amp;");
            }
            start = idx + 1;
            idx = str.indexOf(38, start);
        }
        result.append(str.substring(start));
        return result.toString();
    }

    private void resetAll() {
        this.m_allTests = new ConcurrentLinkedDeque<ITestResult>();
        this.m_configIssues = new ConcurrentLinkedDeque<ITestResult>();
        this.m_numFailed = 0;
    }

    private String generateFileName(ITestContext context) {
        String keyToSearch = context.getSuite().getName() + context.getName();
        String fileName = this.m_fileNameMap.get(keyToSearch) == null ? context.getName() : context.getName() + this.m_fileNameIncrementer++;
        this.m_fileNameMap.put(keyToSearch, fileName);
        return fileName;
    }

    static {
        ATTR_ESCAPES.put("&lt;", LESS);
        ATTR_ESCAPES.put("&gt;", GREATER);
        ATTR_ESCAPES.put("&apos;", SINGLE_QUOTE);
        ATTR_ESCAPES.put("&quot;", QUOTE);
    }
}

