/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal;

import java.util.List;
import org.testng.IClass;
import org.testng.IConfigurationListener;
import org.testng.IConfigurationListener2;
import org.testng.ITestListener;
import org.testng.ITestNGListener;
import org.testng.ITestNGListenerFactory;
import org.testng.ITestResult;
import org.testng.TestNGException;
import org.testng.annotations.IListenersAnnotation;
import org.testng.collections.Lists;
import org.testng.internal.TestNGClassFinder;
import org.testng.internal.annotations.IAnnotationFinder;

public final class TestListenerHelper {
    private TestListenerHelper() {
    }

    static void runPreConfigurationListeners(ITestResult tr, List<IConfigurationListener> listeners) {
        for (IConfigurationListener icl : listeners) {
            if (!(icl instanceof IConfigurationListener2)) continue;
            ((IConfigurationListener2)icl).beforeConfiguration(tr);
        }
    }

    static void runPostConfigurationListeners(ITestResult tr, List<IConfigurationListener> listeners) {
        block5: for (IConfigurationListener icl : listeners) {
            switch (tr.getStatus()) {
                case 3: {
                    icl.onConfigurationSkip(tr);
                    continue block5;
                }
                case 2: {
                    icl.onConfigurationFailure(tr);
                    continue block5;
                }
                case 1: {
                    icl.onConfigurationSuccess(tr);
                    continue block5;
                }
            }
            throw new AssertionError((Object)("Unexpected value: " + tr.getStatus()));
        }
    }

    public static void runTestListeners(ITestResult tr, List<ITestListener> listeners) {
        block7: for (ITestListener itl : listeners) {
            switch (tr.getStatus()) {
                case 3: {
                    itl.onTestSkipped(tr);
                    continue block7;
                }
                case 4: {
                    itl.onTestFailedButWithinSuccessPercentage(tr);
                    continue block7;
                }
                case 2: {
                    itl.onTestFailure(tr);
                    continue block7;
                }
                case 1: {
                    itl.onTestSuccess(tr);
                    continue block7;
                }
                case 16: {
                    itl.onTestStart(tr);
                    continue block7;
                }
            }
            throw new AssertionError((Object)("Unknown status: " + tr.getStatus()));
        }
    }

    public static ListenerHolder findAllListeners(Class<?> cls, IAnnotationFinder finder) {
        ListenerHolder result = new ListenerHolder();
        result.listenerClasses = Lists.newArrayList();
        while (cls != Object.class) {
            IListenersAnnotation l = finder.findAnnotation(cls, IListenersAnnotation.class);
            if (l != null) {
                Class<? extends ITestNGListener>[] classes;
                for (Class<? extends ITestNGListener> c : classes = l.getValue()) {
                    result.listenerClasses.add(c);
                    if (!ITestNGListenerFactory.class.isAssignableFrom(c)) continue;
                    if (result.listenerFactoryClass == null) {
                        result.listenerFactoryClass = c;
                        continue;
                    }
                    throw new TestNGException("Found more than one class implementing ITestNGListenerFactory:" + c + " and " + result.listenerFactoryClass);
                }
            }
            cls = cls.getSuperclass();
        }
        return result;
    }

    public static ITestNGListenerFactory createListenerFactory(TestNGClassFinder finder, Class<? extends ITestNGListenerFactory> factoryClass) {
        ITestNGListenerFactory listenerFactory = null;
        try {
            IClass ic;
            if (finder != null && (ic = finder.getIClass(factoryClass)) != null) {
                listenerFactory = (ITestNGListenerFactory)ic.getInstances(false)[0];
            }
            if (listenerFactory == null) {
                listenerFactory = factoryClass != null ? factoryClass.newInstance() : null;
            }
            return listenerFactory;
        }
        catch (Exception ex) {
            throw new TestNGException("Couldn't instantiate the ITestNGListenerFactory: " + ex);
        }
    }

    public static class ListenerHolder {
        private List<Class<? extends ITestNGListener>> listenerClasses;
        private Class<? extends ITestNGListenerFactory> listenerFactoryClass;

        public List<Class<? extends ITestNGListener>> getListenerClasses() {
            return this.listenerClasses;
        }

        public Class<? extends ITestNGListenerFactory> getListenerFactoryClass() {
            return this.listenerFactoryClass;
        }
    }
}

