/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.testng.DependencyMap;
import org.testng.ITestNGMethod;
import org.testng.TestNGException;
import org.testng.TestRunner;
import org.testng.collections.ListMultiMap;
import org.testng.collections.Lists;
import org.testng.collections.Maps;
import org.testng.internal.DynamicGraph;
import org.testng.internal.WrappedTestNGMethod;
import org.testng.xml.XmlClass;
import org.testng.xml.XmlSuite;
import org.testng.xml.XmlTest;

public final class DynamicGraphHelper {
    private DynamicGraphHelper() {
    }

    public static DynamicGraph<ITestNGMethod> createDynamicGraph(ITestNGMethod[] methods, XmlTest xmlTest) {
        DynamicGraph<ITestNGMethod> result = new DynamicGraph<ITestNGMethod>();
        ListMultiMap<Integer, ITestNGMethod> methodsByPriority = Maps.newListMultiMap();
        for (ITestNGMethod method : methods) {
            methodsByPriority.put(method.getPriority(), method);
        }
        List availablePriorities = Lists.newArrayList(methodsByPriority.keySet());
        Collections.sort(availablePriorities);
        Integer previousPriority = methods.length > 0 ? (Integer)availablePriorities.get(0) : 0;
        for (int i = 1; i < availablePriorities.size(); ++i) {
            Integer currentPriority = (Integer)availablePriorities.get(i);
            for (ITestNGMethod p0Method : (List)methodsByPriority.get(previousPriority)) {
                for (ITestNGMethod p1Method : (List)methodsByPriority.get(currentPriority)) {
                    result.addEdge(TestRunner.PriorityWeight.priority.ordinal(), p1Method, p0Method);
                }
            }
            previousPriority = currentPriority;
        }
        DependencyMap dependencyMap = new DependencyMap(methods);
        boolean hasDependencies = false;
        for (ITestNGMethod m : methods) {
            String[] dependentGroups;
            String[] dependentMethods;
            boolean added = result.addNode(m);
            if (!added) {
                result.addNode(new WrappedTestNGMethod(m));
            }
            if ((dependentMethods = m.getMethodsDependedUpon()) != null) {
                for (String d : dependentMethods) {
                    ITestNGMethod dm = dependencyMap.getMethodDependingOn(d, m);
                    if (m == dm) continue;
                    result.addEdge(TestRunner.PriorityWeight.dependsOnMethods.ordinal(), m, dm);
                }
            }
            for (String d : dependentGroups = m.getGroupsDependedUpon()) {
                hasDependencies = true;
                List<ITestNGMethod> dg = dependencyMap.getMethodsThatBelongTo(d, m);
                if (dg == null) {
                    throw new TestNGException("Method \"" + m + "\" depends on nonexistent group \"" + d + "\"");
                }
                for (ITestNGMethod ddm : dg) {
                    result.addEdge(TestRunner.PriorityWeight.dependsOnGroups.ordinal(), m, ddm);
                }
            }
        }
        if (!hasDependencies && xmlTest.getParallel() == XmlSuite.ParallelMode.NONE && xmlTest.getPreserveOrder().booleanValue()) {
            ListMultiMap<ITestNGMethod, ITestNGMethod> classDependencies = DynamicGraphHelper.createClassDependencies(methods, xmlTest);
            for (Map.Entry es : classDependencies.entrySet()) {
                for (ITestNGMethod dm : (List)es.getValue()) {
                    result.addEdge(TestRunner.PriorityWeight.preserveOrder.ordinal(), dm, (ITestNGMethod)es.getKey());
                }
            }
        }
        if (xmlTest.getGroupByInstances()) {
            ListMultiMap<ITestNGMethod, ITestNGMethod> instanceDependencies = DynamicGraphHelper.createInstanceDependencies(methods);
            for (Map.Entry es : instanceDependencies.entrySet()) {
                result.addEdge(TestRunner.PriorityWeight.groupByInstance.ordinal(), (ITestNGMethod)es.getKey(), (Iterable)es.getValue());
            }
        }
        return result;
    }

    private static Comparator<XmlClass> classComparator() {
        return new Comparator<XmlClass>(){

            @Override
            public int compare(XmlClass arg0, XmlClass arg1) {
                return arg0.getIndex() - arg1.getIndex();
            }
        };
    }

    private static ListMultiMap<ITestNGMethod, ITestNGMethod> createClassDependencies(ITestNGMethod[] methods, XmlTest test) {
        Map classes = Maps.newHashMap();
        List<ITestNGMethod[]> sortedClasses = Lists.newArrayList();
        for (XmlClass c : test.getXmlClasses()) {
            classes.put(c.getName(), new ArrayList());
            if (sortedClasses.contains(c)) continue;
            sortedClasses.add((ITestNGMethod[])c);
        }
        Collections.sort(sortedClasses, DynamicGraphHelper.classComparator());
        Map<String, Integer> indexedClasses1 = Maps.newHashMap();
        Map<Integer, String> indexedClasses2 = Maps.newHashMap();
        int i = 0;
        for (ITestNGMethod[] c : sortedClasses) {
            indexedClasses1.put(c.getName(), i);
            indexedClasses2.put(i, c.getName());
            ++i;
        }
        ListMultiMap<String, ITestNGMethod> methodsFromClass = Maps.newListMultiMap();
        for (ITestNGMethod m : methods) {
            methodsFromClass.put(m.getTestClass().getName(), m);
        }
        ListMultiMap<ITestNGMethod, ITestNGMethod> result = Maps.newListMultiMap();
        for (ITestNGMethod m : methods) {
            String name = m.getTestClass().getName();
            Integer index = (Integer)indexedClasses1.get(name);
            if (index == null || index <= 0) continue;
            String classDependedUpon = (String)indexedClasses2.get(index - 1);
            List methodsDependedUpon = (List)methodsFromClass.get(classDependedUpon);
            for (ITestNGMethod mdu : methodsDependedUpon) {
                result.put(mdu, m);
            }
        }
        return result;
    }

    private static ListMultiMap<ITestNGMethod, ITestNGMethod> createInstanceDependencies(ITestNGMethod[] methods) {
        ListMultiMap<Object, ITestNGMethod> instanceMap = Maps.newSortedListMultiMap();
        for (ITestNGMethod m : methods) {
            instanceMap.put(m.getInstance(), m);
        }
        ListMultiMap<ITestNGMethod, ITestNGMethod> result = Maps.newListMultiMap();
        Object previousInstance = null;
        for (Map.Entry es : instanceMap.entrySet()) {
            if (previousInstance == null) {
                previousInstance = es.getKey();
                continue;
            }
            List previousMethods = (List)instanceMap.get(previousInstance);
            Object currentInstance = es.getKey();
            List currentMethods = (List)instanceMap.get(currentInstance);
            for (ITestNGMethod cm : currentMethods) {
                for (ITestNGMethod pm : previousMethods) {
                    result.put(cm, pm);
                }
            }
            previousInstance = currentInstance;
        }
        return result;
    }
}

