/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal;

import java.util.Map;
import org.testng.IClass;
import org.testng.ITestClassFinder;
import org.testng.ITestContext;
import org.testng.ITestObjectFactory;
import org.testng.collections.Maps;
import org.testng.internal.ClassImpl;
import org.testng.internal.annotations.IAnnotationFinder;
import org.testng.xml.XmlClass;
import org.testng.xml.XmlTest;

public abstract class BaseClassFinder
implements ITestClassFinder {
    private final Map<Class<?>, IClass> m_classes = Maps.newLinkedHashMap();

    @Override
    public IClass getIClass(Class<?> cls) {
        return this.m_classes.get(cls);
    }

    protected void putIClass(Class<?> cls, IClass iClass) {
        if (!this.m_classes.containsKey(cls)) {
            this.m_classes.put(cls, iClass);
        }
    }

    @Deprecated
    protected IClass findOrCreateIClass(ITestContext context, Class<?> cls, XmlClass xmlClass, Object instance, XmlTest xmlTest, IAnnotationFinder annotationFinder, ITestObjectFactory objectFactory) {
        return this.findOrCreateIClass(context, cls, xmlClass, instance, annotationFinder, objectFactory);
    }

    protected IClass findOrCreateIClass(ITestContext context, Class<?> cls, XmlClass xmlClass, Object instance, IAnnotationFinder annotationFinder, ITestObjectFactory objectFactory) {
        IClass result = this.m_classes.get(cls);
        if (null == result) {
            result = new ClassImpl(context, cls, xmlClass, instance, this.m_classes, annotationFinder, objectFactory);
            this.m_classes.put(cls, result);
        }
        return result;
    }

    @Deprecated
    protected Map getExistingClasses() {
        return this.m_classes;
    }

    protected boolean classExists(Class<?> cls) {
        return this.m_classes.containsKey(cls);
    }

    @Override
    public IClass[] findTestClasses() {
        return this.m_classes.values().toArray(new IClass[this.m_classes.size()]);
    }
}

