/*
 * Decompiled with CFR 0.152.
 */
package org.testng;

import com.google.inject.Injector;
import java.io.File;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.testng.IAttributes;
import org.testng.IClassListener;
import org.testng.IConfigurationListener;
import org.testng.IDataProviderListener;
import org.testng.IInvokedMethod;
import org.testng.IInvokedMethodListener;
import org.testng.IMethodInterceptor;
import org.testng.IObjectFactory;
import org.testng.IObjectFactory2;
import org.testng.IReporter;
import org.testng.ISuite;
import org.testng.ISuiteListener;
import org.testng.ISuiteResult;
import org.testng.ITestListener;
import org.testng.ITestNGListener;
import org.testng.ITestNGMethod;
import org.testng.ITestObjectFactory;
import org.testng.ITestResult;
import org.testng.ITestRunnerFactory;
import org.testng.ITestRunnerFactory2;
import org.testng.SuiteResult;
import org.testng.SuiteRunState;
import org.testng.TestListenerAdapter;
import org.testng.TestRunner;
import org.testng.collections.Lists;
import org.testng.collections.Maps;
import org.testng.internal.Attributes;
import org.testng.internal.IConfiguration;
import org.testng.internal.IInvoker;
import org.testng.internal.Systematiser;
import org.testng.internal.Utils;
import org.testng.internal.annotations.IAnnotationFinder;
import org.testng.internal.thread.ThreadUtil;
import org.testng.reporters.JUnitXMLReporter;
import org.testng.reporters.TestHTMLReporter;
import org.testng.reporters.TextReporter;
import org.testng.xml.XmlSuite;
import org.testng.xml.XmlTest;

public class SuiteRunner
implements ISuite,
IInvokedMethodListener {
    private static final String DEFAULT_OUTPUT_DIR = "test-output";
    private Map<String, ISuiteResult> suiteResults = Collections.synchronizedMap(Maps.newLinkedHashMap());
    private List<TestRunner> testRunners = Lists.newArrayList();
    private Map<Class<? extends ISuiteListener>, ISuiteListener> listeners = Maps.newHashMap();
    private TestListenerAdapter textReporter = new TestListenerAdapter();
    private String outputDir;
    private XmlSuite xmlSuite;
    private Injector parentInjector;
    private List<ITestListener> testListeners = Lists.newArrayList();
    private final Map<Class<? extends IClassListener>, IClassListener> classListeners = Maps.newHashMap();
    private final Map<Class<? extends IDataProviderListener>, IDataProviderListener> dataProviderListeners = Maps.newHashMap();
    private ITestRunnerFactory tmpRunnerFactory;
    private boolean useDefaultListeners = true;
    private String remoteHost;
    private IConfiguration configuration;
    private ITestObjectFactory objectFactory;
    private Boolean skipFailedInvocationCounts = Boolean.FALSE;
    private List<IReporter> reporters = Lists.newArrayList();
    private Map<Class<? extends IInvokedMethodListener>, IInvokedMethodListener> invokedMethodListeners;
    private final Collection<IInvokedMethod> invokedMethods = new ConcurrentLinkedQueue<IInvokedMethod>();
    private List<ITestNGMethod> allTestMethods = Lists.newArrayList();
    private SuiteRunState suiteState = new SuiteRunState();
    private IAttributes attributes = new Attributes();

    public SuiteRunner(IConfiguration configuration, XmlSuite suite, String outputDir, Comparator<ITestNGMethod> comparator) {
        this(configuration, suite, outputDir, null, comparator);
    }

    public SuiteRunner(IConfiguration configuration, XmlSuite suite, String outputDir, ITestRunnerFactory runnerFactory, Comparator<ITestNGMethod> comparator) {
        this(configuration, suite, outputDir, runnerFactory, false, comparator);
    }

    public SuiteRunner(IConfiguration configuration, XmlSuite suite, String outputDir, ITestRunnerFactory runnerFactory, boolean useDefaultListeners, Comparator<ITestNGMethod> comparator) {
        this(configuration, suite, outputDir, runnerFactory, useDefaultListeners, new ArrayList<IMethodInterceptor>(), null, null, null, Collections.emptyMap(), comparator);
    }

    @Deprecated
    public SuiteRunner(IConfiguration configuration, XmlSuite suite, String outputDir) {
        this(configuration, suite, outputDir, (ITestRunnerFactory)null);
    }

    @Deprecated
    public SuiteRunner(IConfiguration configuration, XmlSuite suite, String outputDir, ITestRunnerFactory runnerFactory) {
        this(configuration, suite, outputDir, runnerFactory, false);
    }

    @Deprecated
    public SuiteRunner(IConfiguration configuration, XmlSuite suite, String outputDir, ITestRunnerFactory runnerFactory, boolean useDefaultListeners) {
        this(configuration, suite, outputDir, runnerFactory, useDefaultListeners, new ArrayList<IMethodInterceptor>(), null, null, null, Collections.emptyMap(), Systematiser.getComparator());
    }

    @Deprecated
    protected SuiteRunner(IConfiguration configuration, XmlSuite suite, String outputDir, ITestRunnerFactory runnerFactory, boolean useDefaultListeners, List<IMethodInterceptor> methodInterceptors, List<IInvokedMethodListener> invokedMethodListeners, List<ITestListener> testListeners, List<IClassListener> classListeners) {
        this.init(configuration, suite, outputDir, runnerFactory, useDefaultListeners, methodInterceptors, invokedMethodListeners, testListeners, classListeners, Collections.emptyMap(), Systematiser.getComparator());
    }

    @Deprecated
    protected SuiteRunner(IConfiguration configuration, XmlSuite suite, String outputDir, ITestRunnerFactory runnerFactory, boolean useDefaultListeners, List<IMethodInterceptor> methodInterceptors, Collection<IInvokedMethodListener> invokedMethodListeners, Collection<ITestListener> testListeners, Collection<IClassListener> classListeners) {
        this.init(configuration, suite, outputDir, runnerFactory, useDefaultListeners, methodInterceptors, invokedMethodListeners, testListeners, classListeners, Collections.emptyMap(), Systematiser.getComparator());
    }

    @Deprecated
    protected SuiteRunner(IConfiguration configuration, XmlSuite suite, String outputDir, ITestRunnerFactory runnerFactory, boolean useDefaultListeners, List<IMethodInterceptor> methodInterceptors, Collection<IInvokedMethodListener> invokedMethodListeners, Collection<ITestListener> testListeners, Collection<IClassListener> classListeners, Comparator<ITestNGMethod> comparator) {
        this(configuration, suite, outputDir, runnerFactory, useDefaultListeners, methodInterceptors, invokedMethodListeners, testListeners, classListeners, Collections.emptyMap(), comparator);
    }

    protected SuiteRunner(IConfiguration configuration, XmlSuite suite, String outputDir, ITestRunnerFactory runnerFactory, boolean useDefaultListeners, List<IMethodInterceptor> methodInterceptors, Collection<IInvokedMethodListener> invokedMethodListeners, Collection<ITestListener> testListeners, Collection<IClassListener> classListeners, Map<Class<? extends IDataProviderListener>, IDataProviderListener> dataProviderListeners, Comparator<ITestNGMethod> comparator) {
        this.init(configuration, suite, outputDir, runnerFactory, useDefaultListeners, methodInterceptors, invokedMethodListeners, testListeners, classListeners, dataProviderListeners, comparator);
    }

    private void init(IConfiguration configuration, XmlSuite suite, String outputDir, ITestRunnerFactory runnerFactory, boolean useDefaultListeners, List<IMethodInterceptor> methodInterceptors, Collection<IInvokedMethodListener> invokedMethodListener, Collection<ITestListener> testListeners, Collection<IClassListener> classListeners, Map<Class<? extends IDataProviderListener>, IDataProviderListener> dataProviderListeners, Comparator<ITestNGMethod> comparator) {
        this.configuration = configuration;
        this.xmlSuite = suite;
        this.useDefaultListeners = useDefaultListeners;
        this.tmpRunnerFactory = runnerFactory;
        ArrayList localMethodInterceptors = methodInterceptors != null ? methodInterceptors : new ArrayList();
        this.setOutputDir(outputDir);
        this.objectFactory = this.configuration.getObjectFactory();
        if (this.objectFactory == null) {
            this.objectFactory = suite.getObjectFactory();
        }
        this.invokedMethodListeners = Maps.newHashMap();
        if (invokedMethodListener != null) {
            for (IInvokedMethodListener listener : invokedMethodListener) {
                this.invokedMethodListeners.put(listener.getClass(), listener);
            }
        }
        this.invokedMethodListeners.put(this.getClass(), this);
        this.skipFailedInvocationCounts = suite.skipFailedInvocationCounts();
        if (null != testListeners) {
            this.testListeners.addAll(testListeners);
        }
        if (null != classListeners) {
            for (IClassListener classListener : classListeners) {
                this.classListeners.put(classListener.getClass(), classListener);
            }
        }
        if (null != dataProviderListeners) {
            this.dataProviderListeners.putAll(dataProviderListeners);
        }
        if (comparator == null) {
            throw new IllegalArgumentException("comparator must not be null");
        }
        ITestRunnerFactory2 iTestRunnerFactory = this.buildRunnerFactory(comparator);
        List<XmlTest> xmlTests = this.xmlSuite.getTests();
        Collections.sort(xmlTests, new Comparator<XmlTest>(){

            @Override
            public int compare(XmlTest arg0, XmlTest arg1) {
                return arg0.getIndex() - arg1.getIndex();
            }
        });
        for (XmlTest test : xmlTests) {
            TestRunner tr = iTestRunnerFactory.newTestRunner(this, test, this.invokedMethodListeners.values(), Lists.newArrayList(this.classListeners.values()), this.dataProviderListeners);
            for (IMethodInterceptor methodInterceptor : localMethodInterceptors) {
                tr.addMethodInterceptor(methodInterceptor);
            }
            tr.addListener(this.textReporter);
            this.testRunners.add(tr);
            this.allTestMethods.addAll(Arrays.asList(tr.getAllTestMethods()));
        }
    }

    @Override
    public XmlSuite getXmlSuite() {
        return this.xmlSuite;
    }

    @Override
    public String getName() {
        return this.xmlSuite.getName();
    }

    public void setObjectFactory(ITestObjectFactory objectFactory) {
        this.objectFactory = objectFactory;
    }

    public void setReportResults(boolean reportResults) {
        this.useDefaultListeners = reportResults;
    }

    private void invokeListeners(boolean start) {
        for (ISuiteListener sl : this.listeners.values()) {
            if (start) {
                sl.onStart(this);
                continue;
            }
            sl.onFinish(this);
        }
    }

    private void setOutputDir(String outputdir) {
        if (Utils.isStringBlank(outputdir) && this.useDefaultListeners) {
            outputdir = DEFAULT_OUTPUT_DIR;
        }
        this.outputDir = null != outputdir ? new File(outputdir).getAbsolutePath() : null;
    }

    private ITestRunnerFactory2 buildRunnerFactory(Comparator<ITestNGMethod> comparator) {
        ITestRunnerFactory2 factory = null == this.tmpRunnerFactory ? new DefaultTestRunnerFactory(this.configuration, this.testListeners.toArray(new ITestListener[this.testListeners.size()]), this.useDefaultListeners, this.skipFailedInvocationCounts, comparator) : new ProxyTestRunnerFactory(this.testListeners.toArray(new ITestListener[this.testListeners.size()]), this.tmpRunnerFactory);
        return factory;
    }

    @Override
    public String getParallel() {
        return this.xmlSuite.getParallel().toString();
    }

    @Override
    public String getParentModule() {
        return this.xmlSuite.getParentModule();
    }

    @Override
    public String getGuiceStage() {
        return this.xmlSuite.getGuiceStage();
    }

    @Override
    public Injector getParentInjector() {
        return this.parentInjector;
    }

    @Override
    public void setParentInjector(Injector injector) {
        this.parentInjector = injector;
    }

    @Override
    public void run() {
        this.invokeListeners(true);
        try {
            this.privateRun();
        }
        finally {
            this.invokeListeners(false);
        }
    }

    private void privateRun() {
        LinkedHashMap<Method, ITestNGMethod> beforeSuiteMethods = new LinkedHashMap<Method, ITestNGMethod>();
        LinkedHashMap<Method, ITestNGMethod> afterSuiteMethods = new LinkedHashMap<Method, ITestNGMethod>();
        IInvoker invoker = null;
        for (TestRunner tr : this.testRunners) {
            invoker = tr.getInvoker();
            for (ITestNGMethod m : tr.getBeforeSuiteMethods()) {
                beforeSuiteMethods.put(m.getConstructorOrMethod().getMethod(), m);
            }
            for (ITestNGMethod m : tr.getAfterSuiteMethods()) {
                afterSuiteMethods.put(m.getConstructorOrMethod().getMethod(), m);
            }
        }
        if (invoker != null) {
            if (!beforeSuiteMethods.values().isEmpty()) {
                invoker.invokeConfigurations(null, beforeSuiteMethods.values().toArray(new ITestNGMethod[beforeSuiteMethods.size()]), this.xmlSuite, this.xmlSuite.getParameters(), null, null);
            }
            Utils.log("SuiteRunner", 3, "Created " + this.testRunners.size() + " TestRunners");
            boolean testsInParallel = XmlSuite.ParallelMode.TESTS.equals((Object)this.xmlSuite.getParallel());
            if (!testsInParallel) {
                this.runSequentially();
            } else {
                this.runInParallelTestMode();
            }
            if (!afterSuiteMethods.values().isEmpty()) {
                invoker.invokeConfigurations(null, afterSuiteMethods.values().toArray(new ITestNGMethod[afterSuiteMethods.size()]), this.xmlSuite, this.xmlSuite.getAllParameters(), null, null);
            }
        }
    }

    private void addReporter(IReporter listener) {
        this.reporters.add(listener);
    }

    void addConfigurationListener(IConfigurationListener listener) {
        this.configuration.addConfigurationListener(listener);
    }

    public List<IReporter> getReporters() {
        return this.reporters;
    }

    private void runSequentially() {
        for (TestRunner tr : this.testRunners) {
            this.runTest(tr);
        }
    }

    private void runTest(TestRunner tr) {
        tr.run();
        SuiteResult sr = new SuiteResult(this.xmlSuite, tr);
        this.suiteResults.put(tr.getName(), sr);
    }

    private void runInParallelTestMode() {
        List tasks = Lists.newArrayList(this.testRunners.size());
        for (TestRunner tr : this.testRunners) {
            tasks.add(new SuiteWorker(tr));
        }
        ThreadUtil.execute("tests", tasks, this.xmlSuite.getThreadCount(), this.xmlSuite.getTimeOut(Integer.MAX_VALUE), false);
    }

    protected void addListener(ISuiteListener reporter) {
        if (!this.listeners.containsKey(reporter.getClass())) {
            this.listeners.put(reporter.getClass(), reporter);
        }
    }

    @Override
    public void addListener(ITestNGListener listener) {
        IClassListener classListener;
        if (listener instanceof IInvokedMethodListener) {
            IInvokedMethodListener invokedMethodListener = (IInvokedMethodListener)listener;
            this.invokedMethodListeners.put(invokedMethodListener.getClass(), invokedMethodListener);
        }
        if (listener instanceof ISuiteListener) {
            this.addListener((ISuiteListener)listener);
        }
        if (listener instanceof IReporter) {
            this.addReporter((IReporter)listener);
        }
        if (listener instanceof IConfigurationListener) {
            this.addConfigurationListener((IConfigurationListener)listener);
        }
        if (listener instanceof IClassListener && !this.classListeners.containsKey((classListener = (IClassListener)listener).getClass())) {
            this.classListeners.put(classListener.getClass(), classListener);
        }
    }

    @Override
    public String getOutputDirectory() {
        return this.outputDir + File.separatorChar + this.getName();
    }

    @Override
    public Map<String, ISuiteResult> getResults() {
        return this.suiteResults;
    }

    @Override
    public String getParameter(String parameterName) {
        return this.xmlSuite.getParameter(parameterName);
    }

    @Override
    public Map<String, Collection<ITestNGMethod>> getMethodsByGroups() {
        Map<String, Collection<ITestNGMethod>> result = Maps.newHashMap();
        for (TestRunner tr : this.testRunners) {
            ITestNGMethod[] methods;
            for (ITestNGMethod m : methods = tr.getAllTestMethods()) {
                String[] groups;
                for (String groupName : groups = m.getGroups()) {
                    Collection<ITestNGMethod> testMethods = result.get(groupName);
                    if (null == testMethods) {
                        testMethods = Lists.newArrayList();
                        result.put(groupName, testMethods);
                    }
                    testMethods.add(m);
                }
            }
        }
        return result;
    }

    @Override
    public Collection<ITestNGMethod> getInvokedMethods() {
        return this.getIncludedOrExcludedMethods(true);
    }

    @Override
    public Collection<ITestNGMethod> getExcludedMethods() {
        return this.getIncludedOrExcludedMethods(false);
    }

    private Collection<ITestNGMethod> getIncludedOrExcludedMethods(boolean included) {
        List<ITestNGMethod> result = Lists.newArrayList();
        for (TestRunner tr : this.testRunners) {
            Collection<ITestNGMethod> methods = included ? tr.getInvokedMethods() : tr.getExcludedMethods();
            for (ITestNGMethod m : methods) {
                result.add(m);
            }
        }
        return result;
    }

    @Override
    public IObjectFactory getObjectFactory() {
        return this.objectFactory instanceof IObjectFactory ? (IObjectFactory)this.objectFactory : null;
    }

    @Override
    public IObjectFactory2 getObjectFactory2() {
        return this.objectFactory instanceof IObjectFactory2 ? (IObjectFactory2)this.objectFactory : null;
    }

    @Override
    public IAnnotationFinder getAnnotationFinder() {
        return this.configuration.getAnnotationFinder();
    }

    public static void ppp(String s) {
        System.out.println("[SuiteRunner] " + s);
    }

    public void setHost(String host) {
        this.remoteHost = host;
    }

    @Override
    public String getHost() {
        return this.remoteHost;
    }

    @Override
    public SuiteRunState getSuiteState() {
        return this.suiteState;
    }

    public void setSkipFailedInvocationCounts(Boolean skipFailedInvocationCounts) {
        if (skipFailedInvocationCounts != null) {
            this.skipFailedInvocationCounts = skipFailedInvocationCounts;
        }
    }

    @Override
    public Object getAttribute(String name) {
        return this.attributes.getAttribute(name);
    }

    @Override
    public void setAttribute(String name, Object value) {
        this.attributes.setAttribute(name, value);
    }

    @Override
    public Set<String> getAttributeNames() {
        return this.attributes.getAttributeNames();
    }

    @Override
    public Object removeAttribute(String name) {
        return this.attributes.removeAttribute(name);
    }

    @Override
    public void afterInvocation(IInvokedMethod method, ITestResult testResult) {
    }

    @Override
    public void beforeInvocation(IInvokedMethod method, ITestResult testResult) {
        if (method == null) {
            throw new NullPointerException("Method should not be null");
        }
        this.invokedMethods.add(method);
    }

    @Override
    public List<IInvokedMethod> getAllInvokedMethods() {
        return new ArrayList<IInvokedMethod>(this.invokedMethods);
    }

    @Override
    public List<ITestNGMethod> getAllMethods() {
        return this.allTestMethods;
    }

    private static class ProxyTestRunnerFactory
    implements ITestRunnerFactory2 {
        private ITestListener[] failureGenerators;
        private ITestRunnerFactory target;

        public ProxyTestRunnerFactory(ITestListener[] failureListeners, ITestRunnerFactory target) {
            this.failureGenerators = failureListeners;
            this.target = target;
        }

        @Override
        public TestRunner newTestRunner(ISuite suite, XmlTest test, Collection<IInvokedMethodListener> listeners, List<IClassListener> classListeners) {
            return this.newTestRunner(suite, test, listeners, classListeners, Collections.emptyMap());
        }

        @Override
        public TestRunner newTestRunner(ISuite suite, XmlTest test, Collection<IInvokedMethodListener> listeners, List<IClassListener> classListeners, Map<Class<? extends IDataProviderListener>, IDataProviderListener> dataProviderListeners) {
            TestRunner testRunner = this.target instanceof ITestRunnerFactory2 ? ((ITestRunnerFactory2)this.target).newTestRunner(suite, test, listeners, classListeners, dataProviderListeners) : this.target.newTestRunner(suite, test, listeners, classListeners);
            testRunner.addListener(new TextReporter(testRunner.getName(), TestRunner.getVerbose()));
            for (ITestListener itl : this.failureGenerators) {
                testRunner.addListener(itl);
            }
            return testRunner;
        }
    }

    private static class DefaultTestRunnerFactory
    implements ITestRunnerFactory2 {
        private ITestListener[] failureGenerators;
        private boolean useDefaultListeners;
        private boolean skipFailedInvocationCounts;
        private IConfiguration configuration;
        private final Comparator<ITestNGMethod> comparator;

        public DefaultTestRunnerFactory(IConfiguration configuration, ITestListener[] failureListeners, boolean useDefaultListeners, boolean skipFailedInvocationCounts, Comparator<ITestNGMethod> comparator) {
            this.configuration = configuration;
            this.failureGenerators = failureListeners;
            this.useDefaultListeners = useDefaultListeners;
            this.skipFailedInvocationCounts = skipFailedInvocationCounts;
            this.comparator = comparator;
        }

        @Override
        public TestRunner newTestRunner(ISuite suite, XmlTest test, Collection<IInvokedMethodListener> listeners, List<IClassListener> classListeners) {
            return this.newTestRunner(suite, test, listeners, classListeners, Collections.emptyMap());
        }

        @Override
        public TestRunner newTestRunner(ISuite suite, XmlTest test, Collection<IInvokedMethodListener> listeners, List<IClassListener> classListeners, Map<Class<? extends IDataProviderListener>, IDataProviderListener> dataProviderListeners) {
            boolean skip = this.skipFailedInvocationCounts;
            if (!skip) {
                skip = test.skipFailedInvocationCounts();
            }
            TestRunner testRunner = new TestRunner(this.configuration, suite, test, suite.getOutputDirectory(), suite.getAnnotationFinder(), skip, listeners, classListeners, this.comparator, dataProviderListeners);
            if (this.useDefaultListeners) {
                testRunner.addListener(new TestHTMLReporter());
                testRunner.addListener(new JUnitXMLReporter());
                testRunner.addListener(new TextReporter(testRunner.getName(), TestRunner.getVerbose()));
            }
            for (ITestListener itl : this.failureGenerators) {
                testRunner.addTestListener(itl);
            }
            for (IConfigurationListener cl : this.configuration.getConfigurationListeners()) {
                testRunner.addConfigurationListener(cl);
            }
            return testRunner;
        }
    }

    private class SuiteWorker
    implements Runnable {
        private TestRunner testRunner;

        public SuiteWorker(TestRunner tr) {
            this.testRunner = tr;
        }

        @Override
        public void run() {
            Utils.log("[SuiteWorker]", 4, "Running XML Test '" + this.testRunner.getTest().getName() + "' in Parallel");
            SuiteRunner.this.runTest(this.testRunner);
        }
    }
}

