/*
 * Decompiled with CFR 0.152.
 */
package org.testng;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.testng.ITestNGMethod;
import org.testng.TestNGException;
import org.testng.collections.ListMultiMap;
import org.testng.collections.Lists;
import org.testng.collections.Maps;

public class DependencyMap {
    private ListMultiMap<String, ITestNGMethod> m_dependencies = Maps.newListMultiMap();
    private ListMultiMap<String, ITestNGMethod> m_groups = Maps.newListMultiMap();

    public DependencyMap(ITestNGMethod[] methods) {
        for (ITestNGMethod m : methods) {
            this.m_dependencies.put(m.getQualifiedName(), m);
            for (String g : m.getGroups()) {
                this.m_groups.put(g, m);
            }
        }
    }

    public List<ITestNGMethod> getMethodsThatBelongTo(String group, ITestNGMethod fromMethod) {
        Set uniqueKeys = this.m_groups.keySet();
        List<ITestNGMethod> result = Lists.newArrayList();
        for (String k : uniqueKeys) {
            if (!Pattern.matches(group, k)) continue;
            result.addAll((Collection<ITestNGMethod>)this.m_groups.get(k));
        }
        if (result.isEmpty() && !fromMethod.ignoreMissingDependencies()) {
            throw new TestNGException("DependencyMap::Method \"" + fromMethod + "\" depends on nonexistent group \"" + group + "\"");
        }
        return result;
    }

    public ITestNGMethod getMethodDependingOn(String methodName, ITestNGMethod fromMethod) {
        List l = (List)this.m_dependencies.get(methodName);
        if (l.isEmpty()) {
            l = (List)this.m_dependencies.get(DependencyMap.constructMethodNameUsingTestClass(methodName, fromMethod));
        }
        if (l.isEmpty() && fromMethod.ignoreMissingDependencies()) {
            return fromMethod;
        }
        for (ITestNGMethod m : l) {
            if (!DependencyMap.isSameInstance(fromMethod, m) && !DependencyMap.belongToDifferentClassHierarchy(fromMethod, m) && !DependencyMap.hasInstance(fromMethod, m)) continue;
            return m;
        }
        throw new TestNGException("Method \"" + fromMethod + "\" depends on nonexistent method \"" + methodName + "\"");
    }

    private static boolean belongToDifferentClassHierarchy(ITestNGMethod baseClassMethod, ITestNGMethod derivedClassMethod) {
        return !baseClassMethod.getRealClass().isAssignableFrom(derivedClassMethod.getRealClass());
    }

    private static boolean hasInstance(ITestNGMethod baseClassMethod, ITestNGMethod derivedClassMethod) {
        Object baseInstance = baseClassMethod.getInstance();
        Object derivedInstance = derivedClassMethod.getInstance();
        return derivedInstance != null || baseInstance != null;
    }

    private static boolean isSameInstance(ITestNGMethod baseClassMethod, ITestNGMethod derivedClassMethod) {
        Object baseInstance = baseClassMethod.getInstance();
        Object derivedInstance = derivedClassMethod.getInstance();
        return derivedInstance != null && baseInstance != null && baseInstance.getClass().isAssignableFrom(derivedInstance.getClass());
    }

    private static String constructMethodNameUsingTestClass(String currentMethodName, ITestNGMethod m) {
        int lastIndex = currentMethodName.lastIndexOf(46);
        if (lastIndex != -1) {
            return m.getTestClass().getRealClass().getName() + currentMethodName.substring(lastIndex);
        }
        return currentMethodName;
    }
}

