/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.test.permissions;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.baja.category.BCategoryMask;
import javax.baja.category.BCategoryService;
import javax.baja.category.BOrdToCategoryMap;
import javax.baja.naming.BOrd;
import javax.baja.nre.function.ConsumerCanThrowException;
import javax.baja.role.BRole;
import javax.baja.role.BRoleService;
import javax.baja.security.BPermissions;
import javax.baja.security.BPermissionsMap;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BStation;
import javax.baja.sys.BValue;
import javax.baja.user.BUser;
import javax.baja.user.BUserService;

public class PermissionsScenario {
    private final BStation station;
    private final List<SetupStep> setupSteps;
    private final Map<Integer, String> categoryIndexToPermissions = new HashMap<Integer, String>();
    private final Map<String, int[]> ordStringToCategoryIndices = new HashMap<String, int[]>();
    private final Map<String, BCategoryMask> componentOrdToOriginalCategoryMask = new HashMap<String, BCategoryMask>();
    private BOrdToCategoryMap originalCategoryMap;
    private int categoryCounter = 27;

    public PermissionsScenario(BStation station, SetupStep ... setupSteps) {
        this.station = station;
        this.setupSteps = Arrays.asList(setupSteps);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <E extends Exception> void actAsUser(ConsumerCanThrowException<BUser, E> consumer) throws E {
        this.setupSteps.forEach(step -> step.apply(this));
        BUserService userService = this.getUserService();
        BRoleService roleService = this.getRoleService();
        BRole testRole = this.makeTestRole();
        roleService.add("testRole?", (BValue)testRole);
        BUser testUser = this.makeTestUser(testRole);
        userService.add("testUser?", (BValue)testUser);
        this.setupTestCategories();
        try {
            consumer.accept((Object)testUser);
        }
        finally {
            this.restoreOriginalCategories();
            userService.remove((BComplex)testUser);
            roleService.remove((BComplex)testRole);
        }
    }

    public static UserPermissionsSetupStep withPermissions(String permissionsString) {
        return new UserPermissionsSetupStep(permissionsString);
    }

    public static OrdSetupStep withOrd(String ord) {
        return new OrdSetupStep(ord);
    }

    private BRoleService getRoleService() {
        return (BRoleService)BOrd.make((String)"service:baja:RoleService").get((BObject)this.station);
    }

    private BUserService getUserService() {
        return (BUserService)BOrd.make((String)"service:baja:UserService").get((BObject)this.station);
    }

    private BCategoryService getCategoryService() {
        return (BCategoryService)BOrd.make((String)"service:baja:CategoryService").get((BObject)this.station);
    }

    private BUser makeTestUser(BRole testRole) {
        BUser user = new BUser();
        user.setRoles(testRole.getName());
        return user;
    }

    private BRole makeTestRole() {
        int maxIndex = this.categoryIndexToPermissions.keySet().stream().reduce(0, Math::max);
        BPermissions[] permissions = new BPermissions[maxIndex + 1];
        for (int i = 1; i <= maxIndex; ++i) {
            if (!this.categoryIndexToPermissions.containsKey(i)) continue;
            String permissionsString = this.categoryIndexToPermissions.get(i);
            try {
                permissions[i] = BPermissions.make((String)permissionsString);
                continue;
            }
            catch (IOException e) {
                throw new IllegalArgumentException(e);
            }
        }
        BRole testRole = new BRole();
        testRole.setPermissions(BPermissionsMap.make((BPermissions[])permissions));
        return testRole;
    }

    private void setupTestCategories() {
        BCategoryService categoryService = this.getCategoryService();
        this.originalCategoryMap = categoryService.getOrdMap();
        HashMap<BOrd, BCategoryMask> categoryMasks = new HashMap<BOrd, BCategoryMask>();
        int size = this.originalCategoryMap.size();
        for (int i = 0; i < size; ++i) {
            categoryMasks.put(this.originalCategoryMap.getOrd(i), this.originalCategoryMap.getCategoryMask(i));
        }
        this.ordStringToCategoryIndices.forEach((ordString, indices) -> {
            BOrd ord = BOrd.make((String)ordString);
            BCategoryMask categoryMask = BCategoryMask.make((int[])indices);
            BObject obj = ord.get((BObject)this.station);
            if (obj.isComponent()) {
                BComponent comp = obj.asComponent();
                this.componentOrdToOriginalCategoryMask.put((String)ordString, comp.getCategoryMask());
                comp.setCategoryMask(categoryMask, null);
            } else {
                categoryMasks.put(ord, categoryMask);
            }
        });
        ArrayList ords = new ArrayList(categoryMasks.keySet());
        ArrayList masks = new ArrayList();
        for (BOrd ord : ords) {
            masks.add(categoryMasks.get(ord));
        }
        BOrdToCategoryMap testCategoryMap = BOrdToCategoryMap.make((BOrd[])ords.toArray(new BOrd[0]), (BCategoryMask[])masks.toArray(new BCategoryMask[0]));
        categoryService.setOrdMap(testCategoryMap);
    }

    private void restoreOriginalCategories() {
        BCategoryService categoryService = this.getCategoryService();
        categoryService.setOrdMap(this.originalCategoryMap);
        this.componentOrdToOriginalCategoryMask.forEach((ord, categoryMask) -> BOrd.make((String)ord).get((BObject)this.station).asComponent().setCategoryMask(categoryMask, null));
    }

    public static class UserPermissionsSetupStep
    extends SetupStep {
        private final String permissionsString;
        private String ord;
        private int[] indices;

        public UserPermissionsSetupStep(String permissionsString) {
            this.permissionsString = permissionsString;
        }

        @Override
        void apply(PermissionsScenario scenario) {
            if (this.ord != null) {
                int categoryIndex = scenario.categoryCounter++;
                scenario.ordStringToCategoryIndices.put(this.ord, new int[]{categoryIndex});
                scenario.categoryIndexToPermissions.put(categoryIndex, this.permissionsString);
            } else {
                for (int index : this.indices) {
                    scenario.categoryIndexToPermissions.put(index, this.permissionsString);
                }
            }
        }

        public UserPermissionsSetupStep onCategory(int categoryIndex) {
            return this.onCategories(categoryIndex);
        }

        public UserPermissionsSetupStep onCategories(int ... categoryIndices) {
            this.indices = categoryIndices;
            return this;
        }

        public UserPermissionsSetupStep onOrd(String ord) {
            this.ord = ord;
            return this;
        }

        public UserPermissionsSetupStep onComponent(BComponent component) {
            BOrd ord = component.getNavOrd();
            if (ord == null) {
                throw new IllegalArgumentException("can only configure permissions on mounted components");
            }
            return this.onOrd(ord.relativizeToHost().encodeToString());
        }
    }

    public static class OrdSetupStep
    extends SetupStep {
        private final String ord;
        private int[] categoryIndices;

        private OrdSetupStep(String ord) {
            this.ord = ord;
        }

        @Override
        void apply(PermissionsScenario scenario) {
            scenario.ordStringToCategoryIndices.put(this.ord, this.categoryIndices);
        }

        public OrdSetupStep onlyInCategory(int categoryIndex) {
            this.categoryIndices = new int[]{categoryIndex};
            return this;
        }

        public OrdSetupStep onlyInCategories(int ... categoryIndices) {
            this.categoryIndices = categoryIndices;
            return this;
        }
    }

    public static abstract class SetupStep {
        abstract void apply(PermissionsScenario var1);
    }
}

