/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.test;

import com.tridium.sys.Nre;
import com.tridium.sys.module.NModule;
import com.tridium.testng.TestRunnerNg;
import com.tridium.util.ArrayUtil;
import com.tridium.util.CommandLineArguments;
import java.io.File;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.baja.nre.platform.RuntimeProfile;
import javax.baja.registry.ModuleInfo;
import javax.baja.sys.ModuleNotFoundException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class TestRunner {
    private static TestRunnerNg ngRunner = new TestRunnerNg();
    private static TestRunner instance;
    private static final Pattern MODULE_PATTERN;
    private static final Pattern MODULE_PART_PATTERN;
    private static final Pattern TYPE_PATTERN;
    private static final Pattern TYPE_METHOD_PATTERN;
    private static final Pattern TYPE_METHOD_REGEX_PATTERN;
    private static final Pattern CLASS_PATTERN;
    private static final Pattern CLASS_METHOD_PATTERN;
    private static final Pattern CLASS_METHOD_REGEX_PATTERN;
    private static final Pattern REGEX_PATTERN;

    public void run(String target) throws NoSuchMethodException {
        if (target.equals("all")) {
            this.runAll();
        } else if (MODULE_PATTERN.matcher(target).find()) {
            ModuleInfo[] allMi;
            try {
                allMi = Sys.getRegistry().getModules(target + "Test");
            }
            catch (ModuleNotFoundException mnfe) {
                allMi = Sys.getRegistry().getModules(target);
            }
            this.run(allMi);
        } else {
            Matcher matcher = MODULE_PART_PATTERN.matcher(target);
            if (matcher.find()) {
                ModuleInfo mi;
                String moduleName = matcher.group(1);
                RuntimeProfile runtimeProfile = RuntimeProfile.valueOf((String)matcher.group(2));
                try {
                    mi = Sys.getRegistry().getModule(moduleName + "Test", runtimeProfile);
                }
                catch (ModuleNotFoundException mnfe) {
                    mi = Sys.getRegistry().getModule(moduleName, runtimeProfile);
                }
                this.run(mi);
            } else {
                matcher = TYPE_PATTERN.matcher(target);
                if (matcher.find()) {
                    Type type;
                    String moduleName = matcher.group(1);
                    String typeName = matcher.group(2);
                    String testTypeSpec = moduleName + "Test:" + typeName;
                    try {
                        type = Sys.getType((String)testTypeSpec);
                    }
                    catch (ModuleNotFoundException mnfe) {
                        type = Sys.getType((String)target);
                    }
                    this.run(type);
                } else {
                    matcher = TYPE_METHOD_PATTERN.matcher(target);
                    if (matcher.find()) {
                        Type type;
                        String typeSpec = matcher.group(1);
                        String moduleName = matcher.group(2);
                        String typeName = matcher.group(3);
                        String methodName = matcher.group(4);
                        try {
                            type = Sys.getType((String)(moduleName + "Test:" + typeName));
                        }
                        catch (ModuleNotFoundException mnfe) {
                            type = Sys.getType((String)typeSpec);
                        }
                        Method method = TestRunner.getAnyMethodNamed(type.getTypeClass(), methodName);
                        this.run(type, method);
                    } else {
                        matcher = TYPE_METHOD_REGEX_PATTERN.matcher(target);
                        if (matcher.find()) {
                            Type type;
                            String typeSpec = matcher.group(1);
                            String moduleName = matcher.group(2);
                            String typeName = matcher.group(3);
                            String pattern = matcher.group(4);
                            try {
                                type = Sys.getType((String)(moduleName + "Test:" + typeName));
                            }
                            catch (ModuleNotFoundException mnfe) {
                                type = Sys.getType((String)typeSpec);
                            }
                            this.run(type, Pattern.compile(pattern));
                        } else if (CLASS_PATTERN.matcher(target).find()) {
                            this.run(Sys.loadType(this.findClassFromUnknownModule(target)));
                        } else {
                            matcher = CLASS_METHOD_PATTERN.matcher(target);
                            if (matcher.find()) {
                                Class<?> clazz = this.findClassFromUnknownModule(matcher.group(1));
                                Method method = TestRunner.getAnyMethodNamed(clazz, matcher.group(3));
                                this.run(Sys.loadType(clazz), method);
                            } else {
                                matcher = CLASS_METHOD_REGEX_PATTERN.matcher(target);
                                if (matcher.find()) {
                                    Class<?> clazz = this.findClassFromUnknownModule(matcher.group(1));
                                    Pattern pattern = Pattern.compile(matcher.group(3));
                                    this.run(Sys.loadType(clazz), pattern);
                                } else {
                                    matcher = REGEX_PATTERN.matcher(target);
                                    if (matcher.find()) {
                                        this.runMatching(Pattern.compile(matcher.group(1)));
                                    } else {
                                        throw new IllegalArgumentException("Unrecognized target " + target);
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    private Class<?> findClassFromUnknownModule(String className) {
        for (ModuleInfo info : Sys.getRegistry().getModules()) {
            Sys.loadModule((String)info.getModuleName());
            for (NModule module : Nre.getModuleManager().loadModuleParts(info.getModuleName())) {
                try {
                    return module.loadClass(className);
                }
                catch (Exception exception) {
                }
            }
        }
        throw new IllegalArgumentException("could not find class " + className);
    }

    public void runAll() {
        ngRunner.run();
    }

    public void runMatching(Pattern pattern) {
        ngRunner.run(pattern);
    }

    public void run(ModuleInfo moduleInfo) {
        ngRunner.run(moduleInfo);
    }

    public void run(ModuleInfo[] moduleInfos) {
        ngRunner.run(moduleInfos);
    }

    public void run(Type type) {
        ngRunner.run(type);
    }

    public void run(Type type, Method method) {
        ngRunner.run(type, method);
    }

    public void run(Type type, Pattern pattern) {
        ngRunner.run(type, pattern);
    }

    public void run(String ... targets) throws NoSuchMethodException {
        int targetCount = targets.length;
        if (targetCount == 0) {
            throw new IllegalArgumentException("Must provide at least one target");
        }
        if (targetCount == 1) {
            this.run(targets[0]);
        } else {
            boolean exitOnFailure = ngRunner.isExitOnFailure();
            boolean killThreadsOnExit = ngRunner.isKillThreadsOnExit();
            ngRunner.setExitOnFailure(false);
            ngRunner.setKillThreadsOnExit(false);
            String currentOutputDirectory = ngRunner.getOutputDirectory();
            for (int i = 0; i < targetCount - 1; ++i) {
                ngRunner.setReportDirectory(currentOutputDirectory + File.separatorChar + "target." + i);
                this.run(targets[i]);
            }
            ngRunner.setExitOnFailure(exitOnFailure);
            ngRunner.setKillThreadsOnExit(killThreadsOnExit);
            ngRunner.setReportDirectory(currentOutputDirectory + File.separatorChar + "target." + (targetCount - 1));
            this.run(targets[targetCount - 1]);
        }
    }

    public static void usage() {
        System.out.println();
        System.out.println("usage:");
        System.out.println("  test <target> [target ... target] [testng options]");
        System.out.println("target:");
        System.out.println("  all");
        System.out.println("  <module>");
        System.out.println("  <module-runtimeProfile>");
        System.out.println("  <module>:<type>");
        System.out.println("  <module>:<type>.<method>");
        System.out.println("  <module>:<type>./regex to match against methods of <type>/");
        System.out.println("  <com.package>.<BTestClass>");
        System.out.println("  <com.package>.<BTestClass>#<method>");
        System.out.println("  <com.package>.<BTestClass>#/regex to match against methods of <BTestClass>/");
        System.out.println("  /<regex to match against the com.package.BTestClass#method format>/");
        System.out.println("testng options:");
        System.out.println("  -v:<n>                  Set TestNG output verbosity level (1 - 10)");
        System.out.println("  -output:<path>          Set the location for TestNG output");
        System.out.println("  -groups:<a,b,c>         Comma-separated list of TestNG group names to test");
        System.out.println("  -excludegroups:<a,b,c>  Comma-separated list of TestNG group names to skip");
        System.out.println("  -skipHtmlReport         Flag to disable HTML report generation");
        System.out.println("  -generateJunitReport    Flag to enable JUnit XML report generation");
        System.out.println("  -benchmark              Print the 50 highest duration tests and test suites on exit");
        System.out.println("  -loopCount:<n>          Run target(s) in a loop n times (1 - 1000000)");
        System.out.println();
    }

    public static void main(String[] rawArgs) {
        CommandLineArguments args;
        Nre.boot();
        if (rawArgs.length > 0 && rawArgs[0].equals(TestRunner.class.getName())) {
            rawArgs = (String[])ArrayUtil.removeOne((Object[])rawArgs, (int)0);
        }
        if ((args = new CommandLineArguments(rawArgs)).hasHelpOption() || args.parameters.length == 0) {
            TestRunner.usage();
            throw new RuntimeException();
        }
        TestRunner.runTests(args);
    }

    public static void runTests(CommandLineArguments args) {
        TestRunner.runTests(args, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void runTests(CommandLineArguments args, boolean watchMode) {
        instance = new TestRunner();
        try {
            TestRunner.setTestNGOptions(args, watchMode);
            instance.run(args.parameters);
        }
        catch (Throwable e) {
            String target = String.join((CharSequence)", ", args.parameters);
            System.err.println();
            System.err.println("SEVERE [testrunner] invalid test target(s): " + target);
            e.printStackTrace();
            System.err.println();
        }
        finally {
            instance = null;
        }
    }

    private static void setTestNGOptions(CommandLineArguments args, boolean watchMode) {
        String output;
        String excludegroups;
        String groups;
        if (args.hasOption("skipHtmlReport")) {
            ngRunner.setSkipHtmlReport(true);
        }
        if (args.hasOption("generateJunitReport")) {
            ngRunner.setGenerateJunitReport(true);
        }
        if (args.hasOption("groups") && (groups = args.getOption("groups")) != null) {
            ngRunner.setGroups(groups);
        }
        if (args.hasOption("excludegroups") && (excludegroups = args.getOption("excludegroups")) != null) {
            ngRunner.setExcludeGroups(excludegroups);
        }
        if (args.hasOption("v")) {
            int level = 1;
            String verbosity = args.getOption("v");
            if (verbosity != null) {
                level = Integer.parseInt(verbosity);
                if (level < 0) {
                    level = 0;
                }
                if (level > 10) {
                    level = 10;
                }
            }
            ngRunner.setVerbosity(level);
        }
        if (args.hasOption("loopCount")) {
            int loopCount = 1;
            String loops = args.getOption("loopCount");
            if (loops != null) {
                loopCount = Integer.parseInt(loops);
                if (loopCount < 0) {
                    loopCount = 0;
                }
                if (loopCount > 1000000) {
                    loopCount = 1000000;
                }
            }
            ngRunner.setLoopCount(loopCount);
        }
        if (args.hasOption("output") && (output = args.getOption("output")) != null) {
            ngRunner.setReportDirectory(output);
        }
        if (watchMode) {
            ngRunner.setKillThreadsOnExit(false);
            ngRunner.setExitOnFailure(false);
        }
        if (args.hasOption("benchmark")) {
            ngRunner.setBenchmark(true);
        }
    }

    private static Method getAnyMethodNamed(Class<?> cls, String methodName) throws NoSuchMethodException {
        return Arrays.stream(cls.getMethods()).filter(it -> it.getName().equals(methodName)).findAny().orElseThrow(() -> new NoSuchMethodException(cls.getName() + "." + methodName));
    }

    static {
        MODULE_PATTERN = Pattern.compile("^\\w+$");
        MODULE_PART_PATTERN = Pattern.compile("^(\\w+)-(\\w+)$");
        TYPE_PATTERN = Pattern.compile("^(\\w+):(\\w+)$");
        TYPE_METHOD_PATTERN = Pattern.compile("^((\\w+):(\\w+))\\.(\\w+)$");
        TYPE_METHOD_REGEX_PATTERN = Pattern.compile("^((\\w+):(\\w+))\\./([^/]+)/$");
        CLASS_PATTERN = Pattern.compile("^([\\w]+\\.)+\\w+$");
        CLASS_METHOD_PATTERN = Pattern.compile("^(([\\w]+\\.)+\\w+)#(\\w+)$");
        CLASS_METHOD_REGEX_PATTERN = Pattern.compile("^(([\\w]+\\.)+\\w+)#/([^/]+)/$");
        REGEX_PATTERN = Pattern.compile("^/([^/]+)/$");
    }
}

