/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.test;

import com.tridium.authn.AuthenticationClient;
import com.tridium.authn.BAuthenticationService;
import com.tridium.fox.sys.BFoxService;
import com.tridium.fox.sys.BFoxSession;
import com.tridium.jetty.BJettyWebServer;
import com.tridium.sys.Nre;
import com.tridium.sys.station.Station;
import com.tridium.testng.TestAuthenticationClient;
import com.tridium.testng.TestUtil;
import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import javax.baja.alarm.BAlarmService;
import javax.baja.app.BAppContainer;
import javax.baja.category.BCategoryService;
import javax.baja.driver.BDriverContainer;
import javax.baja.fox.BFoxProxySession;
import javax.baja.naming.BHost;
import javax.baja.naming.BLocalHost;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.role.BRole;
import javax.baja.role.BRoleService;
import javax.baja.search.BSearchService;
import javax.baja.security.BAbstractAuthenticator;
import javax.baja.security.BPassword;
import javax.baja.security.BPasswordAuthenticator;
import javax.baja.security.BPbkdf2HmacSha256PasswordEncoder;
import javax.baja.security.BPermissions;
import javax.baja.security.BPermissionsMap;
import javax.baja.sys.BComponent;
import javax.baja.sys.BStation;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.test.BTest;
import javax.baja.test.BTestNg;
import javax.baja.test.permissions.PermissionsScenario;
import javax.baja.user.BUser;
import javax.baja.user.BUserService;
import javax.baja.util.BServiceContainer;
import javax.baja.web.BWebService;
import org.testng.Assert;
import org.testng.annotations.AfterTest;
import org.testng.annotations.BeforeTest;

@NiagaraType
public abstract class BTestNgStation
extends BTestNg {
    @Generated
    public static final Type TYPE = Sys.loadType(BTestNgStation.class);
    protected static final String TEST_SUPER_USER = "TestSuper";
    protected static final String TEST_ADMIN_USER = "TestAdmin";
    protected static final String TEST_OPERATOR_USER = "TestOperator";
    protected static final String TEST_PASSWORD = "Test@1234_5678";
    protected static final String testStationName = "test";
    protected boolean enableHistoryWarmup = false;
    protected boolean makeDefaultAuthFoxServices = true;
    protected static final String USER_SERVICE = "UserService";
    protected static final String ROLE_SERVICE = "RoleService";
    protected static final String AUTH_SERVICE = "AuthenticationService";
    protected static final String CATEGORY_SERVICE = "CategoryService";
    protected static final String ALARM_SERVICE = "AlarmService";
    protected static final String WEB_SERVICE = "WebService";
    protected static final String SEARCH_SERVICE = "SearchService";
    protected static final String HISTORY_SERVICE = "History";
    protected static final String JOB_SERVICE = "Job";
    protected static final String BOX_SERVICE = "BoxService";
    protected static final String FOX_SERVICE = "FoxService";
    protected static final String DRIVERS = "Drivers";
    protected static final String NIAGARA_NETWORK = "NiagaraNetwork";
    protected static final String APPS = "Apps";
    private BWebService webService = null;
    protected static final int MAX_FOX_CONNECTION_ATTEMPTS = 3;
    protected static final long DEFAULT_FOX_CONNECTION_REATTEMPT_DELAY = 1000L;
    protected BTest.TestStationHandler stationHandler;
    protected int foxPort = 1911;
    protected int webPort = 9090;

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    @BeforeTest(alwaysRun=true, description="Setup and start test station")
    public void setupStation() throws Exception {
        this.cleanStationListeners();
        if (this.stationHandler == null) {
            System.out.println("Creating test station for " + ((Object)((Object)this)).getClass());
            this.makeStationHandler();
            System.out.println("Done creating station for " + ((Object)((Object)this)).getClass());
        }
        BStation station = this.stationHandler.getStation();
        try {
            this.configureTestStation(station, testStationName, this.webPort, this.foxPort);
        }
        catch (Exception e) {
            this.stationHandler.stopStation();
            this.stationHandler.releaseStation();
            this.stationHandler = null;
            System.out.println("Unable to set up station for " + ((Object)((Object)this)).getClass());
            throw new Exception("Unable to set up station for " + ((Object)((Object)this)).getClass(), e);
        }
        this.startStation(station);
        Thread.sleep(500L);
        Station.atSteadyState = true;
        Nre.getEngineManager().atSteadyState((BComponent)station);
    }

    @AfterTest(alwaysRun=true, description="Teardown test station")
    public void teardownStation() throws Exception {
        if (this.stationHandler != null) {
            this.stationHandler.stopStation();
            if (this.webService != null && this.webService.getWebServer() != null) {
                String[] serverState = new String[]{null};
                TestUtil.assertWillBeTrue(() -> {
                    try {
                        serverState[0] = this.webService.getWebServer().getServerState();
                        return serverState[0].equals("stopped") || serverState[0].equals("failed");
                    }
                    catch (Exception ignored) {
                        return true;
                    }
                }, () -> "Failed to shutdown webserver in a timely fashion, state is '" + serverState[0] + '\'');
            }
            this.stationHandler.releaseStation();
            this.stationHandler = null;
            this.cleanStationListeners();
            Station.station = null;
            Station.stationStarted = false;
            Station.atSteadyState = false;
        }
    }

    protected void startStation(BStation station) throws Exception {
        BFoxService stationFoxService = ((BFoxService[])((BServiceContainer[])station.getChildren(BServiceContainer.class))[0].getChildren(BFoxService.class))[0];
        if (!station.isRunning()) {
            Nre.clearPlatform();
            Nre.loadPlatform();
            Nre.getServiceManager().startAllServices();
            station.start();
            Station.stationStarted = true;
            Nre.getEngineManager().stationStarted((BComponent)station);
        }
        int maxAttempts = 10;
        while (maxAttempts-- >= 0 && !station.isRunning()) {
            Thread.sleep(100L);
        }
        if (!station.isRunning()) {
            throw new Exception("Station did not start in time");
        }
        maxAttempts = 50;
        while (maxAttempts-- >= 0 && !stationFoxService.isServing()) {
            Thread.sleep(100L);
        }
        if (!stationFoxService.isServing()) {
            throw new Exception("Fox service did not start in time");
        }
    }

    protected void makeStationHandler() throws Exception {
        this.stationHandler = BTestNgStation.createTestStation();
    }

    private void cleanStationListeners() {
        for (Station.SaveListener saveListener : Station.getSaveListeners()) {
            Station.removeSaveListener((Station.SaveListener)saveListener);
        }
        for (Station.SaveListener saveListener : Station.getRemoteListeners()) {
            Station.removeRemoteListener((Station.RemoteListener)saveListener);
        }
    }

    protected BFoxProxySession connect(String userName, String password) throws Exception {
        return this.connect(userName, password, 3);
    }

    protected BFoxProxySession connect(String userName, String password, int maxAttempts) throws Exception {
        BFoxSession foxSession = BFoxSession.make((BHost)BLocalHost.INSTANCE, (int)this.foxPort, (boolean)false);
        TestAuthenticationClient client = new TestAuthenticationClient(userName, password);
        foxSession.getConnection().setAuthenticationClient((AuthenticationClient)client);
        Exception e = null;
        int attempts = 0;
        while (!foxSession.getConnection().isConnected() && attempts < maxAttempts) {
            try {
                ++attempts;
                foxSession = BFoxSession.connect((BFoxSession)foxSession);
                e = null;
            }
            catch (Exception ex) {
                e = ex;
            }
            if (foxSession.getConnection().isConnected() || attempts >= maxAttempts) continue;
            Thread.sleep(Long.getLong("SERVER_STARTUP_SLEEP", 1000L));
        }
        if (!foxSession.getConnection().isConnected() && e != null) {
            throw e;
        }
        Assert.assertTrue(foxSession.getConnection().isConnected(), "failed to connect fox client connection (" + foxSession.getLastFailureCause() + ")");
        return foxSession;
    }

    protected void configureTestStation(BStation station, String stationName, int webPort, int foxPort) throws Exception {
        BComponent drivers = BTestNgStation.addOrSetContainer(station, DRIVERS, BDriverContainer.TYPE);
        BTestNgStation.addOrSetContainer(station, APPS, BAppContainer.TYPE);
        BServiceContainer services = station.getServices();
        services.add(ROLE_SERVICE, (BValue)this.makeRoleService());
        services.add(USER_SERVICE, (BValue)this.makeUserService());
        services.add(ALARM_SERVICE, (BValue)this.newInstance("alarm:AlarmService"));
        services.add(HISTORY_SERVICE, (BValue)this.newInstance("history:HistoryService"));
        services.add(JOB_SERVICE, (BValue)this.newInstance("baja:JobService"));
        services.add(CATEGORY_SERVICE, (BValue)this.newInstance("baja:CategoryService"));
        services.add(BOX_SERVICE, (BValue)this.newInstance("box:BoxService"));
        if (this.makeDefaultAuthFoxServices) {
            services.add(AUTH_SERVICE, (BValue)this.makeDefaultAuthService());
            services.add(FOX_SERVICE, (BValue)this.makeDefaultFoxService(foxPort));
        }
        if (this.isSearchServiceEnabled()) {
            services.add(SEARCH_SERVICE, (BValue)this.newInstance("search:SearchService"));
        }
        if (this.isWebServiceEnabled()) {
            this.webService = this.makeWebService(webPort);
            services.add(WEB_SERVICE, (BValue)this.webService);
        }
        if (drivers.get(NIAGARA_NETWORK) == null) {
            drivers.add(NIAGARA_NETWORK, (BValue)this.newInstance("niagaraDriver:NiagaraNetwork"));
        }
        System.setProperty("niagara.history.warmup", String.valueOf(this.enableHistoryWarmup));
        station.setStationName(stationName);
    }

    public BComponent newInstance(String type) throws Exception {
        return (BComponent)Sys.getType((String)type).getInstance();
    }

    public BComponent makeRoleService() throws Exception {
        BRoleService roleService = new BRoleService();
        this.addRole(roleService, TEST_SUPER_USER, BPermissionsMap.SUPER_USER);
        this.addRole(roleService, TEST_ADMIN_USER, BTestNgStation.map(BPermissions.make((String)"rwiRWI")));
        this.addRole(roleService, TEST_OPERATOR_USER, BTestNgStation.map(BPermissions.make((String)"rwi")));
        return roleService;
    }

    public BComponent makeUserService() throws Exception {
        BUserService userService = new BUserService();
        this.addUser(userService, TEST_SUPER_USER);
        this.addUser(userService, TEST_ADMIN_USER);
        this.addUser(userService, TEST_OPERATOR_USER);
        return userService;
    }

    private static BPermissionsMap map(BPermissions permissions) {
        return BPermissionsMap.make((BPermissions[])new BPermissions[]{null, permissions});
    }

    protected static BPermissionsMap map(BPermissions ... permissions) {
        BPermissions[] mappedPermissions = new BPermissions[permissions.length + 1];
        mappedPermissions[0] = null;
        System.arraycopy(permissions, 0, mappedPermissions, 1, permissions.length);
        return BPermissionsMap.make((BPermissions[])mappedPermissions);
    }

    protected static BPermissionsMap map(String ... permissions) {
        BPermissions[] mappedPermissions = new BPermissions[permissions.length + 1];
        mappedPermissions[0] = null;
        for (int i = 0; i < permissions.length; ++i) {
            BPermissions permissionsValue = BPermissions.none;
            try {
                permissionsValue = BPermissions.make((String)permissions[i]);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            mappedPermissions[i + 1] = permissionsValue;
        }
        return BPermissionsMap.make((BPermissions[])mappedPermissions);
    }

    private BAuthenticationService makeDefaultAuthService() {
        BAuthenticationService authService = new BAuthenticationService();
        authService.get("authenticationSchemes");
        return authService;
    }

    protected BWebService makeWebService(int port) throws Exception {
        BWebService service = new BWebService();
        service.set("httpsCert", (BValue)BString.make((String)"default"));
        service.getMainCertAliasAndPassword().resetAliasAndPassword();
        service.getHttpPort().setPublicServerPort(port);
        BJettyWebServer server = new BJettyWebServer();
        service.add("JettyWebServer", (BValue)server);
        return service;
    }

    private BComponent makeDefaultFoxService(int foxPort) throws Exception {
        BFoxService foxSvc = new BFoxService();
        foxSvc.getFoxPort().setPublicServerPort(foxPort);
        return foxSvc;
    }

    private static BComponent addOrSetContainer(BStation station, String name, Type type) {
        BComponent container = (BComponent)station.get(name);
        if (container == null) {
            container = (BComponent)type.getInstance();
            station.add(name, (BValue)container);
        } else if (!container.getType().is(type)) {
            container = (BComponent)type.getInstance();
            station.set(name, (BValue)container, null);
        }
        return container;
    }

    protected void addUser(BUserService userService, String name) {
        this.addUser(userService, name, TEST_PASSWORD);
    }

    protected void addUser(BUserService userService, String name, String password) {
        userService.add(name, (BValue)BTestNgStation.makeUser(Collections.singleton(name), password));
    }

    protected BUser addUser(String userName, String role) {
        return this.addUser(userName, Collections.singleton(role), TEST_PASSWORD);
    }

    protected BUser addUser(String userName, Set<String> roleNames) {
        return this.addUser(userName, roleNames, TEST_PASSWORD);
    }

    protected BUser addUser(String userName, String role, String password) {
        return this.addUser(userName, Collections.singleton(role), password);
    }

    protected BUser addUser(String userName, Set<String> roleNames, String password) {
        BUser user = BTestNgStation.makeUser(roleNames, password);
        this.getUserService().add(userName, (BValue)user);
        return user;
    }

    private static BUser makeUser(Set<String> roleNames, String password) {
        BUser user = new BUser();
        roleNames.forEach(roleName -> user.addRole(roleName, Context.skipValidate));
        BPassword encodedPassword = BPassword.make((String)password, (String)BPbkdf2HmacSha256PasswordEncoder.ENCODING_TYPE);
        BPasswordAuthenticator pAuth = new BPasswordAuthenticator(encodedPassword);
        user.setAuthenticator((BAbstractAuthenticator)pAuth);
        return user;
    }

    protected void addRole(BRoleService roleService, String name, BPermissionsMap permissions) {
        BRole role = new BRole();
        role.setPermissions(permissions);
        roleService.add(name, (BValue)role);
    }

    protected BRole addRole(String name, BPermissionsMap permissionsMap) {
        BRole role = new BRole();
        role.setPermissions(permissionsMap);
        this.getRoleService().add(name, (BValue)role);
        return role;
    }

    protected PermissionsScenario userPermissionsScenario(PermissionsScenario.SetupStep ... setupSteps) {
        return new PermissionsScenario(this.station, setupSteps);
    }

    protected boolean isWebServiceEnabled() {
        return false;
    }

    protected boolean isSearchServiceEnabled() {
        return false;
    }

    protected BUser getTestSuperUser() {
        return this.getUserService().getUser(TEST_SUPER_USER);
    }

    protected BUser getTestAdminUser() {
        return this.getUserService().getUser(TEST_ADMIN_USER);
    }

    protected BUser getTestOperatorUser() {
        return this.getUserService().getUser(TEST_OPERATOR_USER);
    }

    protected String getSuperUsername() {
        return TEST_SUPER_USER;
    }

    protected String getSuperUserPassword() {
        return TEST_PASSWORD;
    }

    protected BDriverContainer getDrivers() {
        return (BDriverContainer)this.stationHandler.getStation().get(DRIVERS);
    }

    protected BServiceContainer getServices() {
        return this.stationHandler.getStation().getServices();
    }

    protected BRoleService getRoleService() {
        return (BRoleService)this.getServices().get(ROLE_SERVICE);
    }

    protected BUserService getUserService() {
        return (BUserService)this.getServices().get(USER_SERVICE);
    }

    protected BWebService getWebService() {
        if (this.isWebServiceEnabled()) {
            return (BWebService)this.getServices().get(WEB_SERVICE);
        }
        return null;
    }

    protected BSearchService getSearchService() {
        if (this.isSearchServiceEnabled()) {
            return (BSearchService)this.getServices().get(SEARCH_SERVICE);
        }
        return null;
    }

    protected BCategoryService getCategoryService() {
        return (BCategoryService)this.getServices().get(CATEGORY_SERVICE);
    }

    protected BAlarmService getAlarmService() {
        return (BAlarmService)this.getServices().get(ALARM_SERVICE);
    }

    protected BComponent getFoxService() {
        return (BComponent)this.getServices().get(FOX_SERVICE);
    }

    protected BComponent getAuthService() {
        return (BComponent)this.getServices().get(AUTH_SERVICE);
    }

    protected BComponent getNiagaraNetwork() {
        return (BComponent)this.getDrivers().get(NIAGARA_NETWORK);
    }
}

