/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.testng;

import com.tridium.nre.util.NreForkJoinWorkerThreadFactory;
import java.util.concurrent.ForkJoinPool;
import javax.baja.log.Log;

public class TestThreadPool
implements Thread.UncaughtExceptionHandler {
    ForkJoinPool executor;
    MonitorWorker monitorWorker;

    public TestThreadPool(String name, int threads) {
        this.startThreadPool(threads);
    }

    @Override
    public void uncaughtException(Thread t, Throwable e) {
        Log.getLog((String)"search.thread.monitor").error("Uncaught exception from thread " + t, e);
    }

    protected void startThreadPool(int threads) {
        this.executor = new ForkJoinPool(threads, NreForkJoinWorkerThreadFactory.DEFAULT_INSTANCE, this, true);
        int monitorIntervalSec = 2;
        this.monitorWorker = new MonitorWorker(this.executor, monitorIntervalSec);
        new Thread(this.monitorWorker).start();
    }

    public ForkJoinPool executor() {
        return this.executor;
    }

    public void execute(Runnable runnable) {
        this.executor.execute(runnable);
    }

    public void shutdown() {
        this.executor.shutdownNow();
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.monitorWorker.shutdown();
    }

    protected static class MonitorWorker
    implements Runnable {
        private ForkJoinPool executor;
        private int monitorIntervalSec;
        private boolean run = true;

        public MonitorWorker(ForkJoinPool executor, int monitorIntervalSec) {
            this.executor = executor;
            this.monitorIntervalSec = monitorIntervalSec;
        }

        public void shutdown() {
            this.run = false;
        }

        @Override
        public void run() {
            while (this.run) {
                Log.getLog((String)"test.thread.monitor").trace(String.format("[%d/%d] Active: %d, Running: %d, Submitted: %d, Queued: %d, Steals: %d", this.executor.getPoolSize(), this.executor.getParallelism(), this.executor.getActiveThreadCount(), this.executor.getRunningThreadCount(), this.executor.getQueuedSubmissionCount(), this.executor.getQueuedTaskCount(), this.executor.getStealCount()));
                try {
                    Thread.sleep(this.monitorIntervalSec * 1000);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

