/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.testng;

import com.tridium.nre.platform.OperatingSystemEnum;
import com.tridium.testng.annotation.Requires;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.testng.IInvokedMethod;
import org.testng.IInvokedMethodListener;
import org.testng.ITestResult;
import org.testng.SkipException;
import org.testng.TestException;

public class RequiresListener
implements IInvokedMethodListener {
    private final OperatingSystemEnum currentOs;

    public RequiresListener() {
        this(OperatingSystemEnum.getOS());
    }

    public RequiresListener(OperatingSystemEnum currentOs) {
        this.currentOs = currentOs;
    }

    @Override
    public void beforeInvocation(IInvokedMethod method, ITestResult testResult) {
        Requires methodRequires;
        if (!method.isTestMethod() && !method.isConfigurationMethod()) {
            return;
        }
        if (testResult.getStatus() == -1) {
            return;
        }
        if (method.getTestMethod().isAlwaysRun()) {
            return;
        }
        Method testMethod = method.getTestMethod().getConstructorOrMethod().getMethod();
        if (testMethod == null) {
            return;
        }
        Class<?> cls = testMethod.getDeclaringClass();
        Object testInstance = method.getTestMethod().getInstance();
        Requires testRequires = testMethod.getDeclaringClass().getAnnotation(Requires.class);
        if (testRequires != null) {
            RequiresListener.checkPredicate(cls, testInstance, testRequires);
            this.checkOs(testRequires);
        }
        if ((methodRequires = testMethod.getAnnotation(Requires.class)) != null) {
            RequiresListener.checkPredicate(cls, testInstance, methodRequires);
            this.checkOs(methodRequires);
        }
    }

    @Override
    public void afterInvocation(IInvokedMethod method, ITestResult testResult) {
    }

    private void checkOs(Requires r) {
        if (r.os() == null || r.os().length == 0) {
            return;
        }
        for (Requires.OsType os : r.os()) {
            if (this.currentOs != RequiresListener.mapOsToOs(os)) continue;
            return;
        }
        throw new SkipException("Skipping test because requested OS is not available");
    }

    private static void checkPredicate(Class<?> cls, Object instance, Requires r) {
        String predicate = r.predicate();
        if (predicate == null || predicate.isEmpty()) {
            return;
        }
        try {
            Method predicateMethod = RequiresListener.findMethod(cls, predicate);
            if (!predicateMethod.getReturnType().isAssignableFrom(Boolean.TYPE) && !predicateMethod.getReturnType().isAssignableFrom(Boolean.class)) {
                throw new TestException("Predicate " + predicate + " does not return boolean");
            }
            predicateMethod.setAccessible(true);
            Object result = predicateMethod.invoke(instance, new Object[0]);
            if (result == null) {
                throw new TestException("Unexpected null result from predicate");
            }
            boolean res = (Boolean)result;
            if (!res) {
                throw new SkipException("Skipping test because predicate returned false");
            }
        }
        catch (NoSuchMethodException e) {
            throw new TestException("Invalid predicate " + predicate);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new TestException("Unable to invoke method " + predicate + " on class " + cls.getCanonicalName(), e);
        }
    }

    private static OperatingSystemEnum mapOsToOs(Requires.OsType os) {
        switch (os) {
            case QNX: {
                return OperatingSystemEnum.qnx;
            }
            case WIN32: {
                return OperatingSystemEnum.windows;
            }
            case LINUX: {
                return OperatingSystemEnum.linux;
            }
        }
        return OperatingSystemEnum.unknown;
    }

    private static Method findMethod(Class<?> cls, String methodName) throws NoSuchMethodException {
        Class<?> start = cls;
        Method m = null;
        while (true) {
            try {
                m = start.getDeclaredMethod(methodName, new Class[0]);
            }
            catch (NoSuchMethodException e) {
                if ((start = start.getSuperclass()) != null) continue;
            }
            break;
        }
        if (m == null) {
            throw new NoSuchMethodException();
        }
        return m;
    }
}

