/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.testng;

import java.security.AccessController;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.testng.IRetryAnalyzer;
import org.testng.ITestResult;

public class NRetryAnalyzer
implements IRetryAnalyzer {
    private final AtomicInteger currentRetryCount = new AtomicInteger(0);
    public static final int MAX_ATTEMPTS;
    private static final Logger LOGGER;

    @Override
    public boolean retry(ITestResult result) {
        if (this.currentRetryCount.incrementAndGet() >= MAX_ATTEMPTS) {
            this.currentRetryCount.decrementAndGet();
            return false;
        }
        LOGGER.log(Level.WARNING, () -> "NRetryAnalyzer retrying test '" + result + "'...");
        return true;
    }

    static {
        int maxAttemptsValue = 3;
        try {
            String maxAttemptsProperty = AccessController.doPrivileged(() -> System.getProperty("niagara.testng.retryAnalyzer.maxAttempts"));
            if (maxAttemptsProperty != null) {
                maxAttemptsValue = Integer.parseInt(maxAttemptsProperty);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        MAX_ATTEMPTS = Math.max(1, maxAttemptsValue);
        LOGGER = Logger.getLogger("TestNG");
    }
}

