/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.testng;

import java.util.ArrayList;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.test.BTestNg;
import org.testng.TestNG;
import org.testng.annotations.ITestAnnotation;
import org.testng.internal.Utils;
import org.testng.internal.annotations.IAnnotationFinder;
import org.testng.xml.XmlClass;
import org.testng.xml.XmlSuite;
import org.testng.xml.XmlTest;

public class CustomTestNG
extends TestNG {
    private final Class<?> testClass;

    public CustomTestNG(boolean useDefaultListeners) {
        this(useDefaultListeners, BTestNg.class);
    }

    public CustomTestNG(boolean useDefaultListeners, Class<?> testClass) {
        super(useDefaultListeners);
        this.testClass = testClass;
    }

    private XmlClass toXmlClass(Class<?> clazz) {
        Class[] classes = new Class[]{clazz};
        XmlClass[] xmlClasses = Utils.classesToXmlClasses(classes);
        return xmlClasses[0];
    }

    public XmlSuite createXmlSuite(Class<?> clazz) {
        if (!this.testClass.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException(String.format("Only %s subclasses are permissible", this.testClass.getName()));
        }
        XmlSuite xmlSuite = new XmlSuite();
        XmlClass xmlClass = this.toXmlClass(clazz);
        String testName = this.getDefaultTestName();
        Type type = Sys.getType(clazz);
        String suiteName = type.getModule().getModuleName() + "_" + type.getTypeName();
        IAnnotationFinder finder = this.getConfiguration().getAnnotationFinder();
        ITestAnnotation test = finder.findAnnotation(clazz, ITestAnnotation.class);
        if (test != null) {
            suiteName = Utils.defaultIfStringEmpty(test.getSuiteName(), suiteName);
            testName = Utils.defaultIfStringEmpty(test.getTestName(), testName);
        }
        xmlSuite.setName(suiteName);
        XmlTest xmlTest = new XmlTest(xmlSuite);
        xmlTest.setName(testName);
        xmlTest.getXmlClasses().add(xmlClass);
        return xmlSuite;
    }

    @Override
    public void setTestClasses(Class[] classes) {
        ArrayList<XmlSuite> suites = new ArrayList<XmlSuite>(classes.length);
        for (Class clazz : classes) {
            suites.add(this.createXmlSuite(clazz));
        }
        this.setXmlSuites(suites);
    }
}

