/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.test.file;

import com.tridium.sys.transfer.FileToFile;
import java.io.IOException;
import javax.baja.file.BDirectory;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIFile;
import javax.baja.file.FilePath;

public class DirectoryStash
implements AutoCloseable {
    public final BFileSystem fileSystem = BFileSystem.INSTANCE;
    public final FilePath path;
    private final FilePath temporaryPath;

    public DirectoryStash() throws IOException {
        this(null);
    }

    public DirectoryStash(FilePath stashedDirectory) throws IOException {
        boolean exists = stashedDirectory != null && this.fileSystem.findFile(stashedDirectory) != null;
        this.path = stashedDirectory != null ? stashedDirectory : this.buildTemporaryPath(new FilePath("~"), "temp");
        FilePath filePath = this.temporaryPath = exists ? this.buildTemporaryPath(stashedDirectory.getParent(), stashedDirectory.getName()) : null;
        if (exists) {
            this.fileSystem.move(this.path, this.temporaryPath);
        }
    }

    private FilePath buildTemporaryPath(FilePath parentPath, String baseName) {
        BIFile parent = this.fileSystem.findFile(parentPath);
        if (parent == null) {
            return parentPath.merge(baseName);
        }
        return parentPath.merge(FileToFile.getUniqueFilename((BDirectory)((BDirectory)parent), (String)baseName));
    }

    public void doNothing() {
    }

    @Override
    public void close() {
        if (this.temporaryPath != null) {
            try {
                this.fileSystem.delete(this.path);
                this.fileSystem.move(this.temporaryPath, this.path);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

