/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec.threat;

import com.tridium.nd.BNiagaraStation;
import com.tridium.orion.BIOrionAssociation;
import com.tridium.orion.BRef;
import com.tridium.orion.OrionSession;
import com.tridium.orion.OrionType;
import com.tridium.orion.annotations.NiagaraOrionType;
import com.tridiumx.entsec.BEnterpriseSecurityService;
import com.tridiumx.entsec.orionTools.RemoteUtil;
import com.tridiumx.entsec.orionTools.replicate.BReplicableObject;
import com.tridiumx.entsec.threat.BThreatLevelGroupRec;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;

@NiagaraType
@NiagaraOrionType
@NiagaraProperties(value={@NiagaraProperty(name="threatLevelGroup", type="BRef", defaultValue="BRef.make(BThreatLevelGroupRec.TYPE.getTypeSpec())", facets={@Facet(name="KEY", value="true"), @Facet(name="ON_DELETE", value="BOnDelete.CASCADE")}), @NiagaraProperty(name="stationName", type="String", defaultValue="", flags=9, facets={@Facet(name="KEY", value="true"), @Facet(name="WIDTH", value="64"), @Facet(name="BFacets.TARGET_TYPE", value="BNiagaraStation.TYPE.toString()")})})
public class BThreatLevelStationJoin
extends BReplicableObject
implements BIOrionAssociation {
    @Generated
    public static final Property threatLevelGroup = BThreatLevelStationJoin.newProperty((int)0, (BValue)BRef.make((BTypeSpec)BThreatLevelGroupRec.TYPE.getTypeSpec()), (BFacets)BFacets.make((BFacets)BFacets.make((String)"key", (boolean)true), (BFacets)BFacets.make((String)"onDelete", (int)1)));
    @Generated
    public static final Property stationName = BThreatLevelStationJoin.newProperty((int)9, (String)"", (BFacets)BFacets.make((BFacets)BFacets.make((BFacets)BFacets.make((String)"key", (boolean)true), (BFacets)BFacets.make((String)"width", (int)64)), (BFacets)BFacets.make((String)"targetType", (String)BNiagaraStation.TYPE.toString())));
    @Generated
    public static final Type TYPE = Sys.loadType(BThreatLevelStationJoin.class);
    @Generated
    public static final OrionType ORION_TYPE = (OrionType)TYPE;

    @Generated
    public BRef getThreatLevelGroup() {
        return (BRef)this.get(threatLevelGroup);
    }

    @Generated
    public void setThreatLevelGroup(BRef v) {
        this.set(threatLevelGroup, (BValue)v, null);
    }

    @Generated
    public String getStationName() {
        return this.getString(stationName);
    }

    @Generated
    public void setStationName(String v) {
        this.setString(stationName, v, null);
    }

    @Override
    @Generated
    public Type getType() {
        return this.getTypeFromSpace(TYPE);
    }

    @Override
    public void afterInsert(OrionSession session) {
        super.afterInsert(session);
        BEnterpriseSecurityService.threatReplicationRequired();
    }

    @Override
    public void afterDelete(OrionSession session) {
        BEnterpriseSecurityService.threatReplicationRequired();
        if (this.getStationName().equals(Sys.getStation().getStationName()) && RemoteUtil.isSubordinate()) {
            BThreatLevelGroupRec rec = (BThreatLevelGroupRec)this.getThreatLevelGroup().getTarget(session);
            if (rec == null) {
                return;
            }
            try {
                rec.deleteIfNoLongerValidOnSubordinate(session);
            }
            catch (Exception e) {
                throw new BajaRuntimeException(e.getMessage(), (Throwable)e);
            }
        }
        super.afterDelete(session);
    }
}

