/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec.threat;

import com.tridiumx.entsec.BEnterpriseSecurityService;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

@NiagaraType
public final class BThreatLevelEntry
extends BSimple {
    public static final BThreatLevelEntry NULL;
    public static final BThreatLevelEntry DEFAULT;
    public static final Type TYPE;
    private int ordinal;
    private String tag;
    private static final Lexicon lex;

    public Type getType() {
        return TYPE;
    }

    public static BThreatLevelEntry make(int ordinal) {
        return new BThreatLevelEntry(ordinal);
    }

    private BThreatLevelEntry(int ordinal) {
        this.ordinal = ordinal;
    }

    public int getOrdinal() {
        return this.ordinal;
    }

    public int hashCode() {
        return this.ordinal;
    }

    public boolean equals(Object obj) {
        if (obj instanceof BThreatLevelEntry) {
            return ((BThreatLevelEntry)((Object)obj)).ordinal == this.ordinal;
        }
        return false;
    }

    public String toString(Context context) {
        if (this.ordinal < 0) {
            if (context == null) {
                return lex.getText("defaultAssignment");
            }
            return context.getFacets().gets("falseText", lex.getText("defaultAssignment"));
        }
        try {
            BEnterpriseSecurityService service = (BEnterpriseSecurityService)Sys.getService((Type)BEnterpriseSecurityService.TYPE);
            String displayTag = service.getThreatLevelSetup().getThreatLevelRange().getDisplayTag(this.ordinal, context);
            if (!displayTag.equals("" + this.ordinal)) {
                return displayTag + " [" + this.ordinal + "]";
            }
            return "[" + this.ordinal + "]";
        }
        catch (Exception e) {
            return "[" + this.ordinal + "]";
        }
    }

    public void encode(DataOutput out) throws IOException {
        out.writeInt(this.ordinal);
    }

    public BObject decode(DataInput in) throws IOException {
        int i = in.readInt();
        if (i != 0) {
            throw new IOException("Invalid encoding for null.");
        }
        return NULL;
    }

    public String encodeToString() throws IOException {
        return Integer.toString(this.ordinal);
    }

    public BObject decodeFromString(String s) throws IOException {
        return BThreatLevelEntry.make(Integer.parseInt(s));
    }

    public boolean isNull() {
        return this.ordinal == 0;
    }

    static {
        DEFAULT = NULL = new BThreatLevelEntry(0);
        TYPE = Sys.loadType(BThreatLevelEntry.class);
        lex = Lexicon.make(BThreatLevelEntry.class);
    }
}

