/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec.threat;

import com.tridium.fox.sys.BFoxSession;
import com.tridium.nd.BNiagaraStation;
import com.tridiumx.entsec.BEnterpriseSecurityService;
import com.tridiumx.entsec.access.AccessControlServiceUpgrade;
import com.tridiumx.entsec.orionTools.RemoteUtil;
import com.tridiumx.entsec.securityUtil.BSafeSimpleJob;
import com.tridiumx.entsec.securityUtil.HistoryManager;
import com.tridiumx.entsec.threat.BThreatLevelEntry;
import com.tridiumx.entsec.threat.BThreatLevelGroup;
import com.tridiumx.entsec.threat.BThreatLevelSetup;
import java.io.Serializable;
import java.util.Comparator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.job.BJob;
import javax.baja.job.JobLog;
import javax.baja.job.JobLogItem;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdList;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.Action;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BUuid;
import javax.baja.util.Lexicon;
import javax.baja.util.Version;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="ordList", type="BOrdList", defaultValue="BOrdList.DEFAULT", flags=8), @NiagaraProperty(name="threatLevel", type="BThreatLevelEntry", defaultValue="BThreatLevelEntry.DEFAULT", flags=8, facets={@Facet(name="BFacets.FIELD_EDITOR", value="\"entsec:ActiveThreatLevelRangeFE\"")}), @NiagaraProperty(name="stationName", type="String", defaultValue="", flags=8), @NiagaraProperty(name="communicatedWithSupervisor", type="boolean", defaultValue="false", flags=8), @NiagaraProperty(name="communicatedWithPeers", type="boolean", defaultValue="false", flags=8), @NiagaraProperty(name="attemptedCommunicatedWithPeers", type="boolean", defaultValue="false", flags=8), @NiagaraProperty(name="jobUuid", type="BUuid", defaultValue="BUuid.DEFAULT", flags=8), @NiagaraProperty(name="successStations", type="String", defaultValue="", flags=2053), @NiagaraProperty(name="failedStations", type="String", defaultValue="", flags=2053), @NiagaraProperty(name="auditUser", type="String", defaultValue="", flags=2053)})
@NiagaraAction(name="readLog", returnType="BString", flags=2048, override=true)
public class BThreatLevelActivationJob
extends BSafeSimpleJob {
    @Generated
    public static final Property ordList = BThreatLevelActivationJob.newProperty((int)8, (BValue)BOrdList.DEFAULT, null);
    @Generated
    public static final Property threatLevel = BThreatLevelActivationJob.newProperty((int)8, (BValue)BThreatLevelEntry.DEFAULT, (BFacets)BFacets.make((String)"fieldEditor", (String)"entsec:ActiveThreatLevelRangeFE"));
    @Generated
    public static final Property stationName = BThreatLevelActivationJob.newProperty((int)8, (String)"", null);
    @Generated
    public static final Property communicatedWithSupervisor = BThreatLevelActivationJob.newProperty((int)8, (boolean)false, null);
    @Generated
    public static final Property communicatedWithPeers = BThreatLevelActivationJob.newProperty((int)8, (boolean)false, null);
    @Generated
    public static final Property attemptedCommunicatedWithPeers = BThreatLevelActivationJob.newProperty((int)8, (boolean)false, null);
    @Generated
    public static final Property jobUuid = BThreatLevelActivationJob.newProperty((int)8, (BValue)BUuid.DEFAULT, null);
    @Generated
    public static final Property successStations = BThreatLevelActivationJob.newProperty((int)2053, (String)"", null);
    @Generated
    public static final Property failedStations = BThreatLevelActivationJob.newProperty((int)2053, (String)"", null);
    @Generated
    public static final Property auditUser = BThreatLevelActivationJob.newProperty((int)2053, (String)"", null);
    @Generated
    public static final Action readLog = BThreatLevelActivationJob.newAction((int)2048, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BThreatLevelActivationJob.class);
    protected boolean supervisorJob = false;
    protected boolean peerJob = false;
    protected boolean originalJob = true;
    private Array<String> names = new Array(String.class);
    private Object lock = new Object();
    protected String currentSourceName = "";
    public static Logger LOG = Logger.getLogger("entsec.activationJob");
    public static String ACTIVATE_JOB = "activateJob";
    public static BFacets ACTIVATE_JOB_FACETS = BFacets.make((String)ACTIVATE_JOB, (boolean)true);
    static Lexicon lex = Lexicon.make(BThreatLevelActivationJob.class);

    @Generated
    public BOrdList getOrdList() {
        return (BOrdList)this.get(ordList);
    }

    @Generated
    public void setOrdList(BOrdList v) {
        this.set(ordList, (BValue)v, null);
    }

    @Generated
    public BThreatLevelEntry getThreatLevel() {
        return (BThreatLevelEntry)this.get(threatLevel);
    }

    @Generated
    public void setThreatLevel(BThreatLevelEntry v) {
        this.set(threatLevel, (BValue)v, null);
    }

    @Generated
    public String getStationName() {
        return this.getString(stationName);
    }

    @Generated
    public void setStationName(String v) {
        this.setString(stationName, v, null);
    }

    @Generated
    public boolean getCommunicatedWithSupervisor() {
        return this.getBoolean(communicatedWithSupervisor);
    }

    @Generated
    public void setCommunicatedWithSupervisor(boolean v) {
        this.setBoolean(communicatedWithSupervisor, v, null);
    }

    @Generated
    public boolean getCommunicatedWithPeers() {
        return this.getBoolean(communicatedWithPeers);
    }

    @Generated
    public void setCommunicatedWithPeers(boolean v) {
        this.setBoolean(communicatedWithPeers, v, null);
    }

    @Generated
    public boolean getAttemptedCommunicatedWithPeers() {
        return this.getBoolean(attemptedCommunicatedWithPeers);
    }

    @Generated
    public void setAttemptedCommunicatedWithPeers(boolean v) {
        this.setBoolean(attemptedCommunicatedWithPeers, v, null);
    }

    @Generated
    public BUuid getJobUuid() {
        return (BUuid)this.get(jobUuid);
    }

    @Generated
    public void setJobUuid(BUuid v) {
        this.set(jobUuid, (BValue)v, null);
    }

    @Generated
    public String getSuccessStations() {
        return this.getString(successStations);
    }

    @Generated
    public void setSuccessStations(String v) {
        this.setString(successStations, v, null);
    }

    @Generated
    public String getFailedStations() {
        return this.getString(failedStations);
    }

    @Generated
    public void setFailedStations(String v) {
        this.setString(failedStations, v, null);
    }

    @Generated
    public String getAuditUser() {
        return this.getString(auditUser);
    }

    @Generated
    public void setAuditUser(String v) {
        this.setString(auditUser, v, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public BThreatLevelActivationJob(BOrd ord, BThreatLevelEntry entry, String stationName) {
        this(ord, entry, stationName, null);
    }

    public BThreatLevelActivationJob(BOrd ord, BThreatLevelEntry entry, String stationName, String auditUser) {
        this(BOrdList.make((BOrd)ord), entry, stationName, auditUser);
    }

    public BThreatLevelActivationJob(BOrdList ordList, BThreatLevelEntry entry, String stationName) {
        this(ordList, entry, stationName, null);
    }

    public BThreatLevelActivationJob(BOrdList ordList, BThreatLevelEntry entry, String stationName, String auditUser) {
        this.setOrdList(ordList);
        this.setThreatLevel(entry);
        this.setStationName(stationName);
        this.currentSourceName = ordList.toString();
        if (auditUser != null && auditUser.length() > 0) {
            this.setAuditUser(auditUser);
        }
    }

    public BThreatLevelActivationJob() {
    }

    public void run(Context cx) throws Exception {
        int i;
        this.progress(1);
        BEnterpriseSecurityService service = (BEnterpriseSecurityService)Sys.getService((Type)BEnterpriseSecurityService.TYPE);
        BNiagaraStation[] subordinates = service.getMonitorSysDefSecurity().getSecuritySubordinateStations();
        boolean bl = this.supervisorJob = subordinates.length > 0;
        if (this.getJobUuid().equals((Object)BUuid.DEFAULT)) {
            this.originalJob = true;
            this.setJobUuid(BUuid.make());
            BThreatLevelSetup threatLevelSetup = (BThreatLevelSetup)Sys.getService((Type)BThreatLevelSetup.TYPE);
            threatLevelSetup.setLastJobUuid(this.getJobUuid());
        } else {
            this.originalJob = false;
        }
        if (!(this.supervisorJob || this.getCommunicatedWithSupervisor() || this.getCommunicatedWithPeers())) {
            this.setCommunicatedWithPeers(true);
        }
        this.setLocalThreatLevels(cx);
        if (this.supervisorJob) {
            this.setCommunicatedWithSupervisor(true);
            this.remoteStationsWork(subordinates, cx);
        } else {
            if (!this.getCommunicatedWithSupervisor()) {
                this.sendJobToSupervisor(cx);
            }
            if (!this.getAttemptedCommunicatedWithPeers()) {
                this.setAttemptedCommunicatedWithPeers(true);
                BNiagaraStation[] peers = service.getMonitorSysDefSecurity().getSecurityPeerStations();
                this.remoteStationsWork(peers, cx);
            }
        }
        int successCount = 0;
        int failedCount = 0;
        String[] split = null;
        split = TextUtil.split((String)this.getSuccessStations(), (char)';');
        for (i = 0; i < split.length; ++i) {
            if (split[i].length() <= 0) continue;
            ++successCount;
            if (!LOG.isLoggable(Level.FINE)) continue;
            this.log().success("Successful communication to station:" + split[i]);
        }
        if (this.supervisorJob && this.getCommunicatedWithSupervisor() || this.originalJob) {
            split = TextUtil.split((String)this.getFailedStations(), (char)';');
            for (i = 0; i < split.length; ++i) {
                if (split[i].length() <= 0 || split[i].equals(this.getStationName())) continue;
                String message = "Cannot communicate to station:" + split[i];
                for (int j = 0; j < this.names.size(); ++j) {
                    this.alarm(((String)this.names.get(j)).toString(), message);
                }
                if (this.originalJob) {
                    this.log().failed(message);
                }
                ++failedCount;
            }
            if (this.originalJob) {
                if (failedCount == 1) {
                    throw new Exception("1 Station is not Available.");
                }
                if (failedCount > 1) {
                    throw new Exception(failedCount + " Stations are not Available.");
                }
            }
            for (int j = 0; j < this.names.size(); ++j) {
                this.alarmComplete(((String)this.names.get(j)).toString());
            }
        }
        this.progress(100);
    }

    public void setLocalThreatLevels(Context cx) throws Exception {
        boolean useful = false;
        Array a = new Array((Object[])this.getOrdList().toArray());
        a = a.sort((Comparator)new OrdLengthCompare());
        BOrd[] ordArray = (BOrd[])a.trim();
        for (int i = 0; i < ordArray.length; ++i) {
            boolean skip = false;
            for (int j = 0; j < i; ++j) {
                if (ordArray[i].toString().indexOf(ordArray[j].toString()) <= -1) continue;
                skip = true;
            }
            if (skip || !this.setUniqueThreatLevel(ordArray[i], cx)) continue;
            useful = true;
        }
        if (!useful) {
            this.trace("Threat Level Group(s) Not Present");
        }
    }

    public boolean setUniqueThreatLevel(BOrd ord, Context cx) throws Exception {
        BThreatLevelGroup threatLevelGroup = null;
        try {
            threatLevelGroup = (BThreatLevelGroup)ord.get((BObject)this);
        }
        catch (Exception e) {
            if (this.originalJob) {
                throw e;
            }
            return false;
        }
        this.currentSourceName = threatLevelGroup.toDisplayString(cx);
        this.names.add((Object)this.currentSourceName);
        BThreatLevelEntry entry = this.getThreatLevel();
        this.trace("Starting Threat Level Activation for " + threatLevelGroup.toDisplayString(cx) + " to " + entry.toString() + " on " + Sys.getStation().getStationName() + "...");
        this.setThreatLevelAudit(threatLevelGroup, entry, Sys.getStation().getStationName(), cx);
        this.trace("Threat Level Activation Complete on " + Sys.getStation().getStationName() + ".");
        if (this.originalJob) {
            this.alarmIniated(this.currentSourceName);
        }
        return true;
    }

    public void setThreatLevelAudit(BThreatLevelGroup current, BThreatLevelEntry entry, String stationName, Context cx) {
        this.setThreatLevel(current, entry, stationName, cx, this.getAuditUser());
    }

    public void setThreatLevel(BThreatLevelGroup current, BThreatLevelEntry entry, String stationName, Context cx, String audit) {
        StringBuffer b = new StringBuffer();
        b.append(current.toDisplayString(cx));
        BThreatLevelEntry currentEntry = current.getActiveLevel();
        if (!currentEntry.equals((Object)entry)) {
            b.append(" is changing from ").append(currentEntry.toString(cx)).append(" to ").append(entry.toString(cx));
            current.setActiveLevelFromJob(entry);
        } else {
            b.append(" is already set to ").append(entry.toString(cx));
        }
        if (audit != null && audit.length() > 0) {
            HistoryManager.appendAuditRecord("Changed", current.getSlotPath(), BThreatLevelGroup.activeLevel.getName(), currentEntry.toString(), entry.toString(), audit);
        }
        this.log().message(b.toString());
        BThreatLevelGroup[] children = (BThreatLevelGroup[])current.getChildren(BThreatLevelGroup.class);
        for (int i = 0; i < children.length; ++i) {
            this.setThreatLevel(children[i], entry, stationName, cx, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendJobToSupervisor(Context cx) {
        this.trace("trying to send job to supervisor");
        BEnterpriseSecurityService service = (BEnterpriseSecurityService)Sys.getService((Type)BEnterpriseSecurityService.TYPE);
        BNiagaraStation[] supervisorStations = service.getMonitorSysDefSecurity().getSecuritySupervisorStations();
        if (supervisorStations.length > 0) {
            BFoxSession session = RemoteUtil.getFoxSession(supervisorStations[0]);
            String interest = "ThreatLevelActivationJob" + System.identityHashCode((Object)this);
            try {
                int i;
                session.engageNoRetry(interest);
                BThreatLevelSetup remoteSetup = (BThreatLevelSetup)session.getService(BThreatLevelSetup.TYPE);
                remoteSetup.lease();
                remoteSetup.getComponentSpace().sync();
                BThreatLevelActivationJob remoteJob = this.getJob(this.getOrdList(), this.getThreatLevel(), Sys.getStation().getStationName());
                remoteJob.setJobUuid(this.getJobUuid());
                remoteJob.setCommunicatedWithSupervisor(true);
                remoteJob.setAttemptedCommunicatedWithPeers(this.getAttemptedCommunicatedWithPeers());
                remoteJob.setCommunicatedWithPeers(this.getCommunicatedWithPeers());
                BOrd jobOrd = BOrd.make((String)("station:|" + remoteSetup.submit(remoteJob)));
                remoteSetup.getComponentSpace().sync();
                remoteJob = (BThreatLevelActivationJob)jobOrd.get((BObject)session);
                remoteJob.lease();
                while (remoteJob.isAlive()) {
                    Thread.sleep(500L);
                }
                this.checkRemoteJobStatus(remoteJob);
                String[] split = TextUtil.split((String)remoteJob.getSuccessStations(), (char)';');
                for (i = 0; i < split.length; ++i) {
                    if (split[i].length() <= 0) continue;
                    this.addSuccessStation(split[i]);
                }
                split = TextUtil.split((String)remoteJob.getFailedStations(), (char)';');
                for (i = 0; i < split.length; ++i) {
                    if (split[i].length() <= 0) continue;
                    this.addFailedStation(split[i]);
                }
                this.addSuccessStation(supervisorStations[0].getStationName());
                this.traceJobLog(supervisorStations[0].getStationName(), (BJob)remoteJob);
                this.setCommunicatedWithSupervisor(true);
            }
            catch (Exception e) {
                this.addFailedStation(supervisorStations[0].getStationName());
            }
            finally {
                session.disengage(interest);
            }
        }
    }

    public void alarm(String sourceName, String message) {
        StringBuffer b = new StringBuffer();
        BEnterpriseSecurityService service = (BEnterpriseSecurityService)Sys.getService((Type)BEnterpriseSecurityService.TYPE);
        service.getThreatLevelSetup().generateActivationFailureAlert(sourceName + " to " + (Object)((Object)this.getThreatLevel()), lex.getText("activationJob.activationIncomplete", new Object[]{message}));
    }

    public void alarmIniated(String sourceName) {
        StringBuffer b = new StringBuffer();
        BEnterpriseSecurityService service = (BEnterpriseSecurityService)Sys.getService((Type)BEnterpriseSecurityService.TYPE);
        service.getThreatLevelSetup().generateActivationInitiatedAlert(sourceName + " to " + (Object)((Object)this.getThreatLevel()), lex.getText("activationJob.activationInitiated"));
    }

    public void alarmComplete(String sourceName) {
        StringBuffer b = new StringBuffer();
        BEnterpriseSecurityService service = (BEnterpriseSecurityService)Sys.getService((Type)BEnterpriseSecurityService.TYPE);
        service.getThreatLevelSetup().generateActivationCompleteAlert(sourceName + " to " + (Object)((Object)this.getThreatLevel()), lex.getText("activationJob.activationComplete"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remoteStationsWork(BNiagaraStation[] stations, Context context) throws Exception {
        int length = stations.length;
        if (length == 0) {
            return;
        }
        Counter counter = new Counter(length);
        StationWork[] workers = new StationWork[length];
        for (int i = 0; i < length; ++i) {
            if (!this.getStationName().equals(stations[i].getStationName())) {
                workers[i] = new StationWork(stations[i], counter, context);
                stations[i].postAsync((Runnable)workers[i]);
                continue;
            }
            this.signalCounter(counter);
        }
        Counter i = counter;
        synchronized (i) {
            while (counter.count > 0) {
                try {
                    counter.wait(20000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    break;
                }
            }
        }
        for (int i2 = 0; i2 < length; ++i2) {
            if (workers[i2] == null || workers[i2].e == null) continue;
            String message = "Station not available:" + stations[i2].getStationName();
            this.log().failed(message, (Throwable)workers[i2].e);
            this.alarm(this.currentSourceName, message);
        }
    }

    public BThreatLevelActivationJob getJob(BOrdList ordList, BThreatLevelEntry entry, String stationName) {
        return new BThreatLevelActivationJob(ordList, entry, stationName);
    }

    public void checkRemoteJobStatus(BThreatLevelActivationJob remoteJob) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void signalCounter(Counter counter) {
        Counter counter2 = counter;
        synchronized (counter2) {
            --counter.count;
            if (counter.count < 1) {
                counter.notifyAll();
            } else {
                this.progress((int)((float)(counter.length - counter.count) / (float)counter.length * 100.0f));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFailedStation(String stationName) {
        Object object = this.lock;
        synchronized (object) {
            String successStations = this.getSuccessStations();
            String stations = this.getFailedStations();
            if (stations.indexOf(";" + stationName + ";") > -1) {
                return;
            }
            if (successStations.indexOf(";" + stationName + ";") > -1) {
                return;
            }
            if (stations.length() == 0) {
                stations = stations + ";";
            }
            stations = stations + stationName + ";";
            this.setFailedStations(stations);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSuccessStation(String stationName) {
        Object object = this.lock;
        synchronized (object) {
            String failedStations = this.getFailedStations();
            String stations = this.getSuccessStations();
            if (stations.indexOf(";" + stationName + ";") > -1) {
                return;
            }
            if (failedStations.indexOf(";" + stationName + ";") > -1) {
                int index = failedStations.indexOf(";" + stationName + ";");
                if ((failedStations = failedStations.substring(0, index) + failedStations.substring(index + (";" + stationName).length())).equals(";")) {
                    this.setFailedStations("");
                } else {
                    this.setFailedStations(failedStations);
                }
            }
            if (stations.length() == 0) {
                stations = stations + ";";
            }
            stations = stations + stationName + ";";
            this.setSuccessStations(stations);
        }
    }

    public synchronized void traceJobLog(String stationName, BJob remoteJob) throws Exception {
        BString jobLogString = remoteJob.readLog();
        JobLog jobLog = JobLog.decode((String)jobLogString.toString());
        JobLogItem[] items = jobLog.getItems();
        for (int i = 0; i < items.length; ++i) {
            if (items[i].getMessage().equals("Job Success")) continue;
            JobLogItem copy = new JobLogItem(items[i].getId(), stationName + ": " + items[i].getMessage(), items[i].getDetails());
            this.log().add(copy);
        }
    }

    public void trace(String trace) {
        if (LOG.isLoggable(Level.FINE)) {
            this.log().start(trace);
        }
    }

    public String toString(Context cx) {
        return super.toString(cx) + ": " + this.getThreatDisplayName(this.getOrdList()) + ", " + this.getThreatLevel().toString();
    }

    public String getThreatDisplayName(BOrdList ordList) {
        StringBuffer b = new StringBuffer();
        for (int i = 0; i < ordList.size(); ++i) {
            String ord = ordList.get(0).toString();
            int index = ord.indexOf("/threatLevelGroups/") + "/threatLevelGroups/".length();
            if (i > 0) {
                b.append(", ");
            }
            b.append(ord.substring(index));
        }
        return SlotPath.unescape((String)b.toString());
    }

    public static class OrdLengthCompare
    implements Comparator<BOrd>,
    Serializable {
        private static final long serialVersionUID = 1L;

        @Override
        public int compare(BOrd ord1, BOrd ord2) {
            int i1 = ord1.toString().length();
            int i2 = ord2.toString().length();
            return i1 - i2;
        }
    }

    static class Counter {
        int count = 0;
        int length = 1;

        Counter(int count) {
            this.length = count > 0 ? count : 1;
            this.count = count;
        }
    }

    class StationWork
    implements Runnable {
        Counter counter;
        BNiagaraStation station;
        Context cx;
        Exception e = null;

        StationWork(BNiagaraStation station, Counter counter, Context cx) {
            this.station = station;
            this.counter = counter;
            this.cx = cx;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            String stationName = null;
            try {
                stationName = this.station.getStationName();
                if (stationName.equals(BThreatLevelActivationJob.this.getStationName()) || !this.station.getEnabled()) {
                    return;
                }
                BThreatLevelActivationJob.this.trace("Starting Threat Level Activation on station '" + stationName + "'...");
                String interest = "ThreatLevelActivationJob" + System.identityHashCode(this);
                BFoxSession session = RemoteUtil.getFoxSession(this.station);
                try {
                    int i;
                    block23: {
                        session.engageNoRetry(interest);
                        try {
                            Version version = (Version)session.fw(404, (Object)BThreatLevelSetup.TYPE.getModule().getModuleName(), null, null, null);
                            if (version != null && version.compareTo(AccessControlServiceUpgrade.SECURITY_2_2_1) >= 0) break block23;
                            return;
                        }
                        catch (Exception e) {
                            if (LOG.isLoggable(Level.FINE)) {
                                BThreatLevelActivationJob.this.log().failed("version check issue", (Throwable)e);
                            }
                            if (session != null) {
                                session.disengage(interest);
                            }
                            BThreatLevelActivationJob.this.signalCounter(this.counter);
                            return;
                        }
                    }
                    session.getService(BThreatLevelSetup.TYPE);
                    BThreatLevelSetup remoteSetup = (BThreatLevelSetup)session.getService(BThreatLevelSetup.TYPE);
                    remoteSetup.lease();
                    remoteSetup.getComponentSpace().sync();
                    BThreatLevelActivationJob remoteJob = BThreatLevelActivationJob.this.getJob(BThreatLevelActivationJob.this.getOrdList(), BThreatLevelActivationJob.this.getThreatLevel(), Sys.getStation().getStationName());
                    remoteJob.setJobUuid(BThreatLevelActivationJob.this.getJobUuid());
                    remoteJob.setCommunicatedWithSupervisor(BThreatLevelActivationJob.this.getCommunicatedWithSupervisor());
                    remoteJob.setAttemptedCommunicatedWithPeers(BThreatLevelActivationJob.this.getAttemptedCommunicatedWithPeers());
                    remoteJob.setCommunicatedWithPeers(BThreatLevelActivationJob.this.getCommunicatedWithPeers());
                    BOrd jobOrd = BOrd.make((String)("station:|" + remoteSetup.submit(remoteJob)));
                    remoteSetup.getComponentSpace().sync();
                    remoteJob = (BThreatLevelActivationJob)jobOrd.get((BObject)session);
                    remoteJob.lease();
                    while (remoteJob.isAlive()) {
                        Thread.sleep(500L);
                    }
                    BThreatLevelActivationJob.this.checkRemoteJobStatus(remoteJob);
                    String[] split = TextUtil.split((String)remoteJob.getSuccessStations(), (char)';');
                    for (i = 0; i < split.length; ++i) {
                        if (split[i].length() <= 0) continue;
                        BThreatLevelActivationJob.this.addSuccessStation(split[i]);
                    }
                    split = TextUtil.split((String)remoteJob.getFailedStations(), (char)';');
                    for (i = 0; i < split.length; ++i) {
                        if (split[i].length() <= 0) continue;
                        BThreatLevelActivationJob.this.addFailedStation(split[i]);
                    }
                    BThreatLevelActivationJob.this.addSuccessStation(this.station.getStationName());
                    BThreatLevelActivationJob.this.traceJobLog(this.station.getStationName(), (BJob)remoteJob);
                }
                catch (Exception ex) {
                    BThreatLevelActivationJob.this.addFailedStation(stationName);
                }
                finally {
                    if (session != null) {
                        session.disengage(interest);
                    }
                }
            }
            finally {
                BThreatLevelActivationJob.this.signalCounter(this.counter);
            }
        }
    }
}

