/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec.securityUtil.ui.query;

import com.tridium.bql.filter.BAbsTimeFilter;
import com.tridium.bql.filter.BFilterEntry;
import com.tridium.bql.filter.BFilterSet;
import com.tridium.bql.filter.BStringFilter;
import com.tridiumx.entsec.filter.BPersonnelChangeTargetStringFilter;
import com.tridiumx.entsec.filter.PrefilteringUtil;
import com.tridiumx.entsec.securityUtil.query.QueryUtil;
import javax.baja.agent.AgentFilter;
import javax.baja.agent.AgentInfo;
import javax.baja.agent.AgentList;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.query.BExpression;
import javax.baja.query.BIQueryFilter;
import javax.baja.query.BProjection;
import javax.baja.query.BProjectionColumn;
import javax.baja.query.BQuery;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BWidget;
import javax.baja.ui.options.BOptions;
import javax.baja.util.BTypeSpec;
import javax.baja.web.BIWebProfile;
import javax.baja.web.BWebProfileConfig;

@NiagaraType
public class BQueryTableOptions
extends BOptions {
    @Generated
    public static final Type TYPE = Sys.loadType(BQueryTableOptions.class);
    private static String COLUMNS = "Columns";
    private static String SORT_ASC = "SortAsc";
    private static String SORT_INDEX = "SortIndex";
    private static String FILTER = "Filter";
    private static BQueryTableOptions options;
    private Object lock = new Object();
    private static Object staticLock;

    @Generated
    public Type getType() {
        return TYPE;
    }

    public static BQueryTableOptions make() {
        if (options == null) {
            options = BWidget.getApplication() == null ? new BQueryTableOptions() : (BQueryTableOptions)BQueryTableOptions.load((Type)TYPE);
        }
        return options;
    }

    public void setProjection(BQuery query, BProjection projection, Context cx) {
        BTypeSpec typeSpec = QueryUtil.getRowType(query);
        String propName = QueryUtil.getProvider(query).getOptionsKey(query) + COLUMNS;
        BProjection container = (BProjection)projection.newCopy(true);
        QueryUtil.reorderColumns(container);
        BProjectionColumn[] columns = (BProjectionColumn[])container.getChildren(BProjectionColumn.class);
        boolean allHidden = true;
        for (int i = 0; i < columns.length; ++i) {
            if (Flags.isHidden((BComplex)columns[i].getParent(), (Slot)columns[i].getPropertyInParent())) continue;
            allHidden = false;
        }
        if (allHidden) {
            this.removeProjection(query);
            return;
        }
        if (this.get(propName) == null) {
            this.add(propName, (BValue)container);
        } else {
            this.set(propName, (BValue)container);
        }
    }

    public BProjection getProjection(BQuery query, Context cx) {
        BTypeSpec typeSpec = QueryUtil.getRowType(query);
        String propName = QueryUtil.getProvider(query).getOptionsKey(query) + COLUMNS;
        BProjection container = (BProjection)this.get(propName);
        return container;
    }

    public void removeProjection(BQuery query) {
        BTypeSpec typeSpec = QueryUtil.getRowType(query);
        String propName = QueryUtil.getProvider(query).getOptionsKey(query) + COLUMNS;
        if (this.get(propName) != null) {
            this.remove(propName);
        }
    }

    public void setSortColumnIndex(BQuery query, int colIndex) {
        BTypeSpec typeSpec = QueryUtil.getRowType(query);
        String propName = QueryUtil.getProvider(query).getOptionsKey(query) + SORT_INDEX;
        BInteger col = BInteger.make((int)colIndex);
        BInteger oldCol = BInteger.make((int)this.getSortColumnIndex(query));
        boolean asc = true;
        if (oldCol.equals((Object)col)) {
            boolean bl = asc = !this.getSortColumnAsc(query);
        }
        if (this.get(propName) == null) {
            this.add(propName, (BValue)col);
        } else {
            this.set(propName, (BValue)col);
        }
        this.setSortColumnAsc(query, asc);
    }

    public int getSortColumnIndex(BQuery query) {
        BTypeSpec typeSpec = QueryUtil.getRowType(query);
        String propName = QueryUtil.getProvider(query).getOptionsKey(query) + SORT_INDEX;
        BInteger col = (BInteger)this.get(propName);
        if (col == null) {
            return QueryUtil.getProvider(query).getDefaultSortColumnIndex(query);
        }
        return col.getInt();
    }

    private void setSortColumnAsc(BQuery query, boolean ascending) {
        String propName = QueryUtil.getProvider(query).getOptionsKey(query) + SORT_ASC;
        BBoolean col = BBoolean.make((boolean)ascending);
        if (this.get(propName) == null) {
            this.add(propName, (BValue)col);
        } else {
            this.set(propName, (BValue)col);
        }
    }

    public boolean isDefaultAsc(BQuery query) {
        BTypeSpec typeSpec;
        int col = this.getSortColumnIndex(query);
        boolean asc = true;
        BProjectionColumn[] children = (BProjectionColumn[])query.getProjection().getChildren(BProjectionColumn.class);
        if (col < children.length && col > -1 && (typeSpec = (BTypeSpec)children[col].get("typeSpec")).equals((Object)BAbsTime.TYPE.getTypeSpec())) {
            asc = false;
        }
        return asc;
    }

    public boolean getSortColumnAsc(BQuery query) {
        String propName = QueryUtil.getProvider(query).getOptionsKey(query) + SORT_ASC;
        BBoolean asc = (BBoolean)this.get(propName);
        if (asc == null) {
            return true;
        }
        return asc.getBoolean();
    }

    public boolean getSortColumnAscForIndex(BQuery query) {
        boolean asc = this.getSortColumnAsc(query);
        if (!this.isDefaultAsc(query)) {
            return !asc;
        }
        return asc;
    }

    public boolean getPrefiltering(BQuery query) {
        return PrefilteringUtil.getPrefiltering((BComponent)query, this, QueryUtil.getProvider(query).getOptionsKey(query) + PrefilteringUtil.PRE_FILTERING);
    }

    public void setPrefiltering(BQuery query, boolean prefiltering) {
        PrefilteringUtil.setPrefiltering(prefiltering, this, QueryUtil.getProvider(query).getOptionsKey(query) + PrefilteringUtil.PRE_FILTERING);
    }

    public void removePrefiltering(BQuery query) {
        PrefilteringUtil.removePrefiltering(this, QueryUtil.getProvider(query).getOptionsKey(query) + PrefilteringUtil.PRE_FILTERING);
    }

    public BFilterSet getFilterSet(BQuery query) {
        BFilterSet filter = (BFilterSet)this.get(QueryUtil.getProvider(query).getOptionsKey(query) + FILTER);
        return filter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFilterSet(BQuery query, BFilterSet filterSet) {
        String propName = QueryUtil.getProvider(query).getOptionsKey(query) + FILTER;
        Object object = this.lock;
        synchronized (object) {
            if (this.get(propName) == null) {
                this.add(propName, (BValue)filterSet);
            } else {
                this.set(propName, (BValue)filterSet);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFilterSet(BQuery query) {
        String propName = QueryUtil.getProvider(query).getOptionsKey(query) + FILTER;
        Object object = this.lock;
        synchronized (object) {
            if (this.get(propName) != null) {
                this.remove(propName);
            }
        }
    }

    public static void updateFilterSet(BFilterSet filterSet) {
        if (filterSet == null) {
            return;
        }
        BFilterEntry[] entries = (BFilterEntry[])filterSet.getChildren(BFilterEntry.class);
        for (int i = 0; i < entries.length; ++i) {
            BIQueryFilter filter = entries[i].toQueryFilter();
            if (!(filter instanceof BAbsTimeFilter) && !(filter instanceof BPersonnelChangeTargetStringFilter)) continue;
            filter.init(null);
        }
    }

    public static boolean isFilterSetValid(BQuery query, BFilterSet filterSet) {
        BProjectionColumn[] columns;
        if (filterSet == null) {
            return true;
        }
        BFilterEntry[] entries = (BFilterEntry[])filterSet.getChildren(BFilterEntry.class);
        if (entries.length != (columns = query.getProjection().getProjectionColumns()).length) {
            return false;
        }
        for (int i = 0; i < columns.length; ++i) {
            if (!entries[i].getName().equals(columns[i].getName())) {
                return false;
            }
            String name = entries[i].getName();
            BProjection projection = query.getProjection();
            if (Flags.isHidden((BComplex)filterSet, (Slot)filterSet.getProperty(name)) == Flags.isHidden((BComplex)query.getProjection(), (Slot)projection.getProperty(name))) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BFilterSet rebuildFilterSet(BQuery query, BFilterSet filterSet, Context cx) {
        Object object = staticLock;
        synchronized (object) {
            int i;
            if (filterSet == null) {
                filterSet = new BFilterSet();
            }
            BProjectionColumn[] columns = query.getProjection().getProjectionColumns();
            for (int i2 = 0; i2 < columns.length; ++i2) {
                Property p;
                BProjectionColumn col = columns[i2];
                String alias = col.getAlias();
                String fieldName = col.getName();
                boolean newlyHiddenFix = false;
                boolean newlyVisibleFix = false;
                if (Flags.isHidden((BComplex)query.getProjection(), (Slot)col.getPropertyInParent()) && filterSet.getProperty(fieldName) != null && !Flags.isHidden((BComplex)filterSet, (Slot)filterSet.getProperty(fieldName))) {
                    newlyHiddenFix = true;
                }
                if (!Flags.isHidden((BComplex)query.getProjection(), (Slot)col.getPropertyInParent()) && filterSet.getProperty(fieldName) != null && Flags.isHidden((BComplex)filterSet, (Slot)filterSet.getProperty(fieldName))) {
                    newlyVisibleFix = true;
                }
                if (!newlyHiddenFix && !newlyVisibleFix && filterSet.get(fieldName) != null) continue;
                Object filter = null;
                boolean active = false;
                BTypeSpec typeSpec = (BTypeSpec)col.get("typeSpec");
                BObject value = typeSpec.getInstance();
                if (col.get("defaultFilter") == null) {
                    AgentList agents = value.getAgents().filter(AgentFilter.and((AgentFilter)AgentFilter.is((Type)BIQueryFilter.TYPE), (AgentFilter)new ProfileFilter(cx)));
                    filter = agents.size() != 0 ? (BIQueryFilter)agents.getDefault().getInstance() : new BStringFilter();
                } else {
                    filter = (BIQueryFilter)col.get("defaultFilter").newCopy();
                    active = !Flags.isUserDefined1((BComplex)filterSet, (Slot)col.getProperty("defaultFilter"));
                }
                filter.init(value);
                BFilterEntry entry = new BFilterEntry(active, alias, filter, (BExpression)col.getColumnExpression().newCopy());
                if (Flags.isHidden((BComplex)query.getProjection(), (Slot)col.getPropertyInParent())) {
                    if (!newlyHiddenFix && filterSet.get(fieldName) == null) {
                        filterSet.add(fieldName, (BValue)entry, 4);
                        continue;
                    }
                    filterSet.set(fieldName, (BValue)entry);
                    p = filterSet.getProperty(fieldName);
                    filterSet.setFlags((Slot)p, filterSet.getFlags((Slot)p) | 4);
                    continue;
                }
                if (!newlyVisibleFix && filterSet.get(fieldName) == null) {
                    filterSet.add(fieldName, (BValue)entry);
                    continue;
                }
                filterSet.set(fieldName, (BValue)entry);
                p = filterSet.getProperty(fieldName);
                filterSet.setFlags((Slot)p, filterSet.getFlags((Slot)p) & 0xFFFFFFFB);
            }
            BFilterEntry[] entries = (BFilterEntry[])filterSet.getChildren(BFilterEntry.class);
            for (i = 0; i < entries.length; ++i) {
                String name = entries[i].getName();
                boolean found = false;
                for (int j = 0; j < columns.length; ++j) {
                    if (!columns[j].getName().equals(name)) continue;
                    found = true;
                }
                if (found) continue;
                filterSet.remove(entries[i].getPropertyInParent());
            }
            for (i = columns.length - 1; i >= 0; --i) {
                Property p = filterSet.getProperty(columns[i].getName());
                if (p == null) continue;
                filterSet.reorderToTop(p);
            }
            return filterSet;
        }
    }

    public static boolean anyVisibleActive(BFilterSet filterSet) {
        SlotCursor c = filterSet.getProperties();
        while (c.next()) {
            BFilterEntry entry = (BFilterEntry)c.get();
            if (!entry.getActive() || Flags.isHidden((BComplex)filterSet, (Slot)entry.getPropertyInParent())) continue;
            return true;
        }
        return false;
    }

    public static BObject getSlotFacetValue(BObject target, BString name) {
        BFacets facets;
        if (!(target instanceof BComplex) || name == null) {
            return null;
        }
        String key = name.getString();
        if (key == null) {
            return null;
        }
        Property prop = ((BComplex)target).getPropertyInParent();
        if (prop != null && (facets = prop.getFacets()) != null) {
            return facets.get(key);
        }
        return null;
    }

    static {
        staticLock = new Object();
    }

    public static class ProfileFilter
    extends AgentFilter {
        BIWebProfile profile;

        public ProfileFilter(Context cx) {
            if (cx != null && cx.getUser() != null) {
                BWebProfileConfig config = (BWebProfileConfig)cx.getUser().getMixIn(BWebProfileConfig.TYPE);
                this.profile = (BIWebProfile)config.getTypeSpec().getInstance();
            }
        }

        public boolean include(AgentInfo agent) {
            if (this.profile == null) {
                return true;
            }
            if (agent.getAppName() != null) {
                String[] profileAppNames = this.profile.getAppNames();
                for (int i = 0; i < profileAppNames.length; ++i) {
                    if (!profileAppNames[i].equals(agent.getAppName())) continue;
                    return true;
                }
                return false;
            }
            return true;
        }
    }
}

