/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec.securityUtil.query;

import com.tridium.bql.filter.BBooleanFilter;
import com.tridiumx.entsec.securityUtil.query.TypeSpecPath;
import com.tridiumx.entsec.securityUtil.query.consolidated.BConsolidatedColumnsProvider;
import javax.baja.alarm.BAlarmClass;
import javax.baja.alarm.BAlarmService;
import javax.baja.alarm.BAlarmSourceInfo;
import javax.baja.alarm.ext.BAlarmSourceExt;
import javax.baja.control.BControlPoint;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.query.BExpression;
import javax.baja.query.BQuery;
import javax.baja.query.expression.BFunctionExpression;
import javax.baja.query.util.Exprs;
import javax.baja.query.util.Funcs;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.BString;
import javax.baja.sys.Flags;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;

@NiagaraType(agent={@AgentOn(types={"alarm:AlarmSourceExt"})})
public class BAlarmSourceExtColumnsProvider
extends BConsolidatedColumnsProvider {
    @Generated
    public static final Type TYPE = Sys.loadType(BAlarmSourceExtColumnsProvider.class);

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    @Override
    public TypeSpecPath[] getDefaultColumns(BQuery query) {
        Array a = new Array(TypeSpecPath.class);
        a.add((Object)BConsolidatedColumnsProvider.stationNameFunction(null));
        BFunctionExpression exp = Funcs.make((String)"entsec:EnterpriseSecurityService.format", (Type)BString.TYPE, (BExpression)Exprs.simple((BSimple)BString.make((String)"sourceName")));
        TypeSpecPath sourceNameCol = new TypeSpecPath(BTypeSpec.make((String)"baja:String"), "sourceName", null, (BExpression)exp);
        a.add((Object)sourceNameCol);
        a.add((Object)TypeSpecPath.DISPLAY_NAME);
        BFunctionExpression function = Funcs.make((String)"entsec:AlarmSourceExtColumnsProvider.getAlarmClass", (Type)BObject.TYPE, (BExpression)Exprs.simple((BSimple)BString.make((String)"")));
        TypeSpecPath alarmClassColumn = new TypeSpecPath(BTypeSpec.make((String)"baja:String"), "displayAlarmClass", BAlarmClass.TYPE.getDisplayName(null), (BExpression)function);
        a.add((Object)alarmClassColumn);
        a.add((Object)new TypeSpecPath(BAlarmSourceExt.alarmState));
        a.add((Object)TypeSpecPath.STATUS);
        return (TypeSpecPath[])a.trim();
    }

    @Override
    public TypeSpecPath[] getHiddenColumns(BQuery query) {
        Array a = new Array((Object[])super.getHiddenColumns(query));
        BFunctionExpression function = Funcs.make((String)"entsec:AlarmSourceExtColumnsProvider.isPointHidden", (Type)BBoolean.TYPE, (BExpression)Exprs.simple((BSimple)BString.make((String)"")));
        TypeSpecPath isPointHiddenColumn = new TypeSpecPath(BTypeSpec.make((String)"baja:Boolean"), "isPointHidden", null, (BExpression)function);
        isPointHiddenColumn.defaultFilter = new BBooleanFilter();
        a.add(0, (Object)isPointHiddenColumn);
        a.add(1, (Object)BConsolidatedColumnsProvider.stationNameFunction(null));
        return (TypeSpecPath[])a.trim();
    }

    public static BObject getAlarmClass(BObject target, BString name) {
        if (target instanceof BAlarmSourceExt) {
            BAlarmSourceExt ext = (BAlarmSourceExt)target;
            BAlarmService alarmService = (BAlarmService)Sys.getService((Type)BAlarmService.TYPE);
            BAlarmClass alarmClass = alarmService.lookupAlarmClass(ext.getAlarmClass());
            return BString.make((String)alarmClass.getDisplayName(null));
        }
        if (target instanceof BAlarmSourceInfo) {
            BAlarmSourceInfo ext = (BAlarmSourceInfo)target;
            BAlarmService alarmService = (BAlarmService)Sys.getService((Type)BAlarmService.TYPE);
            BAlarmClass alarmClass = alarmService.lookupAlarmClass(ext.getAlarmClass());
            return BString.make((String)alarmClass.getDisplayName(null));
        }
        return null;
    }

    public static BBoolean isPointHidden(BObject target, BString name) {
        if (target instanceof BAlarmSourceExt) {
            BAlarmSourceExt ext = (BAlarmSourceExt)target;
            BControlPoint point = ext.getParentPoint();
            return BBoolean.make((boolean)Flags.isHidden((BComplex)point.getParent(), (Slot)point.getPropertyInParent()));
        }
        if (target instanceof BAlarmSourceInfo) {
            BAlarmSourceInfo info = (BAlarmSourceInfo)target;
            BComponent parent = (BComponent)info.getParent();
            return BBoolean.make((boolean)Flags.isHidden((BComplex)parent, (Slot)info.getPropertyInParent()));
        }
        return null;
    }
}

