/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec.securityUtil.bog;

import com.tridiumx.entsec.securityUtil.bog.Entry;
import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import javax.baja.file.BIFile;
import javax.baja.naming.BOrd;
import javax.baja.nre.util.Array;
import javax.baja.xml.XElem;
import javax.baja.xml.XParser;

public class GenericDecoder
extends XParser {
    public GenericDecoder(BOrd ord) throws Exception {
        this((BIFile)ord.resolve().get());
    }

    public GenericDecoder(BIFile file) throws Exception {
        this(new BufferedInputStream(file.getInputStream()));
    }

    public GenericDecoder(File file) throws Exception {
        this(new BufferedInputStream(new FileInputStream(file)));
    }

    public GenericDecoder(InputStream in) throws Exception {
        super(in);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Entry decodeDocument(boolean close) throws Exception {
        try {
            this.next();
            XElem root = this.elem();
            if (!root.name().equals("bajaObjectGraph")) {
                throw new IllegalStateException("Root element must be \"bajaObjectGraph\"");
            }
            String ver = root.get("version");
            if (!ver.equals("1.0")) {
                throw new IllegalStateException("Only version 1.0 is supported");
            }
            this.next();
            Entry value = this.decode();
            this.next();
            if (this.type() != 2 || this.elem() != root) {
                throw new IllegalStateException("Expected end tag for \"bajaObjectGraph\"");
            }
            Entry entry = value;
            return entry;
        }
        finally {
            if (close) {
                this.close();
            }
        }
    }

    public String getSlotPath(Entry root, String handle) {
        return this.getSlotPath(this.findHandle(root, handle));
    }

    public String getSlotPath(Entry entry) {
        if (entry != null) {
            StringBuffer sb = new StringBuffer();
            Array arr = new Array(String.class);
            arr.add((Object)entry.name);
            Entry parent = entry.parent;
            while (parent != null && parent.name != null) {
                arr.add((Object)parent.name);
                parent = parent.parent;
            }
            String[] names = (String[])arr.trim();
            for (int i = names.length - 1; i >= 0; --i) {
                if (i < names.length - 1) {
                    sb.append("/");
                }
                sb.append(names[i]);
            }
            return sb.toString();
        }
        return null;
    }

    public Entry findType(Entry entry, String module, String type) {
        if (entry != null && entry.module != null && entry.type != null && entry.module.equals(module) && entry.type.equals(type)) {
            return entry;
        }
        Entry[] kids = entry.getChildren();
        for (int i = 0; i < kids.length; ++i) {
            Entry result = this.findType(kids[i], module, type);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public Entry findHandle(Entry entry, String handle) {
        if (entry != null && entry.handle != null && entry.handle.equals(handle)) {
            return entry;
        }
        Entry[] kids = entry.getChildren();
        for (int i = 0; i < kids.length; ++i) {
            Entry result = this.findHandle(kids[i], handle);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private Entry decode() throws Exception {
        Entry value = this.parseSlot(null);
        if (value == null) {
            throw new IllegalStateException("Error parsing value");
        }
        return value;
    }

    void parseSlots(Entry parent) throws Exception {
        while (true) {
            int ptype;
            if ((ptype = this.next()) == -1) {
                throw new EOFException();
            }
            if (ptype == 2) {
                return;
            }
            if (ptype != 1) {
                throw new IllegalStateException("Expected element start");
            }
            Entry e = this.parseSlot(parent);
            parent.addChild(e);
        }
    }

    Entry parseSlot(Entry parent) throws Exception {
        if (this.type() != 1) {
            throw new IllegalStateException("Expected element start (" + this.type() + ")");
        }
        XElem slotElem = this.elem();
        Entry object = new Entry(parent, slotElem);
        this.parseSlots(object);
        return object;
    }

    private static void dump(Entry e, int indent) {
        for (int i = 0; i < indent; ++i) {
            System.out.print("  ");
        }
        System.out.println(e);
        Entry[] kids = e.getChildren();
        for (int i = 0; i < kids.length; ++i) {
            GenericDecoder.dump(kids[i], indent + 1);
        }
    }

    public static void main(String[] args) {
        try {
            File f = new File(args[0]);
            GenericDecoder decoder = new GenericDecoder(f);
            Entry root = decoder.decodeDocument(true);
            GenericDecoder.dump(root, 0);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }
}

