/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec.securityUtil.alarm;

import javax.baja.alarm.BAlarmClass;
import javax.baja.alarm.BAlarmService;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComponent;
import javax.baja.sys.BStruct;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="id", type="int", defaultValue="UNKNOWN"), @NiagaraProperty(name="alarmClassPath", type="String", defaultValue=""), @NiagaraProperty(name="oldPath", type="String", defaultValue="")})
public class BAlarmClassEvent
extends BStruct {
    public static final int UNKNOWN = -1;
    public static final int ADDED = 0;
    public static final int REMOVED = 1;
    public static final int MODIFIED = 2;
    public static final int RENAMED = 3;
    @Generated
    public static final Property id = BAlarmClassEvent.newProperty((int)0, (int)-1, null);
    @Generated
    public static final Property alarmClassPath = BAlarmClassEvent.newProperty((int)0, (String)"", null);
    @Generated
    public static final Property oldPath = BAlarmClassEvent.newProperty((int)0, (String)"", null);
    @Generated
    public static final Type TYPE = Sys.loadType(BAlarmClassEvent.class);
    private BAlarmClass alarmClass;

    @Generated
    public int getId() {
        return this.getInt(id);
    }

    @Generated
    public void setId(int v) {
        this.setInt(id, v, null);
    }

    @Generated
    public String getAlarmClassPath() {
        return this.getString(alarmClassPath);
    }

    @Generated
    public void setAlarmClassPath(String v) {
        this.setString(alarmClassPath, v, null);
    }

    @Generated
    public String getOldPath() {
        return this.getString(oldPath);
    }

    @Generated
    public void setOldPath(String v) {
        this.setString(oldPath, v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public static BAlarmClassEvent makeAdded(BAlarmClass ac) {
        return new BAlarmClassEvent(0, ac);
    }

    public static BAlarmClassEvent makeRemoved(BAlarmClass alarmClass, String removedPath) {
        return new BAlarmClassEvent(1, alarmClass, removedPath);
    }

    public static BAlarmClassEvent makeModified(BAlarmClass alarmClass) {
        return new BAlarmClassEvent(2, alarmClass);
    }

    public static BAlarmClassEvent makeRenamed(BAlarmClass alarmClass, String oldPath) {
        BAlarmClassEvent e = new BAlarmClassEvent(3, alarmClass);
        e.setOldPath(oldPath);
        return e;
    }

    public BAlarmClassEvent() {
    }

    public BAlarmClassEvent(int id, BAlarmClass alarmClass) {
        this.setId(id);
        this.setAlarmClassPath(BAlarmClassEvent.getAlarmPath(alarmClass, null));
        this.alarmClass = alarmClass;
    }

    public static String getAlarmPath(BAlarmClass alarmClass, String alarmClassName) {
        BAlarmClass o = alarmClass;
        if (alarmClassName == null) {
            alarmClassName = alarmClass.getName();
        }
        StringBuffer path = new StringBuffer(alarmClassName);
        while (!(o.getParent() instanceof BAlarmService)) {
            o = (BComponent)o.getParent();
            path.insert(0, o.getName() + "/");
        }
        return path.toString();
    }

    public BAlarmClassEvent(int id, BAlarmClass alarmClass, String oldName) {
        this.setId(id);
        this.setAlarmClassPath(BAlarmClassEvent.getAlarmPath(alarmClass, oldName));
        this.alarmClass = alarmClass;
    }

    public BAlarmClass getAlarmClass() {
        return this.alarmClass;
    }

    public String toString(Context cx) {
        return BAlarmClassEvent.idToString(this.getId()) + ": " + this.getAlarmClass();
    }

    public static String idToString(int id) {
        switch (id) {
            case 0: {
                return "Added";
            }
            case 1: {
                return "Removed";
            }
            case 2: {
                return "Modified";
            }
            case 3: {
                return "Renamed";
            }
        }
        return "Unknown(" + id + ")";
    }
}

