/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec.securityUtil;

import com.tridium.sys.Nre;
import com.tridiumx.entsec.securityUtil.BActivityRecord;
import com.tridiumx.entsec.securityUtil.BIActivityService;
import com.tridiumx.entsec.securityUtil.BIOutOfOrderHistoryRecord;
import com.tridiumx.entsec.securityUtil.BSecHistorySourceFolder;
import java.util.HashMap;
import javax.baja.data.BIDataValue;
import javax.baja.history.BCapacity;
import javax.baja.history.BHistoryConfig;
import javax.baja.history.BHistoryId;
import javax.baja.history.BHistoryRecord;
import javax.baja.history.BHistoryService;
import javax.baja.history.BIHistory;
import javax.baja.history.BIHistoryRecordSet;
import javax.baja.history.HistoryDeletedException;
import javax.baja.history.HistoryException;
import javax.baja.history.HistoryNotFoundException;
import javax.baja.history.db.BHistoryDatabase;
import javax.baja.history.db.HistoryDatabaseConnection;
import javax.baja.naming.BOrdList;
import javax.baja.naming.SlotPath;
import javax.baja.security.AuditEvent;
import javax.baja.security.Auditor;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.timezone.BTimeZone;
import javax.baja.util.BFolder;
import javax.baja.util.BTypeSpec;
import javax.baja.util.Lexicon;

public class HistoryManager {
    private static final String FOLDER_NAME = "historyConfig";
    private static Lexicon lex = Lexicon.make((String)"history");
    private BIActivityService activityService;
    private BComponent service;
    private BHistoryDatabase db;
    private HistoryDatabaseConnection conn;
    private HashMap<Type, HistoryConverter> converters;
    private HashMap<Type, BIHistory> histories;
    private Type[] historyTypes;

    public HistoryManager(BIActivityService activityService, Type[] historyTypes) {
        this(activityService, historyTypes, null);
    }

    public HistoryManager(BIActivityService activityService, Type[] historyTypes, HistoryConverter[] converterArray) {
        this.activityService = activityService;
        this.service = (BComponent)activityService;
        this.histories = new HashMap();
        this.converters = new HashMap();
        BHistoryService histService = (BHistoryService)Sys.getService((Type)BHistoryService.TYPE);
        this.db = histService.getDatabase();
        this.conn = this.db.getDbConnection(null);
        if (this.service.get(FOLDER_NAME) == null) {
            BSecHistorySourceFolder folder = new BSecHistorySourceFolder();
            this.service.add(FOLDER_NAME, (BValue)folder);
        } else if (!(this.service.get(FOLDER_NAME) instanceof BSecHistorySourceFolder)) {
            BSecHistorySourceFolder newFolder = new BSecHistorySourceFolder();
            BFolder oldFolder = (BFolder)this.service.get(FOLDER_NAME);
            this.service.set(FOLDER_NAME, (BValue)newFolder);
            BHistoryConfig[] configs = (BHistoryConfig[])oldFolder.getChildren(BHistoryConfig.class);
            for (int i = 0; i < configs.length; ++i) {
                String name = configs[i].getName();
                oldFolder.remove(name);
                newFolder.add(name, (BValue)configs[i]);
            }
        }
        String station = Sys.getStation().getStationName();
        for (int i = 0; i < historyTypes.length; ++i) {
            BIHistory history = this.getHistory(this.db, station, historyTypes[i].getTypeName(), historyTypes[i].getTypeSpec());
            this.histories.put(historyTypes[i], history);
            if (converterArray != null) {
                this.converters.put(historyTypes[i], converterArray[i]);
            }
            this.checkConfigAvailability(history);
        }
    }

    private BIHistory getHistory(BHistoryDatabase db, String station, String name, BTypeSpec spec) {
        BHistoryId id = BHistoryId.make((String)station, (String)name);
        try (HistoryDatabaseConnection conn = db.getDbConnection(null);){
            if (!conn.exists(id)) {
                BHistoryConfig cfg = new BHistoryConfig(id, spec);
                cfg.setCapacity(BCapacity.makeByRecordCount((int)2000));
                cfg.setTimeZone(BTimeZone.getLocal());
                conn.createHistory(cfg);
            }
            BIHistory bIHistory = conn.getHistory(id);
            return bIHistory;
        }
    }

    private void checkConfigAvailability(BIHistory history) {
        String historyName = history.getId().getHistoryName();
        BValue historyConfig = this.service.get(FOLDER_NAME).asComponent().get(historyName);
        if (historyConfig == null) {
            this.service.get(FOLDER_NAME).asComponent().add(historyName, (BValue)history.getConfig());
        }
        BHistoryConfig cfg = (BHistoryConfig)this.service.get(FOLDER_NAME).asComponent().get(historyName);
        BHistoryId id = BHistoryId.make((String)Sys.getStation().getStationName(), (String)historyName);
        cfg.setId(id);
        if (!this.conn.exists(id)) {
            this.conn.createHistory(cfg);
        }
        BOrdList ordList = BOrdList.make((String)("station:|" + cfg.getSlotPathOrd()));
        BTimeZone timeZone = BTimeZone.getLocal();
        if (!ordList.equals((Object)cfg.getSource())) {
            cfg.setSource(BOrdList.make((String)("station:|" + cfg.getSlotPathOrd().toString())));
        }
        if (!timeZone.equals((Object)cfg.getTimeZone())) {
            cfg.setTimeZone(BTimeZone.getLocal());
        }
        this.conn.reconfigureHistory(cfg);
    }

    public BHistoryConfig getOrCreateHistoryConfig(BIHistory history) throws HistoryException {
        BHistoryConfig config = null;
        try {
            config = history.getConfig();
        }
        catch (HistoryException e) {
            if (e instanceof HistoryDeletedException || e instanceof HistoryNotFoundException) {
                this.checkConfigAvailability(history);
                config = history.getConfig();
            }
            throw e;
        }
        return config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void append(BHistoryRecord rec) {
        HistoryManager historyManager = this;
        synchronized (historyManager) {
            try (HistoryDatabaseConnection conn = this.db.getDbConnection(null);){
                BActivityRecord a;
                HistoryConverter converter;
                BIHistory history = this.histories.get(rec.getType());
                BHistoryConfig config = this.getOrCreateHistoryConfig(history);
                boolean wasOutOfOrder = this.outOfOrderCheck(history, config, rec, conn);
                conn.append(history, (BIHistoryRecordSet)rec);
                if (config.get("lastTimestamp") == null) {
                    config.add("lastTimestamp", (BValue)conn.getLastTimestamp(history), 3);
                } else {
                    config.set("lastTimestamp", (BValue)conn.getLastTimestamp(history));
                }
                if (this.converters != null && (converter = this.converters.get(rec.getType())) != null && (a = converter.convert(rec)) != null) {
                    this.activityService.fireNewActivity(a);
                }
            }
        }
    }

    public void historyConfigChanged(BHistoryConfig config, Property p) {
        this.conn.reconfigureHistory(config);
    }

    public int getRecordCount(BHistoryId history) {
        BHistoryService histService = (BHistoryService)Sys.getService((Type)BHistoryService.TYPE);
        this.db = histService.getDatabase();
        try (HistoryDatabaseConnection conn = this.db.getDbConnection(null);){
            BIHistory biHistory = conn.getHistory(history);
            if (conn.exists(history)) {
                int n = conn.getRecordCount(biHistory);
                return n;
            }
            int n = 0;
            return n;
        }
    }

    protected boolean outOfOrderCheck(BIHistory history, BHistoryConfig config, BHistoryRecord rec, HistoryDatabaseConnection conn) {
        block6: {
            if (!(rec instanceof BIOutOfOrderHistoryRecord)) {
                return false;
            }
            try {
                BAbsTime lastTimestamp = conn.getLastTimestamp(history);
                BAbsTime recTimestamp = rec.getTimestamp();
                if (lastTimestamp == null || lastTimestamp.isNull() || !recTimestamp.isBefore(lastTimestamp)) break block6;
                StringBuffer sb = new StringBuffer();
                Property property = ((BIOutOfOrderHistoryRecord)rec).getOutOfOrderStringProperty();
                BAbsTime compareTime = recTimestamp.add(BRelTime.makeSeconds((int)2));
                if (property == null || !compareTime.isBefore(lastTimestamp)) {
                    rec.setTimestamp(lastTimestamp);
                    return true;
                }
                String outOfOrderPropertyValue = rec.get(property).toString();
                sb.append(outOfOrderPropertyValue).append(" ");
                BFacets facets = null;
                try {
                    facets = (BFacets)config.get("timestampFacets");
                    BTimeZone timeZone = config.getTimeZone();
                    facets = facets != null ? BFacets.make((BFacets)facets, (String)"TimeZone", (BIDataValue)timeZone) : BFacets.make((String)"TimeZone", (BIDataValue)timeZone);
                    facets = BFacets.make((BFacets)facets, (String)"showSeconds", (BIDataValue)BBoolean.TRUE);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                sb.append(lex.getText("log.append.outOfOrder", new Object[]{recTimestamp.toString((Context)facets)}));
                rec.set(property, (BValue)BString.make((String)sb.toString()));
                rec.setTimestamp(lastTimestamp);
                return true;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return false;
    }

    public static void appendAuditRecord(String operation, SlotPath targetPath, String slotName, String oldValue, String newValue, String username) {
        String path = targetPath.toString();
        if (targetPath.getScheme().equals("slot")) {
            path = targetPath.getBody();
        }
        AuditEvent event = new AuditEvent(operation, path, slotName, oldValue, newValue, username);
        Auditor auditor = Nre.auditor;
        if (auditor != null) {
            auditor.audit(event);
        }
    }

    public static class HistoryConverter {
        public BActivityRecord convert(BHistoryRecord record) {
            return null;
        }
    }
}

