/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec.orionTools.history;

import com.tridium.fox.sys.BFoxChannelRegistry;
import com.tridium.orion.BIOrionApp;
import com.tridium.orion.BIOrionObject;
import com.tridium.orion.BOrionTypeId;
import com.tridium.orion.OrionCursor;
import com.tridium.orion.OrionSession;
import com.tridium.orion.OrionType;
import com.tridium.orion.priv.model.BDynamicOrionObject;
import com.tridium.orion.sql.BSqlQuery;
import com.tridium.orion.sql.PropertyValue;
import com.tridium.orion.sql.SqlColumns;
import com.tridiumx.entsec.BEnterpriseSecurityService;
import com.tridiumx.entsec.orionTools.BAppTable;
import com.tridiumx.entsec.orionTools.history.BAuditOrionRec;
import com.tridiumx.entsec.orionTools.history.BOrionHistoryChannel;
import com.tridiumx.entsec.orionTools.history.BOrionHistoryRecord;
import com.tridiumx.entsec.orionTools.history.BOrionHistoryWorker;
import java.io.Serializable;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.control.trigger.BDailyTriggerMode;
import javax.baja.control.trigger.BTimeTrigger;
import javax.baja.control.trigger.BTriggerMode;
import javax.baja.data.BIDataValue;
import javax.baja.history.BHistoryEvent;
import javax.baja.history.BHistoryId;
import javax.baja.history.BHistoryRecord;
import javax.baja.history.BHistoryService;
import javax.baja.history.BIHistory;
import javax.baja.history.HistoryEventListener;
import javax.baja.history.db.BHistoryDatabase;
import javax.baja.history.db.HistoryDatabaseConnection;
import javax.baja.naming.BLocalHost;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.query.BExpression;
import javax.baja.query.BProjectionColumn;
import javax.baja.query.BQuery;
import javax.baja.query.util.Funcs;
import javax.baja.query.util.Predicates;
import javax.baja.status.BIStatus;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BLink;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BSimple;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Cursor;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;
import javax.baja.util.ICoalesceable;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;
import javax.baja.util.PatternFilter;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="consolidatorStatus", type="BStatus", defaultValue="BStatus.ok", flags=3), @NiagaraProperty(name="icon", type="BIcon", defaultValue="BIcon.make(BIcon.std(\"history.png\"), BIcon.std(\"badges/shortcut.png\"))", flags=4, override=true), @NiagaraProperty(name="rowType", type="BOrionTypeId", defaultValue="BAuditOrionRec.ORION_TYPE.getOrionTypeId()", flags=5, override=true), @NiagaraProperty(name="enabled", type="boolean", defaultValue="false"), @NiagaraProperty(name="historyRecordType", type="BTypeSpec", defaultValue="BTypeSpec.make(\"history:AuditRecord\")", facets={@Facet(value="BFacets.make(BFacets.TARGET_TYPE, BString.make(\"history:HistoryRecord\"))")}), @NiagaraProperty(name="devicePattern", type="String", defaultValue="*"), @NiagaraProperty(name="historyNamePattern", type="String", defaultValue="*"), @NiagaraProperty(name="includeLocalHistories", type="boolean", defaultValue="true"), @NiagaraProperty(name="includeRemoteHistoryExports", type="boolean", defaultValue="true"), @NiagaraProperty(name="dataExpiration", type="BRelTime", defaultValue="BRelTime.makeHours(8760)", facets={@Facet(value="BFacets.make(BRelTimeFE.SHOW_DAY, BBoolean.TRUE, BFacets.MIN, BRelTime.make(0L))")}), @NiagaraProperty(name="autoPurge", type="BTimeTrigger", defaultValue="new BTimeTrigger(BDailyTriggerMode.make())"), @NiagaraProperty(name="minLocalConsolidateTime", type="BRelTime", defaultValue="BRelTime.make(5000L)", facets={@Facet(value="BFacets.make(BFacets.MIN,BRelTime.make(0))")}), @NiagaraProperty(name="lastSuccess", type="BAbsTime", defaultValue="BAbsTime.NULL", flags=1), @NiagaraProperty(name="lastFailure", type="BAbsTime", defaultValue="BAbsTime.NULL", flags=1), @NiagaraProperty(name="lastFaultCause", type="String", defaultValue="", flags=3), @NiagaraProperty(name="worker", type="BOrionHistoryWorker", defaultValue="new BOrionHistoryWorker()", flags=4)})
@NiagaraAction(name="purgeExpiredData", flags=144)
public class BOrionHistoryConsolidator
extends BAppTable
implements HistoryEventListener,
Runnable,
BIStatus {
    @Generated
    public static final Property consolidatorStatus = BOrionHistoryConsolidator.newProperty((int)3, (BValue)BStatus.ok, null);
    @Generated
    public static final Property icon = BOrionHistoryConsolidator.newProperty((int)4, (BValue)BIcon.make((BIcon)BIcon.std((String)"history.png"), (BIcon)BIcon.std((String)"badges/shortcut.png")), null);
    @Generated
    public static final Property rowType = BOrionHistoryConsolidator.newProperty((int)5, (BValue)BAuditOrionRec.ORION_TYPE.getOrionTypeId(), null);
    @Generated
    public static final Property enabled = BOrionHistoryConsolidator.newProperty((int)0, (boolean)false, null);
    @Generated
    public static final Property historyRecordType = BOrionHistoryConsolidator.newProperty((int)0, (BValue)BTypeSpec.make((String)"history:AuditRecord"), (BFacets)BFacets.make((String)"targetType", (BIDataValue)BString.make((String)"history:HistoryRecord")));
    @Generated
    public static final Property devicePattern = BOrionHistoryConsolidator.newProperty((int)0, (String)"*", null);
    @Generated
    public static final Property historyNamePattern = BOrionHistoryConsolidator.newProperty((int)0, (String)"*", null);
    @Generated
    public static final Property includeLocalHistories = BOrionHistoryConsolidator.newProperty((int)0, (boolean)true, null);
    @Generated
    public static final Property includeRemoteHistoryExports = BOrionHistoryConsolidator.newProperty((int)0, (boolean)true, null);
    @Generated
    public static final Property dataExpiration = BOrionHistoryConsolidator.newProperty((int)0, (BValue)BRelTime.makeHours((int)8760), (BFacets)BFacets.make((String)"showDay", (BIDataValue)BBoolean.TRUE, (String)"min", (BIDataValue)BRelTime.make((long)0L)));
    @Generated
    public static final Property autoPurge = BOrionHistoryConsolidator.newProperty((int)0, (BValue)new BTimeTrigger((BTriggerMode)BDailyTriggerMode.make()), null);
    @Generated
    public static final Property minLocalConsolidateTime = BOrionHistoryConsolidator.newProperty((int)0, (BValue)BRelTime.make((long)5000L), (BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.make((long)0L)));
    @Generated
    public static final Property lastSuccess = BOrionHistoryConsolidator.newProperty((int)1, (BValue)BAbsTime.NULL, null);
    @Generated
    public static final Property lastFailure = BOrionHistoryConsolidator.newProperty((int)1, (BValue)BAbsTime.NULL, null);
    @Generated
    public static final Property lastFaultCause = BOrionHistoryConsolidator.newProperty((int)3, (String)"", null);
    @Generated
    public static final Property worker = BOrionHistoryConsolidator.newProperty((int)4, (BValue)new BOrionHistoryWorker(), null);
    @Generated
    public static final Action purgeExpiredData = BOrionHistoryConsolidator.newAction((int)144, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BOrionHistoryConsolidator.class);
    private PatternFilter[] dp = null;
    private PatternFilter[] np = null;
    private int oldStatus = 16;
    private HashMap<BHistoryId, BAbsTime> lastTimestampCache = new HashMap();
    private HashMap<BHistoryId, BOrionHistoryRecord[]> lastExportsCache = new HashMap();
    private long lastLocalUpdateTicks = -1L;
    private Object lock = new Object();
    private static Array<BOrionHistoryConsolidator> consolidators = new Array(BOrionHistoryConsolidator.class);
    private static final Logger LOG = Logger.getLogger("orionHistory.consolidation");
    static long WAIT_TICKS = 202L;
    static BRelTime BUF_TIME = BRelTime.make((long)101L);
    static int MAX_EXPORT_CACHE_SIZE = Integer.getInteger("niagara.orionHistoryConsolidator.lastExportCache.maxEntrySize", 10);

    @Generated
    public BStatus getConsolidatorStatus() {
        return (BStatus)this.get(consolidatorStatus);
    }

    @Generated
    public void setConsolidatorStatus(BStatus v) {
        this.set(consolidatorStatus, (BValue)v, null);
    }

    @Generated
    public boolean getEnabled() {
        return this.getBoolean(enabled);
    }

    @Generated
    public void setEnabled(boolean v) {
        this.setBoolean(enabled, v, null);
    }

    @Generated
    public BTypeSpec getHistoryRecordType() {
        return (BTypeSpec)this.get(historyRecordType);
    }

    @Generated
    public void setHistoryRecordType(BTypeSpec v) {
        this.set(historyRecordType, (BValue)v, null);
    }

    @Generated
    public String getDevicePattern() {
        return this.getString(devicePattern);
    }

    @Generated
    public void setDevicePattern(String v) {
        this.setString(devicePattern, v, null);
    }

    @Generated
    public String getHistoryNamePattern() {
        return this.getString(historyNamePattern);
    }

    @Generated
    public void setHistoryNamePattern(String v) {
        this.setString(historyNamePattern, v, null);
    }

    @Generated
    public boolean getIncludeLocalHistories() {
        return this.getBoolean(includeLocalHistories);
    }

    @Generated
    public void setIncludeLocalHistories(boolean v) {
        this.setBoolean(includeLocalHistories, v, null);
    }

    @Generated
    public boolean getIncludeRemoteHistoryExports() {
        return this.getBoolean(includeRemoteHistoryExports);
    }

    @Generated
    public void setIncludeRemoteHistoryExports(boolean v) {
        this.setBoolean(includeRemoteHistoryExports, v, null);
    }

    @Generated
    public BRelTime getDataExpiration() {
        return (BRelTime)this.get(dataExpiration);
    }

    @Generated
    public void setDataExpiration(BRelTime v) {
        this.set(dataExpiration, (BValue)v, null);
    }

    @Generated
    public BTimeTrigger getAutoPurge() {
        return (BTimeTrigger)this.get(autoPurge);
    }

    @Generated
    public void setAutoPurge(BTimeTrigger v) {
        this.set(autoPurge, (BValue)v, null);
    }

    @Generated
    public BRelTime getMinLocalConsolidateTime() {
        return (BRelTime)this.get(minLocalConsolidateTime);
    }

    @Generated
    public void setMinLocalConsolidateTime(BRelTime v) {
        this.set(minLocalConsolidateTime, (BValue)v, null);
    }

    @Generated
    public BAbsTime getLastSuccess() {
        return (BAbsTime)this.get(lastSuccess);
    }

    @Generated
    public void setLastSuccess(BAbsTime v) {
        this.set(lastSuccess, (BValue)v, null);
    }

    @Generated
    public BAbsTime getLastFailure() {
        return (BAbsTime)this.get(lastFailure);
    }

    @Generated
    public void setLastFailure(BAbsTime v) {
        this.set(lastFailure, (BValue)v, null);
    }

    @Generated
    public String getLastFaultCause() {
        return this.getString(lastFaultCause);
    }

    @Generated
    public void setLastFaultCause(String v) {
        this.setString(lastFaultCause, v, null);
    }

    @Generated
    public BOrionHistoryWorker getWorker() {
        return (BOrionHistoryWorker)this.get(worker);
    }

    @Generated
    public void setWorker(BOrionHistoryWorker v) {
        this.set(worker, (BValue)v, null);
    }

    @Generated
    public void purgeExpiredData() {
        this.invoke(purgeExpiredData, null, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public static final BOrionHistoryConsolidator getConsolidator(BHistoryId id, BTypeSpec recType, boolean create, Context cx) {
        BOrionHistoryConsolidator[] cache = (BOrionHistoryConsolidator[])consolidators.array();
        if (cache != null) {
            for (int i = 0; i < cache.length; ++i) {
                try {
                    if (cache[i].getIncludeRemoteHistoryExports() && cache[i].isMatch(id, recType)) {
                        return cache[i];
                    }
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (create) {
            BHistoryRecord rec = (BHistoryRecord)recType.getInstance();
            BEnterpriseSecurityService app = BOrionHistoryConsolidator.getSecurityUtilService(cx);
            if (app != null) {
                BOrionHistoryConsolidator consolidator = new BOrionHistoryConsolidator();
                consolidator.setHistoryNamePattern(id.getHistoryName());
                consolidator.setEnabled(true);
                consolidator.setIncludeLocalHistories(false);
                consolidator.setHistoryRecordType((BTypeSpec)rec.newCopy());
                consolidator.setRowType(BOrionTypeId.make((Type)BOrionHistoryRecord.make(id, rec).getType()));
                app.add(id.getHistoryName() + "?", (BValue)consolidator, cx);
            }
        }
        return null;
    }

    static BEnterpriseSecurityService getSecurityUtilService(Context cx) {
        BOrd serviceOrd = BOrd.make((String)"service:entsec:EnterpriseSecurityService");
        return (BEnterpriseSecurityService)serviceOrd.get((BObject)BLocalHost.INSTANCE, cx);
    }

    public boolean isMatch(BHistoryId id, BTypeSpec recType) {
        if (this.isUnoperational()) {
            return false;
        }
        if (this.dp == null) {
            this.dp = PatternFilter.parseList((String)this.getDevicePattern());
        }
        if (this.np == null) {
            this.np = PatternFilter.parseList((String)this.getHistoryNamePattern());
        }
        try {
            return this.getHistoryRecordType().equals((Object)recType) && BOrionHistoryConsolidator.accept(this.dp, id.getDeviceName()) && BOrionHistoryConsolidator.accept(this.np, id.getHistoryName());
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    static boolean accept(PatternFilter[] patterns, String name) {
        for (int i = 0; i < patterns.length; ++i) {
            if (!patterns[i].accept(name)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BAbsTime readLastTimestamp(BHistoryId id, BHistoryRecord rec, Context cx) {
        HashMap<BHistoryId, BAbsTime> hashMap = this.lastTimestampCache;
        synchronized (hashMap) {
            BAbsTime cachedTimestamp = this.lastTimestampCache.get(id);
            if (cachedTimestamp != null) {
                return cachedTimestamp;
            }
        }
        OrionSession session = null;
        try {
            session = this.getOrionDatabase().createSession(cx);
            BAbsTime bAbsTime = this.readLastTimestamp(session, id, rec);
            return bAbsTime;
        }
        finally {
            if (session != null) {
                session.close();
                session = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BAbsTime readLastTimestamp(OrionSession session, BHistoryId id, BHistoryRecord rec) {
        block23: {
            try {
                BOrionHistoryRecord instance;
                HashMap<BHistoryId, BAbsTime> hashMap = this.lastTimestampCache;
                synchronized (hashMap) {
                    BAbsTime cachedTimestamp = this.lastTimestampCache.get(id);
                    if (cachedTimestamp != null) {
                        return cachedTimestamp;
                    }
                }
                if (rec == null) {
                    BHistoryService service = (BHistoryService)Sys.getService((Type)BHistoryService.TYPE);
                    BHistoryDatabase db = service.getDatabase();
                    try (HistoryDatabaseConnection conn = db.getDbConnection(null);){
                        BIHistory history = conn.getHistory(id);
                        rec = (BHistoryRecord)history.getRecordType().getInstance();
                    }
                }
                if ((instance = BOrionHistoryRecord.make(id, rec)) == null) break block23;
                OrionType consolidatedType = (OrionType)instance.getType();
                String consolidatedTable = BAppTable.getTableName(consolidatedType);
                BSqlQuery q = BSqlQuery.make((OrionType)consolidatedType);
                q.select(SqlColumns.projection((BProjectionColumn)SqlColumns.make((BExpression)Funcs.make((String)"MAX", (Type)BAbsTime.TYPE, (String)"timestamp"))));
                q.where(this.getLastTimestampPredicate(id, consolidatedType));
                OrionCursor c = session.select((BQuery)q);
                c.next();
                BDynamicOrionObject result = (BDynamicOrionObject)c.get();
                OrionType type = result.getOrionType();
                Property[] dps = type.getProperties();
                BAbsTime lastTimestamp = (BAbsTime)result.get(dps[0]);
                HashMap<BHistoryId, BAbsTime> hashMap2 = this.lastTimestampCache;
                synchronized (hashMap2) {
                    this.lastTimestampCache.put(id, lastTimestamp);
                }
                return lastTimestamp;
            }
            catch (Exception e) {
                if (!LOG.isLoggable(Level.FINE)) break block23;
                LOG.log(Level.FINE, "Failed to read last timestamp for " + id, e);
            }
        }
        return BAbsTime.NULL;
    }

    protected BExpression getLastTimestampPredicate(BHistoryId id, OrionType consolidatedType) {
        return Predicates.and((BExpression)Predicates.eq((String)"stationName", (BSimple)BString.make((String)id.getDeviceName())), (BExpression)Predicates.eq((String)"historyName", (BSimple)BString.make((String)id.getHistoryName())));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void appendOrionRecords(BHistoryId id, Cursor<?> records, Context cx) throws Exception {
        OrionSession session = null;
        try {
            session = this.getOrionDatabase().createSession(cx);
            this.appendOrionRecords(session, id, records);
        }
        finally {
            if (session != null) {
                session.close();
                session = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void appendOrionRecords(OrionSession session, BHistoryId id, Cursor<?> records) throws Exception {
        if (!records.next()) {
            return;
        }
        BHistoryRecord rec = (BHistoryRecord)records.get();
        BAbsTime lastTimestamp = null;
        Array lastRecs = new Array(BOrionHistoryRecord.class);
        Object[] last = this.getLastExports(session, id, rec);
        if (last != null && last.length > 0) {
            lastRecs.addAll(last);
            lastTimestamp = ((BOrionHistoryRecord)last[0]).getTimestamp();
        }
        try {
            do {
                Serializable cRec;
                if ((cRec = BOrionHistoryRecord.make(id, rec = (BHistoryRecord)records.get())) == null) {
                    throw new BajaRuntimeException("Could not find matching Orion history record for " + rec.getType());
                }
                session.insert((BIOrionObject)cRec);
                BAbsTime tStamp = cRec.getTimestamp();
                if (lastTimestamp == null || lastTimestamp.isBefore(tStamp)) {
                    lastTimestamp = tStamp;
                    lastRecs.clear();
                    lastRecs.add((Object)cRec);
                    continue;
                }
                if (!lastTimestamp.equals((Object)tStamp)) continue;
                lastRecs.add((Object)cRec);
            } while (records.next());
            this.setLastSuccess(BAbsTime.now());
        }
        catch (Exception e) {
            this.setLastFailure(BAbsTime.now());
            this.setLastFaultCause(e.toString());
            throw e;
        }
        finally {
            if (lastTimestamp != null) {
                HashMap<BHistoryId, BOrionHistoryRecord[]> hashMap = this.lastExportsCache;
                synchronized (hashMap) {
                    if (lastRecs.size() <= MAX_EXPORT_CACHE_SIZE) {
                        this.lastExportsCache.put(id, (BOrionHistoryRecord[])lastRecs.trim());
                    } else {
                        this.lastExportsCache.put(id, null);
                    }
                }
                hashMap = this.lastTimestampCache;
                synchronized (hashMap) {
                    BAbsTime cachedTimestamp = this.lastTimestampCache.get(id);
                    if (cachedTimestamp == null || cachedTimestamp.isBefore(lastTimestamp)) {
                        this.lastTimestampCache.put(id, lastTimestamp);
                    }
                }
            }
            this.updateStatus();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BOrionHistoryRecord[] getLastExports(BHistoryId id, BHistoryRecord rec, Context cx) {
        HashMap<BHistoryId, BOrionHistoryRecord[]> hashMap = this.lastExportsCache;
        synchronized (hashMap) {
            BOrionHistoryRecord[] cachedRecs = this.lastExportsCache.get(id);
            if (cachedRecs != null) {
                return cachedRecs;
            }
        }
        OrionSession session = null;
        try {
            session = this.getOrionDatabase().createSession(cx);
            BOrionHistoryRecord[] bOrionHistoryRecordArray = this.getLastExports(session, id, rec);
            return bOrionHistoryRecordArray;
        }
        finally {
            if (session != null) {
                session.close();
                session = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BOrionHistoryRecord[] getLastExports(OrionSession session, BHistoryId id, BHistoryRecord rec) {
        BOrionHistoryRecord instance;
        HashMap<BHistoryId, BOrionHistoryRecord[]> hashMap = this.lastExportsCache;
        synchronized (hashMap) {
            BOrionHistoryRecord[] cachedRecs = this.lastExportsCache.get(id);
            if (cachedRecs != null) {
                return cachedRecs;
            }
        }
        if (rec == null) {
            BHistoryService service = (BHistoryService)Sys.getService((Type)BHistoryService.TYPE);
            BHistoryDatabase db = service.getDatabase();
            try (HistoryDatabaseConnection conn = db.getDbConnection(null);){
                BIHistory history = conn.getHistory(id);
                rec = (BHistoryRecord)history.getRecordType().getInstance();
            }
        }
        if ((instance = BOrionHistoryRecord.make(id, rec)) == null) {
            return new BOrionHistoryRecord[0];
        }
        OrionType consolidatedType = (OrionType)instance.getType();
        BAbsTime lastT = this.readLastTimestamp(session, id, rec);
        PropertyValue[] propVals = new PropertyValue[]{new PropertyValue(BOrionHistoryRecord.timestamp, (BValue)lastT), new PropertyValue(BOrionHistoryRecord.stationName, (BValue)BString.make((String)id.getDeviceName())), new PropertyValue(BOrionHistoryRecord.historyName, (BValue)BString.make((String)id.getHistoryName()))};
        BOrionHistoryRecord[] lastRecs = (BOrionHistoryRecord[])session.select(consolidatedType, propVals).toArray();
        if (lastRecs == null) {
            lastRecs = new BOrionHistoryRecord[]{};
        }
        HashMap<BHistoryId, BOrionHistoryRecord[]> hashMap2 = this.lastExportsCache;
        synchronized (hashMap2) {
            if (lastRecs.length <= MAX_EXPORT_CACHE_SIZE) {
                this.lastExportsCache.put(id, lastRecs);
            } else {
                this.lastExportsCache.put(id, null);
            }
        }
        return lastRecs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void started() {
        this.setCoalesce(false);
        Array<BOrionHistoryConsolidator> array = consolidators;
        synchronized (array) {
            consolidators.add((Object)this);
        }
        this.updateRowType();
        BComplex app = this.findParentOrionApp();
        if (app instanceof BIOrionApp) {
            this.setAppOrd(BOrd.make((String)("service:" + app.getType().getTypeSpec())));
        } else {
            this.setAppOrd(BOrd.make((String)("service:" + BEnterpriseSecurityService.TYPE.getTypeSpec())));
        }
        BOrionHistoryChannel channel = (BOrionHistoryChannel)BFoxChannelRegistry.getPrototype().get("orionHistory");
        if (channel == null) {
            try {
                BFoxChannelRegistry.getPrototype().add("orionHistory", (BValue)new BOrionHistoryChannel());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.updateHistoryEventRegistration(false);
        this.add(null, (BValue)new BLink(this.getAutoPurge().getOrdInSession(), BTimeTrigger.fireTrigger.getName(), purgeExpiredData.getName(), true), 6);
    }

    public void stationStarted() throws Exception {
        this.updateHistoryEventRegistration(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopped() throws Exception {
        Array<BOrionHistoryConsolidator> array = consolidators;
        synchronized (array) {
            consolidators.remove((Object)this);
        }
        this.updateHistoryEventRegistration(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changed(Property p, Context c) {
        if (p == devicePattern) {
            this.dp = null;
        }
        if (p == historyNamePattern) {
            this.np = null;
        }
        if (!this.isRunning()) {
            return;
        }
        if (p == historyRecordType) {
            this.updateRowType();
        }
        if (p == enabled) {
            this.updateStatus();
        } else if (p == consolidatorStatus || p == includeLocalHistories || p == historyRecordType || p == devicePattern || p == historyNamePattern) {
            this.updateHistoryEventRegistration(false);
        } else if (p == autoPurge) {
            this.add(null, (BValue)new BLink(this.getAutoPurge().getOrdInSession(), BTimeTrigger.fireTrigger.getName(), purgeExpiredData.getName(), true), 6);
        } else if (p == minLocalConsolidateTime) {
            Object object = this.lock;
            synchronized (object) {
                this.lock.notify();
            }
        }
    }

    public IFuture post(Action action, BValue argument, Context cx) {
        this.getWorker().postAsync((Runnable)new Invocation((BComponent)this, action, argument, cx));
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateHistoryEventRegistration(boolean forceUnregister) {
        try {
            BHistoryService service = (BHistoryService)Sys.getService((Type)BHistoryService.TYPE);
            BHistoryDatabase db = service.getDatabase();
            if (!forceUnregister && !this.isUnoperational() && this.getIncludeLocalHistories()) {
                db.addHistoryEventListener((HistoryEventListener)this);
                if (Sys.isStationStarted()) {
                    this.getWorker().postAsync(this);
                }
            } else {
                db.removeHistoryEventListener((HistoryEventListener)this);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.updateStatus();
        }
    }

    protected void updateRowType() {
        try {
            this.setRowType(BOrionTypeId.make((Type)BOrionHistoryRecord.make(null, (BHistoryRecord)this.getHistoryRecordType().getInstance()).getType()));
        }
        catch (Exception e) {
            this.setRowType(BOrionTypeId.NULL);
            this.setLastFailure(BAbsTime.now());
            StringBuffer sb = new StringBuffer();
            sb.append("Cannot determine Orion History Record Type for ");
            sb.append(this.getHistoryRecordType().toString()).append(", ");
            sb.append(e.toString());
            this.setLastFaultCause(sb.toString());
        }
    }

    private BComplex findParentOrionApp() {
        for (BComplex parent = this.getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof BIOrionApp)) continue;
            return parent;
        }
        return null;
    }

    @Override
    public void run() {
        BHistoryService service = (BHistoryService)Sys.getService((Type)BHistoryService.TYPE);
        BHistoryDatabase db = service.getDatabase();
        BIHistory[] histories = db.getHistories();
        for (int i = 0; i < histories.length; ++i) {
            BTypeSpec recType;
            BHistoryId id = histories[i].getId();
            if (!this.isMatch(id, recType = histories[i].getRecordType())) continue;
            BHistoryRecord rec = (BHistoryRecord)recType.getInstance();
            this.getWorker().postAsync(new HistoryUpdate(this, id, rec));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doPurgeExpiredData(Context cx) {
        BRelTime duration = this.getDataExpiration();
        if (duration.getMillis() <= 0L) {
            return;
        }
        BAbsTime purgeTime = BAbsTime.now().subtract(duration);
        OrionSession session = null;
        try {
            session = this.getOrionDatabase().createSession(cx);
            session.delete((OrionType)this.getRowType().getTypeSpec().getResolvedType(), this.getPurgeCondition(purgeTime));
        }
        catch (Exception e) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "Failed to purge expired data for " + this.getName(), e);
            }
        }
        finally {
            if (session != null) {
                session.close();
                session = null;
            }
        }
    }

    protected BExpression getPurgeCondition(BAbsTime purgeTime) {
        BOrionHistoryRecord rec = (BOrionHistoryRecord)this.getRowType().getTypeSpec().getInstance();
        return Predicates.le((Property)rec.timestampProperty(), (BSimple)purgeTime);
    }

    public BStatus getStatus() {
        return this.getConsolidatorStatus();
    }

    protected boolean validRowType() {
        return !this.getRowType().equals((Object)BOrionTypeId.NULL);
    }

    public boolean isUnoperational() {
        return this.isDisabled() || this.isDown() || !this.validRowType();
    }

    public final boolean isDown() {
        return this.getConsolidatorStatus().isDown();
    }

    public final boolean isFault() {
        return this.getConsolidatorStatus().isFault();
    }

    public final boolean isDisabled() {
        return this.getConsolidatorStatus().isDisabled();
    }

    final void updateStatus() {
        BStatus devStatus;
        BEnterpriseSecurityService app = null;
        try {
            app = (BIStatus)this.getAppOrd().get(this.getResolveBase());
        }
        catch (Throwable t) {
            try {
                app = BOrionHistoryConsolidator.getSecurityUtilService(null);
            }
            catch (Throwable t2) {
                app = null;
                this.setLastFailure(BAbsTime.now());
                StringBuffer sb = new StringBuffer();
                sb.append("Cannot find OrionApp, ");
                sb.append(t.toString());
                sb.append(", ").append(t2.toString());
                this.setLastFaultCause(sb.toString());
            }
        }
        int newStatus = this.getConsolidatorStatus().getBits();
        BStatus bStatus = devStatus = app == null ? BStatus.fault : app.getStatus();
        newStatus = !this.getEnabled() || devStatus.isDisabled() ? (newStatus |= 1) : (newStatus &= 0xFFFFFFFE);
        newStatus = devStatus.isDown() ? (newStatus |= 4) : (newStatus &= 0xFFFFFFFB);
        newStatus = !this.validRowType() || devStatus.isFault() ? (newStatus |= 2) : (newStatus &= 0xFFFFFFFD);
        if (newStatus == this.oldStatus) {
            return;
        }
        this.setConsolidatorStatus(BStatus.make((int)newStatus));
        this.oldStatus = newStatus;
    }

    public void historyEvent(BHistoryEvent event) {
        if (event.getId() == 2 && this.isMatch(event.getHistoryId(), event.getRecordSet().getLastRecord().getType().getTypeSpec())) {
            this.getWorker().postAsync(new HistoryUpdate(this, event.getHistoryId(), event.getRecordSet().getLastRecord()));
        }
    }

    public boolean isSubReport() {
        return this.getParent() != null && this.getParent() instanceof BOrionHistoryConsolidator;
    }

    static class HistoryUpdate
    implements ICoalesceable,
    Runnable {
        BOrionHistoryConsolidator consolidator;
        BHistoryId id;
        BHistoryRecord rec;

        HistoryUpdate(BOrionHistoryConsolidator consolidator, BHistoryId id, BHistoryRecord rec) {
            this.consolidator = consolidator;
            this.id = id;
            this.rec = rec;
        }

        public Object getCoalesceKey() {
            return this.id;
        }

        public ICoalesceable coalesce(ICoalesceable c) {
            return c;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            BAbsTime endTime = BAbsTime.now().add(BUF_TIME);
            long startTicks = Clock.ticks();
            OrionSession session = null;
            try {
                Object object = this.consolidator.lock;
                synchronized (object) {
                    long now = Clock.ticks();
                    long minWrite = this.consolidator.getMinLocalConsolidateTime().getMillis();
                    long elapsedTicks = now - this.consolidator.lastLocalUpdateTicks;
                    while (minWrite > 0L && this.consolidator.lastLocalUpdateTicks > 0L && elapsedTicks < minWrite) {
                        long waitTime = minWrite - elapsedTicks;
                        if (waitTime < 100L) {
                            waitTime = 100L;
                        }
                        this.consolidator.lock.wait(waitTime);
                        now = Clock.ticks();
                        minWrite = this.consolidator.getMinLocalConsolidateTime().getMillis();
                        elapsedTicks = now - this.consolidator.lastLocalUpdateTicks;
                    }
                    this.consolidator.lastLocalUpdateTicks = Clock.ticks();
                }
                BHistoryService service = (BHistoryService)Sys.getService((Type)BHistoryService.TYPE);
                BHistoryDatabase db = service.getDatabase();
                session = this.consolidator.getOrionDatabase().createSession(null);
                Object startTime = this.consolidator.readLastTimestamp(session, this.id, this.rec);
                startTime = startTime.isNull() ? null : startTime.add(BRelTime.make((long)1L));
                long sleepTime = WAIT_TICKS - (Clock.ticks() - startTicks);
                if (sleepTime > 0L) {
                    Thread.sleep(sleepTime);
                }
                try (HistoryDatabaseConnection conn = db.getDbConnection(null);){
                    BIHistory history = conn.getHistory(this.id);
                    this.consolidator.appendOrionRecords(session, this.id, (Cursor<?>)conn.timeQuery(history, startTime, endTime).cursor());
                }
            }
            catch (Exception e) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.log(Level.FINE, "Failed to append records for " + this.id, e);
                }
            }
            finally {
                if (session != null) {
                    session.close();
                    session = null;
                }
            }
        }
    }
}

