/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec.orionTools;

import com.tridium.orion.BIOrionApp;
import com.tridium.orion.BLocalOrionDatabase;
import com.tridium.orion.BOrionDatabase;
import com.tridium.orion.BRef;
import com.tridium.orion.BTypeDependency;
import com.tridium.orion.OrionException;
import com.tridium.orion.OrionSession;
import com.tridium.orion.OrionType;
import com.tridium.orion.priv.db.DbOrionSession;
import com.tridium.orion.sql.TableBuilder;
import com.tridium.rdb.jdbc.RdbmsDialect;
import com.tridiumx.entsec.BEnterpriseSecurityService;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.HashSet;
import java.util.logging.Level;
import javax.baja.nre.util.Array;
import javax.baja.rdb.RdbmsContext;
import javax.baja.rdb.ddl.AddColumn;
import javax.baja.rdb.ddl.AddConstraint;
import javax.baja.rdb.ddl.AlterColumn;
import javax.baja.rdb.ddl.Column;
import javax.baja.rdb.ddl.Constraint;
import javax.baja.rdb.ddl.CreateIndex;
import javax.baja.rdb.ddl.CreateTable;
import javax.baja.rdb.ddl.DdlCommand;
import javax.baja.rdb.ddl.DropColumn;
import javax.baja.rdb.ddl.DropConstraint;
import javax.baja.rdb.ddl.DropIndex;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BInteger;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;
import javax.baja.util.BUuid;

public abstract class SchemaUpgradeSupport {
    private static HashSet<String> skipList;

    public static CreateIndex createIndexForSingleColumn(OrionType orionType, Property property, BLocalOrionDatabase db) {
        TableBuilder tb = new TableBuilder((BOrionDatabase)db, orionType);
        DdlCommand[] ddl = tb.createTable();
        for (int i = 0; i < ddl.length; ++i) {
            CreateIndex index;
            CreateIndex.Column[] columns;
            if (!(ddl[i] instanceof CreateIndex) || (columns = (index = (CreateIndex)ddl[i]).getColumns()).length != 1 || !columns[0].getName().equals(property.getName())) continue;
            return index;
        }
        return null;
    }

    public static CreateIndex createIndexForMultipleColumns(OrionType orionType, Property property, BOrionDatabase db) {
        TableBuilder tb = new TableBuilder(db, orionType);
        DdlCommand[] ddl = tb.createTable();
        for (int i = 0; i < ddl.length; ++i) {
            CreateIndex index;
            CreateIndex.Column[] columns;
            if (!(ddl[i] instanceof CreateIndex) || !(columns = (index = (CreateIndex)ddl[i]).getColumns())[0].getName().equals(property.getName())) continue;
            return index;
        }
        return null;
    }

    public static AddColumn addColumnAsLastProperty(OrionType orionType, Property property, BLocalOrionDatabase db) {
        TableBuilder tb = new TableBuilder((BOrionDatabase)db, orionType);
        DdlCommand[] ddl = tb.createTable();
        for (int i = 0; i < ddl.length; ++i) {
            if (!(ddl[i] instanceof CreateTable)) continue;
            CreateTable createTable = (CreateTable)ddl[i];
            Column[] columns = createTable.getColumns();
            for (int j = 0; j < columns.length; ++j) {
                if (!columns[j].getName().equals(property.getName())) continue;
                return new AddColumn(tb.getTableName(), columns[j]);
            }
        }
        return null;
    }

    public static AddColumnBefore addColumnBeforeProperty(OrionType orionType, Property property, BLocalOrionDatabase db, String beforeProperty) {
        TableBuilder tb = new TableBuilder((BOrionDatabase)db, orionType);
        DdlCommand[] ddl = tb.createTable();
        for (int i = 0; i < ddl.length; ++i) {
            if (!(ddl[i] instanceof CreateTable)) continue;
            CreateTable createTable = (CreateTable)ddl[i];
            Column[] columns = createTable.getColumns();
            for (int j = 0; j < columns.length; ++j) {
                if (!columns[j].getName().equals(property.getName())) continue;
                return new AddColumnBefore(tb.getTableName(), columns[j], beforeProperty);
            }
        }
        return null;
    }

    public static AlterColumn alterColumn(OrionType orionType, Property property, BOrionDatabase db) {
        TableBuilder tb = new TableBuilder(db, orionType);
        DdlCommand[] ddl = tb.createTable();
        for (int i = 0; i < ddl.length; ++i) {
            if (!(ddl[i] instanceof CreateTable)) continue;
            CreateTable createTable = (CreateTable)ddl[i];
            Column[] columns = createTable.getColumns();
            for (int j = 0; j < columns.length; ++j) {
                if (!columns[j].getName().equals(property.getName())) continue;
                return new AlterColumn(tb.getTableName(), columns[j]);
            }
        }
        return null;
    }

    public static AlterColumn alterColumnWidth(OrionType orionType, Property property, BOrionDatabase db, int width) {
        TableBuilder tb = new TableBuilder(db, orionType);
        DdlCommand[] ddl = tb.createTable();
        for (int i = 0; i < ddl.length; ++i) {
            if (!(ddl[i] instanceof CreateTable)) continue;
            CreateTable createTable = (CreateTable)ddl[i];
            Column[] columns = createTable.getColumns();
            for (int j = 0; j < columns.length; ++j) {
                Column column = columns[j];
                if (!columns[j].getName().equals(property.getName())) continue;
                column = Column.make((String)column.getName(), (Type)column.getType(), (BValue)column.getDefaultValue(), (int)width, (int)column.getFlags());
                return new AlterColumn(tb.getTableName(), column);
            }
        }
        return null;
    }

    public static DdlCommand[] createTable(OrionType orionType, BLocalOrionDatabase db) {
        TableBuilder tb = new TableBuilder((BOrionDatabase)db, orionType);
        DdlCommand[] ddl = tb.createTable();
        return ddl;
    }

    public static DdlCommand[] alterKeyColumns(OrionType orionType, Type propertyType, BLocalOrionDatabase db) {
        Array a = new Array(DdlCommand.class);
        a.addAll((Object[])SchemaUpgradeSupport.dropForeignKeys(orionType, db));
        Property[] props = orionType.getKey();
        for (int i = 0; i < props.length; ++i) {
            if (props[i].getType() != propertyType) continue;
            a.add((Object)SchemaUpgradeSupport.alterColumn(orionType, props[i], (BOrionDatabase)db));
        }
        a.addAll((Object[])SchemaUpgradeSupport.addForeignKeys(orionType, db));
        return (DdlCommand[])a.trim();
    }

    public static DdlCommand[] alterNonKeyColumns(OrionType orionType, Type propertyType, BLocalOrionDatabase db) {
        Array a = new Array(DdlCommand.class);
        Array propsArray = new Array(Property.class);
        propsArray.addAll((Object[])orionType.getPersistentProperties());
        propsArray = propsArray.removeAll((Object[])orionType.getKey());
        Property[] props = (Property[])propsArray.trim();
        for (int i = 0; i < props.length; ++i) {
            if (props[i].getType() != propertyType) continue;
            a.add((Object)SchemaUpgradeSupport.alterColumn(orionType, props[i], (BOrionDatabase)db));
        }
        return (DdlCommand[])a.trim();
    }

    public static DdlCommand[] dropForeignKeys(OrionType orionType, BLocalOrionDatabase db) {
        Array a = new Array(DdlCommand.class);
        TableBuilder tb = new TableBuilder((BOrionDatabase)db, orionType);
        BTypeDependency[] deps = db.getDependentTypes(orionType);
        for (int i = 0; i < deps.length; ++i) {
            OrionType depOrionType = (OrionType)deps[i].getFromTypeId().getTypeSpec().getResolvedType();
            TableBuilder depTb = new TableBuilder((BOrionDatabase)db, depOrionType);
            Constraint constraint = SchemaUpgradeSupport.findForeignKey(depTb, tb);
            DropConstraint dropConstraint = new DropConstraint(depTb.getTableName(), constraint.getName());
            a.add((Object)dropConstraint);
        }
        return (DdlCommand[])a.trim();
    }

    public static DdlCommand[] addForeignKeys(OrionType orionType, BLocalOrionDatabase db) {
        Array a = new Array(DdlCommand.class);
        TableBuilder tb = new TableBuilder((BOrionDatabase)db, orionType);
        BTypeDependency[] deps = db.getDependentTypes(orionType);
        for (int i = 0; i < deps.length; ++i) {
            OrionType depOrionType = (OrionType)deps[i].getFromTypeId().getTypeSpec().getResolvedType();
            TableBuilder depTb = new TableBuilder((BOrionDatabase)db, depOrionType);
            Constraint constraint = SchemaUpgradeSupport.findForeignKey(depTb, tb);
            AddConstraint addConstraint = new AddConstraint(depTb.getTableName(), constraint);
            a.add((Object)addConstraint);
        }
        return (DdlCommand[])a.trim();
    }

    public static Constraint findForeignKey(TableBuilder tb, TableBuilder fkTb) {
        CreateTable create = (CreateTable)tb.createTable()[0];
        Constraint[] constraints = create.getConstraints();
        for (int i = 0; i < constraints.length; ++i) {
            if (constraints[i].getConstraintType() != 2 || !fkTb.getTableName().equals(constraints[i].getRefTable())) continue;
            return constraints[i];
        }
        throw new IllegalStateException("no foreign key for " + fkTb.getTableName() + " in " + tb.getTableName());
    }

    public static void skipConvertTimestampToLong(OrionType orionType, Property p) {
        if (skipList == null) {
            skipList = new HashSet();
        }
        skipList.add(orionType.toString() + "." + p.getName());
    }

    public static void convertTimestampToLong(BIOrionApp orionApp, BLocalOrionDatabase db, OrionSession session) throws Exception {
        OrionType[] orionTypes = orionApp.getOrionTypes();
        for (int i = 0; i < orionTypes.length; ++i) {
            SchemaUpgradeSupport.convertTimestampToLong(orionTypes[i], db, session);
        }
    }

    public static void convertTimestampToLong(OrionType orionType, BLocalOrionDatabase db, OrionSession session) throws Exception {
        BTypeSpec rdbmsTypeSpec = db.getOrionDatabase().getRdbms().getType().getTypeSpec();
        if (!rdbmsTypeSpec.toString().equals("rdbHsqlDb:HsqlDatabase")) {
            return;
        }
        StringBuffer projection = new StringBuffer();
        String tableName = db.getTableName(orionType);
        RdbmsDialect dialect = (RdbmsDialect)session.getRdbmsContext();
        Property[] keys = orionType.getKey();
        for (int i = 0; i < keys.length; ++i) {
            if (projection.length() > 0) {
                projection.append(", ");
            }
            projection.append(keys[i].getName());
        }
        Array a = new Array(Property.class);
        Property[] allProps = orionType.getProperties();
        for (int i = 0; i < allProps.length; ++i) {
            if (!allProps[i].getType().equals(BAbsTime.TYPE) || skipList != null && skipList.contains(orionType.toString() + "." + allProps[i].getName())) continue;
            a.add((Object)allProps[i]);
            if (projection.length() > 0) {
                projection.append(", ");
            }
            projection.append(allProps[i].getName()).append("2");
        }
        if (a.size() == 0) {
            return;
        }
        Property[] absTimeProps = (Property[])a.trim();
        for (int i = 0; i < absTimeProps.length; ++i) {
            final Property fnlAbsTimeProp = absTimeProps[i];
            final String fnltableName = tableName;
            session.invokeDdl(new DdlCommand(){

                public String getDdl(RdbmsContext context) {
                    return "ALTER TABLE " + fnltableName + " ALTER COLUMN " + fnlAbsTimeProp.getName() + " RENAME TO " + fnlAbsTimeProp.getName() + "2";
                }
            });
            session.invokeDdl((DdlCommand)SchemaUpgradeSupport.addColumnBeforeProperty(orionType, absTimeProps[i], db, absTimeProps[i].getName() + "2"));
        }
        if (BEnterpriseSecurityService.LOG.isLoggable(Level.FINE)) {
            BEnterpriseSecurityService.LOG.fine("SELECT " + projection + " FROM " + tableName);
        }
        try (Connection c = ((DbOrionSession)session).getUnderylingConnection();
             Statement statement = c.createStatement();
             ResultSet rs = statement.executeQuery("SELECT " + projection + " FROM " + tableName);){
            int i;
            StringBuffer b = new StringBuffer();
            b.append("UPDATE ").append(tableName).append(" SET ");
            for (i = 0; i < absTimeProps.length; ++i) {
                if (i > 0) {
                    b.append(", ");
                }
                b.append(absTimeProps[i].getName()).append(" = ? ");
            }
            b.append("WHERE ");
            for (i = 0; i < keys.length; ++i) {
                if (i > 0) {
                    b.append("AND ");
                }
                b.append(keys[i].getName()).append(" = ? ");
            }
            if (BEnterpriseSecurityService.LOG.isLoggable(Level.FINE)) {
                BEnterpriseSecurityService.LOG.fine(b.toString());
            }
            try (PreparedStatement prep = c.prepareStatement(b.toString());){
                while (rs.next()) {
                    int i2;
                    int prepareIndex = 1;
                    for (i2 = 0; i2 < absTimeProps.length; ++i2) {
                        Timestamp s = rs.getTimestamp(absTimeProps[i2].getName() + "2");
                        if (s == null) {
                            prep.setNull(prepareIndex, -5);
                        } else {
                            prep.setLong(prepareIndex, BAbsTime.make((long)s.getTime()).getMillis());
                        }
                        ++prepareIndex;
                    }
                    for (i2 = 0; i2 < keys.length; ++i2) {
                        Type type = keys[i2].getType();
                        if (type.equals(BRef.TYPE)) {
                            BRef ref = (BRef)keys[i2].getDefaultValue();
                            OrionType refType = (OrionType)ref.getTargetTypeSpec().getResolvedType();
                            type = refType.getKey()[0].getType();
                        }
                        if (type.equals(BUuid.TYPE)) {
                            prep.setBytes(prepareIndex, rs.getBytes(keys[i2].getName()));
                        } else if (type.equals(BString.TYPE)) {
                            prep.setString(prepareIndex, rs.getString(keys[i2].getName()));
                        } else if (type.equals(BInteger.TYPE)) {
                            prep.setInt(prepareIndex, rs.getInt(keys[i2].getName()));
                        } else {
                            throw new Exception("Key Type has no Translator available:" + type + " for " + orionType);
                        }
                        ++prepareIndex;
                    }
                    int rowCount = prep.executeUpdate();
                    if (rowCount == 1) continue;
                    throw new OrionException("Unexpected row count during update: " + rowCount);
                }
            }
        }
        for (int i = 0; i < absTimeProps.length; ++i) {
            session.invokeDdl((DdlCommand)new DropColumn(tableName, absTimeProps[i].getName() + "2"));
        }
    }

    public static String makeIndexName(RdbmsContext dialect, String tableName, String paramString) {
        int k;
        int i = ((RdbmsDialect)dialect).getMaxIndexName();
        int j = tableName.length();
        if (j + (k = paramString.length()) <= i) {
            return tableName + paramString;
        }
        int m = i / 2;
        if (j > m) {
            tableName = tableName.substring(0, m);
        }
        if (k > m) {
            paramString = paramString.substring(0, m);
        }
        return tableName + paramString;
    }

    public static void dropIndex(BOrionDatabase db, OrionSession session, OrionType type, String indexName) throws Exception {
        TableBuilder tb = new TableBuilder(db, type);
        DropIndex ddl3 = new DropIndex(tb.getTableName(), indexName);
        session.invokeDdl((DdlCommand)ddl3);
    }

    public static class AddColumnBefore
    implements DdlCommand {
        private final String tableName;
        private final Column column;
        private final String beforeProperty;

        public AddColumnBefore(String tableName, Column column, String beforeProperty) {
            this.tableName = tableName;
            this.column = column;
            this.beforeProperty = beforeProperty;
        }

        public String getTableName() {
            return this.tableName;
        }

        public Column getColumn() {
            return this.column;
        }

        public String getDdl(RdbmsContext context) {
            return "ALTER TABLE " + this.tableName + " ADD " + this.column.getDdl(context) + " BEFORE " + this.beforeProperty;
        }
    }
}

