/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec.orionTools;

import com.tridium.orion.BIOrionObject;
import com.tridium.orion.BOrionScheme;
import com.tridium.orion.BOrionTypeId;
import com.tridium.orion.BRef;
import com.tridium.orion.OrionException;
import com.tridium.orion.OrionSession;
import com.tridium.orion.OrionType;
import com.tridium.orion.sql.PropertyValue;
import com.tridium.smartTableHx.tab.HxTabUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashMap;
import java.util.StringTokenizer;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;

@NiagaraType
public final class BRefList
extends BSimple {
    public static final BRefList NULL;
    public static final BRefList DEFAULT;
    public static final Type TYPE;
    public static final String TRIM = "trim";
    private int resolveCount = 0;
    private boolean hasNullTarget = false;
    private BOrionTypeId typeId;
    private BSimple[] ids;
    private BIOrionObject[] targets;

    public Type getType() {
        return TYPE;
    }

    public static BRefList make(String typeSpec) {
        return BRefList.make(BOrionTypeId.make((String)typeSpec));
    }

    public static BRefList make(BTypeSpec typeSpec) {
        if (typeSpec.isNull()) {
            return NULL;
        }
        return new BRefList(BOrionTypeId.make((BTypeSpec)typeSpec));
    }

    public static BRefList make(BOrionTypeId typeId) {
        return new BRefList(typeId);
    }

    public static BRefList make(BOrionTypeId typeId, BSimple[] ids) {
        return new BRefList(typeId, ids);
    }

    public static BRefList make(BOrionTypeId typeId, BRef[] refs) {
        BSimple[] ids = new BSimple[refs.length];
        for (int i = 0; i < ids.length; ++i) {
            ids[i] = refs[i].getId();
        }
        return new BRefList(typeId, ids);
    }

    public static BRefList make(BRef ref) {
        if (ref.isBound()) {
            return BRefList.make(ref.getTargetOrionTypeId(), new BSimple[]{ref.getId()});
        }
        return BRefList.make(ref.getTargetOrionTypeId());
    }

    public static BRefList make(BIOrionObject obj) {
        return BRefList.make(obj.getOrionType(), new BIOrionObject[]{obj});
    }

    public static BRefList make(OrionType orionType, BIOrionObject[] obj) {
        Property[] props = orionType.getKey();
        if (props == null || props.length != 1) {
            throw new OrionException(orionType + " does not have exactly one identity property");
        }
        BSimple[] simple = new BSimple[obj.length];
        for (int i = 0; i < simple.length; ++i) {
            simple[i] = (BSimple)obj[i].get(props[0]);
        }
        return new BRefList(orionType.getOrionTypeId(), simple, obj, obj.length);
    }

    public static BRefList make(BRefList orig, BIOrionObject[] obj) {
        OrionType otype;
        Property[] props;
        HashMap<BSimple, BSimple> map = new HashMap<BSimple, BSimple>();
        BSimple[] values = orig.getIds();
        if (values != null) {
            for (int i = 0; i < values.length; ++i) {
                map.put(values[i], values[i]);
            }
        }
        if ((props = (otype = orig.getTargetOrionType()).getKey()) == null || props.length != 1) {
            throw new OrionException(otype + " does not have exactly one identity property");
        }
        for (int i = 0; i < obj.length; ++i) {
            BSimple simple = (BSimple)obj[i].get(props[0]);
            if (map.get(simple) != null) continue;
            map.put(simple, simple);
        }
        Array a = new Array(BSimple.class);
        a.addAll((Object[])map.values().toArray(new BSimple[0]));
        return new BRefList(BOrionTypeId.make((BTypeSpec)otype.getTypeSpec()), (BSimple[])a.trim(), null, 0);
    }

    public static BRefList makeRemove(BRefList orig, BIOrionObject[] obj) {
        OrionType otype;
        Property[] props;
        BSimple[] values = orig.getIds();
        HashMap<BSimple, BSimple> map = new HashMap<BSimple, BSimple>();
        if (values != null) {
            for (int i = 0; i < values.length; ++i) {
                map.put(values[i], values[i]);
            }
        }
        if ((props = (otype = orig.getTargetOrionType()).getKey()) == null || props.length != 1) {
            throw new OrionException(otype + " does not have exactly one identity property");
        }
        for (int i = 0; i < obj.length; ++i) {
            map.remove(obj[i].get(props[0]));
        }
        Array a = new Array(BSimple.class);
        a.addAll((Object[])map.values().toArray(new BSimple[0]));
        return new BRefList(BOrionTypeId.make((BTypeSpec)otype.getTypeSpec()), (BSimple[])a.trim(), null, 0);
    }

    public static BRefList makeRemove(BRefList orig, BSimple[] removeValues) {
        OrionType otype;
        Property[] props;
        BSimple[] values = orig.getIds();
        HashMap<BSimple, BSimple> map = new HashMap<BSimple, BSimple>();
        if (values != null) {
            for (int i = 0; i < values.length; ++i) {
                map.put(values[i], values[i]);
            }
        }
        if ((props = (otype = orig.getTargetOrionType()).getKey()) == null || props.length != 1) {
            throw new OrionException(otype + " does not have exactly one identity property");
        }
        for (int i = 0; i < removeValues.length; ++i) {
            map.remove(removeValues[i]);
        }
        Array a = new Array(BSimple.class);
        a.addAll((Object[])map.values().toArray(new BSimple[0]));
        return new BRefList(BOrionTypeId.make((BTypeSpec)otype.getTypeSpec()), (BSimple[])a.trim(), null, 0);
    }

    private BRefList() {
    }

    private BRefList(BOrionTypeId typeId) {
        this(typeId, null);
    }

    private BRefList(BOrionTypeId typeId, BSimple[] ids) {
        this.typeId = typeId;
        this.ids = ids;
    }

    private BRefList(BOrionTypeId typeId, BSimple[] ids, BIOrionObject[] targets, int resolveCount) {
        this.typeId = typeId;
        this.ids = ids;
        this.targets = targets;
        this.resolveCount = resolveCount;
    }

    public OrionType getTargetOrionType(OrionSession session) {
        return this.getTargetOrionType();
    }

    public OrionType getTargetOrionType() {
        return (OrionType)this.getTargetTypeSpec().getResolvedType();
    }

    public BTypeSpec getTargetTypeSpec() {
        if (this.typeId == null) {
            return null;
        }
        return this.typeId.getTypeSpec();
    }

    public BOrionTypeId getTargetOrionTypeId() {
        return this.typeId;
    }

    public BSimple getId(int index) {
        return this.ids[index];
    }

    public BSimple[] getIds() {
        return this.ids;
    }

    public BRef[] getRefs() {
        if (this.ids == null) {
            return new BRef[0];
        }
        BRef[] refs = new BRef[this.ids.length];
        for (int i = 0; i < this.ids.length; ++i) {
            refs[i] = BRef.make((BOrionTypeId)this.typeId, (BSimple)this.ids[i]);
        }
        return refs;
    }

    public String getHandlesAsString(BOrd dbOrd) throws Exception {
        if (!this.isBound()) {
            return "";
        }
        OrionType orionType = (OrionType)this.getTargetOrionTypeId().getTypeSpec().getResolvedType();
        StringBuffer b = new StringBuffer();
        Property[] props = orionType.getKey();
        if (props == null || props.length != 1) {
            throw new OrionException(orionType + " does not have exactly one identity property");
        }
        for (int i = 0; i < this.ids.length; ++i) {
            PropertyValue pv = new PropertyValue(props[0], (BValue)this.ids[i]);
            PropertyValue[] pvs = new PropertyValue[]{pv};
            b.append(BOrionScheme.makeOrdInSession((BOrd)dbOrd, (OrionType)orionType, (PropertyValue[])pvs).toString()).append("|");
        }
        return b.toString();
    }

    public boolean isBound() {
        return this.ids != null && this.ids.length > 0;
    }

    public boolean isNull() {
        if (this == NULL) {
            return true;
        }
        return this.typeId == null && this.ids == null;
    }

    public boolean equals(Object o) {
        if (!(o instanceof BRefList)) {
            return false;
        }
        BRefList other = (BRefList)((Object)o);
        if (other.typeId == null && this.typeId != null) {
            return false;
        }
        if (other.typeId != null && this.typeId == null) {
            return false;
        }
        if (other.typeId != null && this.typeId != null && !other.typeId.equals((Object)this.typeId)) {
            return false;
        }
        if (other.ids == null && this.ids != null) {
            return false;
        }
        if (other.ids != null && this.ids == null) {
            return false;
        }
        if (other.ids == null && this.ids == null) {
            return true;
        }
        for (int i = 0; i < other.ids.length; ++i) {
            if (other.ids.equals(this.ids)) continue;
            return false;
        }
        return true;
    }

    public boolean contains(BRef other) {
        if (!other.isBound() || !this.isBound()) {
            return false;
        }
        for (int j = 0; j < this.ids.length; ++j) {
            if (!other.getId().equals((Object)this.ids[j])) continue;
            return true;
        }
        return false;
    }

    public boolean containsAll(BRefList other) {
        if (other == null) {
            return false;
        }
        if (other.typeId == null && this.typeId != null) {
            return false;
        }
        if (other.typeId != null && this.typeId == null) {
            return false;
        }
        if (other.typeId != null && this.typeId != null && !other.typeId.equals((Object)this.typeId)) {
            return false;
        }
        if (other.ids == null && this.ids != null) {
            return false;
        }
        if (other.ids != null && this.ids == null) {
            return false;
        }
        if (other.ids == null && this.ids == null) {
            return true;
        }
        for (int i = 0; i < other.ids.length; ++i) {
            boolean found = false;
            for (int j = 0; j < this.ids.length; ++j) {
                if (!other.ids[i].equals((Object)this.ids[j])) continue;
                found = true;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    public boolean contains(BRefList other) {
        if (other == null) {
            return false;
        }
        if (other.typeId == null && this.typeId != null) {
            return false;
        }
        if (other.typeId != null && this.typeId == null) {
            return false;
        }
        if (other.typeId != null && this.typeId != null && !other.typeId.equals((Object)this.typeId)) {
            return false;
        }
        if (other.ids == null && this.ids != null) {
            return false;
        }
        if (other.ids != null && this.ids == null) {
            return false;
        }
        if (other.ids == null && this.ids == null) {
            return true;
        }
        for (int i = 0; i < other.ids.length; ++i) {
            for (int j = 0; j < this.ids.length; ++j) {
                if (!other.ids[i].equals((Object)this.ids[j])) continue;
                return true;
            }
        }
        return false;
    }

    public String encodeToString() throws IOException {
        if (this.isNull()) {
            return "null";
        }
        if (!this.isBound()) {
            return this.typeId.encodeToString();
        }
        StringBuffer b = new StringBuffer();
        for (int i = 0; i < this.ids.length; ++i) {
            b.append(this.ids[i].encodeToString()).append(";");
        }
        return this.typeId.encodeToString() + ";" + this.ids[0].getType().getTypeSpec().encodeToString() + ";" + b.toString();
    }

    public BObject decodeFromString(String s) throws IOException {
        if (s.equals("null")) {
            return NULL;
        }
        int semi = s.indexOf(59);
        if (semi == -1) {
            return BRefList.make(BOrionTypeId.decode((String)s));
        }
        StringTokenizer t = new StringTokenizer(s, ";");
        BOrionTypeId targetType = BOrionTypeId.decode((String)t.nextToken());
        BTypeSpec idType = (BTypeSpec)BTypeSpec.DEFAULT.decodeFromString(t.nextToken());
        BSimple proto = (BSimple)idType.getResolvedType().getInstance();
        Array a = new Array(BSimple.class);
        while (t.hasMoreTokens()) {
            a.add((Object)((BSimple)proto.decodeFromString(t.nextToken())));
        }
        return BRefList.make(targetType, (BSimple[])a.trim());
    }

    public void encode(DataOutput out) throws IOException {
        out.writeUTF(this.encodeToString());
    }

    public BObject decode(DataInput in) throws IOException {
        return this.decodeFromString(in.readUTF());
    }

    public String toString(Context cx) {
        if (this.isBound()) {
            String typeDisplay = HxTabUtil.getPluralDisplayName((Type)this.typeId.getTypeSpec().getResolvedType(), (Context)cx);
            if (this.ids.length == 1) {
                typeDisplay = this.typeId.getTypeSpec().getResolvedType().getDisplayName(cx);
            }
            return this.ids.length + " " + typeDisplay;
        }
        return "ref->" + this.typeId;
    }

    public String toString(int index, Context cx) {
        if (index < 0 || index >= this.ids.length) {
            return "ref->" + this.typeId.getTypeSpec().getResolvedType().getDisplayName(cx);
        }
        return this.ids[index] + " (" + this.typeId.getTypeSpec().getResolvedType().getDisplayName(cx) + ")";
    }

    public String toDisplayString(OrionSession session, Context cx) {
        return this.toDisplayString("; ", -1, "...", session, cx);
    }

    public String toDisplayString(String delim, int desiredResolveCount, String extraRecordsMessage, OrionSession session, Context cx) {
        if (this.ids != null) {
            if (desiredResolveCount == -1) {
                desiredResolveCount = this.ids.length;
            }
            BIOrionObject[] targets = this.getTargets(desiredResolveCount, session);
            StringBuffer b = new StringBuffer();
            for (int i = 0; i < targets.length && i <= desiredResolveCount; ++i) {
                if (targets[i] == null) continue;
                if (b.length() > 0) {
                    b.append(delim);
                }
                b.append(targets[i].toDisplayString(cx));
            }
            if (targets.length > desiredResolveCount) {
                if (b.length() > 0) {
                    b.append(delim);
                }
                b.append(extraRecordsMessage);
            }
            return b.toString();
        }
        return HxTabUtil.getNoneText((Context)cx);
    }

    public BIOrionObject[] getTargets(OrionSession session) {
        return this.getTargets(-1, session);
    }

    public BIOrionObject[] getTargets(int desiredResolveCount, OrionSession session) {
        if (!this.isBound()) {
            return null;
        }
        if (desiredResolveCount == -1) {
            desiredResolveCount = this.ids.length;
        }
        if (this.isResolved() && desiredResolveCount <= this.resolveCount) {
            return this.targets;
        }
        if (!this.isResolved()) {
            this.targets = new BIOrionObject[this.ids.length];
        }
        for (int i = this.resolveCount; i < this.ids.length && i <= desiredResolveCount; ++i) {
            this.targets[i] = session.read(this.getTargetOrionType(session), this.getId(i));
            if (this.targets[i] != null) continue;
            this.hasNullTarget = true;
        }
        this.resolveCount = desiredResolveCount;
        return this.targets;
    }

    public BRefList trim(OrionSession session) {
        BRefList trimmed = new BRefList(this.typeId, this.ids);
        trimmed.getTargets(session);
        if (!trimmed.hasNullTarget) {
            return this;
        }
        Array a = new Array((Object[])trimmed.targets);
        a = a.filterNull();
        this.targets = (BIOrionObject[])a.trim();
        trimmed.ids = new BSimple[a.size()];
        for (int i = 0; i < a.size(); ++i) {
            BIOrionObject target = (BIOrionObject)a.get(i);
            trimmed.ids[i] = (BSimple)target.get(target.getOrionType().getKey()[0]);
        }
        trimmed.hasNullTarget = false;
        return trimmed;
    }

    public void resolve(BIOrionObject[] targets) {
        if (!this.isBound()) {
            throw new OrionException("Cannot set auto-resolve target on unbound Ref.");
        }
        this.targets = targets;
    }

    public boolean isResolved() {
        return this.targets != null;
    }

    public Diff getDiff(BRefList refList) {
        Diff diff = new Diff();
        for (int i = 0; this.ids != null && i < this.ids.length; ++i) {
            diff.purge.put(this.ids[i], this.ids[i]);
        }
        BSimple[] otherIds = refList.getIds();
        for (int i = 0; otherIds != null && i < otherIds.length; ++i) {
            BSimple found = diff.purge.get(otherIds[i]);
            if (found != null) {
                diff.purge.remove(otherIds[i]);
                continue;
            }
            diff.persist.put(otherIds[i], otherIds[i]);
        }
        return diff;
    }

    static {
        DEFAULT = NULL = new BRefList();
        TYPE = Sys.loadType(BRefList.class);
    }

    public class Diff {
        public HashMap<BSimple, BSimple> persist = new HashMap();
        public HashMap<BSimple, BSimple> purge = new HashMap();
    }
}

