/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec.orionTools;

import com.tridium.orion.BOrionDatabase;
import com.tridium.orion.BOrionScheme;
import com.tridium.orion.OrionType;
import com.tridium.orion.sql.PropertyValue;
import com.tridiumx.entsec.BEnterpriseSecurityService;
import com.tridiumx.entsec.orionTools.BIMappingService;
import com.tridiumx.entsec.orionTools.BIOrdMappable;
import com.tridiumx.entsec.orionTools.MappingNavListener;
import com.tridiumx.entsec.orionTools.OrionTypeRegistrator;
import com.tridiumx.entsec.securityUtil.BIAsyncStationStarted;
import javax.baja.agent.AgentFilter;
import javax.baja.agent.AgentInfo;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BIMixIn;
import javax.baja.sys.BIcon;
import javax.baja.sys.BModule;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Subscriber;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BUuid;
import javax.baja.util.Lexicon;

@NiagaraType
@NiagaraProperty(name="uuid", type="BUuid", defaultValue="BUuid.DEFAULT", flags=65)
public abstract class BMappedExt
extends BComponent
implements BIMixIn,
BIAsyncStationStarted {
    @Generated
    public static final Property uuid = BMappedExt.newProperty((int)65, (BValue)BUuid.DEFAULT, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BMappedExt.class);
    private static MappingNavListener mappingNavListener;
    private static final BIcon icon;
    private OrionSubscriber subscriber;

    @Generated
    public BUuid getUuid() {
        return (BUuid)this.get(uuid);
    }

    @Generated
    public void setUuid(BUuid v) {
        this.set(uuid, (BValue)v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public abstract Type getMappedType();

    public BIMappingService getMappingService() {
        return OrionTypeRegistrator.getMappingService(this.getMappedType());
    }

    public String getDisplayNameInParent(Context cx) {
        return Lexicon.make((BModule)TYPE.getModule(), (Context)cx).getText("mappedExt");
    }

    public int getSubscriptionDepth() {
        return 0;
    }

    public Property[] getSubscribedProperties() {
        return null;
    }

    public void started() throws Exception {
        if (Sys.isStationStarted()) {
            this.asyncStationStarted();
        }
    }

    public void stationStarted() throws Exception {
        this.startedAndStationStarted();
    }

    public void startedAndStationStarted() throws Exception {
        BEnterpriseSecurityService.postAsyncStationStarted(this);
    }

    @Override
    public void asyncStationStarted() {
        if (this.getUuid().equals((Object)BUuid.DEFAULT)) {
            this.setUuid(BUuid.make());
        }
        BComponent parent = (BComponent)this.getParent();
        BComponent grandParent = (BComponent)parent.getParent();
        this.getMappingService().mappedPersist(parent);
        this.subscriber = new OrionSubscriber(parent);
        this.subscriber.subscribe(grandParent, this.getSubscriptionDepth());
        if (!Flags.isHidden((BComplex)parent, (Slot)this.getPropertyInParent())) {
            parent.setFlags((Slot)this.getPropertyInParent(), parent.getFlags((Slot)this.getPropertyInParent()) | 4);
        }
    }

    public void stopped() {
        if (Sys.getStation().isRunning()) {
            Thread t = new Thread(){

                @Override
                public void run() {
                    try {
                        BMappedExt.this.checkRemoveMapping();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            };
            t.start();
        }
    }

    public BOrd getOrionObjectHandle() throws Exception {
        AgentInfo info = Sys.getRegistry().getAgents(this.getMappedType().getTypeInfo()).filter(AgentFilter.is((Type)BIOrdMappable.TYPE)).getDefault();
        OrionType orionType = (OrionType)info.getAgentType().getTypeSpec().getResolvedType();
        BOrionDatabase db = this.getMappingService().getOrionDatabase();
        BOrd dbOrd = db.getOrdInSpace();
        BOrd ord = BOrionScheme.makeOrdInSession((BOrd)dbOrd, (OrionType)orionType, (PropertyValue[])new PropertyValue[]{new PropertyValue(orionType.getKey()[0], (BValue)this.getUuid())});
        return ord;
    }

    public void checkRemoveMapping() throws Exception {
        Thread.sleep(500L);
        if (!this.isRunning()) {
            this.removeMapping();
        }
    }

    public void removeMapping() {
        if (this.getParent() != null) {
            this.getMappingService().mappedRemoved(this.getParent().asComponent());
        }
        if (mappingNavListener != null) {
            mappingNavListener.remove(this.subscriber);
        }
    }

    public boolean isParentLegal(BComponent parent) {
        return parent.getType().is(this.getMappedType());
    }

    public void pathChanged() {
    }

    public BIcon getIcon() {
        return icon;
    }

    static {
        icon = BIcon.make((String)"module://orion/rc/orion.png");
    }

    class OrionSubscriber
    extends Subscriber {
        BComponent parent;
        Property p;

        public OrionSubscriber(BComponent parent) {
            this.parent = parent;
            this.p = parent.getPropertyInParent();
            if (mappingNavListener == null) {
                mappingNavListener = new MappingNavListener();
            }
            mappingNavListener.add(this);
        }

        public void event(BComponentEvent event) {
            if (!Sys.getStation().isRunning()) {
                return;
            }
            if (event.getSlot() != null && event.getSlot().getName().equals("displayNames")) {
                this.updatePath();
            } else if (event.getSourceComponent() == this.parent && BMappedExt.this.getSubscriptionDepth() > 0) {
                Property[] props = BMappedExt.this.getSubscribedProperties();
                for (int i = 0; props != null && i < props.length; ++i) {
                    if (event.getSlot() == null || !props[i].getName().equals(event.getSlot().getName())) continue;
                    this.update();
                }
            }
        }

        public void update() {
            BMappedExt.this.getMappingService().mappedUpdate(this.parent);
        }

        public void updatePath() {
            BMappedExt.this.pathChanged();
            this.update();
        }
    }
}

