/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec.ldap.importsteps;

import com.tridiumx.entsec.ldap.importutil.AuditLogEntryStatus;
import com.tridiumx.entsec.ldap.importutil.LdapImportLogEntry;
import com.tridiumx.entsec.ldap.importutil.LdapImportUtils;
import com.tridiumx.entsec.ldap.importvalidate.ILdapImportEntryValidator;
import com.tridiumx.ldapDriver.BLdapServer;
import java.util.List;
import java.util.logging.Logger;

public abstract class LdapImportStep {
    protected BLdapServer server;
    protected LdapImportStep[] steps;
    protected final Logger log = Logger.getLogger("entsec:LdapImportJob");
    private List<LdapImportLogEntry> logList = null;

    public LdapImportStep(BLdapServer server) {
        this.server = server;
    }

    public boolean validate() {
        return true;
    }

    public void setDependentSteps(LdapImportStep[] steps) {
        this.steps = steps;
    }

    public List<LdapImportLogEntry> getLogList() {
        return this.logList;
    }

    public void setLogList(List<LdapImportLogEntry> logList) {
        this.logList = logList;
    }

    protected void makeAuditLogErrorEntry(String message, Exception ex) {
        if (this.logList != null) {
            StringBuffer buffer = new StringBuffer(message);
            buffer.append("\n");
            buffer.append(LdapImportUtils.getStackTrace(ex));
            this.getLogList().add(new LdapImportLogEntry(message, AuditLogEntryStatus.ERROR, ex, true));
        }
    }

    public abstract boolean execute() throws Exception;

    public abstract Object getStepData();

    public abstract ILdapImportEntryValidator[] getApplicableValidators();
}

