/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec.ldap.importsteps;

import com.tridium.orion.BOrionObject;
import com.tridium.orion.BRef;
import com.tridium.orion.OrionCursor;
import com.tridium.orion.OrionSession;
import com.tridium.orion.OrionType;
import com.tridium.orion.sql.BSqlQuery;
import com.tridiumx.entsec.access.orion.BPerson;
import com.tridiumx.entsec.access.orion.BPersonLdapServerJoin;
import com.tridiumx.entsec.ldap.importsteps.LdapImportMakeDatabaseEntry;
import com.tridiumx.entsec.ldap.importutil.ColumnDetails;
import com.tridiumx.entsec.ldap.importutil.FilteredLdapMappingDetailsCache;
import com.tridiumx.entsec.ldap.importutil.RecordStatus;
import com.tridiumx.ldapDriver.BLdapServer;
import java.util.Map;
import java.util.logging.Level;
import javax.baja.query.BExpression;
import javax.baja.query.BQuery;
import javax.baja.query.util.Predicates;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BSimple;
import javax.baja.sys.BString;
import javax.baja.sys.Property;
import javax.baja.util.BTypeSpec;
import javax.baja.util.BUuid;

public class LdapImportMakePersonLdapServerJoinEntry
extends LdapImportMakeDatabaseEntry {
    public LdapImportMakePersonLdapServerJoinEntry(BLdapServer server, Map<String, ColumnDetails> mappingDetails, OrionSession session) {
        super(server, mappingDetails, session);
    }

    @Override
    public boolean execute() {
        BPerson person;
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("Entering the step LdapImportMakePersonLdapServerJoinEntry");
        }
        boolean success = false;
        if (this.steps != null && this.steps.length == 1 && (person = (BPerson)this.steps[0].getStepData()) != null) {
            BPersonLdapServerJoin joinEntry = (BPersonLdapServerJoin)((Object)this.getStepData());
            joinEntry.setDistinguishedName(this.user.getDistinguishedName());
            BRef ldapServerRef = BRef.make((BTypeSpec)com.tridiumx.entsec.access.orion.BLdapServer.ORION_TYPE.getTypeSpec(), (BSimple)this.getLDAPServerReference(this.server.getName()));
            joinEntry.setLdapServer(ldapServerRef);
            BUuid personId = person.getPersonId();
            BRef personRef = BRef.make((BTypeSpec)BPerson.ORION_TYPE.getTypeSpec(), (BSimple)personId);
            joinEntry.setPerson(personRef);
            joinEntry.setJobId((int)Thread.currentThread().getId());
            success = super.execute();
        }
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("Completed the step LdapImportMakePersonLdapServerJoinEntry");
        }
        return success;
    }

    @Override
    public OrionType getDataBaseEntryType() {
        return BPersonLdapServerJoin.ORION_TYPE;
    }

    @Override
    public Property[] getMandatoryProperties() {
        return new Property[0];
    }

    @Override
    public RecordStatus recordExists(BOrionObject obj) {
        BPersonLdapServerJoin rec = null;
        BPersonLdapServerJoin ref = (BPersonLdapServerJoin)obj;
        boolean recExists = false;
        BSqlQuery query = BSqlQuery.make((OrionType)BPersonLdapServerJoin.ORION_TYPE);
        BExpression exp = Predicates.eq((String)"distinguishedName", (BSimple)BString.make((String)this.user.getDistinguishedName()));
        OrionCursor c = this.session.select((BQuery)(query = query.where(exp)));
        if (c.next()) {
            rec = (BPersonLdapServerJoin)((Object)c.get());
            rec.setLastModified(BAbsTime.now());
            rec.setJobId((int)Thread.currentThread().getId());
            recExists = true;
        }
        rec = recExists && rec != null ? rec : ref;
        return new RecordStatus(rec, recExists);
    }

    protected BUuid getLDAPServerReference(String ldapServerName) {
        BUuid uuid = FilteredLdapMappingDetailsCache.getInstance(ldapServerName).getLdapServerReference();
        return uuid;
    }
}

