/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec.ldap.importsteps;

import com.tridium.orion.BOrionObject;
import com.tridium.orion.BRef;
import com.tridiumx.entsec.access.orion.BPerson;
import com.tridiumx.entsec.ldap.BLdapAttributeProperties;
import com.tridiumx.entsec.ldap.importsteps.LdapImportStep;
import com.tridiumx.entsec.ldap.importutil.ColumnDetails;
import com.tridiumx.entsec.ldap.importvalidate.ILdapImportEntryValidator;
import com.tridiumx.entsec.ldap.importvalidate.LdapEntryMandatoryFieldsValidator;
import com.tridiumx.ldapDriver.BLdapServer;
import com.tridiumx.ldapDriver.attributes.BLdapAttributesDeviceExt;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;

public class LdapImportGetMappingDataStep
extends LdapImportStep {
    private static final String ENTSEC_MODULE_PREFIX = "entsec:";
    protected Map<String, ColumnDetails> attrColMap = new HashMap<String, ColumnDetails>();
    private static final String VALID_COLUMN_PATH_PREFIX = "entsecref:/owner/";
    private static final String DEFAULT_TABLE_NAME = BPerson.TYPE.getTypeSpec().getTypeName();
    private static final String ENTSEC_TABLE_NAME_PREFIX = "entsec_";

    public LdapImportGetMappingDataStep(BLdapServer server) {
        super(server);
    }

    @Override
    public boolean execute() {
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("Entering the step LdapGetMappingDataStep");
        }
        BLdapAttributesDeviceExt attributeList = this.server.getAttributes();
        attributeList.lease();
        BLdapAttributeProperties[] attributes = (BLdapAttributeProperties[])attributeList.getChildren(BLdapAttributeProperties.class);
        for (int i = 0; i < attributes.length; ++i) {
            String columnPath = attributes[i].getMappedORD().encodeToString();
            if (columnPath.indexOf(VALID_COLUMN_PATH_PREFIX) != 0) continue;
            ColumnDetails details = this.getColumnDetails(columnPath);
            this.attrColMap.put(attributes[i].getAttrName(), details);
        }
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("Completed executing the step LdapGetMappingDataStep");
        }
        return this.attrColMap.size() > 0;
    }

    @Override
    public Object getStepData() {
        return this.attrColMap;
    }

    @Override
    public ILdapImportEntryValidator[] getApplicableValidators() {
        return new ILdapImportEntryValidator[]{new LdapEntryMandatoryFieldsValidator()};
    }

    private ColumnDetails getColumnDetails(String columnPath) {
        columnPath = columnPath.replaceAll(VALID_COLUMN_PATH_PREFIX, "");
        String tableName = DEFAULT_TABLE_NAME;
        String columnName = "";
        String refColumnName = "";
        String[] fragments = columnPath.split("/");
        if (fragments.length >= 1) {
            int counter = 0;
            do {
                if (this.isTableColumn(columnName = fragments[counter])) {
                    tableName = this.getTableName(columnName);
                    continue;
                }
                if (!this.isTableRefColumn(columnName, tableName)) continue;
                refColumnName = columnName;
                tableName = this.getTableNameFromRef(columnName, tableName);
            } while (++counter < fragments.length);
        }
        return new ColumnDetails(columnName, tableName, refColumnName);
    }

    private String getTableName(String columnName) {
        String tableName = DEFAULT_TABLE_NAME;
        if (columnName != null) {
            tableName = columnName.replaceAll(ENTSEC_TABLE_NAME_PREFIX, "");
        }
        return tableName;
    }

    private boolean isTableRefColumn(String columnName, String tableName) {
        BOrionObject orionObj = null;
        try {
            orionObj = (BOrionObject)Sys.getType((String)(ENTSEC_MODULE_PREFIX + tableName)).getInstance();
            Property prop = orionObj.getProperty(columnName);
            return prop != null && prop.getType().equals(BRef.TYPE);
        }
        catch (Exception ex) {
            return false;
        }
    }

    private String getTableNameFromRef(String columnName, String tableName) {
        String ret = DEFAULT_TABLE_NAME;
        BOrionObject orionObj = (BOrionObject)Sys.getType((String)(ENTSEC_MODULE_PREFIX + tableName)).getInstance();
        Property prop = orionObj.getProperty(columnName);
        if (prop != null && prop.getType().equals(BRef.TYPE)) {
            BRef ref = (BRef)prop.getDefaultValue();
            try {
                String typeSpec = ref.getTargetTypeSpec().encodeToString();
                ret = typeSpec.replace(ENTSEC_MODULE_PREFIX, "");
            }
            catch (IOException e) {
                throw new IllegalArgumentException("IO Exception while reading type spec :" + e.getLocalizedMessage());
            }
        }
        return ret;
    }

    private boolean isTableColumn(String columnName) {
        return columnName != null && columnName.indexOf(ENTSEC_TABLE_NAME_PREFIX) == 0;
    }
}

