/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec.ldap.importconfig;

import com.tridiumx.entsec.ldap.importutil.AuditLogEntryStatus;
import com.tridiumx.entsec.ldap.importutil.LdapImportLogEntry;
import com.tridiumx.ldapDriver.users.BLdapUser;
import java.util.Iterator;
import java.util.List;
import javax.baja.sys.Context;

public class UserImportCallback {
    private BLdapUser user;
    private UserImportStatus userImportStatus;
    private Context ctx;
    private String details;

    public UserImportCallback(BLdapUser user, UserImportStatus status, Context ctx) {
        this.user = user;
        this.userImportStatus = status;
        this.ctx = ctx;
        this.details = "";
    }

    public UserImportCallback(BLdapUser user, Exception ex, Context ctx) {
        this.user = user;
        this.userImportStatus = UserImportStatus.ERROR;
        this.ctx = ctx;
        this.details = ex.getMessage();
    }

    public UserImportCallback(List<LdapImportLogEntry> logEntries, Context ctx) {
        this.user = new BLdapUser();
        this.ctx = ctx;
        Iterator<LdapImportLogEntry> it = logEntries.iterator();
        StringBuffer message = new StringBuffer();
        boolean hasError = false;
        boolean hasWarning = false;
        this.setUserImportStatus(UserImportStatus.SUCCESS);
        while (it.hasNext()) {
            LdapImportLogEntry entry = it.next();
            message.append(entry.getMessage());
            message.append("\n");
            hasError = hasError || AuditLogEntryStatus.ERROR.equals((Object)entry.getAuditStatus());
            hasWarning = hasWarning || AuditLogEntryStatus.WARNING.equals((Object)entry.getAuditStatus());
        }
        if (hasWarning) {
            this.setUserImportStatus(UserImportStatus.WARNING);
        }
        if (hasError) {
            this.setUserImportStatus(UserImportStatus.ERROR);
        }
        this.setDetails(message.toString());
    }

    public BLdapUser getUser() {
        return this.user;
    }

    public void setUser(BLdapUser user) {
        this.user = user;
    }

    public UserImportStatus getUserImportStatus() {
        return this.userImportStatus;
    }

    public void setUserImportStatus(UserImportStatus userImportStatus) {
        this.userImportStatus = userImportStatus;
    }

    public Context getContext() {
        return this.ctx;
    }

    public void setContext(Context ctx) {
        this.ctx = ctx;
    }

    public String getDetails() {
        return this.details;
    }

    public void setDetails(String faultCause) {
        this.details = faultCause;
    }

    public static enum UserImportStatus {
        SUCCESS,
        ERROR,
        WARNING;

    }
}

