/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec.ldap.importconfig;

import com.tridium.orion.OrionSession;
import com.tridiumx.entsec.access.orion.BLdapServer;
import com.tridiumx.entsec.ldap.importconfig.CreatePersonCleanupProcedure;
import com.tridiumx.entsec.orionTools.BAppTable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.baja.rdb.RdbmsContext;

class CreatePersonCleanupProcedureForSQLServer
extends CreatePersonCleanupProcedure {
    CreatePersonCleanupProcedureForSQLServer() {
    }

    @Override
    public String getDdl(RdbmsContext context) {
        StringBuilder sql = new StringBuilder();
        sql.append("CREATE PROCEDURE                                                                    ");
        sql.append("removePersonsDeletedFromLdapServer");
        sql.append("    @ldapServerOrdString VARCHAR(255),                                              ");
        sql.append("    @noOfDeletedPersons INT OUTPUT                                                  ");
        sql.append("AS                                                                                  ");
        sql.append("BEGIN                                                                               ");
        sql.append("    DECLARE @dnRefToDelete VARCHAR(255),                                            ");
        sql.append("            @dnToBeDelete VARCHAR(255),                                             ");
        sql.append("            @personToDelete BINARY(16),                                             ");
        sql.append("            @ldapServerOrdWithPrefix VARCHAR(255),                                  ");
        sql.append("            @ldapServerIdFromOrd BINARY(16),                                        ");
        sql.append("            @ldapServerIdFromQuery BINARY(16);                                      ");
        sql.append("    DECLARE person_cursor CURSOR FOR                                                ");
        sql.append(this.getToBeDeletedPersonsCursorQuery());
        sql.append("    DECLARE ldapServerIdFromOrd_cursor CURSOR FOR                                   ");
        sql.append("    select ldapServerId                                                             ");
        sql.append("      from ").append(BAppTable.getTableName(BLdapServer.ORION_TYPE));
        sql.append("     where ord like CONCAT('%', @ldapServerIdFromOrd);                              ");
        sql.append("    OPEN ldapServerIdFromOrd_cursor;                                                ");
        sql.append("    FETCH NEXT FROM ldapServerIdFromOrd_cursor INTO  @ldapServerIdFromOrd;          ");
        sql.append("    CLOSE ldapServerIdFromOrd_cursor;                                               ");
        sql.append("    DEALLOCATE ldapServerIdFromOrd_cursor;                                          ");
        sql.append("    SET @noOfDeletedPersons = 0;                                                    ");
        sql.append("    OPEN person_cursor;                                                             ");
        sql.append("    FETCH NEXT FROM person_cursor INTO  @personToDelete,                            ");
        sql.append("                                        @ldapServerIdFromQuery,                     ");
        sql.append("                                        @dnToBeDelete,                              ");
        sql.append("                                        @dnRefToDelete;                             ");
        sql.append("    BEGIN TRANSACTION                                                               ");
        sql.append("    WHILE @@FETCH_STATUS = 0                                                        ");
        sql.append("    BEGIN                                                                           ");
        sql.append("        IF (@ldapServerIdFromQuery = @ldapServerIdFromOrd)                          ");
        sql.append("            BEGIN                                                                   ");
        sql.append(this.deletePerson("@personToDelete"));
        sql.append("                SET @noOfDeletedPersons = @noOfDeletedPersons + 1;                  ");
        sql.append("                FETCH NEXT FROM person_cursor INTO  @personToDelete,                ");
        sql.append("                                                    @ldapServerIdFromQuery,         ");
        sql.append("                                                    @dnToBeDelete,                  ");
        sql.append("                                                    @dnRefToDelete;                 ");
        sql.append("            END;                                                                    ");
        sql.append("    END;                                                                            ");
        sql.append("    COMMIT TRANSACTION                                                              ");
        sql.append("    CLOSE person_cursor;                                                            ");
        sql.append("    DEALLOCATE person_cursor;                                                       ");
        sql.append("END                                                                                 ");
        return sql.toString();
    }

    @Override
    protected boolean isProcedureCreationRequired(OrionSession session) throws SQLException {
        StringBuilder query = new StringBuilder();
        query.append("  SELECT COUNT(1)     ");
        query.append("    FROM SYSOBJECTS    ");
        query.append("   WHERE XTYPE = 'P'   ");
        query.append("     AND NAME = ?      ");
        try (Connection connection = this.getConnection(session);
             PreparedStatement statement = connection.prepareStatement(query.toString());){
            int paramIndex = 0;
            statement.setString(++paramIndex, "removePersonsDeletedFromLdapServer");
            try (ResultSet rs = statement.executeQuery();){
                if (rs.next() && rs.getInt(1) > 0) {
                    boolean bl = false;
                    return bl;
                }
            }
        }
        return true;
    }
}

