/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec.ldap.importconfig;

import com.tridium.orion.BOrionDatabase;
import com.tridium.orion.BOrionService;
import com.tridium.orion.OrionSession;
import com.tridiumx.entsec.access.orion.BBadge;
import com.tridiumx.entsec.access.orion.BLdapServerPersonEntry;
import com.tridiumx.entsec.access.orion.BPerson;
import com.tridiumx.entsec.access.orion.BPersonLdapServerJoin;
import com.tridiumx.entsec.ldap.importconfig.CreatePersonCleanupProcedureForDB2;
import com.tridiumx.entsec.ldap.importconfig.CreatePersonCleanupProcedureForHSQL;
import com.tridiumx.entsec.ldap.importconfig.CreatePersonCleanupProcedureForMySQL;
import com.tridiumx.entsec.ldap.importconfig.CreatePersonCleanupProcedureForOracle;
import com.tridiumx.entsec.ldap.importconfig.CreatePersonCleanupProcedureForSQLServer;
import com.tridiumx.entsec.orionTools.BAppTable;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.rdb.RdbmsContext;
import javax.baja.rdb.ddl.DdlCommand;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;

public abstract class CreatePersonCleanupProcedure
implements DdlCommand {
    private static Logger LOG = Logger.getLogger("entsec:CreatePersonCleanupProcedure");
    protected static final String STORED_PROCEDURE_REMOVE_PERSONS_DELETED_IN_LDAP_SERVER = "removePersonsDeletedFromLdapServer";
    private static final BTypeSpec DB2 = BTypeSpec.make((String)"rdbDb2:Db2Database");
    private static final BTypeSpec ORACLE = BTypeSpec.make((String)"rdbOracle:OracleDatabase");
    private static final BTypeSpec HSQL = BTypeSpec.make((String)"rdbHsqlDb:HsqlDatabase");
    private static final BTypeSpec SQL_SERVER = BTypeSpec.make((String)"rdbSqlServer:SqlServerDatabase");
    private static final BTypeSpec MY_SQL = BTypeSpec.make((String)"rdbMySQL:MySQLDatabase");

    protected abstract boolean isProcedureCreationRequired(OrionSession var1) throws SQLException;

    public abstract String getDdl(RdbmsContext var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createProcedure(OrionSession session) throws SQLException {
        if (this.isProcedureCreationRequired(session)) {
            Connection connection = null;
            Statement statement = null;
            try {
                connection = this.getConnection(session);
                statement = connection.createStatement();
                boolean bl = statement.execute(this.getDdl(null));
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
                if (connection != null) {
                    connection.close();
                }
            }
        }
    }

    protected String getToBeDeletedPersonsCursorQuery() {
        StringBuilder sql = new StringBuilder();
        sql.append(" select person, ldapServerId, dnToBeDeleted, refDn                                               ");
        sql.append("   from (                                                                                        ");
        sql.append("          select A.person,                                                                       ");
        sql.append("                 A.ldapServer as ldapServerId,                                                   ");
        sql.append("                 A.distinguishedName as dnToBeDeleted,                                           ");
        sql.append("                 B.distinguishedName as refDn                                                    ");
        sql.append("            from ").append(BAppTable.getTableName(BPersonLdapServerJoin.ORION_TYPE)).append(" A ");
        sql.append(" left outer join ").append(BAppTable.getTableName(BLdapServerPersonEntry.ORION_TYPE)).append(" B ");
        sql.append("              on A.distinguishedName = B.distinguishedName                                       ");
        sql.append("        ) AS TEMP_TABLE                                                                          ");
        sql.append("  where refDn is null;                                                                           ");
        return sql.toString();
    }

    protected String deletePerson(String deleteParamValue) {
        StringBuilder sql = new StringBuilder();
        sql.append(" update ").append(BAppTable.getTableName(BBadge.ORION_TYPE));
        sql.append("    set ").append(BBadge.owner.getName()).append(" = NULL,                                      ");
        sql.append("        ").append(BBadge.status.getName()).append(" = NULL,                                     ");
        sql.append("        ").append(BBadge.issueDate.getName()).append(" = NULL                                   ");
        sql.append("  where ").append(BBadge.owner.getName()).append(" = ").append(deleteParamValue).append(";      ");
        sql.append(" delete from ").append(BAppTable.getTableName(BPerson.ORION_TYPE));
        sql.append("  where ").append(BPerson.personId.getName()).append(" = ").append(deleteParamValue).append(";  ");
        return sql.toString();
    }

    protected Connection getConnection(OrionSession session) throws SQLException {
        return session.getOrionDatabase().getRdbms().getConnection();
    }

    protected void closeConnection(Connection connection) throws SQLException {
        connection.close();
    }

    public static void createPersonCleanupStoredProcedure() {
        OrionSession session = null;
        try {
            session = CreatePersonCleanupProcedure.getOrionSession();
            CreatePersonCleanupProcedure personCleanupProcedure = null;
            Type type = session.getOrionDatabase().getRdbms().getType();
            if (type.getTypeSpec().equals((Object)MY_SQL)) {
                personCleanupProcedure = new CreatePersonCleanupProcedureForMySQL();
            } else if (type.getTypeSpec().equals((Object)SQL_SERVER)) {
                personCleanupProcedure = new CreatePersonCleanupProcedureForSQLServer();
            } else if (type.getTypeSpec().equals((Object)HSQL)) {
                personCleanupProcedure = new CreatePersonCleanupProcedureForHSQL();
            } else if (type.getTypeSpec().equals((Object)ORACLE)) {
                personCleanupProcedure = new CreatePersonCleanupProcedureForOracle();
            } else if (type.getTypeSpec().equals((Object)DB2)) {
                personCleanupProcedure = new CreatePersonCleanupProcedureForDB2();
            }
            if (personCleanupProcedure != null) {
                super.createProcedure(session);
            }
        }
        catch (SQLException e) {
            LOG.log(Level.SEVERE, "Failed to create procedure.", e);
        }
        finally {
            CreatePersonCleanupProcedure.closeOrionSession(session);
        }
    }

    private static OrionSession getOrionSession() {
        BOrionDatabase orionDatabase = BOrionService.getService().getOrionDatabases()[0];
        OrionSession orionSession = orionDatabase.createSession(null);
        orionSession.setAutoCommit(false);
        return orionSession;
    }

    private static void closeOrionSession(OrionSession orionSession) {
        if (orionSession != null) {
            orionSession.close();
        }
    }
}

