/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec.ldap.importconfig;

import com.tridium.orion.OrionSession;
import com.tridiumx.accessDriver.enums.activity.BLDAPActivityEnum;
import com.tridiumx.entsec.access.BAccessControlService;
import com.tridiumx.entsec.access.history.BLDAPAuditRecord;
import com.tridiumx.entsec.ldap.importconfig.UserImportCallback;
import com.tridiumx.entsec.ldap.importsteps.LdapImportGetMappingDataStep;
import com.tridiumx.entsec.ldap.importsteps.LdapImportMakeBadgeEntry;
import com.tridiumx.entsec.ldap.importsteps.LdapImportMakeBadgeLdapServerJoinEntry;
import com.tridiumx.entsec.ldap.importsteps.LdapImportMakeDatabaseEntry;
import com.tridiumx.entsec.ldap.importsteps.LdapImportMakePersonAccJoinEntry;
import com.tridiumx.entsec.ldap.importsteps.LdapImportMakePersonEntry;
import com.tridiumx.entsec.ldap.importsteps.LdapImportMakePersonInfoEntry;
import com.tridiumx.entsec.ldap.importsteps.LdapImportMakePersonLdapServerJoinEntry;
import com.tridiumx.entsec.ldap.importsteps.LdapImportMakeTenantEntry;
import com.tridiumx.entsec.ldap.importsteps.LdapImportPeriodicImportStep;
import com.tridiumx.entsec.ldap.importsteps.LdapImportPrepareStep;
import com.tridiumx.entsec.ldap.importsteps.LdapImportStartSubscriptionAndCleanupStep;
import com.tridiumx.entsec.ldap.importsteps.LdapImportStep;
import com.tridiumx.entsec.ldap.importutil.AuditLogEntryStatus;
import com.tridiumx.entsec.ldap.importutil.ColumnDetails;
import com.tridiumx.entsec.ldap.importutil.FilteredLdapMappingDetailsCache;
import com.tridiumx.entsec.ldap.importutil.LdapImportLogEntry;
import com.tridiumx.entsec.ldap.importutil.LdapImportUtils;
import com.tridiumx.entsec.securityUtil.HistoryManager;
import com.tridiumx.ldapDriver.BLdapServer;
import com.tridiumx.ldapDriver.users.BLdapUser;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.job.BSimpleJob;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BVector;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

@NiagaraType
public abstract class BLdapImportJob
extends BSimpleJob {
    @Generated
    public static final Type TYPE = Sys.loadType(BLdapImportJob.class);
    protected BLdapServer server;
    protected Logger log = Logger.getLogger("entsec:LdapImportJob");
    protected Lexicon lex = Lexicon.make(BLdapImportJob.class);
    protected BVector userVector;
    protected List<LdapImportLogEntry> auditLogList = new LinkedList<LdapImportLogEntry>();
    private Context cx;
    public boolean mandatoryAttributesMapped = true;
    public int failedUsers = 0;
    public int successUsers = 0;

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BLdapImportJob() {
    }

    public BLdapImportJob(BLdapServer server) {
        this.server = server;
    }

    private void log(LdapImportLogEntry logEntry, boolean triggerWrite) {
        if (logEntry != null) {
            if (logEntry.isAuditable()) {
                this.auditLogList.add(logEntry);
            }
            if (AuditLogEntryStatus.ERROR.equals((Object)logEntry.getAuditStatus()) && this.failedUsers <= 0) {
                this.log().failed(logEntry.getMessage(), (Throwable)logEntry.getEx());
            }
        }
        if (triggerWrite && this.auditLogList.size() > 0) {
            this.addAuditLogEntry(new UserImportCallback(this.auditLogList, this.cx));
            this.auditLogList.clear();
        }
    }

    private void logException(LdapImportMakeDatabaseEntry dbEntry, String message, AuditLogEntryStatus alertType) {
        if (dbEntry.isGotLicenseExceptionDuringInsert()) {
            this.log(new LdapImportLogEntry(dbEntry.getLicenseExceptionMessage(), alertType, true), false);
        } else {
            this.log(new LdapImportLogEntry(message, alertType, true), false);
        }
    }

    public void run(Context cx) throws Exception {
        this.cx = cx;
        OrionSession session = null;
        try {
            this.log.fine("Begin execution of LDAP Import");
            this.log.fine("Retrieve the mapping data from ldap attribute extension");
            ImportStatus importStatus = new ImportStatus(false, true);
            LdapImportGetMappingDataStep mappingStep = new LdapImportGetMappingDataStep(this.server);
            boolean isMappingReady = ((LdapImportStep)mappingStep).execute();
            if (isMappingReady) {
                List<String> mandatoryAttributes = LdapImportUtils.getMandatoryFieldsForMapping();
                HashMap attrMap = (HashMap)((LdapImportStep)mappingStep).getStepData();
                Set attrSet = attrMap.keySet();
                for (String key : attrSet) {
                    ColumnDetails cols = (ColumnDetails)attrMap.get(key);
                    mandatoryAttributes.remove(cols.getColumnName().toString());
                }
                if (mandatoryAttributes.size() > 0) {
                    String attributesList = LdapImportUtils.getAttributesList(mandatoryAttributes);
                    String msg = this.lex.getText("ldap.mandatoryAttributes.Error", new Object[]{attributesList});
                    Exception ex = new Exception(this.lex.getText("ldap.mandatoryAttributes.Exception", new Object[]{mandatoryAttributes}));
                    this.mandatoryAttributesMapped = false;
                    this.log(new LdapImportLogEntry(msg, AuditLogEntryStatus.ERROR, ex, true), true);
                    throw ex;
                }
                this.mandatoryAttributesMapped = true;
                this.log.fine("Retrieved the LDAP - entsec mapping details successfully");
                session = this.getOrionSession();
                if (!this.preExecuteLdapImport(((LdapImportStep)mappingStep).getStepData(), session, cx)) {
                    String msg = "Error while deleting person and related join entries.";
                    this.log(null, true);
                    throw new Exception(msg, null);
                }
                importStatus = this.executeLdapImport(mappingStep, session, cx);
            } else {
                String msg = "No mapping details available.Import cannot proceed";
                this.log(new LdapImportLogEntry(msg, AuditLogEntryStatus.ERROR, true), true);
                throw new Exception(msg);
            }
            this.postExecuteLdapImport(((LdapImportStep)mappingStep).getStepData(), session, cx);
            if (importStatus.isImportReady() && importStatus.isAllUsersImported()) {
                LdapImportStartSubscriptionAndCleanupStep subscriptionStep = new LdapImportStartSubscriptionAndCleanupStep(this.server);
                boolean subscribed = ((LdapImportStep)subscriptionStep).execute();
                if (subscribed) {
                    this.log(new LdapImportLogEntry("Ldap change subscription successful", AuditLogEntryStatus.INFO, true), true);
                } else {
                    this.log(new LdapImportLogEntry("Ldap change subscription failed. Do a manual ping to retry.", AuditLogEntryStatus.WARNING, true), true);
                }
            }
            this.setProgress(100);
        }
        catch (Exception ex) {
            try {
                this.log(new LdapImportLogEntry("Error during import process ", AuditLogEntryStatus.ERROR, ex, true), true);
                throw ex;
            }
            catch (Throwable throwable) {
                FilteredLdapMappingDetailsCache.resetMappingDetailsCache();
                this.closeOrionSession(session);
                throw throwable;
            }
        }
        FilteredLdapMappingDetailsCache.resetMappingDetailsCache();
        this.closeOrionSession(session);
    }

    protected boolean preExecuteLdapImport(Object mappingStep, OrionSession session, Context ctx) {
        return true;
    }

    protected boolean postExecuteLdapImport(Object mappingStep, OrionSession session, Context ctx) {
        return true;
    }

    protected ImportStatus executeLdapImport(LdapImportStep mappingStep, OrionSession session, Context ctx) throws Exception {
        boolean allUsersImported = true;
        boolean isImportReady = false;
        this.setProgress(5);
        LdapImportStep prepareStep = this.getPrepareDataStep();
        isImportReady = prepareStep.execute();
        boolean isGotLicenseExceptionDuringInsert = false;
        String licenseExceptionMessage = null;
        if (isImportReady) {
            LdapImportPrepareStep.ImportData importData = (LdapImportPrepareStep.ImportData)prepareStep.getStepData();
            do {
                if (isImportReady) {
                    this.log.info("Retrieved the user data for LDAP import");
                    this.setProgress(10);
                }
                BLdapUser[] users = importData.getUserList();
                Map mappingDetails = (Map)mappingStep.getStepData();
                this.setProgress(15);
                this.log.info("Retrieve all LDAP users selected for import");
                int userLength = users.length;
                int progressPerUser = userLength > 0 ? 80 / userLength : 80;
                this.log.info("Adding the selected users to Entsec Database");
                for (int index = 0; index < users.length; ++index) {
                    LdapImportMakeTenantEntry tenantEntry;
                    boolean isTenantAvailable;
                    boolean hasError = false;
                    BLdapUser user = users[index];
                    if (this.log.isLoggable(Level.FINE)) {
                        this.log.fine("Adding user " + user.getDistinguishedName() + " to entsec database");
                    }
                    if (!(isTenantAvailable = (tenantEntry = new LdapImportMakeTenantEntry(this.server, mappingDetails, session)).validate())) {
                        this.log(new LdapImportLogEntry("Validation failed while assigning tenant to the user. The tenant will not be assigned to this user.", AuditLogEntryStatus.WARNING, true), false);
                    } else {
                        tenantEntry.setLdapUser(user);
                        isTenantAvailable = tenantEntry.execute();
                    }
                    LdapImportMakePersonEntry personEntry = new LdapImportMakePersonEntry(this.server, mappingDetails, session);
                    personEntry.setLdapUser(user);
                    personEntry.setLogList(this.auditLogList);
                    boolean validUser = ((LdapImportMakeDatabaseEntry)personEntry).validate();
                    if (validUser) {
                        if (isTenantAvailable) {
                            personEntry.setDependentSteps(new LdapImportStep[]{tenantEntry});
                        }
                        if (((LdapImportMakeDatabaseEntry)personEntry).execute()) {
                            LdapImportMakePersonLdapServerJoinEntry serverJoinEntry = new LdapImportMakePersonLdapServerJoinEntry(this.server, mappingDetails, session);
                            if (serverJoinEntry.validate()) {
                                serverJoinEntry.setLdapUser(user);
                                serverJoinEntry.setDependentSteps(new LdapImportStep[]{personEntry});
                                if (!((LdapImportMakeDatabaseEntry)serverJoinEntry).execute()) {
                                    this.logException(serverJoinEntry, "Error creating entry in Ldapserver-person mapping table ", AuditLogEntryStatus.ERROR);
                                    hasError = true;
                                }
                            } else {
                                this.log(new LdapImportLogEntry("No distinguished name is present in the entry", AuditLogEntryStatus.ERROR, true), false);
                                hasError = true;
                            }
                            if (hasError) continue;
                            LdapImportMakeBadgeEntry badgeEntry = new LdapImportMakeBadgeEntry(this.server, mappingDetails, session);
                            boolean isBadgeValid = badgeEntry.validate();
                            if (isBadgeValid) {
                                LdapImportStep[] ldapImportStepArray;
                                if (isTenantAvailable) {
                                    LdapImportStep[] ldapImportStepArray2 = new LdapImportStep[2];
                                    ldapImportStepArray2[0] = tenantEntry;
                                    ldapImportStepArray = ldapImportStepArray2;
                                    ldapImportStepArray2[1] = personEntry;
                                } else {
                                    LdapImportStep[] ldapImportStepArray3 = new LdapImportStep[1];
                                    ldapImportStepArray = ldapImportStepArray3;
                                    ldapImportStepArray3[0] = personEntry;
                                }
                                LdapImportStep[] dependentSteps = ldapImportStepArray;
                                badgeEntry.setDependentSteps(dependentSteps);
                                badgeEntry.setLdapUser(user);
                                if (((LdapImportMakeDatabaseEntry)badgeEntry).execute()) {
                                    LdapImportMakeBadgeLdapServerJoinEntry bdageServerJoinEntry = new LdapImportMakeBadgeLdapServerJoinEntry(this.server, mappingDetails, session);
                                    if (bdageServerJoinEntry.validate()) {
                                        bdageServerJoinEntry.setLdapUser(user);
                                        bdageServerJoinEntry.setDependentSteps(new LdapImportStep[]{badgeEntry});
                                        if (!((LdapImportMakeDatabaseEntry)bdageServerJoinEntry).execute()) {
                                            this.logException(bdageServerJoinEntry, "Badge will not be associated with the LDAP server and in future this badge is not considered as LDAP imported badge. ", AuditLogEntryStatus.WARNING);
                                        }
                                    }
                                } else {
                                    this.logException(badgeEntry, "Failed to assign badge to the user. ", AuditLogEntryStatus.WARNING);
                                }
                            } else {
                                this.log(new LdapImportLogEntry("Validation failed while assigning badge to the user. The badge will not be assigned to this user. ", AuditLogEntryStatus.WARNING, true), false);
                            }
                            LdapImportMakePersonAccJoinEntry personAccJoinEntry = new LdapImportMakePersonAccJoinEntry(this.server, mappingDetails, session);
                            personAccJoinEntry.setLogList(this.auditLogList);
                            personAccJoinEntry.setLdapUser(user);
                            boolean isAccJoinValid = personAccJoinEntry.validate();
                            if (isAccJoinValid) {
                                personAccJoinEntry.setDependentSteps(new LdapImportStep[]{personEntry});
                                ((LdapImportMakeDatabaseEntry)personAccJoinEntry).execute();
                            } else {
                                this.log(new LdapImportLogEntry("Validation failed while assigning Access Rights to the user. The Access Rights will not be assigned to this user.", AuditLogEntryStatus.WARNING, true), false);
                            }
                            LdapImportMakePersonInfoEntry personInfoEntry = new LdapImportMakePersonInfoEntry(this.server, mappingDetails, session);
                            boolean isPersonInfoValid = personInfoEntry.validate();
                            if (isPersonInfoValid) {
                                personInfoEntry.setDependentSteps(new LdapImportStep[]{personEntry});
                                personInfoEntry.setLdapUser(user);
                                if (!((LdapImportMakeDatabaseEntry)personInfoEntry).execute()) {
                                    this.logException(personInfoEntry, "Failed to make an entry for PersonInfo details. Will proceed to subsequent steps.", AuditLogEntryStatus.WARNING);
                                }
                            } else {
                                this.log(new LdapImportLogEntry("Failed to make an entry for PersonInfo details. Will proceed to subsequent steps.", AuditLogEntryStatus.WARNING, true), false);
                            }
                        } else {
                            hasError = true;
                            isGotLicenseExceptionDuringInsert = personEntry.isGotLicenseExceptionDuringInsert();
                            licenseExceptionMessage = personEntry.getLicenseExceptionMessage();
                        }
                    } else {
                        this.log(new LdapImportLogEntry("Validation for person entry failed. Skipping user with DN " + user.getDistinguishedName(), AuditLogEntryStatus.ERROR, true), true);
                        hasError = true;
                    }
                    if (!hasError) {
                        session.commit();
                        ++this.successUsers;
                        this.log(new LdapImportLogEntry("User " + user.getDistinguishedName() + " added successfully", AuditLogEntryStatus.INFO, true), true);
                    } else {
                        session.rollback();
                        ++this.failedUsers;
                        if (isGotLicenseExceptionDuringInsert) {
                            this.log(new LdapImportLogEntry(licenseExceptionMessage + ", for user with DN " + user.getDistinguishedName(), AuditLogEntryStatus.ERROR, true), true);
                        } else {
                            this.log(new LdapImportLogEntry("Error making person entry in entsec database Skipping user with DN " + user.getDistinguishedName(), AuditLogEntryStatus.ERROR, true), true);
                        }
                    }
                    UserImportCallback userImportCallback = new UserImportCallback(this.auditLogList, this.cx);
                    userImportCallback.setUser(user);
                    if (!validUser) {
                        userImportCallback.setUserImportStatus(UserImportCallback.UserImportStatus.ERROR);
                    }
                    this.userAdded(userImportCallback, validUser);
                    this.setProgress(15 + (index + 1) * progressPerUser);
                    allUsersImported = allUsersImported && !hasError;
                }
                isImportReady = prepareStep.execute();
            } while ((importData = (LdapImportPrepareStep.ImportData)prepareStep.getStepData()).hasMore());
            if (this.getSuccessUsers() > 0) {
                this.log().success("Successfully made " + this.getSuccessUsers() + " persons entry in entsec database");
            }
            if (this.getFailedUsers() > 0) {
                this.log().failed("Error making person entry in entsec database, skipping persons " + this.getFailedUsers() + " with DN");
            }
        }
        if (!isImportReady) {
            String msg = "Failed to prepare the entsec system for LDAP import";
            this.log(new LdapImportLogEntry(msg, AuditLogEntryStatus.ERROR, true), true);
            throw new Exception(msg);
        }
        return new ImportStatus(isImportReady, allUsersImported);
    }

    private LdapImportStep getPrepareDataStep() {
        if (this.userVector != null) {
            return new LdapImportPeriodicImportStep(this.server);
        }
        return new LdapImportPrepareStep(this.server);
    }

    private OrionSession getOrionSession() {
        return LdapImportUtils.getOrionSession();
    }

    private void closeOrionSession(OrionSession orionSession) {
        if (orionSession != null) {
            orionSession.close();
            orionSession = null;
        }
    }

    public abstract void userAdded(UserImportCallback var1, boolean var2);

    public void addAuditLogEntry(UserImportCallback userImportCallback) {
        BAccessControlService accessControlService = (BAccessControlService)Sys.getService((Type)BAccessControlService.TYPE);
        HistoryManager historyManager = accessControlService.getHistoryManager();
        Context ctx = userImportCallback.getContext();
        BLDAPAuditRecord auditRecord = new BLDAPAuditRecord();
        auditRecord.setTimestamp(BAbsTime.now());
        auditRecord.setLdapServerOrd(this.server.getSlotPathOrd());
        auditRecord.setActivity(BLDAPActivityEnum.importPersonnel);
        if (ctx != null && ctx.getUser() != null) {
            auditRecord.setOwner(ctx.getUser().getUsername());
        } else {
            auditRecord.setOwner("Periodc Import");
        }
        auditRecord.setStatus(userImportCallback.getUserImportStatus().name());
        auditRecord.setDetails(userImportCallback.getDetails());
        historyManager.append(auditRecord);
    }

    public boolean getMandatoryAttributesMapped() {
        return this.mandatoryAttributesMapped;
    }

    public int getFailedUsers() {
        return this.failedUsers;
    }

    public int getSuccessUsers() {
        return this.successUsers;
    }

    public class ImportStatus {
        private boolean isImportReady;
        private boolean allUsersImported;

        public ImportStatus(boolean isImportReady, boolean allUsersImported) {
            this.isImportReady = isImportReady;
            this.allUsersImported = allUsersImported;
        }

        public boolean isImportReady() {
            return this.isImportReady;
        }

        public void setImportReady(boolean isImportReady) {
            this.isImportReady = isImportReady;
        }

        public boolean isAllUsersImported() {
            return this.allUsersImported;
        }

        public void setAllUsersImported(boolean allUsersImported) {
            this.allUsersImported = allUsersImported;
        }
    }
}

