/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec.ldap.importconfig;

import com.tridiumx.entsec.ldap.importconfig.BLdapForceImportJob;
import com.tridiumx.entsec.ldap.importconfig.BLdapImportFrequency;
import com.tridiumx.entsec.ldap.importconfig.BLdapPeriodicImportJob;
import com.tridiumx.ldapDriver.BLdapServer;
import com.tridiumx.ldapDriver.users.BLdapUser;
import com.tridiumx.ldapDriver.util.LdapDriverUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIMixIn;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.BVector;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType(agent={@AgentOn(types={"ldapDriver:LdapServer"}, app="entsec", requiredPermissions="r")})
@NiagaraProperties(value={@NiagaraProperty(name="importFrequency", type="BLdapImportFrequency", defaultValue="BLdapImportFrequency.daily"), @NiagaraProperty(name="lastImportTime", type="BAbsTime", defaultValue="BAbsTime.NULL", flags=1), @NiagaraProperty(name="groupAttribute", type="String", defaultValue=""), @NiagaraProperty(name="allowNewInactiveUsers", type="boolean", defaultValue="true"), @NiagaraProperty(name="statusAttribute", type="String", defaultValue=""), @NiagaraProperty(name="activeStatusValues", type="String", defaultValue=""), @NiagaraProperty(name="accountExpiryDateTimeAttribute", type="String", defaultValue=""), @NiagaraProperty(name="changeLog", type="BVector", defaultValue="new BVector()", flags=5)})
@NiagaraActions(value={@NiagaraAction(name="ldapIncrementalImport", parameterType="BVector", defaultValue="new BVector()", flags=5), @NiagaraAction(name="ldapForceImport"), @NiagaraAction(name="handleLdapEntries", parameterType="BVector", defaultValue="new BVector()", flags=4), @NiagaraAction(name="resetLastImportTime", flags=4), @NiagaraAction(name="commitImportFrequency", flags=4)})
public class BLdapImportConfig
extends BComponent
implements BIMixIn {
    @Generated
    public static final Property importFrequency = BLdapImportConfig.newProperty((int)0, (BValue)BLdapImportFrequency.daily, null);
    @Generated
    public static final Property lastImportTime = BLdapImportConfig.newProperty((int)1, (BValue)BAbsTime.NULL, null);
    @Generated
    public static final Property groupAttribute = BLdapImportConfig.newProperty((int)0, (String)"", null);
    @Generated
    public static final Property allowNewInactiveUsers = BLdapImportConfig.newProperty((int)0, (boolean)true, null);
    @Generated
    public static final Property statusAttribute = BLdapImportConfig.newProperty((int)0, (String)"", null);
    @Generated
    public static final Property activeStatusValues = BLdapImportConfig.newProperty((int)0, (String)"", null);
    @Generated
    public static final Property accountExpiryDateTimeAttribute = BLdapImportConfig.newProperty((int)0, (String)"", null);
    @Generated
    public static final Property changeLog = BLdapImportConfig.newProperty((int)5, (BValue)new BVector(), null);
    @Generated
    public static final Action ldapIncrementalImport = BLdapImportConfig.newAction((int)5, (BValue)new BVector(), null);
    @Generated
    public static final Action ldapForceImport = BLdapImportConfig.newAction((int)0, null);
    @Generated
    public static final Action handleLdapEntries = BLdapImportConfig.newAction((int)4, (BValue)new BVector(), null);
    @Generated
    public static final Action resetLastImportTime = BLdapImportConfig.newAction((int)4, null);
    @Generated
    public static final Action commitImportFrequency = BLdapImportConfig.newAction((int)4, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BLdapImportConfig.class);
    private List<String> validStatusList = null;
    private Clock.Ticket ticket;
    public static final String LDAP_SUBSCRIBE = "ldapSubscribe";

    @Generated
    public BLdapImportFrequency getImportFrequency() {
        return (BLdapImportFrequency)this.get(importFrequency);
    }

    @Generated
    public void setImportFrequency(BLdapImportFrequency v) {
        this.set(importFrequency, (BValue)v, null);
    }

    @Generated
    public BAbsTime getLastImportTime() {
        return (BAbsTime)this.get(lastImportTime);
    }

    @Generated
    public void setLastImportTime(BAbsTime v) {
        this.set(lastImportTime, (BValue)v, null);
    }

    @Generated
    public String getGroupAttribute() {
        return this.getString(groupAttribute);
    }

    @Generated
    public void setGroupAttribute(String v) {
        this.setString(groupAttribute, v, null);
    }

    @Generated
    public boolean getAllowNewInactiveUsers() {
        return this.getBoolean(allowNewInactiveUsers);
    }

    @Generated
    public void setAllowNewInactiveUsers(boolean v) {
        this.setBoolean(allowNewInactiveUsers, v, null);
    }

    @Generated
    public String getStatusAttribute() {
        return this.getString(statusAttribute);
    }

    @Generated
    public void setStatusAttribute(String v) {
        this.setString(statusAttribute, v, null);
    }

    @Generated
    public String getActiveStatusValues() {
        return this.getString(activeStatusValues);
    }

    @Generated
    public void setActiveStatusValues(String v) {
        this.setString(activeStatusValues, v, null);
    }

    @Generated
    public String getAccountExpiryDateTimeAttribute() {
        return this.getString(accountExpiryDateTimeAttribute);
    }

    @Generated
    public void setAccountExpiryDateTimeAttribute(String v) {
        this.setString(accountExpiryDateTimeAttribute, v, null);
    }

    @Generated
    public BVector getChangeLog() {
        return (BVector)this.get(changeLog);
    }

    @Generated
    public void setChangeLog(BVector v) {
        this.set(changeLog, (BValue)v, null);
    }

    @Generated
    public void ldapIncrementalImport(BVector parameter) {
        this.invoke(ldapIncrementalImport, (BValue)parameter, null);
    }

    @Generated
    public void ldapForceImport() {
        this.invoke(ldapForceImport, null, null);
    }

    @Generated
    public void handleLdapEntries(BVector parameter) {
        this.invoke(handleLdapEntries, (BValue)parameter, null);
    }

    @Generated
    public void resetLastImportTime() {
        this.invoke(resetLastImportTime, null, null);
    }

    @Generated
    public void commitImportFrequency() {
        this.invoke(commitImportFrequency, null, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        BLdapServer server = (BLdapServer)this.getParent();
        if (this.get(LDAP_SUBSCRIBE) != null) {
            this.remove(LDAP_SUBSCRIBE);
        }
        this.linkTo(LDAP_SUBSCRIBE, (BComponent)server, (Slot)BLdapServer.ldapEntryChanged, (Slot)handleLdapEntries);
        this.doCommitImportFrequency();
    }

    public void doCommitImportFrequency() {
        BLdapServer server = (BLdapServer)this.getParent();
        LdapDriverUtil.checkFeatureLicense((BLdapServer)server);
        if (this.ticket != null && !this.ticket.isExpired()) {
            this.ticket.cancel();
        }
        if (!BLdapImportFrequency.instant.equals((Object)this.getImportFrequency())) {
            BRelTime period = BRelTime.makeHours((int)this.getImportFrequency().getOrdinal());
            this.ticket = Clock.schedulePeriodically((BComponent)this, (BRelTime)period, (Action)ldapIncrementalImport, (BValue)this.getChangeLog());
        } else {
            this.ldapIncrementalImport(this.getChangeLog());
        }
    }

    public void stopped() throws Exception {
        if (this.get(LDAP_SUBSCRIBE) != null) {
            this.remove(LDAP_SUBSCRIBE);
        }
        if (this.ticket != null && !this.ticket.isExpired()) {
            this.ticket.cancel();
        }
    }

    public void doLdapIncrementalImport(BVector vector, Context ctx) {
        BLdapServer server = (BLdapServer)this.getParent();
        LdapDriverUtil.checkFeatureLicense((BLdapServer)server);
        BLdapPeriodicImportJob job = new BLdapPeriodicImportJob(server, this.getChangeLog());
        if (ctx != null) {
            job.submit(ctx);
        } else {
            job.submit((Context)new BasicContext(this.getSession().getSessionContext()));
        }
    }

    public void doHandleLdapEntries(BVector vector) {
        BLdapServer server = (BLdapServer)this.getParent();
        LdapDriverUtil.checkFeatureLicense((BLdapServer)server);
        BLdapUser[] users = (BLdapUser[])vector.getChildren(BLdapUser.class);
        BVector changeLog = this.getChangeLog();
        for (int i = 0; i < users.length; ++i) {
            String key = SlotPath.escape((String)users[i].getDistinguishedName());
            if (changeLog.get(key) == null) {
                changeLog.add(key, users[i].newCopy());
                continue;
            }
            changeLog.set(key, users[i].newCopy());
        }
        if (this.getImportFrequency().equals((Object)BLdapImportFrequency.instant)) {
            this.ldapIncrementalImport(changeLog);
        }
    }

    public void doLdapForceImport(Context ctx) {
        BLdapServer server = (BLdapServer)this.getParent();
        LdapDriverUtil.checkFeatureLicense((BLdapServer)server);
        BLdapForceImportJob job = new BLdapForceImportJob(server);
        job.submit(ctx);
    }

    public void doResetLastImportTime() {
        BLdapServer server = (BLdapServer)this.getParent();
        LdapDriverUtil.checkFeatureLicense((BLdapServer)server);
        this.setLastImportTime(BAbsTime.NULL);
    }

    public String getDisplayNameInParent(Context cx) {
        return "LdapImportConfig";
    }

    public synchronized List<String> getValidStatusList() {
        if (this.validStatusList == null) {
            this.validStatusList = new ArrayList<String>();
            String statusValues = this.getActiveStatusValues();
            if (statusValues != null && !"".equals(statusValues.trim())) {
                String[] fragments = statusValues.split(",");
                this.validStatusList = Arrays.asList(fragments);
            }
        }
        return this.validStatusList;
    }

    public synchronized void updateValidStatusList() {
        this.validStatusList = new ArrayList<String>();
        String statusValues = this.getActiveStatusValues();
        if (statusValues != null && !"".equals(statusValues.trim())) {
            String[] fragments = statusValues.split(",");
            this.validStatusList = Arrays.asList(fragments);
        }
    }
}

