/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec.intrusion.schema;

import com.tridium.orion.BIOrionApp;
import com.tridium.orion.BLocalOrionDatabase;
import com.tridium.orion.BOrionDatabase;
import com.tridium.orion.BSchemaVersion;
import com.tridium.orion.ISchemaUpgrader;
import com.tridium.orion.OrionSession;
import com.tridiumx.entsec.BEnterpriseSecurityService;
import com.tridiumx.entsec.intrusion.BIntrusionService;
import com.tridiumx.entsec.intrusion.orion.BIntrusionPin;
import com.tridiumx.entsec.orionTools.SchemaUpgradeSupport;
import java.util.logging.Level;
import javax.baja.rdb.ddl.AlterColumn;
import javax.baja.rdb.ddl.DdlCommand;

public class Upgrade_1_4_to_1_5
implements ISchemaUpgrader {
    private static final BSchemaVersion FROM_VERSION = BIntrusionService.VERSION_1_4;
    private static final BSchemaVersion TO_VERSION = BIntrusionService.VERSION_1_5;
    private static final int WIDTH = 255;

    public BSchemaVersion getFromVersion() {
        return FROM_VERSION;
    }

    public BSchemaVersion getToVersion() {
        return TO_VERSION;
    }

    public static void upgradeIntrusionPinNumber(BOrionDatabase db, OrionSession session) throws Exception {
        AlterColumn ddl = SchemaUpgradeSupport.alterColumnWidth(BIntrusionPin.ORION_TYPE, BIntrusionPin.pinNumber, db, 255);
        session.invokeDdl((DdlCommand)ddl);
    }

    public void upgrade(BLocalOrionDatabase db, BIOrionApp app, OrionSession session) throws Exception {
        try {
            Upgrade_1_4_to_1_5.upgradeIntrusionPinNumber((BOrionDatabase)db, session);
            ((BIntrusionService)app).encryptPinNumbers = true;
        }
        catch (Exception e) {
            BEnterpriseSecurityService.LOG.log(Level.SEVERE, "Upgrade_1_4_to_1_5 Schema Upgrade either not needed or failed", e);
            throw e;
        }
    }
}

