/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec.intrusion;

import com.tridium.orion.OrionCursor;
import com.tridium.orion.OrionSession;
import com.tridiumx.accessDriver.BAccessReader;
import com.tridiumx.accessDriver.BValidationInfo;
import com.tridiumx.accessDriver.enums.activity.BBadgeActivity;
import com.tridiumx.accessDriver.enums.activity.BIntrusionStatusEnum;
import com.tridiumx.entsec.intrusion.BIntrusionService;
import com.tridiumx.entsec.intrusion.BIntrusionZone;
import com.tridiumx.entsec.intrusion.IntrusionUtil;
import com.tridiumx.entsec.intrusion.orion.BIntrusionPin;
import com.tridiumx.entsec.intrusion.orion.BIntrusionZoneRec;
import com.tridiumx.entsec.orionTools.BScheduleRec;
import com.tridiumx.entsec.securityUtil.BActivityRecord;
import javax.baja.schedule.BBooleanSchedule;
import javax.baja.sys.BComponent;
import javax.baja.sys.BLink;
import javax.baja.sys.Knob;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public abstract class ValidationUtil {
    private static boolean HANDLED = true;
    private static boolean VALIDATED = true;

    public static boolean validatePin(BAccessReader location, String pinNumber, OrionSession session) {
        return ValidationUtil.validateIntrusionToggle(location, pinNumber, session);
    }

    private static boolean validateIntrusionToggle(BAccessReader reader, String pinNumber, OrionSession session) {
        BIntrusionPin intrusionPin = null;
        String intrusionPinDescription = "Intrusion Activation Failed";
        BIntrusionService service = (BIntrusionService)Sys.getService((Type)BIntrusionService.TYPE);
        try {
            Integer.parseInt(pinNumber);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        OrionCursor cursor = session.scan(BIntrusionPin.ORION_TYPE);
        while (cursor.next()) {
            BIntrusionPin pin = (BIntrusionPin)cursor.get();
            if (!pin.getPinNumber().validate(pinNumber) || pin.getIntrusionZones(session).toArray().length <= 0) continue;
            intrusionPin = pin;
            break;
        }
        if (intrusionPin == null) {
            reader.makeAlarm(BBadgeActivity.invalidPinNumber, "", intrusionPinDescription, IntrusionUtil.text("intrusionPin"), null);
            service.fireNewActivity(new BActivityRecord());
            return false;
        }
        BBooleanSchedule schedule = null;
        BScheduleRec scheduleRec = intrusionPin.resolveSchedule(session);
        if (scheduleRec != null) {
            schedule = (BBooleanSchedule)scheduleRec.getMappedOrd().get();
        }
        intrusionPinDescription = intrusionPin.getIntrusionPinName();
        if (schedule == null || !schedule.getOut().getValue()) {
            reader.makeAlarm(BBadgeActivity.noActiveSchedule, "", intrusionPinDescription, IntrusionUtil.text("intrusionPin"), null);
            return false;
        }
        BIntrusionZoneRec[] intrusionZonesRecs = (BIntrusionZoneRec[])intrusionPin.getIntrusionZones(session).toArray();
        BValidationInfo info = new BValidationInfo();
        info.setReaderHandle(reader.getHandle().toString());
        info.setAuthorization(IntrusionUtil.text("pinAuthorization", new Object[]{intrusionPinDescription}));
        IntrusionRedirect redirect = ValidationUtil.intrusionRedirect(reader, info, intrusionZonesRecs);
        if (!redirect.handled) {
            reader.badgeValidated(info);
        } else if (!redirect.validated) {
            intrusionPinDescription = IntrusionUtil.text("notValidOnThisReader", new Object[]{intrusionPinDescription});
            reader.makeAlarm(BBadgeActivity.invalidPinNumber, "", intrusionPinDescription, IntrusionUtil.text("intrusionPin"), null);
            return false;
        }
        return true;
    }

    public static boolean matchIntrusionZone(BIntrusionZone zone, BIntrusionZoneRec[] intrusionZoneRecs) {
        if (intrusionZoneRecs == null) {
            return true;
        }
        for (int i = 0; i < intrusionZoneRecs.length; ++i) {
            if (!intrusionZoneRecs[i].getMappedDisplayPath().equals(zone.toDisplayPathString(null))) continue;
            return true;
        }
        return false;
    }

    public static IntrusionRedirect intrusionRedirect(BAccessReader reader, BValidationInfo info, BIntrusionZoneRec[] intrusionZoneRecs) {
        BIntrusionZone zone;
        int i;
        Knob[] knobs = reader.getKnobs((Slot)BAccessReader.accessValidated);
        BLink[] links = new BLink[knobs.length];
        if (knobs.length < 2 && intrusionZoneRecs == null) {
            return new IntrusionRedirect(!HANDLED, VALIDATED);
        }
        int zones = 0;
        BComponent[] targets = new BComponent[knobs.length];
        boolean allDisarmed = true;
        boolean noMatches = true;
        for (i = 0; i < targets.length; ++i) {
            targets[i] = knobs[i].getTargetComponent();
            links[i] = knobs[i].getLink();
            if (!(targets[i] instanceof BIntrusionZone)) continue;
            ++zones;
            zone = (BIntrusionZone)targets[i];
            if (!ValidationUtil.matchIntrusionZone(zone, intrusionZoneRecs)) continue;
            noMatches = false;
            if (zone.getZoneStatus() == BIntrusionStatusEnum.disarmed || zone.getZoneStatus() == BIntrusionStatusEnum.unableToArm) continue;
            allDisarmed = false;
        }
        if (noMatches && intrusionZoneRecs != null) {
            return new IntrusionRedirect(HANDLED, !VALIDATED);
        }
        if (zones <= 1) {
            return new IntrusionRedirect(!HANDLED, VALIDATED);
        }
        if (allDisarmed) {
            int i2;
            boolean successfulArm = true;
            for (i2 = 0; i2 < targets.length; ++i2) {
                if (targets[i2] instanceof BIntrusionZone) {
                    if (!ValidationUtil.matchIntrusionZone((BIntrusionZone)targets[i2], intrusionZoneRecs)) {
                        links[i2].deactivate();
                        continue;
                    }
                    BIntrusionZone zone2 = (BIntrusionZone)targets[i2];
                    String activePoints = zone2.doArmingTest(null).toString();
                    if (activePoints.length() > 0) {
                        successfulArm = false;
                        continue;
                    }
                    links[i2].deactivate();
                    continue;
                }
                links[i2].deactivate();
            }
            if (!successfulArm) {
                reader.badgeValidated(info);
            } else if (intrusionZoneRecs != null) {
                for (i2 = 0; i2 < targets.length; ++i2) {
                    if (!(targets[i2] instanceof BIntrusionZone) || !ValidationUtil.matchIntrusionZone((BIntrusionZone)targets[i2], intrusionZoneRecs)) continue;
                    links[i2].activate();
                }
                reader.badgeValidated(info);
            }
            for (i2 = 0; i2 < targets.length; ++i2) {
                links[i2].activate();
            }
            return new IntrusionRedirect(!successfulArm || intrusionZoneRecs != null, VALIDATED);
        }
        for (i = 0; i < targets.length; ++i) {
            if (!(targets[i] instanceof BIntrusionZone) || (zone = (BIntrusionZone)targets[i]).getZoneStatus() != BIntrusionStatusEnum.disarmed && zone.getZoneStatus() != BIntrusionStatusEnum.unableToArm && ValidationUtil.matchIntrusionZone(zone, intrusionZoneRecs)) continue;
            links[i].deactivate();
        }
        reader.badgeValidated(info);
        for (i = 0; i < targets.length; ++i) {
            if (!(targets[i] instanceof BIntrusionZone)) continue;
            links[i].activate();
        }
        return new IntrusionRedirect(HANDLED, VALIDATED);
    }

    static /* synthetic */ boolean access$000() {
        return VALIDATED;
    }

    static /* synthetic */ boolean access$100() {
        return HANDLED;
    }

    private static class IntrusionRedirect {
        public boolean validated = ValidationUtil.access$000();
        public boolean handled = ValidationUtil.access$100();

        IntrusionRedirect() {
        }

        IntrusionRedirect(boolean h, boolean v) {
            this.handled = h;
            this.validated = v;
        }
    }
}

