/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec.filter;

import com.tridiumx.entsec.filter.BDynamicRecentTimeRangeType;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BSimple;
import javax.baja.sys.BTime;
import javax.baja.sys.BWeekday;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BIValidator;
import javax.baja.util.CannotValidateException;

@NiagaraType
public final class BDynamicRecentTimeRange
extends BSimple
implements BIValidator {
    public static final BDynamicRecentTimeRange LAST_5_MINUTES = new BDynamicRecentTimeRange(BDynamicRecentTimeRangeType.last5Minutes);
    public static final BDynamicRecentTimeRange LAST_20_MINUTES = new BDynamicRecentTimeRange(BDynamicRecentTimeRangeType.last20Minutes);
    public static final BDynamicRecentTimeRange LAST_HOUR = new BDynamicRecentTimeRange(BDynamicRecentTimeRangeType.lastHour);
    public static final BDynamicRecentTimeRange LAST_12_HOURS = new BDynamicRecentTimeRange(BDynamicRecentTimeRangeType.last12Hours);
    public static final BDynamicRecentTimeRange TODAY = new BDynamicRecentTimeRange(BDynamicRecentTimeRangeType.today);
    public static final BDynamicRecentTimeRange LAST_24_HOURS = new BDynamicRecentTimeRange(BDynamicRecentTimeRangeType.last24Hours);
    public static final BDynamicRecentTimeRange YESTERDAY = new BDynamicRecentTimeRange(BDynamicRecentTimeRangeType.yesterday);
    public static final BDynamicRecentTimeRange WEEK_TO_DATE = new BDynamicRecentTimeRange(BDynamicRecentTimeRangeType.weekToDate);
    public static final BDynamicRecentTimeRange LAST_WEEK = new BDynamicRecentTimeRange(BDynamicRecentTimeRangeType.lastWeek);
    public static final BDynamicRecentTimeRange LAST_7_DAYS = new BDynamicRecentTimeRange(BDynamicRecentTimeRangeType.last7Days);
    private static final BTime LAST_INSTANT = BTime.make((int)23, (int)59, (int)59, (int)999);
    public static final BDynamicRecentTimeRange DEFAULT = LAST_12_HOURS;
    public static final Type TYPE = Sys.loadType(BDynamicRecentTimeRange.class);
    private static final HashMap<String, BDynamicRecentTimeRange> byId = new HashMap();
    private BDynamicRecentTimeRangeType rangeType;
    private BAbsTime startTime;
    private BAbsTime endTime;

    public Type getType() {
        return TYPE;
    }

    private BDynamicRecentTimeRange() {
        this(BDynamicRecentTimeRangeType.today);
    }

    private BDynamicRecentTimeRange(BDynamicRecentTimeRangeType rangeType) {
        this.rangeType = rangeType;
        this.startTime = this.endTime = BAbsTime.NULL;
    }

    public static BDynamicRecentTimeRange make(BDynamicRecentTimeRangeType rangeType) {
        if (rangeType == BDynamicRecentTimeRangeType.last5Minutes) {
            return LAST_5_MINUTES;
        }
        if (rangeType == BDynamicRecentTimeRangeType.last20Minutes) {
            return LAST_20_MINUTES;
        }
        if (rangeType == BDynamicRecentTimeRangeType.lastHour) {
            return LAST_HOUR;
        }
        if (rangeType == BDynamicRecentTimeRangeType.last12Hours) {
            return LAST_12_HOURS;
        }
        if (rangeType == BDynamicRecentTimeRangeType.today) {
            return TODAY;
        }
        if (rangeType == BDynamicRecentTimeRangeType.last24Hours) {
            return LAST_24_HOURS;
        }
        if (rangeType == BDynamicRecentTimeRangeType.yesterday) {
            return YESTERDAY;
        }
        if (rangeType == BDynamicRecentTimeRangeType.weekToDate) {
            return WEEK_TO_DATE;
        }
        if (rangeType == BDynamicRecentTimeRangeType.lastWeek) {
            return LAST_WEEK;
        }
        if (rangeType == BDynamicRecentTimeRangeType.last7Days) {
            return LAST_7_DAYS;
        }
        if (rangeType == BDynamicRecentTimeRangeType.timeRange) {
            throw new IllegalArgumentException("Must provide time bounds with timeRange.");
        }
        throw new IllegalArgumentException();
    }

    public static BDynamicRecentTimeRange make(String periodId) {
        BDynamicRecentTimeRange result = null;
        String key = periodId.toLowerCase();
        Iterator<String> keys = byId.keySet().iterator();
        result = byId.get(key);
        if (result == null) {
            throw new IllegalArgumentException("Invalid period id: " + periodId);
        }
        return result;
    }

    public static BDynamicRecentTimeRange make(BAbsTime startTime, BAbsTime endTime) {
        BDynamicRecentTimeRange result = new BDynamicRecentTimeRange();
        result.rangeType = BDynamicRecentTimeRangeType.timeRange;
        if (!startTime.isNull() && !endTime.isNull() && startTime.isAfter(endTime)) {
            throw new IllegalArgumentException("Start time is after End Time.");
        }
        result.startTime = startTime;
        result.endTime = endTime;
        return result;
    }

    public void validate(BObject value, Context cx) throws CannotValidateException {
        BDynamicRecentTimeRange range = (BDynamicRecentTimeRange)value;
        if (range.getRangeType() != BDynamicRecentTimeRangeType.timeRange) {
            return;
        }
        if (range.getFixedStartTime().isNull() || range.getFixedEndTime().isNull() || range.getFixedStartTime().delta(range.getFixedEndTime()).compareTo((Object)BRelTime.makeHours((int)169)) > 0) {
            throw new CannotValidateException("Start Date and End Date may not be more than 1 Week apart.");
        }
    }

    public BDynamicRecentTimeRangeType getRangeType() {
        return this.rangeType;
    }

    public BAbsTime getFixedStartTime() {
        return this.startTime;
    }

    public BAbsTime getFixedEndTime() {
        return this.endTime;
    }

    public BAbsTime getStartTime(BAbsTime currentTime) {
        if (this.rangeType == BDynamicRecentTimeRangeType.timeRange) {
            return this.startTime;
        }
        if (this.rangeType == BDynamicRecentTimeRangeType.last5Minutes) {
            return currentTime.subtract(BRelTime.make((long)300000L));
        }
        if (this.rangeType == BDynamicRecentTimeRangeType.last20Minutes) {
            return currentTime.subtract(BRelTime.make((long)1200000L));
        }
        if (this.rangeType == BDynamicRecentTimeRangeType.lastHour) {
            return currentTime.subtract(BRelTime.HOUR);
        }
        if (this.rangeType == BDynamicRecentTimeRangeType.last12Hours) {
            return currentTime.subtract(BRelTime.make((long)43200000L));
        }
        if (this.rangeType == BDynamicRecentTimeRangeType.today) {
            return BAbsTime.make((BAbsTime)currentTime, (BTime)BTime.MIDNIGHT);
        }
        if (this.rangeType == BDynamicRecentTimeRangeType.last24Hours) {
            return currentTime.subtract(BRelTime.DAY);
        }
        if (this.rangeType == BDynamicRecentTimeRangeType.yesterday) {
            return BAbsTime.make((BAbsTime)currentTime.prevDay(), (BTime)BTime.MIDNIGHT);
        }
        if (this.rangeType == BDynamicRecentTimeRangeType.weekToDate) {
            BAbsTime day = currentTime;
            while (day.getWeekday() != BWeekday.sunday) {
                day = day.prevDay();
            }
            return BAbsTime.make((BAbsTime)day, (BTime)BTime.MIDNIGHT);
        }
        if (this.rangeType == BDynamicRecentTimeRangeType.lastWeek) {
            BAbsTime day = currentTime;
            while (day.getWeekday() != BWeekday.sunday) {
                day = day.prevDay();
            }
            day = day.prevDay();
            while (day.getWeekday() != BWeekday.sunday) {
                day = day.prevDay();
            }
            return BAbsTime.make((BAbsTime)day, (BTime)BTime.MIDNIGHT);
        }
        if (this.rangeType == BDynamicRecentTimeRangeType.last7Days) {
            BAbsTime day = currentTime;
            for (int i = 0; i < 7; ++i) {
                day = day.prevDay();
            }
            return BAbsTime.make((BAbsTime)day, (BTime)BTime.MIDNIGHT);
        }
        throw new IllegalStateException("Unsupported range type: " + (Object)((Object)this.rangeType));
    }

    public BAbsTime getEndTime(BAbsTime currentTime) {
        if (this.rangeType == BDynamicRecentTimeRangeType.timeRange) {
            return this.endTime;
        }
        if (this.rangeType == BDynamicRecentTimeRangeType.last5Minutes) {
            return currentTime;
        }
        if (this.rangeType == BDynamicRecentTimeRangeType.last20Minutes) {
            return currentTime;
        }
        if (this.rangeType == BDynamicRecentTimeRangeType.lastHour) {
            return currentTime;
        }
        if (this.rangeType == BDynamicRecentTimeRangeType.last12Hours) {
            return currentTime;
        }
        if (this.rangeType == BDynamicRecentTimeRangeType.today) {
            return BAbsTime.make((BAbsTime)currentTime, (BTime)LAST_INSTANT);
        }
        if (this.rangeType == BDynamicRecentTimeRangeType.last24Hours) {
            return currentTime;
        }
        if (this.rangeType == BDynamicRecentTimeRangeType.yesterday) {
            return BAbsTime.make((BAbsTime)currentTime.prevDay(), (BTime)LAST_INSTANT);
        }
        if (this.rangeType == BDynamicRecentTimeRangeType.weekToDate) {
            return currentTime;
        }
        if (this.rangeType == BDynamicRecentTimeRangeType.lastWeek) {
            BAbsTime day = currentTime;
            while (day.getWeekday() != BWeekday.sunday) {
                day = day.prevDay();
            }
            day = day.prevDay();
            return BAbsTime.make((BAbsTime)day, (BTime)LAST_INSTANT);
        }
        if (this.rangeType == BDynamicRecentTimeRangeType.last7Days) {
            BAbsTime day = currentTime;
            day = day.prevDay();
            return BAbsTime.make((BAbsTime)day, (BTime)LAST_INSTANT);
        }
        throw new IllegalStateException("Unsupported range type: " + (Object)((Object)this.rangeType));
    }

    public String toOrdParams() {
        BAbsTime end;
        if (this.rangeType != BDynamicRecentTimeRangeType.timeRange) {
            return "period=" + this.rangeType.getTag();
        }
        StringBuffer s = new StringBuffer(32);
        s.append("period=").append(this.rangeType.getTag());
        BAbsTime start = this.getFixedStartTime();
        if (start != null && !start.isNull()) {
            s.append(';').append("start=").append(start.encodeToString());
        }
        if ((end = this.getFixedEndTime()) != null && !end.isNull()) {
            s.append(';').append("end=").append(end.encodeToString());
        }
        return s.toString();
    }

    public int hashCode() {
        int hash = 23 + this.rangeType.hashCode();
        hash = hash * 37 + this.startTime.hashCode();
        return hash * 37 + this.endTime.hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof BDynamicRecentTimeRange) {
            BDynamicRecentTimeRange other = (BDynamicRecentTimeRange)((Object)o);
            return this.rangeType == other.rangeType && this.startTime.equals((Object)other.startTime) && this.endTime.equals((Object)other.endTime);
        }
        return false;
    }

    public void encode(DataOutput out) throws IOException {
        this.rangeType.encode(out);
        this.startTime.encode(out);
        this.endTime.encode(out);
    }

    public BObject decode(DataInput in) throws IOException {
        BDynamicRecentTimeRange result = new BDynamicRecentTimeRange();
        result.rangeType = (BDynamicRecentTimeRangeType)BDynamicRecentTimeRangeType.timeRange.decode(in);
        result.startTime = (BAbsTime)BAbsTime.DEFAULT.decode(in);
        result.endTime = (BAbsTime)BAbsTime.DEFAULT.decode(in);
        return result;
    }

    public String encodeToString() throws IOException {
        if (this.rangeType != BDynamicRecentTimeRangeType.timeRange) {
            return this.rangeType.encodeToString();
        }
        return this.rangeType.encodeToString() + ":startTime=" + this.startTime.encodeToString() + ";endTime=" + this.endTime.encodeToString();
    }

    public BObject decodeFromString(String s) throws IOException {
        int colon = s.indexOf(58);
        if (colon == -1) {
            return BDynamicRecentTimeRange.make(s);
        }
        int semi = s.indexOf(59);
        BDynamicRecentTimeRange result = new BDynamicRecentTimeRange();
        String typeString = s.substring(0, colon);
        if (!typeString.equals(BDynamicRecentTimeRangeType.timeRange.getTag())) {
            throw new IOException("Invalid string encoding: " + s);
        }
        result.rangeType = BDynamicRecentTimeRangeType.timeRange;
        String startParam = s.substring(colon + 1, semi);
        int eq = startParam.indexOf(61);
        if (eq == -1) {
            throw new IOException("Invalid string encoding: " + s);
        }
        if (!startParam.substring(0, eq).equals("startTime")) {
            throw new IOException("Invalid string encoding: " + s);
        }
        result.startTime = (BAbsTime)BAbsTime.DEFAULT.decodeFromString(startParam.substring(eq + 1));
        String endParam = s.substring(semi + 1);
        eq = endParam.indexOf(61);
        if (eq == -1) {
            throw new IOException("Invalid string encoding: " + s);
        }
        if (!endParam.substring(0, eq).equals("endTime")) {
            throw new IOException("Invalid string encoding: " + s);
        }
        result.endTime = (BAbsTime)BAbsTime.DEFAULT.decodeFromString(endParam.substring(eq + 1));
        return result;
    }

    static {
        byId.put(BDynamicRecentTimeRangeType.last5Minutes.getTag().toLowerCase(), LAST_5_MINUTES);
        byId.put(BDynamicRecentTimeRangeType.last20Minutes.getTag().toLowerCase(), LAST_20_MINUTES);
        byId.put(BDynamicRecentTimeRangeType.lastHour.getTag().toLowerCase(), LAST_HOUR);
        byId.put(BDynamicRecentTimeRangeType.last12Hours.getTag().toLowerCase(), LAST_12_HOURS);
        byId.put(BDynamicRecentTimeRangeType.today.getTag().toLowerCase(), TODAY);
        byId.put(BDynamicRecentTimeRangeType.last24Hours.getTag().toLowerCase(), LAST_24_HOURS);
        byId.put(BDynamicRecentTimeRangeType.yesterday.getTag().toLowerCase(), YESTERDAY);
        byId.put(BDynamicRecentTimeRangeType.weekToDate.getTag().toLowerCase(), WEEK_TO_DATE);
        byId.put(BDynamicRecentTimeRangeType.lastWeek.getTag().toLowerCase(), LAST_WEEK);
        byId.put(BDynamicRecentTimeRangeType.last7Days.getTag().toLowerCase(), LAST_7_DAYS);
    }
}

