/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec.access.util.dbCache.data;

import com.tridiumx.entsec.access.orion.BAccFloorJoin;
import com.tridiumx.entsec.access.orion.BAccFloorRec;
import com.tridiumx.entsec.access.util.dbCache.data.AbstractCacheData;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.baja.nre.util.Array;
import javax.baja.util.BUuid;

public class FloorCacheData
extends AbstractCacheData {
    private static final BUuid[] EMPTY_BUUID_ARRAY = new BUuid[0];
    private static ReentrantReadWriteLock rwLock = new ReentrantReadWriteLock();
    private String floorDisplayPath = "";
    private Map<BUuid, FloorAccessRightCacheData> accessRightsMap = new HashMap<BUuid, FloorAccessRightCacheData>();

    public FloorCacheData() {
    }

    public FloorCacheData(BAccFloorRec rec) {
        this.setFloorData(rec);
    }

    public FloorCacheData(BAccFloorJoin floorAccJoin) {
        this.insertAccessRight(floorAccJoin);
    }

    public FloorCacheData(BAccFloorRec rec, BAccFloorJoin floorAccJoin) {
        this.setFloorData(rec);
        this.insertAccessRight(floorAccJoin);
    }

    public void setFloorData(BAccFloorRec rec) {
        this.setFloorDisplayPath(rec.getFloorDisplayPath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertAccessRight(BAccFloorJoin floorAccJoin) {
        if (floorAccJoin != null && !floorAccJoin.isNull()) {
            FloorCacheData.getWriteLock(rwLock);
            try {
                BUuid key = (BUuid)floorAccJoin.getAccessRight().getId();
                if (!this.containsAccessRight(key)) {
                    FloorAccessRightCacheData data = new FloorAccessRightCacheData(floorAccJoin);
                    this.addAccessRightEntry(key, data);
                }
            }
            finally {
                FloorCacheData.releaseWriteLock(rwLock);
            }
        }
    }

    private void addAccessRightEntry(BUuid key, FloorAccessRightCacheData data) {
        FloorCacheData.getWriteLock(rwLock);
        try {
            if (!data.isEmpty()) {
                this.accessRightsMap.put(key, data);
            } else {
                this.deleteAccessRight(key);
            }
        }
        finally {
            FloorCacheData.releaseWriteLock(rwLock);
        }
    }

    public void deleteAccessRight(BUuid accessRightUuid) {
        FloorCacheData.getWriteLock(rwLock);
        try {
            this.accessRightsMap.remove(accessRightUuid);
        }
        finally {
            FloorCacheData.releaseWriteLock(rwLock);
        }
    }

    public String getFloorDisplayPath() {
        return this.floorDisplayPath;
    }

    public void setFloorDisplayPath(String value) {
        this.floorDisplayPath = value != null && value.length() > 0 ? value : "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BUuid[] getAccessRightUuids() {
        FloorCacheData.getReadLock(rwLock);
        try {
            if (this.accessRightsMap.isEmpty()) {
                BUuid[] bUuidArray = EMPTY_BUUID_ARRAY;
                return bUuidArray;
            }
            Array arr = new Array(BUuid.class);
            Set<Map.Entry<BUuid, FloorAccessRightCacheData>> set = this.accessRightsMap.entrySet();
            for (Map.Entry<BUuid, FloorAccessRightCacheData> me : set) {
                BUuid accessRightUuid = me.getKey();
                if (accessRightUuid == null || accessRightUuid.equals((Object)BUuid.DEFAULT)) continue;
                arr.add((Object)accessRightUuid);
            }
            BUuid[] bUuidArray = (BUuid[])arr.trim();
            return bUuidArray;
        }
        finally {
            FloorCacheData.releaseReadLock(rwLock);
        }
    }

    public boolean containsAccessRight(BUuid key) {
        FloorCacheData.getReadLock(rwLock);
        try {
            boolean bl = this.accessRightsMap.containsKey(key);
            return bl;
        }
        finally {
            FloorCacheData.releaseReadLock(rwLock);
        }
    }

    public BAccFloorRec getFloor(BUuid uuid) {
        BAccFloorRec floor = new BAccFloorRec();
        floor.setUuid(uuid);
        floor.setFloorDisplayPath(this.getFloorDisplayPath());
        floor.clearAllModified();
        return floor;
    }

    public void printMap() {
        FloorCacheData.getReadLock(rwLock);
        try {
            BUuid[] uuids = this.getAccessRightUuids();
            if (uuids.length == 0) {
                System.out.println("    <No Access Rights>");
            } else {
                if (uuids.length == 1) {
                    System.out.println("    Access Right:");
                } else {
                    System.out.println("    Access Rights:");
                }
                for (int i = 0; i < uuids.length; ++i) {
                    System.out.println("      " + uuids[i].toString());
                }
            }
        }
        finally {
            FloorCacheData.releaseReadLock(rwLock);
        }
    }

    private class FloorAccessRightCacheData {
        private FloorAccessRightCacheData(BAccFloorJoin floorAccJoin) {
            this.setData(floorAccJoin);
        }

        private void setData(BAccFloorJoin floorAccJoin) {
        }

        private boolean isEmpty() {
            return false;
        }
    }
}

