/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec.access.util.dbCache.data;

import com.tridium.orion.BOrionTypeId;
import com.tridium.orion.BRef;
import com.tridiumx.entsec.access.orion.BBadge;
import com.tridiumx.entsec.access.orion.BBadgeStatus;
import com.tridiumx.entsec.access.orion.BPerson;
import com.tridiumx.entsec.access.orion.BWiegandFormat;
import com.tridiumx.entsec.access.util.dbCache.data.AbstractCacheData;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BSimple;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.util.BTypeSpec;
import javax.baja.util.BUuid;

public class BadgeCacheData
extends AbstractCacheData {
    private String credential = null;
    private String facilityCode = null;
    private String description = null;
    private BUuid wiegandFormat = BUuid.DEFAULT;
    private int status = 0;
    private BAbsTime issueDate = BAbsTime.DEFAULT;
    private BAbsTime expirationDate = BAbsTime.DEFAULT;
    private BUuid owner = BUuid.DEFAULT;
    private String badgeId = null;

    private BadgeCacheData() {
        this.init();
    }

    private BadgeCacheData(BBadge rec) {
        this.setData(rec);
    }

    public static BadgeCacheData make() {
        return new BadgeCacheData();
    }

    public static BadgeCacheData make(BBadge rec) {
        return new BadgeCacheData(rec);
    }

    private void init() {
        BValue value = null;
        value = BBadge.badgeId.getDefaultValue();
        if (value instanceof BString) {
            this.setBadgeId(((BString)value).getString());
        }
        if ((value = BBadge.credential.getDefaultValue()) instanceof BString) {
            this.setCredential(((BString)value).getString());
        }
        if ((value = BBadge.facilityCode.getDefaultValue()) instanceof BString) {
            this.setFacilityCode(((BString)value).getString());
        }
        if ((value = BBadge.bDescription.getDefaultValue()) instanceof BString) {
            this.setDescription(((BString)value).getString());
        }
        if ((value = BBadge.wiegandFormat.getDefaultValue()) instanceof BRef) {
            this.setWiegandFormat((BRef)value);
        }
        if ((value = BBadge.status.getDefaultValue()) instanceof BBadgeStatus) {
            this.setStatus((BBadgeStatus)value);
        }
        if ((value = BBadge.issueDate.getDefaultValue()) instanceof BAbsTime) {
            this.setIssueDate((BAbsTime)value);
        }
        if ((value = BBadge.expirationDate.getDefaultValue()) instanceof BAbsTime) {
            this.setExpirationDate((BAbsTime)value);
        }
        if ((value = BBadge.owner.getDefaultValue()) instanceof BRef) {
            this.setOwner((BRef)value);
        }
    }

    public void setData(BBadge rec) {
        this.setCredential(rec.getCredential());
        this.setFacilityCode(rec.getFacilityCode());
        this.setDescription(rec.getBDescription());
        this.setWiegandFormat(rec.getWiegandFormat());
        this.setStatus(rec.getStatus());
        this.setIssueDate(rec.getIssueDate());
        this.setExpirationDate(rec.getExpirationDate());
        this.setOwner(rec.getOwner());
        this.setBadgeId(rec.getBadgeId());
    }

    public String getBadgeId() {
        return this.badgeId;
    }

    public void setBadgeId(String value) {
        this.badgeId = value;
    }

    public String getCredential() {
        return this.credential;
    }

    public void setCredential(String value) {
        this.credential = value;
    }

    public String getFacilityCode() {
        return this.facilityCode;
    }

    public void setFacilityCode(String value) {
        this.facilityCode = value;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String value) {
        this.description = value;
    }

    public BUuid getWiegandFormat() {
        return this.wiegandFormat;
    }

    public void setWiegandFormat(BRef ref) {
        this.wiegandFormat = ref != null && ref.isBound() ? (BUuid)ref.getId() : BUuid.DEFAULT;
    }

    public BBadgeStatus getStatus() {
        return BBadgeStatus.make(this.status);
    }

    public void setStatus(BBadgeStatus value) {
        this.status = value.getOrdinal();
    }

    public BAbsTime getIssueDate() {
        return this.issueDate;
    }

    public void setIssueDate(BAbsTime value) {
        this.issueDate = value;
    }

    public BAbsTime getExpirationDate() {
        return this.expirationDate;
    }

    public void setExpirationDate(BAbsTime value) {
        this.expirationDate = value;
    }

    public BUuid getOwner() {
        return this.owner;
    }

    public void setOwner(BRef ref) {
        this.owner = ref != null && ref.isBound() ? (BUuid)ref.getId() : BUuid.DEFAULT;
    }

    public BBadge getBadge() {
        BBadge badge = new BBadge();
        badge.setBadgeId(this.badgeId);
        badge.setCredential(this.credential);
        badge.setFacilityCode(this.facilityCode);
        badge.setBDescription(this.description);
        if (!this.wiegandFormat.equals((Object)BUuid.DEFAULT)) {
            badge.setWiegandFormat(BRef.make((BOrionTypeId)BWiegandFormat.ORION_TYPE.getOrionTypeId(), (BSimple)this.wiegandFormat));
        }
        badge.setStatus(this.getStatus());
        badge.setIssueDate(this.issueDate);
        badge.setExpirationDate(this.expirationDate);
        if (!this.owner.equals((Object)BUuid.DEFAULT)) {
            badge.setOwner(BRef.make((BTypeSpec)BPerson.TYPE.getTypeSpec(), (BSimple)this.owner));
        }
        badge.clearAllModified();
        return badge;
    }
}

