/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec.access.util.dbCache;

import com.tridium.orion.BIOrionObject;
import com.tridium.orion.BRef;
import com.tridium.orion.OrionCursor;
import com.tridium.orion.OrionSession;
import com.tridium.orion.sql.PropertyValue;
import com.tridiumx.entsec.access.orion.BAccReaderJoin;
import com.tridiumx.entsec.access.orion.BAccReaderRec;
import com.tridiumx.entsec.access.orion.BAccessRight;
import com.tridiumx.entsec.access.orion.BAccessZoneRec;
import com.tridiumx.entsec.access.orion.BEntryReaderZoneJoin;
import com.tridiumx.entsec.access.orion.BExitReaderZoneJoin;
import com.tridiumx.entsec.access.util.dbCache.AbstractCache;
import com.tridiumx.entsec.access.util.dbCache.DbCache;
import com.tridiumx.entsec.access.util.dbCache.data.BAccessRightData;
import com.tridiumx.entsec.access.util.dbCache.data.ReaderCacheData;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.baja.nre.util.Array;
import javax.baja.sys.BValue;
import javax.baja.util.BUuid;

public abstract class ReaderCache
extends AbstractCache {
    private static final BAccessRightData[] EMPTY_ACCESS_RIGHT_DATA_ARRAY = new BAccessRightData[0];
    private static final BAccessZoneRec[] EMPTY_ACCESS_ZONE_ARRAY = new BAccessZoneRec[0];
    private static final BUuid[] EMPTY_BUUID_ARRAY = new BUuid[0];
    private static ReentrantReadWriteLock rwLock = new ReentrantReadWriteLock();
    private static Map<BUuid, ReaderCacheData> readersMap = new HashMap<BUuid, ReaderCacheData>();

    public static void initReaders(DbCache dbCache, OrionSession session) {
        ReaderCache.getWriteLock(rwLock);
        try {
            readersMap.clear();
        }
        finally {
            ReaderCache.releaseWriteLock(rwLock);
        }
        if (!dbCache.isRunningOnSupervisor()) {
            OrionCursor cursor = session.scan(BAccReaderRec.ORION_TYPE);
            while (cursor.next()) {
                BAccReaderRec reader = (BAccReaderRec)cursor.get();
                ReaderCache.insertReader(dbCache, reader);
            }
            cursor.close();
        }
        ReaderCache.initAccessRights(dbCache, session);
        ReaderCache.initEntryZones(dbCache, session);
        ReaderCache.initExitZones(dbCache, session);
    }

    public static void initAccessRights(DbCache dbCache, OrionSession session) {
        if (!dbCache.isRunningOnSupervisor()) {
            OrionCursor cursor = session.scan(BAccReaderJoin.ORION_TYPE);
            while (cursor.next()) {
                BAccReaderJoin readerAccJoin = (BAccReaderJoin)((Object)cursor.get());
                ReaderCache.insertAccessRight(dbCache, readerAccJoin);
            }
            cursor.close();
        }
    }

    public static void initEntryZones(DbCache dbCache, OrionSession session) {
        if (!dbCache.isRunningOnSupervisor()) {
            OrionCursor cursor = session.scan(BEntryReaderZoneJoin.ORION_TYPE);
            while (cursor.next()) {
                BEntryReaderZoneJoin readerZoneJoin = (BEntryReaderZoneJoin)cursor.get();
                ReaderCache.insertEntryZone(dbCache, readerZoneJoin);
            }
            cursor.close();
        }
    }

    public static void initExitZones(DbCache dbCache, OrionSession session) {
        if (!dbCache.isRunningOnSupervisor()) {
            OrionCursor cursor = session.scan(BExitReaderZoneJoin.ORION_TYPE);
            while (cursor.next()) {
                BExitReaderZoneJoin readerZoneJoin = (BExitReaderZoneJoin)cursor.get();
                ReaderCache.insertExitZone(dbCache, readerZoneJoin);
            }
            cursor.close();
        }
    }

    public static void insertReader(DbCache dbCache, BAccReaderRec reader) {
        if (!dbCache.isRunningOnSupervisor()) {
            ReaderCache.getWriteLock(rwLock);
            try {
                ReaderCacheData data = ReaderCache.getCacheData(reader.getUuid());
                if (data == null) {
                    data = new ReaderCacheData(reader);
                } else {
                    data.setReaderData(reader);
                }
                ReaderCache.addMapEntry(reader.getUuid(), data);
            }
            finally {
                ReaderCache.releaseWriteLock(rwLock);
            }
        }
    }

    public static void updateReader(DbCache dbCache, BAccReaderRec reader) {
        if (!dbCache.isRunningOnSupervisor()) {
            ReaderCache.insertReader(dbCache, reader);
        }
    }

    public static void deleteReader(DbCache dbCache, BAccReaderRec reader) {
        if (!dbCache.isRunningOnSupervisor()) {
            ReaderCache.removeReader(reader.getUuid());
        }
    }

    private static void removeReader(BUuid key) {
        ReaderCache.getWriteLock(rwLock);
        try {
            readersMap.remove(key);
        }
        finally {
            ReaderCache.releaseWriteLock(rwLock);
        }
    }

    public static void insertAccessRight(DbCache dbCache, BAccReaderJoin readerAccJoin) {
        if (!dbCache.isRunningOnSupervisor()) {
            ReaderCache.insertAccessRight((BUuid)readerAccJoin.getReader().getId(), readerAccJoin);
        }
    }

    private static void insertAccessRight(BUuid readerUuid, BAccReaderJoin readerAccJoin) {
        ReaderCache.getWriteLock(rwLock);
        try {
            ReaderCacheData data = ReaderCache.getCacheData(readerUuid);
            if (data == null) {
                data = new ReaderCacheData(readerAccJoin);
            } else {
                data.insertAccessRight(readerAccJoin);
            }
            ReaderCache.addMapEntry(readerUuid, data);
        }
        finally {
            ReaderCache.releaseWriteLock(rwLock);
        }
    }

    public static void deleteAccessRight(DbCache dbCache, BAccReaderJoin readerAccJoin) {
        if (!dbCache.isRunningOnSupervisor()) {
            ReaderCache.removeAccessRight((BUuid)readerAccJoin.getReader().getId(), (BUuid)readerAccJoin.getAccessRight().getId());
        }
    }

    public static void removeReaderRecsAccessRight(DbCache dbCache, OrionSession session, BAccessRight accessRight) {
        if (!dbCache.isRunningOnSupervisor()) {
            OrionCursor cursor = session.select(BAccReaderJoin.ORION_TYPE, new PropertyValue(BAccReaderJoin.accessRight, (BValue)BRef.make((BIOrionObject)accessRight)));
            while (cursor.next()) {
                BAccReaderJoin rec = (BAccReaderJoin)((Object)cursor.get());
                ReaderCache.removeAccessRight((BUuid)rec.getReader().getId(), accessRight.getAccessRightId());
            }
            cursor.close();
        }
    }

    private static void removeAccessRight(BUuid readerUuid, BUuid accessRightUuid) {
        ReaderCache.getWriteLock(rwLock);
        try {
            ReaderCacheData data = ReaderCache.getCacheData(readerUuid);
            if (data != null) {
                data.deleteAccessRight(accessRightUuid);
                ReaderCache.addMapEntry(readerUuid, data);
            }
        }
        finally {
            ReaderCache.releaseWriteLock(rwLock);
        }
    }

    public static void removeReaderRecsAccessZone(DbCache dbCache, OrionSession session, BAccessZoneRec accessZone) {
        ReaderCache.removeReaderRecsEntryZone(dbCache, session, accessZone);
        ReaderCache.removeReaderRecsExitZone(dbCache, session, accessZone);
    }

    public static void insertEntryZone(DbCache dbCache, BEntryReaderZoneJoin readerZoneJoin) {
        if (!dbCache.isRunningOnSupervisor()) {
            ReaderCache.insertEntryZone((BUuid)readerZoneJoin.getReader().getId(), readerZoneJoin);
        }
    }

    private static void insertEntryZone(BUuid readerUuid, BEntryReaderZoneJoin readerZoneJoin) {
        ReaderCache.getWriteLock(rwLock);
        try {
            ReaderCacheData data = ReaderCache.getCacheData(readerUuid);
            if (data == null) {
                data = new ReaderCacheData(readerZoneJoin);
            } else {
                data.insertEntryZone(readerZoneJoin);
            }
            ReaderCache.addMapEntry(readerUuid, data);
        }
        finally {
            ReaderCache.releaseWriteLock(rwLock);
        }
    }

    public static void deleteEntryZone(DbCache dbCache, BEntryReaderZoneJoin readerZoneJoin) {
        if (!dbCache.isRunningOnSupervisor()) {
            ReaderCache.removeEntryZone((BUuid)readerZoneJoin.getReader().getId(), (BUuid)readerZoneJoin.getAccessZone().getId());
        }
    }

    private static void removeReaderRecsEntryZone(DbCache dbCache, OrionSession session, BAccessZoneRec accessZone) {
        if (!dbCache.isRunningOnSupervisor()) {
            OrionCursor cursor = session.select(BEntryReaderZoneJoin.ORION_TYPE, new PropertyValue(BEntryReaderZoneJoin.accessZone, (BValue)BRef.make((BIOrionObject)accessZone)));
            while (cursor.next()) {
                BEntryReaderZoneJoin rec = (BEntryReaderZoneJoin)cursor.get();
                ReaderCache.removeEntryZone((BUuid)rec.getReader().getId(), accessZone.getUuid());
            }
            cursor.close();
        }
    }

    private static void removeEntryZone(BUuid readerUuid, BUuid accessZoneUuid) {
        ReaderCache.getWriteLock(rwLock);
        try {
            ReaderCacheData data = ReaderCache.getCacheData(readerUuid);
            if (data != null) {
                data.deleteEntryZone(accessZoneUuid);
                ReaderCache.addMapEntry(readerUuid, data);
            }
        }
        finally {
            ReaderCache.releaseWriteLock(rwLock);
        }
    }

    public static void insertExitZone(DbCache dbCache, BExitReaderZoneJoin readerZoneJoin) {
        if (!dbCache.isRunningOnSupervisor()) {
            ReaderCache.insertExitZone((BUuid)readerZoneJoin.getReader().getId(), readerZoneJoin);
        }
    }

    private static void insertExitZone(BUuid readerUuid, BExitReaderZoneJoin readerZoneJoin) {
        ReaderCache.getWriteLock(rwLock);
        try {
            ReaderCacheData data = ReaderCache.getCacheData(readerUuid);
            if (data == null) {
                data = new ReaderCacheData(readerZoneJoin);
            } else {
                data.insertExitZone(readerZoneJoin);
            }
            ReaderCache.addMapEntry(readerUuid, data);
        }
        finally {
            ReaderCache.releaseWriteLock(rwLock);
        }
    }

    public static void deleteExitZone(DbCache dbCache, BExitReaderZoneJoin readerZoneJoin) {
        if (!dbCache.isRunningOnSupervisor()) {
            ReaderCache.removeExitZone((BUuid)readerZoneJoin.getReader().getId(), (BUuid)readerZoneJoin.getAccessZone().getId());
        }
    }

    private static void removeReaderRecsExitZone(DbCache dbCache, OrionSession session, BAccessZoneRec accessZone) {
        if (!dbCache.isRunningOnSupervisor()) {
            OrionCursor cursor = session.select(BExitReaderZoneJoin.ORION_TYPE, new PropertyValue(BExitReaderZoneJoin.accessZone, (BValue)BRef.make((BIOrionObject)accessZone)));
            while (cursor.next()) {
                BExitReaderZoneJoin rec = (BExitReaderZoneJoin)cursor.get();
                ReaderCache.removeExitZone((BUuid)rec.getReader().getId(), accessZone.getUuid());
            }
            cursor.close();
        }
    }

    private static void removeExitZone(BUuid readerUuid, BUuid accessZoneUuid) {
        ReaderCache.getWriteLock(rwLock);
        try {
            ReaderCacheData data = ReaderCache.getCacheData(readerUuid);
            if (data != null) {
                data.deleteExitZone(accessZoneUuid);
                ReaderCache.addMapEntry(readerUuid, data);
            }
        }
        finally {
            ReaderCache.releaseWriteLock(rwLock);
        }
    }

    public static BAccReaderRec getReader(DbCache dbCache, BUuid readerUuid) {
        ReaderCacheData data = ReaderCache.getCacheData(readerUuid);
        if (data == null) {
            return null;
        }
        return data.getReader(readerUuid);
    }

    public static BUuid[] getAccessRightUuids(DbCache dbCache, BUuid readerUuid) {
        ReaderCacheData data = ReaderCache.getCacheData(readerUuid);
        if (data == null) {
            return EMPTY_BUUID_ARRAY;
        }
        return data.getAccessRightUuids();
    }

    public static BAccessRightData[] getAccessRights(DbCache dbCache, BUuid readerUuid) {
        BUuid[] accessRightUuids = ReaderCache.getAccessRightUuids(dbCache, readerUuid);
        if (accessRightUuids.length == 0) {
            return EMPTY_ACCESS_RIGHT_DATA_ARRAY;
        }
        Array arr = new Array(BAccessRightData.class);
        for (int i = 0; i < accessRightUuids.length; ++i) {
            BAccessRightData accessRightData = dbCache.getAccessRightData(accessRightUuids[i]);
            if (accessRightData == null) continue;
            arr.add((Object)accessRightData);
        }
        return (BAccessRightData[])arr.trim();
    }

    public static boolean containsAccessRight(BUuid readerUuid, BUuid accessRightUuid) {
        ReaderCacheData data = ReaderCache.getCacheData(readerUuid);
        if (data == null) {
            return false;
        }
        return data.containsAccessRight(accessRightUuid);
    }

    public static BUuid[] getEntryZoneUuids(DbCache dbCache, BUuid readerUuid) {
        ReaderCacheData data = ReaderCache.getCacheData(readerUuid);
        if (data == null) {
            return EMPTY_BUUID_ARRAY;
        }
        return data.getEntryZoneUuids();
    }

    public static BAccessZoneRec[] getEntryZones(DbCache dbCache, BUuid readerUuid) {
        BUuid[] zoneUuids = ReaderCache.getEntryZoneUuids(dbCache, readerUuid);
        if (zoneUuids.length == 0) {
            return EMPTY_ACCESS_ZONE_ARRAY;
        }
        Array arr = new Array(BAccessZoneRec.class);
        for (int i = 0; i < zoneUuids.length; ++i) {
            BAccessZoneRec accessZone = dbCache.getAccessZone(zoneUuids[i]);
            if (accessZone == null) continue;
            arr.add((Object)accessZone);
        }
        return (BAccessZoneRec[])arr.trim();
    }

    public static boolean containsEntryZone(BUuid readerUuid, BUuid accessZoneUuid) {
        ReaderCacheData data = ReaderCache.getCacheData(readerUuid);
        if (data == null) {
            return false;
        }
        return data.containsEntryZone(accessZoneUuid);
    }

    public static BUuid[] getExitZoneUuids(DbCache dbCache, BUuid readerUuid) {
        ReaderCacheData data = ReaderCache.getCacheData(readerUuid);
        if (data == null) {
            return EMPTY_BUUID_ARRAY;
        }
        return data.getExitZoneUuids();
    }

    public static BAccessZoneRec[] getExitZones(DbCache dbCache, BUuid readerUuid) {
        BUuid[] zoneUuids = ReaderCache.getExitZoneUuids(dbCache, readerUuid);
        if (zoneUuids.length == 0) {
            return EMPTY_ACCESS_ZONE_ARRAY;
        }
        Array arr = new Array(BAccessZoneRec.class);
        for (int i = 0; i < zoneUuids.length; ++i) {
            BAccessZoneRec accessZone = dbCache.getAccessZone(zoneUuids[i]);
            if (accessZone == null) continue;
            arr.add((Object)accessZone);
        }
        return (BAccessZoneRec[])arr.trim();
    }

    public static boolean containsExitZone(BUuid readerUuid, BUuid accessZoneUuid) {
        ReaderCacheData data = ReaderCache.getCacheData(readerUuid);
        if (data == null) {
            return false;
        }
        return data.containsExitZone(accessZoneUuid);
    }

    public static ReaderCacheData getCacheData(BUuid readerUuid) {
        if (readerUuid == null) {
            return null;
        }
        ReaderCache.getReadLock(rwLock);
        try {
            ReaderCacheData readerCacheData = readersMap.get(readerUuid);
            return readerCacheData;
        }
        finally {
            ReaderCache.releaseReadLock(rwLock);
        }
    }

    private static void addMapEntry(BUuid key, ReaderCacheData data) {
        ReaderCache.getWriteLock(rwLock);
        try {
            if (!data.isEmpty()) {
                readersMap.put(key, data);
            } else {
                ReaderCache.removeReader(key);
            }
        }
        finally {
            ReaderCache.releaseWriteLock(rwLock);
        }
    }

    public static int getSize() {
        ReaderCache.getReadLock(rwLock);
        try {
            int n = readersMap.size();
            return n;
        }
        finally {
            ReaderCache.releaseReadLock(rwLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void printMap() {
        ReaderCache.getReadLock(rwLock);
        try {
            System.out.println("Reader: " + readersMap.size() + " Record(s)");
            Set<Map.Entry<BUuid, ReaderCacheData>> set = readersMap.entrySet();
            if (set.isEmpty()) {
                System.out.println("  <empty>\n");
                return;
            }
            for (Map.Entry<BUuid, ReaderCacheData> me : set) {
                BUuid readerUuid = me.getKey();
                System.out.println("  Reader: " + readerUuid.toString());
                ReaderCacheData data = me.getValue();
                System.out.println("    Name: " + data.getReaderName());
                data.printMap();
            }
            System.out.println("");
        }
        finally {
            ReaderCache.releaseReadLock(rwLock);
        }
    }
}

