/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec.access.util;

import com.tridium.nd.BNiagaraNetwork;
import com.tridium.orion.BIOrionObject;
import com.tridium.orion.BRef;
import com.tridium.orion.OrionCursor;
import com.tridium.orion.OrionSession;
import com.tridium.orion.OrionType;
import com.tridium.orion.priv.model.BDynamicOrionObject;
import com.tridium.orion.priv.model.DynamicOrionProperty;
import com.tridium.orion.priv.model.DynamicOrionType;
import com.tridium.orion.sql.BJoin;
import com.tridium.orion.sql.BSqlField;
import com.tridium.orion.sql.BSqlJoin;
import com.tridium.orion.sql.BSqlQuery;
import com.tridium.orion.sql.PropertyValue;
import com.tridium.orion.sql.SqlColumns;
import com.tridiumx.accessDriver.BAccessElevator;
import com.tridiumx.accessDriver.BAccessReader;
import com.tridiumx.accessDriver.BValidationInfo;
import com.tridiumx.accessDriver.enums.BValidationResult;
import com.tridiumx.accessDriver.enums.activity.BBadgeActivity;
import com.tridiumx.accessDriver.enums.activity.BTimeAttendEnum;
import com.tridiumx.entsec.access.BAccessControlService;
import com.tridiumx.entsec.access.BAccessValidationInfo;
import com.tridiumx.entsec.access.BAccessZone;
import com.tridiumx.entsec.access.history.BAttendanceRecord;
import com.tridiumx.entsec.access.orion.BAccFloorJoin;
import com.tridiumx.entsec.access.orion.BAccFloorRec;
import com.tridiumx.entsec.access.orion.BAccReaderJoin;
import com.tridiumx.entsec.access.orion.BAccReaderRec;
import com.tridiumx.entsec.access.orion.BAccessRight;
import com.tridiumx.entsec.access.orion.BAccessZoneRec;
import com.tridiumx.entsec.access.orion.BBadge;
import com.tridiumx.entsec.access.orion.BBadgeStatus;
import com.tridiumx.entsec.access.orion.BPerson;
import com.tridiumx.entsec.access.orion.BPersonAccJoin;
import com.tridiumx.entsec.access.orion.BThreatLevelBadgeJoin;
import com.tridiumx.entsec.access.orion.BValidationBits;
import com.tridiumx.entsec.access.orion.BWiegandFormat;
import com.tridiumx.entsec.access.util.AccessZonesValidationUtil;
import com.tridiumx.entsec.access.util.dbCache.DbCache;
import com.tridiumx.entsec.access.util.dbCache.PersonCache;
import com.tridiumx.entsec.access.util.dbCache.data.AccessRightCacheData;
import com.tridiumx.entsec.access.util.dbCache.data.BAccessRightData;
import com.tridiumx.entsec.access.util.dbCache.data.BPersonData;
import com.tridiumx.entsec.access.util.dbCache.data.BThreatLevelBadgeJoinData;
import com.tridiumx.entsec.access.util.dbCache.data.BThreatLevelGroupRecData;
import com.tridiumx.entsec.access.util.dbCache.data.PersonCacheData;
import com.tridiumx.entsec.access.util.dbCache.data.ThreatLevelGroupRecCacheData;
import com.tridiumx.entsec.orionTools.BAppTable;
import com.tridiumx.entsec.orionTools.BScheduleRec;
import com.tridiumx.entsec.orionTools.RemoteUtil;
import com.tridiumx.entsec.threat.BThreatLevelActivationJob;
import com.tridiumx.entsec.threat.BThreatLevelEntry;
import com.tridiumx.entsec.threat.BThreatLevelGroupRec;
import com.tridiumx.entsec.threat.BThreatLevelOperationEnum;
import com.tridiumx.entsec.threat.BThreatLevelSetup;
import java.security.AccessController;
import java.util.logging.Level;
import javax.baja.naming.BOrd;
import javax.baja.nd.BINiagaraStation;
import javax.baja.nd.SysDefSession;
import javax.baja.nre.util.Array;
import javax.baja.query.BExpression;
import javax.baja.query.BProjection;
import javax.baja.query.BProjectionColumn;
import javax.baja.query.BQuery;
import javax.baja.query.util.ExpressionBuilder;
import javax.baja.query.util.Predicates;
import javax.baja.schedule.BBooleanSchedule;
import javax.baja.security.BPassword;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComplex;
import javax.baja.sys.BDouble;
import javax.baja.sys.BInteger;
import javax.baja.sys.BSimple;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BVector;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;
import javax.baja.util.BUuid;

public abstract class ValidationUtil {
    private static final long REMOTE_VALIDATION_DELAY = 10000L;
    private static final String R = BAppTable.getTableName(BAccReaderRec.ORION_TYPE);
    private static final String A = BAppTable.getTableName(BAccessRight.ORION_TYPE);
    private static final String P = BAppTable.getTableName(BPerson.ORION_TYPE);
    private static final String AR = BAppTable.getTableName(BAccReaderJoin.ORION_TYPE);
    private static final String PA = BAppTable.getTableName(BPersonAccJoin.ORION_TYPE);
    private static final String A_ACCESSRIGHTID = "a." + BAccessRight.accessRightId.getName();
    private static final String P_PERSONID = "p." + BPerson.personId.getName();
    private static final String R_UUID = "r." + BAccReaderRec.uuid.getName();
    private static final String PA_ACCESSRIGHT = "pa." + BPersonAccJoin.accessRight.getName();
    private static final String PA_PERSON = "pa." + BPersonAccJoin.person.getName();
    private static final String AR_READER = "ar." + BAccReaderJoin.reader.getName();
    private static final String AR_ACCESSRIGHT = "ar." + BAccReaderJoin.accessRight.getName();
    private static final String PA_THREAT = "pa." + BPersonAccJoin.assignedThreatLevel.getName();
    private static final String SQL_ACCESS_RIGHTS = "select a.* from " + A + " a inner join " + PA + " pa on " + A_ACCESSRIGHTID + " = " + PA_ACCESSRIGHT + " inner join " + P + " p  on " + P_PERSONID + " = " + PA_PERSON + " inner join " + AR + " ar on " + A_ACCESSRIGHTID + " = " + AR_ACCESSRIGHT + " inner join " + R + " r  on " + R_UUID + " = " + AR_READER + " where p.personId = ? and r.uuid = ?";
    private static final String SQL_ACCESS_RIGHTS_FILTER_VALID_DATE = "select a.* , " + PA_THREAT + " from " + A + " a inner join " + PA + " pa on " + A_ACCESSRIGHTID + " = " + PA_ACCESSRIGHT + " inner join " + P + " p  on " + P_PERSONID + " = " + PA_PERSON + " inner join " + AR + " ar on " + A_ACCESSRIGHTID + " = " + AR_ACCESSRIGHT + " inner join " + R + " r  on " + R_UUID + " = " + AR_READER + " where p.personId = ? and r.uuid = ? AND ((pa.startDate IS NULL OR pa.startDate <= ? OR pa.startDate <= ?) AND (pa.endDate IS NULL OR pa.endDate <= ? OR pa.endDate >= ?))";
    private static String lastFailedBadgeId = "";
    private static long lastFailedBadgeTime = 0L;

    public static BValidationResult validate(BAccessValidationInfo info, OrionSession session, boolean isRemoteRequest, DbCache dbCache) {
        boolean valid;
        info.readerRec = ValidationUtil.getReaderRec(info, session, dbCache);
        BAccessControlService service = info.service;
        BAccessReader accessReader = info.getAccessReader();
        boolean flagA = ValidationUtil.validateBadge(info, session, dbCache);
        boolean flagB = flagA && ValidationUtil.validateAccessRight(info, session, dbCache);
        boolean bl = valid = flagB && ValidationUtil.validateFloors(info, session, dbCache);
        if (service.getRemoteValidation()) {
            boolean validationTimeoutOK = ValidationUtil.checkForValidationTimeout(info);
            if (!valid && validationTimeoutOK && (!info.getCredential().equals(lastFailedBadgeId) || ValidationUtil.okToRequestValidation())) {
                lastFailedBadgeId = info.getCredential();
                lastFailedBadgeTime = Clock.ticks();
                BINiagaraStation supervisorStation = ValidationUtil.getSecuritySupervisor();
                if (supervisorStation != null) {
                    long originalStartTicks = info.getStartTicks();
                    BOrd accessControlOrd = BOrd.make((String)"service:entsec:AccessControlService");
                    try {
                        BAccessValidationInfo remoteInfo = (BAccessValidationInfo)RemoteUtil.invokeRemote(supervisorStation.getStationName(), accessControlOrd, BAccessControlService.validateRemoteBadge.getName(), (BValue)info);
                        valid = remoteInfo.getRecord().getGranted();
                        if (valid) {
                            lastFailedBadgeId = "";
                            lastFailedBadgeTime = 0L;
                        }
                        info.copyFrom((BComplex)remoteInfo);
                        info.validatedRemotely = true;
                        info.setStartTicks(originalStartTicks);
                        info.service = service;
                        info.setAccessReader(accessReader);
                        validationTimeoutOK = ValidationUtil.checkForValidationTimeout(info);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            boolean bl2 = valid = valid && validationTimeoutOK;
            if (isRemoteRequest) {
                AccessRightCacheData data;
                BAccessRightData accessRightdata = info.getAccessRightData();
                if (accessRightdata != null && (data = accessRightdata.getAccessRightCacheData()) != null && !data.getNiagaraIntegrationUuid().equals((Object)BUuid.DEFAULT)) {
                    info.setRemoteIntegrationId(ValidationUtil.getNiagaraIntegrationId(info, session, dbCache));
                }
                return ValidationUtil.getResult(valid);
            }
        }
        valid = valid && AccessZonesValidationUtil.validate(info, session, dbCache);
        ValidationUtil.notifyReader(info, session, dbCache);
        service.validateRecord(info);
        if (valid && !info.getAccessReader().hasSensor()) {
            service.badgeHolderEntered(info);
        }
        return ValidationUtil.getResult(valid);
    }

    private static BValidationResult getResult(boolean valid) {
        if (valid) {
            return BValidationResult.valid;
        }
        return BValidationResult.invalid;
    }

    private static boolean validateBadge(BAccessValidationInfo info, OrionSession session, DbCache dbCache) {
        boolean trace;
        BBadge badge = null;
        if (info.getBadgeIsHex()) {
            badge = ValidationUtil.getBadge(info, session, dbCache);
            if (badge == null) {
                BWiegandFormat[] wiegandFormats = ValidationUtil.getWiegandFormats(info, session, dbCache);
                BBadge[] unknownBadges = BWiegandFormat.getUnknownBadgeInfo(info.getCredential(), wiegandFormats);
                badge = unknownBadges[0];
                if (!badge.getWiegandFormat().isBound()) {
                    info.getRecord().setActivity(BBadgeActivity.unknownWiegandFormat);
                    return false;
                }
                BBadge validationBitBadge = ValidationUtil.getValidationBitBadge(info, session, dbCache, unknownBadges, wiegandFormats, info.time);
                if (validationBitBadge == null) {
                    info.getRecord().setBadge(badge.toString());
                    info.getRecord().setActivity(BBadgeActivity.badgeDoesNotExist);
                    return false;
                }
                badge = validationBitBadge;
            }
        } else {
            BBadge[] badges = ValidationUtil.getBadgesFromCredential(info, session, dbCache);
            if (badges.length == 1) {
                badge = badges[0];
            } else {
                if (badges.length > 0) {
                    info.getRecord().setActivity(BBadgeActivity.invalidPinNumber);
                    info.getRecord().setDetails("More than one Credential with this PIN exists");
                    return false;
                }
                info.getRecord().setActivity(BBadgeActivity.badgeDoesNotExist);
                return false;
            }
        }
        info.setBadgeId(badge.getBadgeId());
        info.getRecord().setBadge(badge.toDisplayString(null));
        BPersonData personData = ValidationUtil.getBadgeOwner(info, session, dbCache, badge);
        if (personData == null) {
            info.getRecord().setActivity(BBadgeActivity.badgeNotAssigned);
            return false;
        }
        info.getRecord().setPersonId(personData.getPersonUuid());
        info.setPersonData(personData);
        PersonCacheData cacheData = personData.getPersonCacheData();
        if (cacheData != null) {
            info.getRecord().setOwner(cacheData.getDisplayString());
        }
        if (badge.getStatus() == BBadgeStatus.lost) {
            info.getRecord().setActivity(BBadgeActivity.badgeIsLost);
            return false;
        }
        if (badge.isDisabled(info.time)) {
            info.getRecord().setActivity(BBadgeActivity.badgeIsDisabled);
            info.getRecord().setDetails(badge.getDisabledReason(info.time));
            return false;
        }
        if (info.getRequiresPinValidation()) {
            BPassword password = personData.getPersonCacheData().getPinNumber();
            if ((password == null || password.isDefault()) && personData.getPersonCacheData().isPinKnown()) {
                info.getRecord().setActivity(BBadgeActivity.invalidPinNumber);
                return false;
            }
            personData = ValidationUtil.getBadgeOwner(info, session, dbCache, badge, true);
            password = personData.getPersonCacheData().getPinNumber();
            String personPin = AccessController.doPrivileged(() -> ((BPassword)password).getValue());
            BAccessControlService service = info.service;
            if (service.getHasPinDuress()) {
                int pinAsNumber = 0;
                try {
                    pinAsNumber = Integer.parseInt(personPin);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                String pinDuressAsString = "" + (service.getPinDuressOffset() + pinAsNumber);
                if (pinDuressAsString.equals(info.getPin())) {
                    info.getRecord().setActivity(BBadgeActivity.grantedButPinDuress);
                } else if (!personPin.equals(info.getPin())) {
                    info.getRecord().setActivity(BBadgeActivity.invalidPinNumber);
                    return false;
                }
            } else if (!personPin.equals(info.getPin())) {
                info.getRecord().setActivity(BBadgeActivity.invalidPinNumber);
                return false;
            }
        }
        if (trace = cacheData.getTraceCard()) {
            info.getRecord().setActivity(BBadgeActivity.grantedButTrace);
        }
        return true;
    }

    private static boolean validateAccessRight(BAccessValidationInfo info, OrionSession session, DbCache dbCache) {
        BAccessRightData[] accessRights = ValidationUtil.getPersonReaderAccessRights(info, session, dbCache, true);
        if (accessRights == null || accessRights.length == 0) {
            info.getRecord().setActivity(BBadgeActivity.noAccessRight);
            return false;
        }
        ThreatLevelGroupRecCacheData lastInactiveThreatLevelGroupRec = null;
        BBooleanSchedule schedule = null;
        boolean isElevator = ValidationUtil.isElevator(info);
        for (int i = 0; i < accessRights.length; ++i) {
            ThreatLevelGroupRecCacheData threatLevelGroup = ValidationUtil.getThreatLevelGroupRec(info, accessRights[i], session, dbCache);
            if (threatLevelGroup != null) {
                AccessRightCacheData data = accessRights[i].getAccessRightCacheData();
                int assignedLevel = data.getAssignedThreatLevel();
                if (assignedLevel == -1) {
                    assignedLevel = threatLevelGroup.getDefaultAccessRightThreatLevel();
                }
                if (data.getThreatLevelOperation() == BThreatLevelOperationEnum.normal && threatLevelGroup.getActiveLevel() > assignedLevel || data.getThreatLevelOperation() == BThreatLevelOperationEnum.reverse && threatLevelGroup.getActiveLevel() < assignedLevel || data.getThreatLevelOperation() == BThreatLevelOperationEnum.specificLevel && threatLevelGroup.getActiveLevel() != assignedLevel) {
                    lastInactiveThreatLevelGroupRec = threatLevelGroup;
                    continue;
                }
            }
            if ((schedule = ValidationUtil.getSchedule(info, accessRights[i], session, dbCache)) == null || !schedule.getOut().getBoolean()) continue;
            info.setAccessRightData(accessRights[i]);
            if (!isElevator) {
                return true;
            }
            if (info.elevatorAccessRightUuids == null) {
                info.elevatorAccessRightUuids = new Array(BUuid.class);
            }
            info.elevatorAccessRightUuids.add((Object)accessRights[i].getAccessRightUuid());
        }
        if (info.elevatorAccessRightUuids != null) {
            return true;
        }
        if (lastInactiveThreatLevelGroupRec == null) {
            info.getRecord().setActivity(BBadgeActivity.noActiveSchedule);
        } else {
            info.getRecord().setActivity(BBadgeActivity.inactiveThreatLevelGroup);
            info.getRecord().setDetails(lastInactiveThreatLevelGroupRec.getDisplayString());
        }
        return false;
    }

    private static boolean validateFloors(BAccessValidationInfo info, OrionSession session, DbCache dbCache) {
        if (!ValidationUtil.isElevator(info)) {
            return true;
        }
        if (info.elevatorAccessRightUuids == null) {
            info.getRecord().setActivity(BBadgeActivity.noAccessRight);
            return false;
        }
        BVector v = ValidationUtil.getFloors(info, session, dbCache);
        if (v == null || v.isNull()) {
            info.getRecord().setActivity(BBadgeActivity.noAccessRight);
            return false;
        }
        info.add("floors", (BValue)v);
        return true;
    }

    private static boolean checkForValidationTimeout(BAccessValidationInfo info) {
        boolean valid;
        long startTicks = info.getStartTicks();
        long timeElapsed = Clock.ticks() - startTicks;
        boolean bl = valid = timeElapsed < info.getValidationTimeout().getMillis();
        if (!valid) {
            info.getRecord().setActivity(BBadgeActivity.validationTimeoutExpired);
        }
        return valid;
    }

    private static void notifyReader(BAccessValidationInfo info, OrionSession session, DbCache dbCache) {
        if (info.getRecord().getActivity().equals((Object)BBadgeActivity.unknownWiegandFormat) && !info.service.getDisplayUnknownWiegandFormats()) {
            return;
        }
        if (info.getRecord().getActivity().isGranted()) {
            info.getRecord().setGranted(true);
            boolean activationBadge = ValidationUtil.checkActivationBadges(info, session, dbCache);
            if (activationBadge) {
                info.activationBadge = true;
                info.getAccessReader().notifyValidatedOutput();
            } else {
                AccessRightCacheData data;
                info.getAccessReader().doBadgeValidated((BValidationInfo)info);
                int integrationID = info.getRemoteIntegrationId();
                BAccessRightData accessRightdata = info.getAccessRightData();
                if (accessRightdata != null && (data = accessRightdata.getAccessRightCacheData()) != null && integrationID == 0 && !data.getNiagaraIntegrationUuid().equals((Object)BUuid.DEFAULT)) {
                    integrationID = ValidationUtil.getNiagaraIntegrationId(info, session, dbCache);
                }
                info.getAccessReader().getLastLocationId().set(BDouble.make((double)BInteger.make((int)integrationID).getDouble()));
            }
        } else {
            info.getRecord().setGranted(false);
        }
        info.getAccessReader().setLastBadgeActivity(info.getRecord().getActivity());
        info.getAccessReader().setLastPersonName(info.getRecord().getOwner());
        info.getAccessReader().setLastPersonId(info.getPersonData().getPersonUuid());
    }

    public static void record(BAccessValidationInfo info, OrionSession session, DbCache dbCache) {
        if (info.validatedRemotely && PersonCache.getMaxCacheSize() > 0) {
            dbCache.initPerson(info.getPersonData().getPersonUuid(), session);
        }
        if (info.getRecord().getActivity().equals((Object)BBadgeActivity.unknownWiegandFormat) && !info.service.getDisplayUnknownWiegandFormats()) {
            return;
        }
        if (info.getRecord().getActivity().isGranted() && info.getAccessReader().getTimeAttend() != BTimeAttendEnum.none && !info.activationBadge) {
            BAttendanceRecord record = new BAttendanceRecord(info.getAccessReader().getTimeAttend(), info.getRecord().getOwner(), info.getPersonData().getPersonUuid());
            info.service.getHistoryManager().append(record);
        }
        if (info.getRecord().getActivity().isAlarm()) {
            if (!info.getAccessZoneRec().getUuid().equals((Object)BUuid.DEFAULT)) {
                BAccessZoneRec rec = info.getAccessZoneRec();
                if (rec.getStationName().equals(Sys.getStation().getStationName())) {
                    BAccessZone zone = (BAccessZone)rec.getMappedOrd().get();
                    zone.makeAlarm(info.getRecord().getActivity(), info.getRecord().getOwner(), info.getRecord().getBadge(), info.getRecord().getDetails(), info.getPersonData().getPersonUuid());
                    if (!zone.enableLogging(info.getRecord().getActivity())) {
                        return;
                    }
                } else {
                    try {
                        RemoteUtil.invokeRemote(rec.getStationName(), rec.getMappedOrd(), BAccessZone.remoteMakeAlarm.getName(), (BValue)info);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            info.getAccessReader().makeAlarm(info.getRecord().getActivity(), info.getRecord().getOwner(), info.getRecord().getBadge(), info.getRecord().getDetails(), info.getPersonData().getPersonUuid());
            if (!info.getAccessReader().enableLogging(info.getRecord().getActivity())) {
                return;
            }
        }
        info.service.getHistoryManager().append(info.getRecord());
    }

    public static boolean checkActivationBadges(BAccessValidationInfo info, OrionSession session, DbCache dbCache) {
        block9: {
            BThreatLevelEntry threatLevelEntry = null;
            BThreatLevelGroupRec groupRec = null;
            if (dbCache != null && !dbCache.isRunningOnSupervisor()) {
                BThreatLevelBadgeJoinData data = dbCache.getThreatLevelBadgeJoinData(BString.make((String)info.getBadgeId()));
                if (data == null) {
                    return false;
                }
                threatLevelEntry = BThreatLevelEntry.make(data.getThreatLevelBadgeJoinCacheData().getActiveThreatLevel());
                groupRec = (BThreatLevelGroupRec)session.read(BThreatLevelGroupRec.ORION_TYPE, new PropertyValue(BThreatLevelGroupRec.uuid, (BValue)data.getThreatLevelBadgeJoinCacheData().getThreatLevelGroupUuid()));
            } else {
                BThreatLevelBadgeJoin badgeJoin = (BThreatLevelBadgeJoin)session.read(BThreatLevelBadgeJoin.ORION_TYPE, new PropertyValue(BThreatLevelBadgeJoin.badge, (BValue)BRef.make((BTypeSpec)BBadge.ORION_TYPE.getTypeSpec(), (BSimple)BString.make((String)info.getBadgeId()))));
                if (badgeJoin == null) {
                    return false;
                }
                threatLevelEntry = badgeJoin.getActiveThreatLevel();
                groupRec = badgeJoin.resolveThreatLevelGroup(session);
            }
            if (groupRec == null) {
                return false;
            }
            info.getRecord().setDetails("Threat Level Activation: " + groupRec.toDisplayString(null) + " to " + threatLevelEntry.toString());
            String auditString = BAccessControlService.lex.getText("badgeAuthorization", new Object[]{info.getRecord().getBadge()});
            try {
                BOrd.make((String)("station:|" + groupRec.getMappedOrd())).get();
                BThreatLevelSetup threatLevelSetup = (BThreatLevelSetup)Sys.getService((Type)BThreatLevelSetup.TYPE);
                BThreatLevelActivationJob activationJob = new BThreatLevelActivationJob(groupRec.getMappedOrd(), threatLevelEntry, Sys.getStation().getStationName(), auditString);
                threatLevelSetup.invoke(BThreatLevelSetup.submit, (BValue)activationJob, null);
            }
            catch (Exception e) {
                BAccessControlService.LOG.log(Level.FINE, "Threat Level Group for Activation Badge does not exist on JACE", e);
                BINiagaraStation supervisorStation = ValidationUtil.getSecuritySupervisor();
                if (supervisorStation == null) break block9;
                BOrd threatLevelSetupOrd = BOrd.make((String)("service:" + BThreatLevelSetup.TYPE));
                try {
                    RemoteUtil.invokeRemote(supervisorStation.getStationName(), threatLevelSetupOrd, BThreatLevelSetup.submit.getName(), (BValue)new BThreatLevelActivationJob(groupRec.getMappedOrd(), threatLevelEntry, Sys.getStation().getStationName(), auditString));
                }
                catch (Exception ee) {
                    BAccessControlService.LOG.log(Level.SEVERE, "Threat Level Group for Activation Badge does not exist on supervisor or JACE", ee);
                }
            }
        }
        return true;
    }

    private static boolean isElevator(BAccessValidationInfo info) {
        return info.getReaderParentTypeSpec() != null && !info.getReaderParentTypeSpec().equals((Object)BTypeSpec.DEFAULT) && info.getReaderParentTypeSpec().getResolvedType() != null && info.getReaderParentTypeSpec().getResolvedType().getInstance() instanceof BAccessElevator;
    }

    private static boolean okToRequestValidation() {
        if (lastFailedBadgeTime == 0L) {
            return true;
        }
        return Clock.ticks() > lastFailedBadgeTime + 10000L;
    }

    private static BNiagaraNetwork getNiagaraNetwork() {
        return (BNiagaraNetwork)Sys.getService((Type)BNiagaraNetwork.TYPE);
    }

    private static SysDefSession getProviderSession(Context cx) {
        return ValidationUtil.getNiagaraNetwork().createSysDefSession(cx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static BINiagaraStation getSecuritySupervisor() {
        BINiagaraStation supervisorStation = null;
        SysDefSession session = ValidationUtil.getProviderSession(null);
        if (session != null) {
            try {
                BINiagaraStation[] supervisors = session.getSupervisors(session.getLocalStation());
                for (int i = 0; i < supervisors.length; ++i) {
                    if (!session.getServices(session.getStation(supervisors[i].getStationName())).contains((Object)BAccessControlService.TYPE.getTypeSpec())) continue;
                    supervisorStation = supervisors[i];
                    break;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                if (session != null && session.isOpen()) {
                    session.close();
                }
            }
        }
        return supervisorStation;
    }

    private static BAccessRightData[] getPersonReaderAccessRights(BAccessValidationInfo info, OrionSession session, DbCache dbCache, boolean filterValidDate) {
        if (!dbCache.isRunningOnSupervisor()) {
            return dbCache.getPersonReaderAccessRights(info.getPersonData().getPersonUuid(), info.getReaderUuid(), info.time, filterValidDate);
        }
        OrionCursor cursor = null;
        cursor = !filterValidDate ? session.select(BAccessRight.ORION_TYPE, SQL_ACCESS_RIGHTS, new BSimple[]{info.getPersonData().getPersonUuid(), info.getReaderUuid()}) : session.select(ValidationUtil.getDynamicOrionType(), SQL_ACCESS_RIGHTS_FILTER_VALID_DATE, new BSimple[]{info.getPersonData().getPersonUuid(), info.getReaderUuid(), BAbsTime.DEFAULT, info.time, BAbsTime.DEFAULT, info.time});
        Array arr = new Array(BAccessRightData.class);
        while (cursor.next()) {
            BDynamicOrionObject accessRight = (BDynamicOrionObject)cursor.get();
            BAccessRightData accessRightData = new BAccessRightData(accessRight);
            if (accessRightData == null) continue;
            arr.add((Object)accessRightData);
        }
        cursor.close();
        return (BAccessRightData[])arr.trim();
    }

    private static BAccReaderRec getReaderRec(BAccessValidationInfo info, OrionSession session, DbCache dbCache) {
        if (!dbCache.isRunningOnSupervisor()) {
            return dbCache.getReaderRec(info.getReaderUuid());
        }
        return (BAccReaderRec)session.read(BAccReaderRec.ORION_TYPE, (BSimple)info.getReaderUuid());
    }

    private static BBooleanSchedule getSchedule(BAccessValidationInfo info, BAccessRightData accessRightData, OrionSession session, DbCache dbCache) {
        if (!dbCache.isRunningOnSupervisor()) {
            return dbCache.getScheduleForAccessRight(accessRightData.getAccessRightUuid());
        }
        BBooleanSchedule schedule = null;
        BAccessRight accessRight = new BAccessRight();
        accessRight.setAccessRightId(accessRightData.getAccessRightUuid());
        accessRight = (BAccessRight)session.read((BIOrionObject)accessRight);
        BScheduleRec scheduleRec = accessRight.resolveSchedule(session);
        if (scheduleRec != null) {
            schedule = (BBooleanSchedule)scheduleRec.getMappedOrd().get();
        }
        return schedule;
    }

    private static ThreatLevelGroupRecCacheData getThreatLevelGroupRec(BAccessValidationInfo info, BAccessRightData accessRightData, OrionSession session, DbCache dbCache) {
        if (accessRightData.getAccessRightCacheData().getThreatLevelGroupRecUuid() == BUuid.DEFAULT) {
            return null;
        }
        if (!dbCache.isRunningOnSupervisor()) {
            BThreatLevelGroupRecData data = dbCache.getThreatLevelGroupRecData(accessRightData.getAccessRightCacheData().getThreatLevelGroupRecUuid());
            if (data != null) {
                return data.getThreatLevelGroupRecCacheData();
            }
            return null;
        }
        BThreatLevelGroupRec threatLevelGroup = new BThreatLevelGroupRec();
        threatLevelGroup.setUuid(accessRightData.getAccessRightCacheData().getThreatLevelGroupRecUuid());
        threatLevelGroup = (BThreatLevelGroupRec)session.read((BIOrionObject)threatLevelGroup);
        if (threatLevelGroup != null) {
            return new ThreatLevelGroupRecCacheData(threatLevelGroup);
        }
        return null;
    }

    private static int getNiagaraIntegrationId(BAccessValidationInfo info, OrionSession session, DbCache dbCache) {
        if (!dbCache.isRunningOnSupervisor()) {
            return dbCache.getIntegrationIdForAccessRight(info.getAccessRightData().getAccessRightUuid());
        }
        BAccessRight accessRight = new BAccessRight();
        accessRight.setAccessRightId(info.getAccessRightData().getAccessRightUuid());
        accessRight = (BAccessRight)session.read((BIOrionObject)accessRight);
        return accessRight.resolveNiagaraIntegrationID(session).getIntegrationId();
    }

    private static BWiegandFormat[] getWiegandFormats(BAccessValidationInfo info, OrionSession session, DbCache dbCache) {
        if (!dbCache.isRunningOnSupervisor()) {
            return dbCache.getWiegandFormats();
        }
        return (BWiegandFormat[])session.scan(BWiegandFormat.ORION_TYPE).toArray();
    }

    private static BBadge getBadge(BAccessValidationInfo info, OrionSession session, DbCache dbCache) {
        if (!dbCache.isRunningOnSupervisor()) {
            return dbCache.getBadge(info.getCredential());
        }
        BBadge badge = new BBadge();
        badge.setBadgeId(info.getCredential());
        badge = (BBadge)session.read((BIOrionObject)badge);
        return badge;
    }

    private static BBadge getValidationBitBadge(BAccessValidationInfo info, OrionSession session, DbCache dbCache, BBadge[] unknownBadges, BWiegandFormat[] wiegandFormats, BAbsTime time) {
        if (!dbCache.isRunningOnSupervisor()) {
            return ValidationUtil.getValidationBitBadge(dbCache, unknownBadges, time);
        }
        return BWiegandFormat.validationBitBadge(unknownBadges, wiegandFormats, info.time, session);
    }

    private static BBadge getValidationBitBadge(DbCache dbCache, BBadge[] badges, BAbsTime time) {
        BBadge lastBadge = null;
        for (int i = 0; i < badges.length; ++i) {
            BWiegandFormat wiegandFormat = dbCache.getWiegandFormat((BUuid)badges[i].getWiegandFormat().getId());
            if (wiegandFormat == null || wiegandFormat.getValidationBits().equals((Object)BValidationBits.all)) continue;
            if (wiegandFormat.getValidationBits().equals((Object)BValidationBits.credentialOnly)) {
                lastBadge = dbCache.getBadge("Z" + badges[i].getCredential());
            } else if (wiegandFormat.getValidationBits().equals((Object)BValidationBits.credentialAndFacilityCode)) {
                lastBadge = dbCache.getBadge("Z" + badges[i].getCredential() + "Y" + badges[i].getFacilityCode());
            }
            if (lastBadge == null || !lastBadge.getWiegandFormat().getId().equals((Object)wiegandFormat.getWiegandFormatId()) || !lastBadge.getOwner().isBound() || lastBadge.getStatus() != BBadgeStatus.active || lastBadge.isDisabled(time)) continue;
            return lastBadge;
        }
        return lastBadge;
    }

    private static BBadge[] getBadgesFromCredential(BAccessValidationInfo info, OrionSession session, DbCache dbCache) {
        if (!dbCache.isRunningOnSupervisor()) {
            return dbCache.getBadgesFromCredential(info.getCredential());
        }
        return (BBadge[])session.select(BBadge.ORION_TYPE, new PropertyValue(BBadge.credential, (BValue)BString.make((String)info.getCredential()))).toArray();
    }

    private static BPersonData getBadgeOwner(BAccessValidationInfo info, OrionSession session, DbCache dbCache, BBadge badge, boolean refreshPersonForPin) {
        if (!dbCache.isRunningOnSupervisor()) {
            return dbCache.getBadgeOwner(badge, session, refreshPersonForPin);
        }
        BPerson person = badge.resolveOwner(session);
        if (person == null) {
            return null;
        }
        PersonCacheData data = new PersonCacheData(person);
        return new BPersonData(person.getPersonId(), data);
    }

    private static BPersonData getBadgeOwner(BAccessValidationInfo info, OrionSession session, DbCache dbCache, BBadge badge) {
        return ValidationUtil.getBadgeOwner(info, session, dbCache, badge, false);
    }

    private static BVector getFloors(BAccessValidationInfo info, OrionSession session, DbCache dbCache) {
        String slotPath = info.getReaderParentDisplayPath() + "/";
        if (!dbCache.isRunningOnSupervisor()) {
            return dbCache.getFloorsVector(info.elevatorAccessRightUuids, slotPath);
        }
        return ValidationUtil.getFloors(info, session, slotPath);
    }

    private static BVector getFloors(BAccessValidationInfo info, OrionSession session, String slotPath) {
        BSqlField f1 = new BSqlField(BAccFloorRec.ORION_TYPE, BAccFloorRec.floorDisplayPath);
        BSqlField j1 = new BSqlField(BAccFloorRec.ORION_TYPE, BAccFloorRec.uuid);
        BSqlField j2 = new BSqlField(BAccFloorJoin.ORION_TYPE, BAccFloorJoin.floor);
        BSqlField a = new BSqlField(BAccFloorJoin.ORION_TYPE, BAccFloorJoin.accessRight);
        BSqlJoin join = new BSqlJoin(BJoin.innerJoin, j1, j2);
        BSqlQuery q = BSqlQuery.make((OrionType)BAccFloorRec.ORION_TYPE);
        q.join(join);
        BProjection projection = SqlColumns.projection((BProjectionColumn)SqlColumns.make((BSqlField)f1));
        projection.setDistinct(true);
        q.select(projection);
        ExpressionBuilder b = new ExpressionBuilder();
        for (int i = 0; i < info.elevatorAccessRightUuids.size(); ++i) {
            b.or(Predicates.eq((BExpression)a.newExprCopy(), (BSimple)((BSimple)info.elevatorAccessRightUuids.get(i))));
        }
        q.where(Predicates.and((BExpression)Predicates.like((BExpression)f1.newExprCopy(), (BString)BString.make((String)(slotPath + "%"))), (BExpression)b.getExpression()));
        BIOrionObject[] floors = session.select((BQuery)q).toArray();
        if (floors.length == 0) {
            return null;
        }
        BVector v = new BVector();
        for (int i = 0; i < floors.length; ++i) {
            v.add(null, floors[i].get(floors[i].getOrionType().getProperties()[0]));
        }
        return v;
    }

    public static OrionType getDynamicOrionType() {
        Array a = new Array(Property.class);
        Property[] accessProps = BAccessRight.ORION_TYPE.getPersistentProperties();
        for (int i = 0; i < accessProps.length; ++i) {
            a.add((Object)new DynamicOrionProperty(accessProps[i]));
        }
        a.add((Object)BPersonAccJoin.assignedThreatLevel);
        return DynamicOrionType.makeTemporary((Property[])((Property[])a.trim()));
    }
}

