/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec.access.orion;

import com.tridium.json.JSONArray;
import com.tridium.json.JSONObject;
import com.tridium.orion.BIOrionObject;
import com.tridium.orion.BOrionDatabase;
import com.tridium.orion.BOrionObject;
import com.tridium.orion.BOrionService;
import com.tridium.orion.BRef;
import com.tridium.orion.OrionCursor;
import com.tridium.orion.OrionSession;
import com.tridium.orion.OrionType;
import com.tridium.orion.annotations.NiagaraOrionType;
import com.tridium.orion.annotations.OrionProperties;
import com.tridium.orion.annotations.OrionProperty;
import com.tridium.orion.annotations.OrionRefCursor;
import com.tridium.orion.annotations.OrionRefCursors;
import com.tridium.orion.priv.util.CountingUtil;
import com.tridium.orion.sql.BSqlQuery;
import com.tridium.orion.sql.PropertyValue;
import com.tridiumx.entsec.access.BAccessControlService;
import com.tridiumx.entsec.access.orion.BBadgeLdapServerJoin;
import com.tridiumx.entsec.access.orion.BBadgeStatus;
import com.tridiumx.entsec.access.orion.BPerson;
import com.tridiumx.entsec.access.orion.BWiegandFormat;
import com.tridiumx.entsec.isom.ICompatibleWithIsom;
import com.tridiumx.entsec.isom.InstantReplicationRequired;
import com.tridiumx.entsec.orionTools.BITenantObject;
import com.tridiumx.entsec.orionTools.BTenant;
import com.tridiumx.entsec.orionTools.replicate.BReplicableObject;
import com.tridiumx.entsec.photoID.orion.BBadgeTemplate;
import com.tridiumx.entsec.photoID.orion.BPhotoIDTemplateRec;
import java.util.HashMap;
import java.util.Map;
import javax.baja.data.BIDataValue;
import javax.baja.license.LicenseException;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.query.util.Predicates;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BUuid;
import javax.baja.util.Lexicon;

@NiagaraType
@NiagaraOrionType
@OrionRefCursors(value={@OrionRefCursor(name="BadgeTemplates", type="BBadgeTemplate", ref="badge"), @OrionRefCursor(name="BadgeLdapServerJoins", type="BBadgeLdapServerJoin", ref="badge")})
@NiagaraProperties(value={@NiagaraProperty(name="badgeId", type="String", defaultValue="", flags=5, facets={@Facet(name="KEY", value="true"), @Facet(name="WIDTH", value="128"), @Facet(name="BFacets.FIELD_EDITOR", value="\"entsec:SecStringFE\"")}), @NiagaraProperty(name="credential", type="String", defaultValue="BBadge.ZERO", flags=9, facets={@Facet(name="INDEXED", value="true"), @Facet(name="WIDTH", value="128"), @Facet(name="ALLOW_NULL", value="false"), @Facet(name="BFacets.FIELD_EDITOR", value="\"entsec:SecStringFE\"")}), @NiagaraProperty(name="facilityCode", type="String", defaultValue="BBadge.ZERO", flags=9, facets={@Facet(name="INDEXED", value="true"), @Facet(name="WIDTH", value="128"), @Facet(name="BFacets.FIELD_EDITOR", value="\"entsec:SecStringFE\"")}), @NiagaraProperty(name="bDescription", type="String", defaultValue="", flags=8, facets={@Facet(name="WIDTH", value="30")}), @NiagaraProperty(name="status", type="BBadgeStatus", defaultValue="BBadgeStatus.issueable", flags=8, facets={@Facet(name="BFacets.FIELD_EDITOR", value="\"entsec:SmartFrozenEnumFE\"")}), @NiagaraProperty(name="issueDate", type="BAbsTime", defaultValue="BAbsTime.DEFAULT", facets={@Facet(name="BFacets.FIELD_EDITOR", value="\"entsec:IssueDateFE\"")}), @NiagaraProperty(name="expirationDate", type="BAbsTime", defaultValue="BAbsTime.DEFAULT", facets={@Facet(name="BFacets.FIELD_EDITOR", value="\"entsec:ExpirationDateFE\"")})})
@OrionProperties(value={@OrionProperty(name="wiegandFormat", refType="entsec:WiegandFormat", flags=9, facets={@Facet(name="ON_DELETE", value="BOnDelete.CASCADE")}), @OrionProperty(name="owner", refType="entsec:Person", flags=8, facets={@Facet(name="ON_DELETE", value="BOnDelete.NO_ACTION"), @Facet(name="ALLOW_NULL", value="true")}), @OrionProperty(name="tenant", refType="entsec:Tenant", flags=8, facets={@Facet(name="ON_DELETE", value="BOnDelete.NO_ACTION"), @Facet(name="ALLOW_NULL", value="true")})})
public class BBadge
extends BReplicableObject
implements BITenantObject,
ICompatibleWithIsom,
InstantReplicationRequired {
    private static final String ZERO = "0";
    @Generated
    public static final Property badgeId = BBadge.newProperty((int)5, (String)"", (BFacets)BFacets.make((BFacets)BFacets.make((BFacets)BFacets.make((String)"key", (boolean)true), (BFacets)BFacets.make((String)"width", (int)128)), (BFacets)BFacets.make((String)"fieldEditor", (String)"entsec:SecStringFE")));
    @Generated
    public static final Property credential = BBadge.newProperty((int)9, (String)"0", (BFacets)BFacets.make((BFacets)BFacets.make((BFacets)BFacets.make((BFacets)BFacets.make((String)"indexed", (boolean)true), (BFacets)BFacets.make((String)"width", (int)128)), (BFacets)BFacets.make((String)"allowNull", (boolean)false)), (BFacets)BFacets.make((String)"fieldEditor", (String)"entsec:SecStringFE")));
    @Generated
    public static final Property facilityCode = BBadge.newProperty((int)9, (String)"0", (BFacets)BFacets.make((BFacets)BFacets.make((BFacets)BFacets.make((String)"indexed", (boolean)true), (BFacets)BFacets.make((String)"width", (int)128)), (BFacets)BFacets.make((String)"fieldEditor", (String)"entsec:SecStringFE")));
    @Generated
    public static final Property bDescription = BBadge.newProperty((int)8, (String)"", (BFacets)BFacets.make((String)"width", (int)30));
    @Generated
    public static final Property wiegandFormat = BBadge.newProperty((int)9, (BValue)BRef.make((String)"entsec:WiegandFormat"), (BFacets)BFacets.make((String)"onDelete", (int)1));
    @Generated
    public static final Property status = BBadge.newProperty((int)8, (BValue)BBadgeStatus.issueable, (BFacets)BFacets.make((String)"fieldEditor", (String)"entsec:SmartFrozenEnumFE"));
    @Generated
    public static final Property issueDate = BBadge.newProperty((int)0, (BValue)BAbsTime.DEFAULT, (BFacets)BFacets.make((String)"fieldEditor", (String)"entsec:IssueDateFE"));
    @Generated
    public static final Property expirationDate = BBadge.newProperty((int)0, (BValue)BAbsTime.DEFAULT, (BFacets)BFacets.make((String)"fieldEditor", (String)"entsec:ExpirationDateFE"));
    @Generated
    public static final Property owner = BBadge.newProperty((int)8, (BValue)BRef.make((String)"entsec:Person"), (BFacets)BFacets.make((BFacets)BFacets.make((String)"onDelete", (int)0), (BFacets)BFacets.make((String)"allowNull", (boolean)true)));
    @Generated
    public static final Property tenant = BBadge.newProperty((int)8, (BValue)BRef.make((String)"entsec:Tenant"), (BFacets)BFacets.make((BFacets)BFacets.make((String)"onDelete", (int)0), (BFacets)BFacets.make((String)"allowNull", (boolean)true)));
    @Generated
    public static final Type TYPE = Sys.loadType(BBadge.class);
    @Generated
    public static final OrionType ORION_TYPE = (OrionType)TYPE;
    public static final BIcon ICON = BIcon.std((String)"card.png");
    private static int count = -1;
    private static int maxLicenseLimit = -1;
    static final Lexicon lex = Lexicon.make(BBadge.class);

    @Generated
    public String getBadgeId() {
        return this.getString(badgeId);
    }

    @Generated
    public void setBadgeId(String v) {
        this.setString(badgeId, v, null);
    }

    @Generated
    public String getCredential() {
        return this.getString(credential);
    }

    @Generated
    public void setCredential(String v) {
        this.setString(credential, v, null);
    }

    @Generated
    public String getFacilityCode() {
        return this.getString(facilityCode);
    }

    @Generated
    public void setFacilityCode(String v) {
        this.setString(facilityCode, v, null);
    }

    @Generated
    public String getBDescription() {
        return this.getString(bDescription);
    }

    @Generated
    public void setBDescription(String v) {
        this.setString(bDescription, v, null);
    }

    @Generated
    public BRef getWiegandFormat() {
        return (BRef)this.get(wiegandFormat);
    }

    @Generated
    public void setWiegandFormat(BRef v) {
        this.set(wiegandFormat, (BValue)v, null);
    }

    @Generated
    public BWiegandFormat resolveWiegandFormat(OrionSession session) {
        return (BWiegandFormat)this.getWiegandFormat().getTarget(session);
    }

    @Generated
    public BBadgeStatus getStatus() {
        return (BBadgeStatus)this.get(status);
    }

    @Generated
    public void setStatus(BBadgeStatus v) {
        this.set(status, (BValue)v, null);
    }

    @Generated
    public BAbsTime getIssueDate() {
        return (BAbsTime)this.get(issueDate);
    }

    @Generated
    public void setIssueDate(BAbsTime v) {
        this.set(issueDate, (BValue)v, null);
    }

    @Generated
    public BAbsTime getExpirationDate() {
        return (BAbsTime)this.get(expirationDate);
    }

    @Generated
    public void setExpirationDate(BAbsTime v) {
        this.set(expirationDate, (BValue)v, null);
    }

    @Generated
    public BRef getOwner() {
        return (BRef)this.get(owner);
    }

    @Generated
    public void setOwner(BRef v) {
        this.set(owner, (BValue)v, null);
    }

    @Generated
    public BPerson resolveOwner(OrionSession session) {
        return (BPerson)this.getOwner().getTarget(session);
    }

    @Override
    @Generated
    public BRef getTenant() {
        return (BRef)this.get(tenant);
    }

    @Generated
    public void setTenant(BRef v) {
        this.set(tenant, (BValue)v, null);
    }

    @Generated
    public BTenant resolveTenant(OrionSession session) {
        return (BTenant)this.getTenant().getTarget(session);
    }

    @Generated
    public BadgeTemplatesCursor getBadgeTemplates(OrionSession session) {
        return new BadgeTemplatesCursor(session.select(BBadgeTemplate.ORION_TYPE, new PropertyValue(BBadgeTemplate.badge, (BValue)BRef.make((BIOrionObject)this))));
    }

    @Generated
    public BadgeLdapServerJoinsCursor getBadgeLdapServerJoins(OrionSession session) {
        return new BadgeLdapServerJoinsCursor(session.select(BBadgeLdapServerJoin.ORION_TYPE, new PropertyValue(BBadgeLdapServerJoin.badge, (BValue)BRef.make((BIOrionObject)this))));
    }

    @Override
    @Generated
    public Type getType() {
        return this.getTypeFromSpace(TYPE);
    }

    public BBadgeTemplate getBadgeTemplate(OrionSession session) {
        BadgeTemplatesCursor c = this.getBadgeTemplates(session);
        if (c.next()) {
            return (BBadgeTemplate)c.get();
        }
        return null;
    }

    public BPhotoIDTemplateRec getTemplateRec(OrionSession session) {
        BBadgeTemplate template = this.getBadgeTemplate(session);
        if (template == null) {
            return null;
        }
        return template.resolveTemplate(session);
    }

    public boolean isDisabled(BAbsTime time) {
        return this.getStatus() == BBadgeStatus.disabled || this.getStatus() == BBadgeStatus.unknown || time.isBefore(this.getIssueDate()) || !this.getExpirationDate().equals((Object)BAbsTime.DEFAULT) && time.isAfter(this.getExpirationDate());
    }

    public String getDisabledReason(BAbsTime time) {
        if (this.getStatus() == BBadgeStatus.disabled) {
            return BAccessControlService.lex.getText("badgeStatusDisabled");
        }
        if (this.getStatus() == BBadgeStatus.unknown) {
            return BAccessControlService.lex.getText("badgeStatusUnknown");
        }
        if (time.isBefore(this.getIssueDate())) {
            return BAccessControlService.lex.getText("badgeBeforeIssueDate");
        }
        if (!this.getExpirationDate().equals((Object)BAbsTime.DEFAULT) && time.isAfter(this.getExpirationDate())) {
            return BAccessControlService.lex.getText("badgeIsAfterExpirationDate");
        }
        return "";
    }

    public BFacets getSlotFacets(Slot slot) {
        BFacets facets = super.getSlotFacets(slot);
        if (slot.equals((Object)status)) {
            facets = !this.getOwner().isBound() ? BFacets.make((BFacets)facets, (String)"range", (BIDataValue)BBadgeStatus.issueableRange) : BFacets.make((BFacets)facets, (String)"range", (BIDataValue)BBadgeStatus.activeRange);
        } else if (slot.equals((Object)owner)) {
            facets = BFacets.make((BFacets)facets, (String)"update", (BIDataValue)BBoolean.TRUE);
        }
        return facets;
    }

    public void updateStatus() {
        if (this.getOwner().isBound() && this.getStatus() == BBadgeStatus.issueable) {
            this.setStatus(BBadgeStatus.active);
            if (this.getIssueDate().equals((Object)BAbsTime.DEFAULT)) {
                this.setIssueDate(BAbsTime.now());
            }
        } else if (!this.getOwner().isBound() && this.getStatus() == BBadgeStatus.active) {
            this.setStatus(BBadgeStatus.issueable);
            if (!this.getIssueDate().equals((Object)BAbsTime.DEFAULT)) {
                this.setIssueDate(BAbsTime.DEFAULT);
            }
        }
        if (this.getOwner().isBound() && this.getStatus() == BBadgeStatus.active && this.getIssueDate().equals((Object)BAbsTime.DEFAULT)) {
            this.setIssueDate(BAbsTime.now());
        }
    }

    public String toString(Context cx) {
        return this.toDisplayString(cx);
    }

    public String toDisplayString(Context cx) {
        StringBuffer b = new StringBuffer();
        b.append(this.getCredential());
        if (this.getFacilityCode().length() != 0) {
            b.append(" [" + this.getFacilityCode() + "]");
        }
        if (this.getBDescription().length() != 0) {
            b.append(" - " + this.getBDescription());
        }
        return b.toString();
    }

    public String calculateId(OrionSession session) throws Exception {
        BWiegandFormat wiegandFormat = this.resolveWiegandFormat(session);
        String format = wiegandFormat.getFormat();
        int wFacilityLength = wiegandFormat.getFacilityLength();
        String facilityCode = "";
        if (wFacilityLength > 0) {
            facilityCode = BWiegandFormat.convert(this.getFacilityCode(), 10, 2);
        }
        int wFacilityStart = wiegandFormat.getFacilityStart();
        int bFacilityLength = facilityCode.length();
        if (bFacilityLength > wFacilityLength && wFacilityLength != 0) {
            throw new IllegalStateException("Malform Facility Code Length: " + bFacilityLength + " > " + wFacilityLength);
        }
        if (wFacilityLength != 0) {
            for (int i = 0; i < wFacilityLength - bFacilityLength; ++i) {
                facilityCode = ZERO + facilityCode;
            }
            BAccessControlService.LOG.fine("facility code:" + facilityCode);
        } else {
            facilityCode = "";
            this.setFacilityCode(ZERO);
        }
        String credentialNumber = BWiegandFormat.convert(this.getCredential(), 10, 2);
        BAccessControlService.LOG.fine("Credential Number: " + credentialNumber);
        int wCredentialLength = wiegandFormat.getCredentialLength();
        int wCredentialStart = wiegandFormat.getCredentialStart();
        int bCredentialLength = credentialNumber.length();
        if (bCredentialLength > wCredentialLength) {
            throw new IllegalStateException("Malform Credential Number Length:" + bCredentialLength + " > " + wCredentialLength);
        }
        for (int i = 0; i < wCredentialLength - bCredentialLength; ++i) {
            credentialNumber = ZERO + credentialNumber;
        }
        BAccessControlService.LOG.fine("cred:" + credentialNumber);
        StringBuffer b = new StringBuffer("");
        for (int i = 0; i < wiegandFormat.getBitLength(); ++i) {
            if (format.charAt(i) == '0') {
                b.append('0');
                continue;
            }
            if (format.charAt(i) == '1') {
                b.append('1');
                continue;
            }
            b.append('0');
        }
        String id = b.toString();
        String prefix = "";
        String suffix = "";
        if (wFacilityLength != 0) {
            if (wFacilityStart > 0) {
                prefix = id.substring(0, wFacilityStart);
            }
            if (wFacilityStart + wFacilityLength < id.length()) {
                suffix = id.substring(wFacilityStart + wFacilityLength, id.length());
            }
            id = prefix + facilityCode + suffix;
            BAccessControlService.LOG.fine("postFacAppend:" + id);
        }
        prefix = "";
        suffix = "";
        if (wCredentialStart > 0) {
            prefix = id.substring(0, wCredentialStart);
        }
        if (wCredentialStart + wCredentialLength < id.length()) {
            suffix = id.substring(wCredentialStart + wCredentialLength, id.length());
        }
        id = prefix + credentialNumber + suffix;
        BAccessControlService.LOG.fine("");
        BAccessControlService.LOG.fine("1234567890123456789012345678901234567890");
        BAccessControlService.LOG.fine(id);
        id = this.setParities(id, wiegandFormat);
        BAccessControlService.LOG.fine(id);
        if (wiegandFormat.getBitLength() % 8 != 0) {
            for (int i = 0; i < 8 - wiegandFormat.getBitLength() % 8; ++i) {
                id = id + ZERO;
            }
        }
        String hexId = this.binaryToHex(id);
        BAccessControlService.LOG.fine(hexId);
        this.setBadgeId(hexId);
        this.setCredential(wiegandFormat.getCredentialNumber(hexId));
        return hexId;
    }

    private String binaryToHex(String id) {
        StringBuffer hex = new StringBuffer("");
        if (id.length() % 8 != 0) {
            throw new IllegalStateException("Conversion requires binary in bytes");
        }
        for (int i = 0; i < id.length() - 3; i += 4) {
            hex.append(Integer.toHexString(Integer.parseInt(id.substring(i, i + 4), 2)));
        }
        return hex.toString();
    }

    private String setParities(String id, BWiegandFormat wiegandFormat) {
        int i;
        int parityBits = wiegandFormat.getParityBits();
        String format = wiegandFormat.getFormat();
        String parity = wiegandFormat.getParity();
        String[] parityLayouts = new String[parityBits];
        int flexibleParity = -1;
        for (int i2 = 0; i2 < parityBits; ++i2) {
            parityLayouts[i2] = parity.substring(i2 * format.length(), (i2 + 1) * format.length());
        }
        String calculatedParityFormat = "";
        for (i = 0; i < format.length(); ++i) {
            calculatedParityFormat = calculatedParityFormat + "-";
        }
        for (i = 0; i < parityBits; ++i) {
            char bit;
            int j;
            flexibleParity = -1;
            int bitParityCounter = 0;
            boolean even = true;
            if (parityLayouts[i].indexOf("O") > -1) {
                even = false;
            }
            for (j = 0; j < format.length(); ++j) {
                if (calculatedParityFormat.charAt(j) != '-' || (bit = parityLayouts[i].charAt(j)) != 'E' && bit != 'O' || format.charAt(j) != 'P') continue;
                flexibleParity = j;
            }
            for (j = 0; j < format.length(); ++j) {
                bit = parityLayouts[i].charAt(j);
                if (bit != 'E' && bit != 'O' || id.charAt(j) != '1') continue;
                ++bitParityCounter;
            }
            String prefix = "";
            String suffix = "";
            boolean flexibleIsOne = false;
            if (even && bitParityCounter % 2 == 1 || !even && bitParityCounter % 2 == 0) {
                flexibleIsOne = true;
                if (flexibleParity > 0) {
                    prefix = id.substring(0, flexibleParity);
                }
                if (flexibleParity + 1 < id.length()) {
                    suffix = id.substring(flexibleParity + 1, id.length());
                }
                id = prefix + "1" + suffix;
            }
            if (flexibleParity > 0) {
                prefix = calculatedParityFormat.substring(0, flexibleParity);
            }
            if (flexibleParity + 1 < calculatedParityFormat.length()) {
                suffix = calculatedParityFormat.substring(flexibleParity + 1, calculatedParityFormat.length());
            }
            calculatedParityFormat = flexibleIsOne ? prefix + "1" + suffix : prefix + ZERO + suffix;
        }
        return id;
    }

    public BIcon getIcon() {
        return ICON;
    }

    @Override
    public boolean beforeInsert(OrionSession session) {
        BBadge.checkInsert(session);
        try {
            if (this.getBadgeId().length() == 0) {
                this.calculateId(session);
            }
        }
        catch (Exception e) {
            throw new BajaRuntimeException("Error calculating badgeId from Wiegand Format", (Throwable)e);
        }
        this.updateStatus();
        return super.beforeInsert(session);
    }

    private void validateValidityInformation() throws Exception {
        BAbsTime issueDateTime = this.getIssueDate();
        BAbsTime expirationDateTime = this.getExpirationDate();
        if (expirationDateTime == null || expirationDateTime == BAbsTime.NULL) {
            return;
        }
        if (issueDateTime.isAfter(expirationDateTime)) {
            throw new Exception("The badge expiration date should be after issue date and time.");
        }
    }

    @Override
    public boolean beforeUpdate(OrionSession session) {
        this.updateStatus();
        boolean result = super.beforeUpdate(session);
        if (this.isModified(owner)) {
            this.createDeletionRecord(session);
        }
        return result;
    }

    @Override
    public void afterInsert(OrionSession session) {
        this.confirmInsert();
        super.afterInsert(session);
        BAccessControlService service = (BAccessControlService)Sys.getService((Type)BAccessControlService.TYPE);
        service.getDbCache().insertBadge(this);
    }

    @Override
    public void afterUpdate(OrionSession session) {
        if (this.changesShouldReplicate()) {
            this.getReplicationService().execute(BBoolean.make((boolean)false));
        }
        BAccessControlService service = (BAccessControlService)Sys.getService((Type)BAccessControlService.TYPE);
        service.getDbCache().updateBadge(this);
    }

    @Override
    public void afterDelete(OrionSession session) {
        this.confirmDelete();
        if (this.changesShouldReplicate()) {
            this.getReplicationService().execute(BBoolean.make((boolean)false));
        }
        BAccessControlService service = (BAccessControlService)Sys.getService((Type)BAccessControlService.TYPE);
        service.getDbCache().deleteBadge(this);
    }

    public boolean validOnSubordinate(OrionSession session) throws Exception {
        if (this.getOwner().isBound()) {
            return this.resolveOwner(session).validOnSubordinate(session);
        }
        return false;
    }

    @Override
    public Property getTenantProperty() {
        return tenant;
    }

    public static void checkInsert(OrionSession session) {
        if (maxLicenseLimit == -1) {
            String limit = ((BAccessControlService)Sys.getService((Type)BAccessControlService.TYPE)).getCredentialLimit();
            if (limit == null) {
                limit = ZERO;
            }
            maxLicenseLimit = limit.equals("none") ? -2 : Integer.parseInt(limit);
        }
        if (maxLicenseLimit == -2) {
            return;
        }
        boolean orionCounted = false;
        if (count < 0) {
            count = CountingUtil.getCount((OrionType)ORION_TYPE, (OrionSession)session);
            orionCounted = true;
        }
        if (count + 1 > maxLicenseLimit) {
            if (!orionCounted) {
                count = CountingUtil.getCount((OrionType)ORION_TYPE, (OrionSession)session);
            }
            if (count + 1 > maxLicenseLimit) {
                throw new LicenseException("Credential License Limit Reached: " + maxLicenseLimit);
            }
        }
    }

    private void confirmInsert() {
        ++count;
    }

    private void confirmDelete() {
        --count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fromJson(JSONObject jsonObject) throws Exception {
        OrionSession orionSession = null;
        try {
            if (jsonObject != null) {
                BOrionDatabase orionDatabase = BOrionService.getService().getOrionDatabases()[0];
                orionSession = orionDatabase.createSession(null);
                for (String key : jsonObject.keySet()) {
                    if (key.equalsIgnoreCase("CredentialNumber")) {
                        this.setCredential(jsonObject.get(key).toString());
                        continue;
                    }
                    if (key.equalsIgnoreCase("FacilityCode")) {
                        this.setFacilityCode(jsonObject.get(key).toString());
                        continue;
                    }
                    if (key.equalsIgnoreCase("Relation")) {
                        this.updateRelations(jsonObject, orionSession, key);
                        continue;
                    }
                    if (key.equalsIgnoreCase("Validity")) {
                        JSONObject validity = (JSONObject)jsonObject.get(key);
                        this.setIssueDate(BAbsTime.make((String)validity.get("ValidFrom").toString()));
                        this.setExpirationDate(BAbsTime.make((String)validity.get("ValidTo").toString()));
                        this.validateValidityInformation();
                        continue;
                    }
                    if (key.equalsIgnoreCase("WiegandFormatId") || key.equalsIgnoreCase("WiegandFormatName")) {
                        this.updateWiegandFormat(orionSession, key, jsonObject.get(key).toString());
                        continue;
                    }
                    if (!key.equalsIgnoreCase("Enable")) continue;
                    this.setStatus(new Boolean(jsonObject.get("Enable").toString()) != false ? BBadgeStatus.active : BBadgeStatus.disabled);
                }
            }
        }
        finally {
            if (orionSession != null) {
                orionSession.close();
                orionSession = null;
            }
        }
    }

    private void updateWiegandFormat(OrionSession orionSession, String wiegandKey, String wiegandValue) throws Exception {
        OrionCursor cursor = null;
        cursor = wiegandKey.equals("WiegandFormatId") ? orionSession.select(BSqlQuery.make((OrionType)BWiegandFormat.ORION_TYPE).where(Predicates.eq((Property)BWiegandFormat.wiegandFormatId, (BSimple)BUuid.make((String)wiegandValue)))) : orionSession.select(BSqlQuery.make((OrionType)BWiegandFormat.ORION_TYPE).where(Predicates.eq((String)BWiegandFormat.wiegandFormatName.getName(), (BSimple)BString.make((String)wiegandValue))));
        if (cursor.next()) {
            BWiegandFormat wiegandFormat = (BWiegandFormat)cursor.get();
            BRef wiegandFormatRef = BRef.make((BIOrionObject)wiegandFormat);
            this.setWiegandFormat(wiegandFormatRef);
            return;
        }
        throw new Exception("Wiegand format not found");
    }

    private void updateRelations(JSONObject jsonObject, OrionSession orionSession, String key) throws Exception {
        JSONArray relations = (JSONArray)jsonObject.get(key);
        for (JSONObject relation : relations) {
            if (relation.isNull("CredentialAssignedToCredentialHolder")) continue;
            String personRefUUID = (String)relation.get("CredentialAssignedToCredentialHolder");
            OrionCursor cursor = orionSession.select(BSqlQuery.make((OrionType)BPerson.ORION_TYPE).where(Predicates.eq((Property)BPerson.personId, (BSimple)BUuid.make((String)personRefUUID))));
            if (cursor.next()) {
                BPerson person = (BPerson)cursor.get();
                BRef personRef = BRef.make((BIOrionObject)person);
                this.setOwner(personRef);
                return;
            }
            throw new Exception("Credential Holder not found");
        }
    }

    @Override
    public JSONObject getJSON(OrionSession orionSession) throws Exception {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("id", (Object)this.getBadgeId());
        jsonObject.put("CredentialNumber", (Object)this.getCredential());
        jsonObject.put("FacilityCode", (Object)this.getFacilityCode());
        jsonObject.put("WiegandFormatName", (Object)((BWiegandFormat)this.getWiegandFormat().getTarget(orionSession)).getWiegandFormatName());
        jsonObject.put("Enable", (Object)(this.getStatus().equals((Object)BBadgeStatus.active) ? Boolean.TRUE.toString() : Boolean.FALSE.toString()));
        JSONArray relations = new JSONArray();
        JSONObject personRef = new JSONObject();
        BPerson person = this.resolveOwner(orionSession);
        if (null != person) {
            personRef.put("CredentialAssignedToCredentialHolder", (Object)person.getPersonId().encodeToString());
        } else {
            personRef.put("CredentialAssignedToCredentialHolder", (Object)"");
        }
        relations.put((Object)personRef);
        jsonObject.put("Relation", (Object)relations);
        JSONObject validity = new JSONObject();
        validity.put("ValidFrom", (Object)this.getIssueDate().encodeToString());
        validity.put("ValidTo", (Object)this.getExpirationDate().encodeToString());
        jsonObject.put("Validity", (Object)validity);
        return jsonObject;
    }

    @Override
    public BOrionObject[] getRefObject(OrionSession orionSession, Type refObj) {
        BOrionObject[] returnObjects = null;
        if (refObj.is(BPerson.TYPE)) {
            returnObjects = new BOrionObject[]{this.resolveOwner(orionSession)};
        }
        return returnObjects;
    }

    @Override
    public boolean hasAdditionalInfo() {
        return false;
    }

    @Override
    public BOrionObject getAdditionalInfoOrionObjects(OrionSession orionSession) {
        return null;
    }

    @Override
    public BOrionObject getAdditionalInfoOrionObjectsFromJson(JSONObject jsonObject) {
        return null;
    }

    @Override
    public BOrionObject[] associateObject(BOrionObject[] orionObject) {
        return null;
    }

    public BBadgeLdapServerJoin getBadgeLdapServerJoin(OrionSession session) {
        BadgeLdapServerJoinsCursor c = this.getBadgeLdapServerJoins(session);
        if (c.next()) {
            return (BBadgeLdapServerJoin)c.get();
        }
        return null;
    }

    @Override
    public Map<String, BObject> removeReferenceObject() {
        HashMap<String, BObject> map = new HashMap<String, BObject>();
        BRef personRef = this.getOwner();
        map.put("personRef", (BObject)personRef);
        map.put("badgeStatus", (BObject)this.getStatus());
        this.setOwner(BRef.NULL);
        this.setStatus(BBadgeStatus.issueable);
        return map;
    }

    @Override
    public void addReferenceObject(Map<String, BObject> map) {
        if (map != null && !map.isEmpty()) {
            BRef personRef = (BRef)map.get("personRef");
            this.setOwner(personRef);
            BBadgeStatus badgeStatus = (BBadgeStatus)map.get("badgeStatus");
            this.setStatus(badgeStatus);
        }
    }

    @Generated
    public static class BadgeLdapServerJoinsCursor
    implements OrionCursor {
        private final OrionCursor cursor;

        private BadgeLdapServerJoinsCursor(OrionCursor cursor) {
            this.cursor = cursor;
        }

        public Context getContext() {
            return this.cursor.getContext();
        }

        public OrionType getOrionType() {
            return this.cursor.getOrionType();
        }

        public BIOrionObject[] toArray() {
            return this.cursor.toArray();
        }

        public boolean next() {
            return this.cursor.next();
        }

        public boolean nextComponent() {
            return this.cursor.nextComponent();
        }

        public boolean next(Class<?> cls) {
            return this.cursor.next(cls);
        }

        public BObject get() {
            return (BObject)this.cursor.get();
        }

        public OrionSession getSession() {
            return this.cursor.getSession();
        }

        public void close() {
            this.cursor.close();
        }

        public BBadgeLdapServerJoin getBadgeLdapServerJoin() {
            return (BBadgeLdapServerJoin)((Object)this.cursor.get());
        }
    }

    @Generated
    public static class BadgeTemplatesCursor
    implements OrionCursor {
        private final OrionCursor cursor;

        private BadgeTemplatesCursor(OrionCursor cursor) {
            this.cursor = cursor;
        }

        public Context getContext() {
            return this.cursor.getContext();
        }

        public OrionType getOrionType() {
            return this.cursor.getOrionType();
        }

        public BIOrionObject[] toArray() {
            return this.cursor.toArray();
        }

        public boolean next() {
            return this.cursor.next();
        }

        public boolean nextComponent() {
            return this.cursor.nextComponent();
        }

        public boolean next(Class<?> cls) {
            return this.cursor.next(cls);
        }

        public BObject get() {
            return (BObject)this.cursor.get();
        }

        public OrionSession getSession() {
            return this.cursor.getSession();
        }

        public void close() {
            this.cursor.close();
        }

        public BBadgeTemplate getBadgeTemplate() {
            return (BBadgeTemplate)((Object)this.cursor.get());
        }
    }
}

